#include <a_samp>

forward Timer();
forward SetPlayerPosWithObjects(playerid,Float:x,Float:y,Float:z);
/*
	SetPlayerPosWithObjects usage in your gamemode:

		CallRemoteFunction("SetPlayerPosWithObjects","ifff",playerid,newx,newy,newz);
*/

//------------------------------------------------------------------------------

enum object_info
{
	modelid,
	Float:ox,
	Float:oy,
	Float:oz,
	Float:orx,
	Float:ory,
	Float:orz,
	Float:viewdist
}

new Objects[][object_info] = {
	{11507, 1460.113281, -108.135841, 194.861435, 0.0, 0.0, 180.0, 1000.0},
	{11507, 1214.021240, -107.197754, 197.665619, 0.0, 0.0, 180.0,1000.0},
	{11507, 960.208008, -106.939079, 217.257339, 0.0, 0.0, 180.0,1000.0}
	// {modelid,x,y,z,rotx,roty,rotz,viewdistance}
	// all params are same as create object, except there is an additional viewdistance parameter. This is the distance
	// a player should be to see the object
};

enum player_info
{
	objid[sizeof(Objects)],
	bool:view[sizeof(Objects)]
}
new Player[MAX_PLAYERS][player_info];

//------------------------------------------------------------------------------

bool:IsInReach(Float:x,Float:y,Float:z,Float:x2,Float:y2,Float:z2,Float:dist)
{
	x = (x > x2) ? x - x2 : x2 - x;
	if(x > dist) return false;
	y = (y > y2) ? y - y2 : y2 - y;
	if(y > dist) return false;
	z = (z > z2) ? z - z2 : z2 - z;
	if(z > dist) return false;
	return true;
}

//------------------------------------------------------------------------------

new timer;

public OnFilterScriptInit()
{
	print("---\nLoaded xObjects by Boylett\n---");
	timer = SetTimer("Timer",500,1);
	return 1;
}

public OnFilterScriptExit()
{
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		for(new o = 0; o < sizeof(Objects); o++)
		{
			if(Player[i][view][o])
			{
				Player[i][view][o] = false;
				DestroyPlayerObject(i,Player[i][objid][o]);
			}
		}
	}
	
	KillTimer(timer);
}

//------------------------------------------------------------------------------

public OnPlayerConnect(playerid)
{
	for(new i = 0; i < sizeof(Objects); i++) Player[playerid][view][i] = false;
}

public OnPlayerDisconnect(playerid)
{
	for(new i = 0; i < sizeof(Objects); i++)
	{
		if(Player[playerid][view][i])
		{
			Player[playerid][view][i] = false;
			DestroyPlayerObject(playerid,Player[playerid][objid][i]);
		}
	}
}

//------------------------------------------------------------------------------

public Timer()
{
	for(new i = 0; i < MAX_PLAYERS; i++)
		if(IsPlayerConnected(i))
		    PlayerObjectUpdate(i);
}

PlayerObjectUpdate(playerid)
{
	new Float:pos[3];
	GetPlayerPos(playerid,pos[0],pos[1],pos[2]);
	for(new i = 0; i < sizeof(Objects); i++)
	{
	    if(!Player[playerid][view][i])
	    {
	        if(IsInReach(pos[0],pos[1],pos[2],Objects[i][ox],Objects[i][oy],Objects[i][oz],Objects[i][viewdist]))
	        {
	            Player[playerid][view][i] = true;
	            Player[playerid][objid][i] = CreatePlayerObject(playerid,Objects[i][modelid],Objects[i][ox],Objects[i][oy],Objects[i][oz],Objects[i][orx],Objects[i][ory],Objects[i][orz]);
	        }
	    } else if(!IsInReach(pos[0],pos[1],pos[2],Objects[i][ox],Objects[i][oy],Objects[i][oz],Objects[i][viewdist]))
	    {
            Player[playerid][view][i] = false;
            DestroyPlayerObject(playerid,Player[playerid][objid][i]);
	    }
	}
}

public SetPlayerPosWithObjects(playerid,Float:x,Float:y,Float:z)
{
	for(new i = 0; i < sizeof(Objects); i++)
	{
	    if(!Player[playerid][view][i])
	    {
	        if(IsInReach(x,y,z,Objects[i][ox],Objects[i][oy],Objects[i][oz],Objects[i][viewdist]))
	        {
	            Player[playerid][view][i] = true;
	            Player[playerid][objid][i] = CreatePlayerObject(playerid,Objects[i][modelid],Objects[i][ox],Objects[i][oy],Objects[i][oz],Objects[i][orx],Objects[i][ory],Objects[i][orz]);
	        }
	    } else if(!IsInReach(x,y,z,Objects[i][ox],Objects[i][oy],Objects[i][oz],Objects[i][viewdist]))
	    {
            Player[playerid][view][i] = false;
            DestroyPlayerObject(playerid,Player[playerid][objid][i]);
	    }
	}
	SetPlayerPos(playerid,Float:x,Float:y,Float:z);
}

public OnPlayerSpawn(playerid)
	PlayerObjectUpdate(playerid);
