--[[ GUI Editor - Code Output - Client ]]--

local editorwindow,editortabpanel,editortab,editorbutton,editormemo,editorcheckbox,editorlabel,editoredit,editorprogress,editorradio,editorgrid,editorimage = false,false,false,false,false,false,false,false,false,false,false,false
guieditor_version = nil

addEventHandler("onClientResourceStart",getResourceRootElement(getThisResource()),function()

	output_window = guiCreateWindow(0,258,500,346,"Output",false)
	output_button_close = guiCreateButton(0.1341,0.9075,0.3118,0.0664,"Close",true,output_window)
	output_button_output = guiCreateButton(0.5641,0.9075,0.3118,0.0664,"Output to file",true,output_window)
	output_memo = guiCreateMemo(0.0247,0.0635,0.9504,0.8208,"",true,output_window)
	guiSetVisible(output_window,false)
	addEventHandler("onClientGUIClick",output_button_close,HidePrintGUI,false)
	addEventHandler("onClientGUIClick",output_button_output,function() PrintAllGUI("guioutput") end,false)
	
	triggerServerEvent("getEditorVersion",getLocalPlayer())
end)


addEvent("receiveEditorVersion",true)
addEventHandler("receiveEditorVersion",root,function(version)
	guiSetText(output_window,"GUI Editor Version "..tostring(version).." - Output")
	guieditor_version = tostring(version)
end)


-- as of 1.0, we need to wrap this and do some hacky server-client tricks to actually get a gui element list
-- no longer needed as of 1.0.1
------------------------------------------------------------------------------------------------------------
--[[
function PrintAllGUI(command)
	triggerServerEvent("GetResourcesForOutput",getLocalPlayer(),command)
end

local glob_gui_elements = {}

addEvent("RecieveResourcesForOutput",true)
addEventHandler("RecieveResourcesForOutput",getRootElement(),function(resources,arg1,arg2)	
	-- both arguments exist, calling from GetGUIElementsWithinBox2
	if arg1 and arg2 then
		glob_gui_elements = {}
		for _,res in ipairs(resources) do
			local function search(element)
				-- dont want to add guiroot
				if getElementType(element)~="guiroot" then
					table.insert(glob_gui_elements,element)
				end
			
				for _,v in ipairs(getElementChildren(element)) do
					if string.find(getElementType(v),'gui-...') then
						search(v)
					end
				end
			end	
	
			search(getResourceGUIElement(getResourceFromName(res)))
		end
		
		GetGUIElementsWithinBox2(glob_gui_elements,arg1,arg2)
	else
		-- loop all resource names, then loop all children of the resources gui root
		local gui_elements = {}
		for _,res in pairs(resources) do
			for _,gui_element in ipairs(getElementChildren(getResourceGUIElement(getResourceFromName(res)))) do
				table.insert(gui_elements,gui_element)
			--	outputChatBox("Found: "..getElementType(gui_element).."("..res..")")			
			end
		end
	
		PrintAllGUI2(arg1,gui_elements)
	end
end)
]]
------------------------------------------------------------------------------------------------------------]]


function PrintAllGUI(command)
	if not gui_editor then
		outputChatBox("Type /guieditor to begin using the GUI Editor")
		return
	end
	
	if guieditor_tutorial then
		if not guieditor_tutorial_waiting["output_code"] then
			outputChatBox("Continue with the tutorial to access this command.")
		end
	end
	
	guiSetText(output_memo,"")
	local code = ""
	local dx_code = ""
	
	editorwindow,editortabpanel,editortab,editorbutton,editormemo,editorcheckbox,editorlabel,editoredit,editorprogress,editorradio,editorgrid,editorimage = false,false,false,false,false,false,false,false,false,false,false,false
	
	-- put all existing child gui elements of guiroot into gui_elements
	local gui_elements = {}
	for _,v in ipairs(gui_element_names) do
		for _,gui_element in ipairs(getElementsByType(v)) do
			if getElementType(getElementParent(gui_element))=="guiroot" then
				table.insert(gui_elements,gui_element)
			end
		end
	end
	
	
	
	local variable_table_index = {["gui-window"] = 0,["gui-button"] = 0,["gui-memo"] = 0,["gui-label"] = 0,["gui-checkbox"] = 0,["gui-edit"] = 0,["gui-gridlist"] = 0,["gui-progressbar"] = 0,["gui-tabpanel"] = 0,["gui-tab"] = 0,["gui-radiobutton"] = 0,["gui-staticimage"] = 0}

	-- loop every child gui element of gui-root
	for i,parent_element in ipairs(gui_elements) do	
		-- if it was made with the editor (isnt part of the editor's own gui, etc)
		if getElementData(parent_element,"guieditor_varname") then
			-- loop all its child elements
			local function search(element)
				if not getElementData(element,"modify_menu") then
					--outputChatBox("Generating "..getElementType(element).." ["..i.."]")
					
					-- we want to properly index output elements with the default table-variable, after loading big guis (eg: admin) and then deleting them (or just a lot of creation/deletion in general) the first index in the output code can balloon to 60+
					-- so, we keep count of each variable type and properly order them
					if UsingDefaultVariable(element) then
						local type = getElementType(element)
						variable_table_index[type] = variable_table_index[type] + 1
						local varname = ""
						
						if type == "gui-window" then varname = "GUIEditor_Window["..variable_table_index[type].."]"
						elseif type == "gui-button" then varname = "GUIEditor_Button["..variable_table_index[type].."]" 
						elseif type == "gui-memo" then varname = "GUIEditor_Memo["..variable_table_index[type].."]" 
						elseif type == "gui-label" then varname = "GUIEditor_Label["..variable_table_index[type].."]" 
						elseif type == "gui-checkbox" then varname = "GUIEditor_Checkbox["..variable_table_index[type].."]" 
						elseif type == "gui-edit" then varname = "GUIEditor_Edit["..variable_table_index[type].."]" 
						elseif type == "gui-gridlist" then varname = "GUIEditor_Grid["..variable_table_index[type].."]" 
						elseif type == "gui-progressbar" then varname = "GUIEditor_Progress["..variable_table_index[type].."]" 
						elseif type == "gui-tabpanel" then varname = "GUIEditor_TabPanel["..variable_table_index[type].."]" 
						elseif type == "gui-tab" then varname = "GUIEditor_Tab["..variable_table_index[type].."]" 
						elseif type == "gui-radiobutton" then varname = "GUIEditor_Radio["..variable_table_index[type].."]" 
						elseif type == "gui-staticimage" then varname = "GUIEditor_Image["..variable_table_index[type].."]" 
						end
						
						setElementData(element,"guieditor_varname",varname)
					end
					
					-- generate code for the element
					local element_code = GenerateCodeForElement(element,getElementType(element))
					if element_code then
						code = code .. "\n" .. element_code
					else
						outputDebugString("GUIEditor Error: code generation failed on element ["..getElementType(element).."]")
					end
					
					for _,v in ipairs(getElementChildren(element)) do
						if getElementData(v,"guieditor_varname") then
							search(v)
						end
					end
				else
					-- generate the render handle
					if dx_code == "" then
						dx_code = "-- Direct X Drawing\naddEventHandler(\"onClientRender\",root,\n    function()"
					end
					
					local element_code = GenerateCodeForDX(element)
					if element_code and #element_code>0 then
						dx_attributes[element].code = element_code
					--	outputDebugString("GUIEditor: successful DX code generation on ["..getElementType(element).."]")
					else
						dx_attributes[element].code = ""
						outputDebugString("GUIEditor Error: DX code generation failed on ["..getElementType(element).."]")
					end
				
					for _,v in ipairs(getElementChildren(element)) do
						if getElementData(v,"guieditor_varname") then
							search(v)
						end
					end		
				end
			end

			if parent_element then
				search(parent_element)
			end
			
			if not getElementData(parent_element,"modify_menu") then
				code = code .. "\n"
			end
		end		
	end
	
	for i=#dx_ordering, 1, -1 do
		if dx_ordering[i] and dx_attributes[dx_ordering[i]] then
			dx_code = dx_code .. "\n" .. tostring(dx_attributes[dx_ordering[i]].code)
			dx_attributes[dx_ordering[i]].code = nil
		end
	end			
	
	if dx_code ~= "" then
		dx_code = dx_code .. "\n    end\n)\n"
	end
	
			
	local tables = ""
	if editorwindow == true then tables = tables.."GUIEditor_Window = {}\n" end
	if editortabpanel == true then tables = tables.."GUIEditor_TabPanel = {}\n" end
	if editortab == true then tables = tables.."GUIEditor_Tab = {}\n" end
	if editorbutton == true then tables = tables.."GUIEditor_Button = {}\n" end
	if editormemo == true then tables = tables.."GUIEditor_Memo = {}\n" end
	if editorcheckbox == true then tables = tables.."GUIEditor_Checkbox = {}\n" end
	if editorlabel == true then tables = tables.."GUIEditor_Label = {}\n" end
	if editoredit == true then tables = tables.."GUIEditor_Edit = {}\n" end
	if editorprogress == true then tables = tables.."GUIEditor_Progress = {}\n" end
	if editorradio == true then tables = tables.."GUIEditor_Radio = {}\n" end
	if editorgrid == true then tables = tables.."GUIEditor_Grid = {}\n" end
	if editorimage == true then tables = tables.."GUIEditor_Image = {}\n" end	
	
	code = tables .. code .. (code == "\n" and "" or "\n\n\n") .. dx_code

	if command=="guiprint" then
		guiSetText(output_memo,code)
		guiSetVisible(output_window,true)
	elseif command=="guioutput" then
		local valuescreen, valuechildren
		if settings.screen_output_type.value==true then valuescreen="relative" else valuescreen="absolute" end
		if settings.child_output_type.value==true then valuechildren="relative" else valuechildren="absolute" end
		
		if guieditor_tutorial and guieditor_tutorial_waiting["output_code"] then
			progressTutorial("output_code")
		end
		
		triggerServerEvent("OutputGUIToFile",getLocalPlayer(),code,"with "..valuescreen.." screen and "..valuechildren.." children.")
	end
end
addCommandHandler("guiprint",PrintAllGUI)
addCommandHandler("guioutput",PrintAllGUI)


function HidePrintGUI()
	guiSetVisible(output_window,false)
end
addCommandHandler("guihide",HidePrintGUI)


function GenerateCodeForElement(element,type)
	local code = ""
	-- check both variables exist and check element has not been deleted
	if element and type and isElement(element) then
		if type == "gui-window" then
			local w,h = guiGetSize(element,settings.screen_output_type.value)
			local x,y = guiGetPosition(element,settings.screen_output_type.value)
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))		
			local t_ = guiGetText(element) if t_==nil or t_==false then t_ = "" end
			local t = t_:gsub("\n","\\n") 
		--	t = t:gsub("\\","\\\\")
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateWindow("..x..","..y..","..w..","..h..",\""..t.."\","..tostring(settings.screen_output_type.value)..")" --guiCreateWindow(float x,float y,float width,float height,string titleBarText,bool relative )
			if getElementData(element,"guieditor_alpha")==true then code = code .."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if getElementData(element,"guieditor_movable")==false then code = code .."\nguiWindowSetMovable("..varname..",false)" end
			if getElementData(element,"guieditor_sizable")==false then code = code .."\nguiWindowSetSizable("..varname..",false)" end
			-- loop all saved property changes for the element
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			-- if it is still using its original variable name, indicate that code for the variable table needs to be created
			if UsingDefaultVariable(element) then
				editorwindow = true
			end
			
			return code
		end

		if type == "gui-tabpanel" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				-- force absolute values if loose manipulation has been used to breach the parent border, relative values will fail with values <0 or >1
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)
				end
			end
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))			
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateTabPanel("..x..","..y..","..w..","..h..parent_name..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code .."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editortabpanel = true
			end
			
			return code
		end
	
		if type == "gui-tab" then
			-- dont remember why tabs specifically stored their parents variable, though it seems to work fine now without (perhaps due to the reorganisation)
			-- keep an eye on this
		--	local parent = getElementData(element,"guieditor_parent")
			local parent = getElementData(getElementParent(element),"guieditor_varname")
			local t = guiGetText(element) if t==nil or t==false then t = "" end
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateTab(\""..t.."\","..parent..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editortab = true
			end
			
			return code
		end	
	
		if type == "gui-button" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))			
			local t_ = guiGetText(element) if t_==nil or t_==false then t_ = "" end
			local t = t_:gsub("\n","\\n") 
		--	t = t:gsub("\\","\\\\")
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateButton("..x..","..y..","..w..","..h..",\""..t.."\""..parent_name..")" --guiCreateButton(float x,float y,float width,float height, string text, bool relative, [ element parent = nil ])
			if getElementData(element,"guieditor_alpha")==true then code = code .."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if guiGetFont(element)~="default-normal" then code = code.."\nguiSetFont("..varname..",\""..guiGetFont(element).."\")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editorbutton = true
			end
			
			return code
		end
	
		if type == "gui-memo" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))
			local t_ = guiGetText(element) if t_==nil or t_==false then t_ = "" end
			t_ = string.sub(t_,1,-2)
			local t = t_:gsub("\n","\\n") 
		--	t = t:gsub("\\","\\\\")
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateMemo("..x..","..y..","..w..","..h..",\""..t.."\""..parent_name..")" --guiCreateMemo ( float x, float y, float width, float height, string text, bool relative, [element parent = nil] )
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if getElementData(element,"guieditor_readonly")==true then code = code.."\nguiMemoSetReadOnly("..varname..",true)" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editormemo = true
			end
			
			return code
		end

		if type == "gui-checkbox" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))	
			local t_ = guiGetText(element) if t_==nil or t_==false then t_ = "" end			
			local t = t_:gsub("\n","\\n") 
		--	t = t:gsub("\\","\\\\")
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateCheckBox("..x..","..y..","..w..","..h..",\""..t.."\",false"..parent_name..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if guiCheckBoxGetSelected(element)==true then code = code.."\nguiCheckBoxSetSelected("..varname..",true)" end
			if guiGetFont(element)~="default-normal" then code = code.."\nguiSetFont("..varname..",\""..guiGetFont(element).."\")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editorcheckbox = true
			end
			
			return code
		end
	
		if type == "gui-label" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))			
			local t_ = guiGetText(element) if t_==nil or t_==false then t_ = "" end
			local t = t_:gsub("\n","\\n") 
		--	t = t:gsub("\\","\\\\")
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateLabel("..x..","..y..","..w..","..h..",\""..t.."\""..parent_name..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if getElementData(element,"guieditor_colour")~=nil then code = code.."\nguiLabelSetColor("..varname..","..getElementData(element,"guieditor_colour")..")" end
			if getElementData(element,"guieditor_vertalign")~=nil then code = code.."\nguiLabelSetVerticalAlign("..varname..",\""..getElementData(element,"guieditor_vertalign").."\")" end
			local wordwrap = "false"
			if getElementData(element,"guieditor_wordwrap")==true then wordwrap = "true" end
			if getElementData(element,"guieditor_horizalign")~=nil then code = code.."\nguiLabelSetHorizontalAlign("..varname..",\""..getElementData(element,"guieditor_horizalign").."\","..wordwrap..")" end
			if guiGetFont(element)~="default-normal" then code = code.."\nguiSetFont("..varname..",\""..guiGetFont(element).."\")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editorlabel = true
			end
			
			return code
		end
	
		if type == "gui-edit" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))			
			local t = guiGetText(element) if t==nil or t==false then t = "" end
		--	t = t:gsub("\\","\\\\")
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateEdit("..x..","..y..","..w..","..h..",\""..t.."\""..parent_name..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if getElementData(element,"guieditor_masked")==true then code = code.."\nguiEditSetMasked("..varname..",true)" end
			if getElementData(element,"guieditor_readonly")==true then code = code.."\nguiEditSetReadOnly("..varname..",true)" end
			if getElementData(element,"guieditor_maxlength")~=nil then code = code.."\nguiEditSetMaxLength("..varname..","..getElementData(element,"guieditor_maxlength")..")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editoredit = true
			end
			
			return code
		end	
	
		if type == "gui-progressbar" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))			
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateProgressBar("..x..","..y..","..w..","..h..parent_name..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if guiProgressBarGetProgress(element)>0 then code = code.."\nguiProgressBarSetProgress("..varname..","..guiProgressBarGetProgress(element)..")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editorprogress = true
			end
			
			return code
		end

		if type == "gui-radiobutton" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))		
			local t_ = guiGetText(element) if t_==nil or t_==false then t_ = "" end			
			local t = t_:gsub("\n","\\n") 		
		--	t = t:gsub("\\","\\\\")	
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateRadioButton("..x..","..y..","..w..","..h..",\""..t.."\""..parent_name..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			if guiRadioButtonGetSelected(element)==true then code = code.."\nguiRadioButtonSetSelected("..varname..",true)" end
			if guiGetFont(element)~="default-normal" then code = code.."\nguiSetFont("..varname..",\""..guiGetFont(element).."\")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editorradio = true
			end
			
			return code
		end	

		if type == "gui-gridlist" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end					
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))			
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateGridList("..x..","..y..","..w..","..h..parent_name..")" --
			code = code.."\nguiGridListSetSelectionMode("..varname..",2)"
			
			local row_c = guiGridListGetRowCount(element)
			if row_c~=false and row_c>0 then
				code = code .."\nfor i = 1, "..row_c.." do\n    guiGridListAddRow("..varname..")\nend"
			end
			
			local col_c = getElementData(element,"guieditor_colcount")
			if col_c>0 then
			--	code = code.."\nfor i = 1, "..col_c.." do\n    guiGridListAddColumn("..varname..",".. ..",0.2)\nend"
				for i=1, col_c do
					code = code.."\nguiGridListAddColumn("..varname..",\""..getElementData(element,"guieditor_coltitle_"..i).."\",0.2)"
				end
			end
			
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editorgrid = true
			end
			
			return code
		end
	
		if type == "gui-staticimage" then
			local parent_name = ",false"
			local parent = DoesElementHaveGUIParent(element)
			local values_type = false
		
			if parent==true and settings.child_output_type.value==true then parent_name = ",true,"..getElementData(getElementParent(element),"guieditor_varname") values_type = true
			elseif parent==true and settings.child_output_type.value==false then parent_name = ",false,"..getElementData(getElementParent(element),"guieditor_varname") values_type = false
			elseif parent==false and settings.screen_output_type.value==true then parent_name = ",true" values_type = true
			elseif parent==false and settings.screen_output_type.value==false then parent_name = ",false" values_type = false end			 
			
			local w,h = guiGetSize(element,values_type)
			local x,y = guiGetPosition(element,values_type)
			
			if values_type == true then
				if x > 1 or x < 0 or y > 1 or y < 0 or w > 1 or w < 0 or h > 1 or h < 0 then
					values_type = false
					parent_name = parent_name:gsub(",true",",false")
					
					w,h = guiGetSize(element,values_type)
					x,y = guiGetPosition(element,values_type)					
				end
			end			
			
			x = tonumber(string.format("%.4f",x)) y = tonumber(string.format("%.4f",y))
			w = tonumber(string.format("%.4f",w)) h = tonumber(string.format("%.4f",h))			
			local t = guiGetText(element) if t==nil or t==false then t = "" end
			local varname = getElementData(element,"guieditor_varname")
			code = varname.." = guiCreateStaticImage("..x..","..y..","..w..","..h..",\""..getElementData(element,"guieditor_dir").."\""..parent_name..")" --
			if getElementData(element,"guieditor_alpha")==true then code = code.."\nguiSetAlpha("..varname..","..guiGetAlpha(element)..")" end
			for prop,val in pairs(getElementData(element,"guieditor_properties")) do
				code = code .. "\nguiSetProperty("..varname..",\""..prop.."\",\""..val.."\")"
			end

			if UsingDefaultVariable(element) then
				editorimage = true
			end
			
			return code
		end
	end	
	return ""
end



function UsingDefaultVariable(element)
	if element then
		local type = getElementType(element)
		local varname = getElementData(element,"guieditor_varname")
		
		if type=="gui-window" then 
			if varname:find("GUIEditor_Window[",1,true) then return true end
		elseif type=="gui-button" then
			if varname:find("GUIEditor_Button[",1,true) then return true end
		elseif type=="gui-memo" then 
			if varname:find("GUIEditor_Memo[",1,true) then return true end
		elseif type=="gui-label" then 
			if varname:find("GUIEditor_Label[",1,true) then return true end
		elseif type=="gui-checkbox" then 
			if varname:find("GUIEditor_Checkbox[",1,true) then return true end
		elseif type=="gui-edit" then 
			if varname:find("GUIEditor_Edit[",1,true) then return true end
		elseif type=="gui-gridlist" then 
			if varname:find("GUIEditor_Grid[",1,true) then return true end
		elseif type=="gui-progressbar" then 
			if varname:find("GUIEditor_Progress[",1,true) then return true end
		elseif type=="gui-tabpanel" then 
			if varname:find("GUIEditor_TabPanel[",1,true) then return true end
		elseif type=="gui-tab" then 
			if varname:find("GUIEditor_Tab[",1,true) then return true end
		elseif type=="gui-radiobutton" then
			if varname:find("GUIEditor_Radio[",1,true) then return true end
		elseif type=="gui-staticimage" then 
			if varname:find("GUIEditor_Image[",1,true) then return true end
		else return false
		end
	end
	
	return false
end



function GenerateCodeForDX(element)
	if element and isElement(element) then
		local code = ""
		
		if getElementType(element) == "gui-label" then
			if dx_attributes[element].type == "text" then
				local x,y,w,h = GetAbsolutePositionAndSizeOfElement(element)
				if x then	
					local r,g,b,a = HexToRGBA(string.format("%X",dx_attributes[element].colour))
					code = string.format("        dxDrawText(\"%s\",%.1f,%.1f,%.1f,%.1f,tocolor(%d,%d,%d,%d),%.1f,\"%s\",\"%s\",\"%s\",%s,%s,%s)",tostring(dx_attributes[element].text),x,y,x+w,y+h,r,g,b,a,dx_attributes[element].scale,dx_attributes[element].font,dx_attributes[element].halign,dx_attributes[element].valign,tostring(dx_attributes[element].clip),tostring(dx_attributes[element].wordwrap),tostring(dx_attributes[element].postgui))
				end
			elseif dx_attributes[element].type == "line" then
				local r,g,b,a = HexToRGBA(string.format("%X",dx_attributes[element].colour))
				code = string.format("        dxDrawLine(%.1f,%.1f,%.1f,%.1f,tocolor(%d,%d,%d,%d),%.1f,%s)",dx_attributes[element].sx,dx_attributes[element].sy,dx_attributes[element].ex,dx_attributes[element].ey,r,g,b,a,dx_attributes[element].width,tostring(dx_attributes[element].postgui))
			elseif dx_attributes[element].type == "rectangle" then
				local x,y,w,h = GetAbsolutePositionAndSizeOfElement(element)
				if x then	
					local r,g,b,a = HexToRGBA(string.format("%X",dx_attributes[element].colour))
					code = string.format("        dxDrawRectangle(%.1f,%.1f,%.1f,%.1f,tocolor(%d,%d,%d,%d),%s)",x,y,w,h,r,g,b,a,tostring(dx_attributes[element].postgui))
				end			
			elseif dx_attributes[element].type == "image" then
				local x,y,w,h = GetAbsolutePositionAndSizeOfElement(element)
				if x then	
					local r,g,b,a = HexToRGBA(string.format("%X",dx_attributes[element].colour))
					code = string.format("        dxDrawImage(%.1f,%.1f,%.1f,%.1f,\"%s\",%.1f,%.1f,%.1f,tocolor(%d,%d,%d,%d),%s)",x,y,w,h,dx_attributes[element].image,dx_attributes[element].rotation,dx_attributes[element].rxoffset,dx_attributes[element].ryoffset,r,g,b,a,tostring(dx_attributes[element].postgui))
				end					
			end
		else
			outputDebugString("GUIEditor Error: attempt to generate DX code on ["..getElementType(element).."]")
		end
		
		return code
	end
	return ""
end
