--[[ GUI Editor - Drawing - Client/DX ]]--

dx_attributes = {}
dx_ordering = {}
dx_internal = {}


addEventHandler("onClientPreRender",root,function()
	-- loop it backwards because the last dx item to be created is the top
	for i=#dx_ordering, 1, -1 do
		if dx_ordering[i] and dx_attributes[dx_ordering[i]] then
			local drawing = dx_attributes[dx_ordering[i]]
			if drawing.type == "rectangle" then
				local x,y,w,h = GetAbsolutePositionAndSizeOfElement(dx_ordering[i])
				if x then			
					dxDrawRectangle(x,y,w,h,drawing.colour,drawing.postgui)
				end		
			elseif drawing.type == "image" then
				local x,y,w,h = GetAbsolutePositionAndSizeOfElement(dx_ordering[i])
				if x then			
					dxDrawImage(x,y,w,h,drawing.image,drawing.rotation,drawing.rxoffset,drawing.ryoffset,drawing.colour,drawing.postgui)
				end	
			elseif drawing.type == "line" then
				dxDrawLine(drawing.sx,drawing.sy,drawing.ex,drawing.ey,drawing.colour,drawing.width,drawing.postgui)				
			elseif drawing.type == "text" then
				local x,y,w,h = GetAbsolutePositionAndSizeOfElement(dx_ordering[i])
				if x then
					dxDrawText(tostring(drawing.text),x,y,x+w,y+h,drawing.colour,drawing.scale,drawing.font,drawing.halign,drawing.valign,drawing.clip,drawing.wordwrap,drawing.postgui)
				end	
			end			
		end
	end
	--dxDrawText("text",569.0,400.0,141.0,74.0,"0xFF0000FF",5.0,"default","left","top",false,false,false)
	-- alpha red green (blue not detected), MTA bug, remember to submit report
	
	
	for i,drawing in ipairs(dx_internal) do
		if drawing.type == "line" then
			dxDrawLine(drawing.sx,drawing.sy,drawing.ex,drawing.ey,drawing.colour,drawing.width,drawing.postgui)
			if drawing.destruct then dx_internal[i] = nil end
		end
	end
end)



function loadDXDrawing(type,gui)
	if type == "dx_text" then				
		dx_attributes[gui] = {}
		dx_attributes[gui].type = "text"
		dx_attributes[gui].text = ""
		dx_attributes[gui].colour = tocolor(255,255,255,255)
		dx_attributes[gui].scale = 1
		dx_attributes[gui].font = "default"
		dx_attributes[gui].valign = "top"
		dx_attributes[gui].halign = "left"
		dx_attributes[gui].clip = false
		dx_attributes[gui].wordwrap = false
		dx_attributes[gui].postgui = false
		table.insert(dx_ordering,gui)
		setElementData(gui,"guieditor_varname","")
	elseif type == "dx_line" then
		dx_attributes[gui] = {}
		dx_attributes[gui].type = "line"
		dx_attributes[gui].sx = 0
		dx_attributes[gui].sy = 0
		dx_attributes[gui].ex = 0
		dx_attributes[gui].ey = 0
		dx_attributes[gui].colour = tocolor(255,255,255,255)
		dx_attributes[gui].width = 1
		dx_attributes[gui].postgui = false
		table.insert(dx_ordering,gui)
		addEventHandler("onClientGUIMove",gui,plotCorrectDXPosition)
		addEventHandler("onCleintGUISize",gui,plotCorrectDXPosition)
		setElementData(gui,"guieditor_varname","")
	elseif type == "dx_rectangle" then
		dx_attributes[gui] = {}
		dx_attributes[gui].type = "rectangle"
		dx_attributes[gui].colour = tocolor(255,255,255,255)
		dx_attributes[gui].postgui = false
		table.insert(dx_ordering,gui)
		setElementData(gui,"guieditor_varname","")
	elseif type == "dx_pre_image" then
		dx_attributes[gui] = {}
		dx_attributes[gui].type = "image"
		dx_attributes[gui].image = ""
		dx_attributes[gui].rotation = 0
		dx_attributes[gui].rxoffset = 0
		dx_attributes[gui].ryoffset = 0
		dx_attributes[gui].colour = tocolor(255,255,255,255)
		dx_attributes[gui].postgui = false
		table.insert(dx_ordering,gui)
		setElementData(gui,"guieditor_varname","")
	end
end


function copyDXItem(original,copy)
	if original and copy then
		dx_attributes[copy] = {}
		
		for key,value in pairs(dx_attributes[original]) do
			dx_attributes[copy][tostring(key)] = value
			outputChatBox("Copying: "..tostring(key).." as "..tostring(value))
		end
		
		setElementData(copy,"modify_menu",getElementData(original,"modify_menu"))
		table.insert(dx_ordering,copy)
		
		if dx_attributes[copy].type == "line" then
			addEventHandler("onClientGUIMove",copy,plotCorrectDXPosition)
			addEventHandler("onCleintGUISize",copy,plotCorrectDXPosition)
		end
	end
end


function removeDXDrawing(gui)
	if dx_attributes[gui].type == "line" then
		removeEventHandler("onClientGUIMove",gui,plotCorrectDXPosition)
		removeEventHandler("onCleintGUISize",gui,plotCorrectDXPosition)
	end

	dx_attributes[gui] = nil
	
	removeOrdering(gui)
end


function removeOrdering(gui)
	local removal = nil
	
	for index,value in pairs(dx_ordering) do
		if value == gui then removal = index end
	end
	
	if removal then
		table.remove(dx_ordering,removal)
	end
end


function moveDXToBack(gui)
	removeOrdering(gui)
	
	table.insert(dx_ordering,gui)
end


function plotCorrectDXPosition(gui)
	if not gui then gui = source end
	
	if gui then
		local x,y,w,h = GetAbsolutePositionAndSizeOfElement(gui)
		
		if dx_attributes[gui].orientation == "tr" then
			dx_attributes[gui].sx = x
			dx_attributes[gui].sy = y+h
			dx_attributes[gui].ex = x+w
			dx_attributes[gui].ey = y
		elseif dx_attributes[gui].orientation == "br" then
			dx_attributes[gui].sx = x
			dx_attributes[gui].sy = y
			dx_attributes[gui].ex = x+w
			dx_attributes[gui].ey = y+h		
		elseif dx_attributes[gui].orientation == "tl" then
			dx_attributes[gui].sx = x+w
			dx_attributes[gui].sy = y+h
			dx_attributes[gui].ex = x
			dx_attributes[gui].ey = y		
		elseif dx_attributes[gui].orientation == "bl" then
			dx_attributes[gui].sx = x+w
			dx_attributes[gui].sy = y
			dx_attributes[gui].ex = x
			dx_attributes[gui].ey = y+h		
	--[[	elseif dx_attributes[gui].orientation == "t" then
			dx_attributes[gui].sx = x+(w/2)
			dx_attributes[gui].sy = y+h
			dx_attributes[gui].ex = x+(w/2)
			dx_attributes[gui].ey = y
		elseif dx_attributes[gui].orientation == "b" then
			dx_attributes[gui].sx = x+(w/2)
			dx_attributes[gui].sy = y
			dx_attributes[gui].ex = x+(w/2)
			dx_attributes[gui].ey = y+h	
		elseif dx_attributes[gui].orientation == "l" then
			dx_attributes[gui].sx = x
			dx_attributes[gui].sy = y+(h/2)
			dx_attributes[gui].ex = x+w
			dx_attributes[gui].ey = y+(h/2)		
		elseif dx_attributes[gui].orientation == "r" then
			dx_attributes[gui].sx = x+w
			dx_attributes[gui].sy = y+(h/2)
			dx_attributes[gui].ex = x
			dx_attributes[gui].ey = y+(h/2)		]]			
		end
	end	
end


function plotCorrectMaskPosition(center_x,center_y,clicked_x,clicked_y,element)
	-- top right
	if center_x<=clicked_x and center_y>clicked_y then
		guiSetPosition(element,center_x,clicked_y,false)
		guiSetSize(element,clicked_x-center_x,center_y-clicked_y,false)
		dx_attributes[element].orientation = "tr"
	-- bottom right
	elseif center_x<clicked_x and center_y<=clicked_y then
		guiSetPosition(element,center_x,center_y,false)
		guiSetSize(element,clicked_x-center_x,clicked_y-center_y,false)
		dx_attributes[element].orientation = "br"		
	-- top left
	elseif center_x>clicked_x and center_y>=clicked_y then
		guiSetPosition(element,clicked_x,clicked_y,false)
		guiSetSize(element,center_x-clicked_x,center_y-clicked_y,false)	
		dx_attributes[element].orientation = "tl"
	-- bottom left
	elseif center_x>=clicked_x and center_y<clicked_y then
		guiSetPosition(element,clicked_x,center_y,false)
		guiSetSize(element,center_x-clicked_x,clicked_y-center_y,false)	
		dx_attributes[element].orientation = "bl"
	-- top
--[[	elseif center_x==clicked_x and center_y>clicked_y then
		guiSetPosition(element,center_x-(math.ceil(min_size[1]/2)),clicked_y,false)
		guiSetSize(element,min_size[1],center_y-clicked_y,false)	
		dx_attributes[element].orientation = "t"		
	-- bottom
	elseif center_x==clicked_x and center_y<clicked_y then
		guiSetPosition(element,center_x-(math.ceil(min_size[1]/2)),center_y,false)
		guiSetSize(element,min_size[1],clicked_y-center_y,false)	
		dx_attributes[element].orientation = "b"		
	-- left
	elseif center_x>clicked_x and center_y==clicked_y then
		guiSetPosition(element,clicked_x,center_y-(math.ceil(min_size[1]/2)),false)
		guiSetSize(element,center_x-clicked_x,min_size[2],false)	
		dx_attributes[element].orientation = "l"		
	-- right
	elseif center_x<clicked_x and center_y==clicked_y then
		guiSetPosition(element,center_x,center_y-(math.ceil(min_size[1]/2)),false)
		guiSetSize(element,clicked_x-center_x,min_size[2],false)	
		dx_attributes[element].orientation = "r"	]]	
	-- fucked
	else
		outputDebugString("GUIEditor Error: plotCorrectMaskPosition failed to determine position.")
	end
						
--	local w,h = guiGetSize(element,false)
--	if w < min_size[1] then w = min_size[1] end
--	if h < min_size[2] then h = min_size[2] end
--	guiSetSize(element,w,h,false)	
end




function loadInternalDXDrawing(type,...)
	
	local index = #dx_internal+1
	
	if type == "dx_line" then
		dx_internal[index] = {}
		
		local args = {...}
		
		dx_internal[index].type = "line"
		dx_internal[index].sx = args[1]
		dx_internal[index].sy = args[2]
		dx_internal[index].ex = args[3]
		dx_internal[index].ey = args[4]
		dx_internal[index].colour = tocolor(args[5],args[6],args[7],args[8])
		dx_internal[index].width = args[9]
		dx_internal[index].postgui = args[10]
		dx_internal[index].destruct = args[11]
		return index
	end
end


function removeInternalDXDrawing(index)
	dx_internal[index] = nil
end
