--[[ GUI Editor (server) ]]--

function OutputGUIToFile(text,valuetype)
	local file = fileOpen("GUIEditor_output.txt") 
	if not file then
		file = fileCreate("GUIEditor_output.txt")
	end
    
	if file then      
		fileSetPos(file,fileGetSize(file))
		local written = fileWrite(file,"\r\n",text,"\r\n--- --- --- --- ---\r\n")
		fileClose(file)
		if written then
			outputChatBox("Succesfully saved to GUIEditor_output.txt",source)
			outputChatBox(valuetype,source)
		end
	end
end
addEvent("OutputGUIToFile",true)
addEventHandler("OutputGUIToFile",getRootElement(),OutputGUIToFile)


function ServerLoadImageTable()
	local res,table_,xml = getThisResource(), {}, xmlLoadFile("meta.xml",res)
    if xml then
		local i = 0
		while (xmlFindChild(xml, "file", i)) do  
			local dir = xmlNodeGetAttribute(xmlFindChild(xml, "file", i), "src")
			if dir:find("images/")~=nil then
				table.insert(table_,dir)
			end
			i = i + 1
		end  	
	end
	
	--for i,v in ipairs(table_) do
	--	outputChatBox(v)
	--end
	
	triggerClientEvent(source,"ClientReceiveImageTable",getRootElement(),table_)
end
addEvent("ServerLoadImageTable",true)
addEventHandler("ServerLoadImageTable",getRootElement(),ServerLoadImageTable)


addEvent("getEditorVersion",true)
addEventHandler("getEditorVersion",root,function()
	triggerClientEvent(client,"receiveEditorVersion",client,getResourceInfo(getThisResource(),"version"))
end)
	

function checkForUpdates(manual)
	local player = client
	local called = callRemote("http://community.mtasa.com/mta/resources.php",function(n,v) updateResult(n,v,player,manual) end,"version",string.lower(getResourceName(getThisResource())))
	
	if not called then
	--	outputChatBox("Error: Check ACL permissions and website availability.")
		triggerClientEvent(client,"receiveUpdateCheck",client,nil)
	end
end	
addEvent("checkUpdateStatus",true)
addEventHandler("checkUpdateStatus",root,checkForUpdates)


function updateResult(name,version,player,manual)
	local update = false
	
	if string.lower(name):find("error") or version == 0 then update = nil end
	
	if update == false then
		local v1,v2,v3 = parseVersion(tostring(version))

		local cv1,cv2,cv3 = parseVersion(tostring(getResourceInfo(getThisResource(),"version")))
		
		if v1 and cv1 then
			if v1 > cv1 then update = true
			elseif v2 > cv2 then update = true
			elseif v3 > cv3 then update = true
			end
		end
	end

	triggerClientEvent(player,"receiveUpdateCheck",player,update,version,tostring(getResourceInfo(getThisResource(),"version")),manual)
end


function parseVersion(version)
	local parts = split(version,string.byte("."))
	
	return parts[1],parts[2],parts[3]
end


	
-- needed as of 1.0 to get a list of gui elements
-- no longer needed as of 1.0.1
--[[
function GetResourcesForOutput(arg1,arg2)
	local resources = {}
	
	for _,res in ipairs(getResources()) do
		if getResourceState(res) == "running" then
			table.insert(resources,getResourceName(res))
		end
	end
	
	triggerClientEvent(source,"RecieveResourcesForOutput",getRootElement(),resources,arg1,arg2)
end
addEvent("GetResourcesForOutput",true)
addEventHandler("GetResourcesForOutput",getRootElement(),GetResourcesForOutput)
]]