--[[ GUI Editor - Load GUI - Client ]]--


function LoadGUIElement(element)
	if element then
		local type = getElementType(element)
		--outputChatBox("loaded "..type)
		
		local font = guiGetFont(element)
		if font and font == "default-normal" then font = nil end
		if font then guiSetFont(element,font) end
		
		if type=="gui-window" then 
			GUIEditor_Window[window_count] = element
			setElementData(GUIEditor_Window[window_count],"guieditor_varname","GUIEditor_Window["..window_count.."]")
			setElementData(GUIEditor_Window[window_count],"guieditor_movable",true)	
			setElementData(GUIEditor_Window[window_count],"guieditor_sizable",true)	
			setElementData(GUIEditor_Window[window_count],"guieditor_properties",{})
			window_count = window_count + 1
		elseif type=="gui-button" then 
			GUIEditor_Button[button_count] = element
			setElementData(GUIEditor_Button[button_count],"guieditor_varname","GUIEditor_Button["..button_count.."]")		
			setElementData(GUIEditor_Button[button_count],"guieditor_properties",{})
			button_count = button_count + 1
		elseif type=="gui-memo" then
			GUIEditor_Memo[memo_count] = element
			setElementData(GUIEditor_Memo[memo_count],"guieditor_varname","GUIEditor_Memo["..memo_count.."]")
			setElementData(GUIEditor_Memo[memo_count],"guieditor_properties",{})
			memo_count = memo_count + 1
		elseif type=="gui-label" then 
			GUIEditor_Label[label_count] = element
			setElementData(GUIEditor_Label[label_count],"guieditor_varname","GUIEditor_Label["..label_count.."]")
			local colour = guiGetProperty(GUIEditor_Label[label_count],"TextColours")
			if colour then
				local r,g,b,a = HexToRGBA(colour:sub(4,11))
				if r and g and b then
					setElementData(GUIEditor_Label[label_count],"guieditor_colour",r..","..g..","..b)
				end
			end
			setElementData(GUIEditor_Label[label_count],"guieditor_wordwrap",false)
			setElementData(GUIEditor_Label[label_count],"guieditor_horizalign","left")
			setElementData(GUIEditor_Label[label_count],"guieditor_vertalign","top")
			setElementData(GUIEditor_Label[label_count],"guieditor_properties",{})
			label_count = label_count + 1	
		elseif type=="gui-checkbox" then 
			GUIEditor_Checkbox[checkbox_count] = element
			setElementData(GUIEditor_Checkbox[checkbox_count],"guieditor_varname","GUIEditor_Checkbox["..checkbox_count.."]")	
			setElementData(GUIEditor_Checkbox[checkbox_count],"guieditor_properties",{})
			checkbox_count = checkbox_count + 1	
		elseif type=="gui-edit" then 
			GUIEditor_Edit[edit_count] = element
			setElementData(GUIEditor_Edit[edit_count],"guieditor_varname","GUIEditor_Edit["..edit_count.."]")
			setElementData(GUIEditor_Edit[edit_count],"guieditor_masked",false)
			setElementData(GUIEditor_Edit[edit_count],"guieditor_maxlength",nil)
			setElementData(GUIEditor_Edit[edit_count],"guieditor_properties",{})
			edit_count = edit_count + 1	
		elseif type=="gui-gridlist" then 
			GUIEditor_Grid[grid_count] = element
			guiGridListSetSelectionMode(GUIEditor_Grid[grid_count],2)
			setElementData(GUIEditor_Grid[grid_count],"guieditor_varname","GUIEditor_Grid["..grid_count.."]")
			setElementData(GUIEditor_Grid[grid_count],"guieditor_colcount",0)
			setElementData(GUIEditor_Grid[grid_count],"guieditor_properties",{})
			grid_count = grid_count + 1	
		elseif type=="gui-progressbar" then 
			GUIEditor_Progress[progress_count] = element
			setElementData(GUIEditor_Progress[progress_count],"guieditor_varname","GUIEditor_Progress["..progress_count.."]")
			setElementData(GUIEditor_Progress[progress_count],"guieditor_properties",{})
			progress_count = progress_count + 1	
		elseif type=="gui-tabpanel" then 
			GUIEditor_TabPanel[tabpanel_count] = element
			setElementData(GUIEditor_TabPanel[tabpanel_count],"guieditor_varname","GUIEditor_TabPanel["..tabpanel_count.."]")			
			setElementData(GUIEditor_TabPanel[tabpanel_count],"guieditor_properties",{})
			tabpanel_count = tabpanel_count + 1	
		elseif type=="gui-tab" then 
			GUIEditor_Tab[tab_count] = element
			setElementData(GUIEditor_Tab[tab_count],"guieditor_varname","GUIEditor_Tab["..tab_count.."]")
		--	setElementData(GUIEditor_Tab[tab_count],"guieditor_parent",getElementData(getElementParent(element),"guieditor_varname"))
			setElementData(GUIEditor_Tab[tab_count],"guieditor_properties",{})
			tab_count = tab_count + 1	
		elseif type=="gui-radiobutton" then 
			GUIEditor_Radio[radio_count] = element
			setElementData(GUIEditor_Radio[radio_count],"guieditor_varname","GUIEditor_Radio["..radio_count.."]")	
			setElementData(GUIEditor_Radio[radio_count],"guieditor_properties",{})
			radio_count = radio_count + 1	
		elseif type=="gui-staticimage" then
			GUIEditor_Image[image_count] = element
			setElementData(GUIEditor_Image[image_count],"guieditor_varname","GUIEditor_Image["..image_count.."]")
			setElementData(GUIEditor_Image[image_count],"guieditor_dir",image_dir)
			setElementData(GUIEditor_Image[image_count],"guieditor_properties",{})
			image_count = image_count + 1
		end
	else
		outputDebugString("GUIEditor Error: GUI element could not be created. Element data not set.",1)
	end
end


function HexToRGBA(hex)
	if type(hex) ~= "string" then hex = tostring(hex) end
	
	if hex:len() ~= 8 then
		return nil,nil,nil,nil
	else
		alpha = "0x" .. hex:sub(1,2)
		red = "0x" .. hex:sub(3,4)
		green = "0x" .. hex:sub(5,6)
		blue = "0x" .. hex:sub(7,8)
		
		alpha = tonumber(alpha)
		red = tonumber(red)
		green = tonumber(green)
		blue = tonumber(blue)		
		return red, green, blue, alpha
	end
end
