local captureTable = {
"tf2/cp/announcer_we_secured_control.ogg",
"tf2/cp/announcer_we_captured_control.ogg"
}
local alertTable = {
"tf2/cp/announcer_control_point_warning2.ogg",
"tf2/cp/announcer_control_point_warning3.ogg",
"tf2/cp/announcer_control_point_warning.ogg"
}
local centerAlertTable = {
"tf2/cp/announcer_alert_center_control_being_contested.ogg",
"tf2/cp/announcer_alert_center_control_being_captured.ogg"
}
local lastAlertTable = {
"tf2/cp/announcer_last_flag2.ogg",
"tf2/cp/announcer_last_flag.ogg"
}

local startsound

local pointParents = {}
local endtime = 10000
local respawntime = 10000
local sx,sy = guiGetScreenSize()

function teamselect()
	startsound = playSound("tf2/gamestartup1.ogg",true)
	setSoundVolume(startsound,0.3)
	bluteam = getTeamFromName("Blu")
	redteam = getTeamFromName("Red")
	--triggerServerEvent("requestMapState",getLocalPlayer())
	GUIEditor_Window = {}
	GUIEditor_Button = {}
	GUIEditor_Label = {}
	GUIEditor_Image = {}
	
	showCursor(true)
	
	GUIEditor_Window[1] = guiCreateWindow(sx - (0.5 * sx) - 200,sy - (0.5 * sy) - 75,400,150,"Welcome",false)
	guiWindowSetMovable(GUIEditor_Window[1],true)
	guiWindowSetSizable(GUIEditor_Window[1],false)
	GUIEditor_Label[1] = guiCreateLabel(0,0.05,1,0.4,"Please choose a team:",true,GUIEditor_Window[1])
	guiLabelSetColor(GUIEditor_Label[1],255,255,255)
	guiLabelSetVerticalAlign(GUIEditor_Label[1],"center")
	guiLabelSetHorizontalAlign(GUIEditor_Label[1],"center",false)
	GUIEditor_Button[1] = guiCreateButton(0.3795,0.4,0.2426,0.25,"Spectate",true,GUIEditor_Window[1])
	GUIEditor_Button[2] = guiCreateButton(0.0980,0.4,0.2426,0.25,"Blu",true,GUIEditor_Window[1])
	GUIEditor_Button[3] = guiCreateButton(0.661,0.4,0.2426,0.25,"Red",true,GUIEditor_Window[1])
	
	addEventHandler("onClientGUIClick",GUIEditor_Button[2],requestBlu,false)
	addEventHandler("onClientGUIClick",GUIEditor_Button[3],requestRed,false)
	addEventHandler("onClientGUIClick",GUIEditor_Button[1],chooseSpectate,false)
	setTimer(createCoronaMarkers,1000,1)
end
addEventHandler("onClientResourceStart",getResourceRootElement(getThisResource()),teamselect)

function chooseSpectate()
	if #getPlayersInTeam(redteam) + #getPlayersInTeam(bluteam) >= 1 then
		closeTeamSelection()
		triggerServerEvent("onTeamJoin",getLocalPlayer(),nil)
		startSpectating(true)
	else
		cantJoin()
	end
end

function resetRound()
	local targetmarker = getElementData(getLocalPlayer(),"targetmarker")
	local enemymarker = getElementData(getLocalPlayer(),"enemymarker")
	for i,v in ipairs(getElementsByType("marker"),getResourceRootElement(getThisResource())) do
		if v ~= targetmarker and v ~= enemymarker then
			destroyElement(v)
		end
	end
		
	for i,v in ipairs(getElementsByType("blip"),getResourceRootElement(getThisResource())) do
		destroyElement(v)
	end
		
	for i,v in ipairs(getElementsByType("pointparent"),getResourceRootElement(getThisResource())) do
		destroyElement(v)
	end
	
	outputDebugString("Client Reset All CP Data")
	pointParents = {}
	setTimer(createCoronaMarkers,1000,1)
end
addEvent("onClientGamemodeMapStart",true)
addEventHandler("onClientGamemodeMapStart",getRootElement(),resetRound)

function createCoronaMarkers()
	for i,v in ipairs(getElementsByType("pointparent")) do
		pointParents[v] = {}
		local px,py,pz = getElementPosition(getElementChild(v,0))
		--[[
		pointParents[v][1] = createMarker(px,py+5,getGroundPosition(px,py+5,pz+3),"corona",2,0,255,0,100)
		pointParents[v][2] = createMarker(px+3.5,py+3.5,getGroundPosition(px+3.5,py+3.5,pz+3),"corona",2,0,255,0,100)
		pointParents[v][3] = createMarker(px+5,py,getGroundPosition(px+5,py,pz+3),"corona",2,0,255,0,100)
		pointParents[v][4] = createMarker(px+3.5,py-3.5,getGroundPosition(px+3.5,py-3.5,pz+3),"corona",2,0,255,0,100)
		pointParents[v][5] = createMarker(px,py-5,getGroundPosition(px,py-5,pz+3),"corona",2,0,255,0,100)
		pointParents[v][6] = createMarker(px-3.5,py-3.5,getGroundPosition(px-3.5,py-3.5,pz+3),"corona",2,0,255,0,100)
		pointParents[v][7] = createMarker(px-5,py,getGroundPosition(px-5,py,pz+3),"corona",2,0,255,0,100)
		pointParents[v][8] = createMarker(px-3.5,py+3.5,getGroundPosition(px-3.5,py+3.5,pz+3),"corona",2,0,255,0,100)
		]]
		pointParents[v][1] = createMarker(px,py+5,pz,"corona",2,0,255,0,100)
		pointParents[v][2] = createMarker(px+3.5,py+3.5,pz,"corona",2,0,255,0,100)
		pointParents[v][3] = createMarker(px+5,py,pz,"corona",2,0,255,0,100)
		pointParents[v][4] = createMarker(px+3.5,py-3.5,pz,"corona",2,0,255,0,100)
		pointParents[v][5] = createMarker(px,py-5,pz,"corona",2,0,255,0,100)
		pointParents[v][6] = createMarker(px-3.5,py-3.5,pz,"corona",2,0,255,0,100)
		pointParents[v][7] = createMarker(px-5,py,pz,"corona",2,0,255,0,100)
		pointParents[v][8] = createMarker(px-3.5,py+3.5,pz,"corona",2,0,255,0,100)
		for i=1,8,1 do
			setElementAlpha(pointParents[v][i],0)
		end
	end
	for i,v in ipairs(getElementsByType("pointparent")) do
		if tonumber(getElementData(v,"state")) == -1 then
			for i1,v1 in ipairs(getElementsByType("pointparent")) do
				if tonumber(getElementData(v1,"order")) + 1 == tonumber(getElementData(v,"order")) then
					if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) and tonumber(getElementData(v1,"state")) ~= 0 and tonumber(getElementData(v,"state")) ~= 0 then
						for i2,v2 in ipairs(pointParents[v]) do
							setElementAlpha(pointParents[v][i2],100)
						end
						setElementData(v,"availableFromStart",true,false)
					end
				end
			end
		elseif tonumber(getElementData(v,"state")) == 1 then
			for i1,v1 in ipairs(getElementsByType("pointparent")) do
				if tonumber(getElementData(v1,"order")) - 1 == tonumber(getElementData(v,"order")) then
					if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) and tonumber(getElementData(v1,"state")) ~= 0 and tonumber(getElementData(v,"state")) ~= 0 then
						for i2,v2 in ipairs(pointParents[v]) do
							setElementAlpha(pointParents[v][i2],100)
						end
						setElementData(v,"availableFromStart",true,false)
					end
				end
			end
		else
			for i1,v1 in ipairs(getElementsByType("pointparent")) do
				if tonumber(getElementData(v1,"order")) - 1 == tonumber(getElementData(v,"order")) or tonumber(getElementData(v1,"order")) + 1 == tonumber(getElementData(v,"order")) then
					if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) then
						for i2,v2 in ipairs(pointParents[v]) do
							setElementAlpha(pointParents[v][i2],100)
						end
						setElementData(v,"availableFromStart",true,false)
					end
				end
			end
		end
	end
end

function requestBlu()
	--if mapstate then
		if getTeamMemberAmount(bluteam) - getTeamMemberAmount(redteam) <= 0 then
			closeTeamSelection()
			--if mapstate == "prepare" then
				triggerServerEvent("onTeamJoin",getLocalPlayer(),bluteam)
			--elseif mapstate == "heist" or mapstate == "escape" then
			--	if not getPlayerTeam(getLocalPlayer()) or not getPlayerTeam(getLocalPlayer()) == bluteam then
			--		setElementData(getLocalPlayer(),"team",bluteam,true)
			--	end
			--	if not getPlayerTeam(getLocalPlayer()) or isPlayerDead(getLocalPlayer()) then
			--		startSpectating()
			--	end
			--end
		else
			cantJoin("Blu")
		end
	--else
	--	mapstatemissing()
	--end
end

function requestRed()
	--if mapstate then
		if getTeamMemberAmount(redteam) - getTeamMemberAmount(bluteam) <= 0 then
			closeTeamSelection()
			--if mapstate == "prepare" then
				triggerServerEvent("onTeamJoin",getLocalPlayer(),redteam)
			--elseif mapstate == "heist" or mapstate == "escape" then
			--	if not getPlayerTeam(getLocalPlayer()) or not getPlayerTeam(getLocalPlayer()) == redteam then
			--		setElementData(getLocalPlayer(),"team",redteam,true)
			--	end
			--	if not getPlayerTeam(getLocalPlayer()) or isPlayerDead(getLocalPlayer()) then
			--		startSpectating()
			--	end
			--end
		else
			cantJoin("Red")
		end
	--else
	--	mapstatemissing()
	--end
end

function showGui()
	guiSetVisible(GUIEditor_Window[1],true)
	showCursor(true)
end
addEvent("showTeamSelection",true)
addEventHandler("showTeamSelection",getRootElement(),showGui)

function rechooseTeam()
	if getPlayerTeam(getLocalPlayer()) then
		guiSetVisible(GUIEditor_Window[1],not guiGetVisible(GUIEditor_Window[1]))
		showCursor(not isCursorShowing())
	else
		guiSetVisible(GUIEditor_Window[1],true)
		showCursor(true)
	end
end
addCommandHandler("reselect",rechooseTeam)
bindKey(".","down","reselect")

function closeTeamSelection()
	if isElement(startsound) then
		stopSound(startsound)
	end
	guiSetVisible(GUIEditor_Window[1],false)
	showCursor(false)
end

function cantJoin(team)
	if team then
		local label = guiCreateLabel(0.01,0.7,1,0.2,"Can't join "..team.."\n(too many players)",true,GUIEditor_Window[1])
		guiLabelSetVerticalAlign(label,"center")
		guiLabelSetHorizontalAlign(label,"center",false)
		setTimer(destroyElement,2000,1,label)
	else
		local label = guiCreateLabel(0.01,0.7,1,0.1,"Can't spectate. No one to spectate",true,GUIEditor_Window[1])
		guiLabelSetVerticalAlign(label,"center")
		guiLabelSetHorizontalAlign(label,"center",false)
		setTimer(destroyElement,2000,1,label)
	end
end

function getTeamMemberAmount(team)
	local otherteam
	if team == bluteam then
		otherteam = redteam
	elseif team == redteam then
		otherteam = bluteam
	end
	local amount = 0
	if getPlayersInTeam(team) then
		for i,v in ipairs(getPlayersInTeam(team)) do
			--if not getElementData(v,"team") or not getElementData(v,"team") == otherteam then
				amount = amount + 1
			--end
		end
		--for i,v in ipairs(getPlayersInTeam(otherteam)) do
		--	if getElementData(v,"team") and getElementData(v,"team") == team then
		--		amount = amount + 1
		--	end
		--end
	end
	return amount
end

function roundEnd()
	if getPlayerTeam(getLocalPlayer()) == source then
		local sound = playSound("tf2/roundend/your_team_won.ogg",false)
		setSoundVolume(sound,0.5)
	else
		local sound = playSound("tf2/roundend/your_team_lost.ogg",false)
		setSoundVolume(sound,0.5)
	end
	for i,v in ipairs(getElementsByType("pointparent")) do
		for i1,v1 in ipairs(pointParents[v]) do
			setElementAlpha(pointParents[v][i1],0)
		end
	end
	setTimer(showStartAvailableMarkers,endtime,1)
end
addEvent("onRoundEnd",true)
addEventHandler("onRoundEnd",getRootElement(),roundEnd)

function showStartAvailableMarkers()
	for i,v in ipairs(getElementsByType("pointparent")) do
		if getElementData(v,"availableFromStart") == true then
			for i1,v1 in ipairs(pointParents[v]) do
				setElementAlpha(pointParents[v][i1],100)
			end
		end
	end
end

function drawPoints()
	local points = getElementsByType("pointparent")
	local pointcount = #points
	for i,v in ipairs(points) do
		for i1,v1 in ipairs(getElementChildren(v)) do
			if getElementType(v1) == "marker" then
				if isElementWithinMarker(getLocalPlayer(),v1) then
					dxDrawImage((sx*0.5-15)+(tonumber(getElementData(v,"order"))*80),sy-120,40,30,"materials/arrow.png")
				end
			end
		end
		if getElementData(v,"challenger") == false then
			local r,g,b
			
			if tonumber(getElementData(v,"state")) == -1 then
				r,g,b = 0,0,255
			elseif tonumber(getElementData(v,"state")) == 1 then
				r,g,b = 255,0,0
			else
				r,g,b = 100,100,100
			end
			
			local order = tonumber(getElementData(v,"order"))
			
			dxDrawRectangle((sx*0.5-20)+(order*80)-5,sy-85,60,60,tocolor(0,0,0,255))
			dxDrawRectangle((sx*0.5-20)+(order*80),sy-80,50,50,tocolor(r,g,b,255))
			
			local cporder = tonumber(getElementData(v,"order"))
			
			for i1,v1 in ipairs(points) do
				if tonumber(getElementData(v1,"order")) + tonumber(getElementData(v1,"state")) == cporder or tonumber(getElementData(v1,"state")) == 0 then
					if tonumber(getElementData(v1,"state")) == tonumber(getElementData(v,"state")) or tonumber(getElementData(v1,"state")) == 0 then
						if tonumber(getElementData(v,"state")) ~= 0 then
							dxDrawImage((sx*0.5-20)+(order*80),sy-80,50,50,"materials/lock.png")
						end
					end
				end
			end
		else
			local r,g,b
			local r2,g2,b2
			if tonumber(getElementData(v,"state")) == -1 then
				r,g,b = 0,0,255
				r2,g2,b2 = 255,0,0
			elseif tonumber(getElementData(v,"state")) == 1 then
				r,g,b = 255,0,0
				r2,g2,b2 = 0,0,255
			else
				r,g,b = 100,100,100
				if tonumber(getElementData(v,"challenger")) == -1 then
					r2,g2,b2 = 0,0,255
				elseif tonumber(getElementData(v,"challenger")) == 1 then
					r2,g2,b2 = 255,0,0
				end
			end
			local order = tonumber(getElementData(v,"order"))
			dxDrawRectangle((sx*0.5-20)+(order*80)-5,sy-85,60,60,tocolor(0,0,0,255))
			dxDrawRectangle((sx*0.5-20)+(order*80),sy-80,50,50,tocolor(r,g,b,255))
			if tonumber(getElementData(v,"challenger")) == -1 then
				dxDrawRectangle((sx*0.5-20)+(order*80),sy-80,(tonumber(getElementData(v,"progress"))*50)/tonumber(getElementData(v,"captime")),50,tocolor(r2,g2,b2,255))
			else
				dxDrawRectangle(math.floor((sx*0.5-20)+(order*80)+(50*(tonumber(getElementData(v,"captime"))-tonumber(getElementData(v,"progress")))/tonumber(getElementData(v,"captime")))),sy-80,math.ceil((tonumber(getElementData(v,"progress"))*50)/tonumber(getElementData(v,"captime"))),50,tocolor(r2,g2,b2,255))
			end
			if getElementData(v,"blocked") then
				dxDrawImage((sx*0.5-20)+(order*80),sy-80,50,50,"materials/block.png")
			else
				local challengers = tonumber(getElementData(v,"challengers"))
				if challengers > 0 then
					dxDrawText("x"..challengers,(sx*0.5-20)+(order*80),sy-80,((sx*0.5-20)+(order*80))+50,sy-30,tocolor(255,255,255,255),2,"default","center","center",false,false,false)
				end
			end
		end
	end
end
addEventHandler("onClientRender",getRootElement(),drawPoints)

function pointCap(challenger)
	if tonumber(getElementData(getPlayerTeam(getLocalPlayer()),"id")) == challenger then
		if tonumber(getElementData(source,"order")) == 0 then
			playSound("tf2/cp/announcer_we_captured_center_control.ogg",false)
		else
			playSound(captureTable[math.random(1,#captureTable)],false)
		end
	else
		if tonumber(getElementData(source,"order")) == 0 then
			playSound("tf2/cp/announcer_we_lost_center_control.ogg",false)
		else
			playSound("tf2/cp/announcer_we_lost_control.ogg",false)
		end
	end
	for i,v in ipairs(getElementsByType("pointparent")) do
		if tonumber(getElementData(v,"order")) + challenger == tonumber(getElementData(source,"order")) then
			--sichtbar
			for i1,v1 in ipairs(pointParents[v]) do
				setElementAlpha(pointParents[v][i1],100)
			end
		elseif tonumber(getElementData(v,"order")) - challenger == tonumber(getElementData(source,"order")) then
			--unsichtbar
			for i1,v1 in ipairs(pointParents[v]) do
				setElementAlpha(pointParents[v][i1],0)
			end
		end
	end
end
addEvent("onPointCapture",true)
addEventHandler("onPointCapture",getRootElement(),pointCap)

function spectate()
	if isPlayerDead(getLocalPlayer()) then
		startSpectating()
	end
end

function startSpectating(hasNoTeam)
	spectating = true
	local specPlayers
	if hasNoTeam then
		specPlayers = getElementsByType("player")
	else
		specPlayers = getPlayersInTeam(getPlayerTeam(getLocalPlayer()))
	end
	if specPlayers then
		for index,player in ipairs(specPlayers) do
			if not isPlayerDead(player) and player~=getLocalPlayer() then
				setCameraTarget(player)
				triggerEvent("endSpec",getLocalPlayer(),nil,player)
				fadeCamera(true)
				spectating=index
				break
			end
		end
	end
end
addEvent("enterSpectatorMode",true)
addEventHandler("enterSpectatorMode",getRootElement(),spectate)

function stopSpectating()
	spectating=false
	setCameraTarget(getLocalPlayer())
end
addEventHandler("onClientPlayerSpawn",getLocalPlayer(),stopSpectating)

function spectateNext()
	if spectating then
		local specPlayers
		local team = getPlayerTeam(getLocalPlayer())
		if team then
			specPlayers = getPlayersInTeam(team)
		else
			specPlayers = getElementsByType("player")
		end
		if #specPlayers > 1 then
			local player
			local startSpectating=spectating
			repeat
				spectating = spectating + 1
				
				if spectating > #specPlayers then spectating = 1 end
				
				local newPlayer = specPlayers[spectating]
				if not isPlayerDead(newPlayer) and player~=getLocalPlayer() then
					player=newPlayer
				end
			until player or spectating==startSpectating
			
			if player then
				setCameraTarget(player)
			end
		end
	end
end
addCommandHandler("specnext",spectateNext)
bindKey("arrow_r","down","specnext")
bindKey("mouse1","down","specnext")

function spectatePrevious()
	if spectating then
		local specPlayers
		local team = getPlayerTeam(getLocalPlayer())
		if team then
			specPlayers = getPlayersInTeam(team)
		else
			specPlayers = getElementsByType("player")
		end
		if #specPlayers > 1 then
			local player
			local startSpectating=spectating
			repeat
				spectating = spectating - 1
				
				if spectating < 1 then spectating = #specPlayers end
				
				local newPlayer = specPlayers[spectating]
				if not isPlayerDead(newPlayer) and player~=getLocalPlayer() then
					player=newPlayer
				end
			until player or spectating==startSpectating
			
			if player then
				setCameraTarget(player)
			end
		end
	end
end
addCommandHandler("spectateprevious",spectatePrevious)
bindKey("arrow_l","down","spectateprevious")
bindKey("mouse2","down","spectateprevious")

function alert(challenger,oldstate)
	if challenger == -1 then
		local order = 0
		for i,v in ipairs(getElementsByType("pointparent")) do
			local cporder = tonumber(getElementData(v,"order"))
			if cporder > order then
				order = cporder
			end
		end
		if order == tonumber(getElementData(source,"order")) then
			if tonumber(getElementData(getPlayerTeam(getLocalPlayer()),"id")) ~= challenger then
				playSound(lastAlertTable[math.random(1,#lastAlertTable)],false)
			end
		elseif tonumber(getElementData(source,"order")) == 0 then
			if tonumber(getElementData(getPlayerTeam(getLocalPlayer()),"id")) ~= challenger then
				playSound(centerAlertTable[math.random(1,#centerAlertTable)],false)
			end
		else
			if tonumber(getElementData(getPlayerTeam(getLocalPlayer()),"id")) ~= challenger then
				playSound(alertTable[math.random(1,#alertTable)],false)
			end
		end
	elseif challenger == 1 then
		local order = 0
		for i,v in ipairs(getElementsByType("pointparent")) do
			local cporder = tonumber(getElementData(v,"order"))
			if cporder < order then
				order = cporder
			end
		end
		if order == tonumber(getElementData(source,"order")) then
			if tonumber(getElementData(getPlayerTeam(getLocalPlayer()),"id")) ~= challenger then
				playSound(lastAlertTable[math.random(1,#lastAlertTable)],false)
			end
		elseif tonumber(getElementData(source,"order")) == 0 then
			if tonumber(getElementData(getPlayerTeam(getLocalPlayer()),"id")) ~= challenger then
				playSound(centerAlertTable[math.random(1,#centerAlertTable)],false)
			end
		else
			if tonumber(getElementData(getPlayerTeam(getLocalPlayer()),"id")) ~= challenger then
				playSound(alertTable[math.random(1,#alertTable)],false)
			end
		end
	end
end
addEvent("onCaptureBegin",true)
addEventHandler("onCaptureBegin",getRootElement(),alert)

function spawnHandler()
	local player = source
	if player == getLocalPlayer() then
		removeEventHandler("onClientRender",getRootElement(),drawRespawn)
		addEventHandler("onClientPlayerDamage",getLocalPlayer(),cancelDamage)
	else
		--setElementCollisionsEnabled(player,false)
	end
	if spectating then
		stopSpectating()
	end
	setElementAlpha(player,100)
	local r,g,b = getTeamColor(getPlayerTeam(player))
	local marker = createMarker(0,0,0,"corona",1,r,g,b,100)
	attachElements(marker,player)
	setTimer(spawnKillProtectorEnd,3000,1,player,marker)
end
addEventHandler("onClientPlayerSpawn",getRootElement(),spawnHandler)

function cancelDamage()
	cancelEvent()
end

function spawnKillProtectorEnd(player,marker)
	setElementAlpha(player,255)
	destroyElement(marker)
	if not player == getLocalPlayer() then
		--setElementCollisionsEnabled(player,true)
	else
		removeEventHandler("onClientPlayerDamage",getLocalPlayer(),cancelDamage)
	end
end

local deathtime
function startRespawnDraw()
	deathtime = getTickCount()
	addEventHandler("onClientRender",getRootElement(),drawRespawn)
end
addEventHandler("onClientPlayerWasted",getLocalPlayer(),startRespawnDraw)

function drawRespawn()
	local team = getPlayerTeam(getLocalPlayer())
	if team then
		local timeleft = respawntime - (getTickCount()-deathtime)
		if timeleft <= 0 then
			removeEventHandler("onClientRender",getRootElement(),drawRespawn)
		else
			dxDrawText("Respawning in: "..string.format("%.02f",math.floor((timeleft+0.005))/1000).." seconds!",0.5*sx-0.5*dxGetTextWidth("Respawning in: "..string.format("%.02f",math.floor((timeleft+0.005))/1000).." seconds!",3,"default"),sy-165,0,0,tocolor(0,255,0,255),3,"default","left","top",false,false,false)
		end
	end
end

function markSquadPeds(peds)
	for i,v in ipairs(peds) do
		local marker = createMarker(0,0,0,"arrow",0.5,255,255,255,128)
		attachElements(marker,v)
		setElementAttachedOffsets(marker,0,0,1.5)
		createBlipAttachedTo(v,0,1,255,255,255,255,10,99999,getRootElement())
		
		local targetmarker = createMarker(0,0,0,"corona",1.5,255,255,255,0)
		setElementData(v,"targetmarker",targetmarker)
	end
end
addEvent("onClientSendSquadmembers",true)
addEventHandler("onClientSendSquadmembers",getRootElement(),markSquadPeds)

function removeAttachedSquadStuff()
	for i,v in ipairs(getAttachedElements(source)) do
		destroyElement(v)
	end
	local targetmarker = getElementData(source,"targetmarker")
	if isElement(targetmarker) then
		destroyElement(targetmarker) -- thanks to BieHDC, for pointing out that there was stuff to do here
	end
end
addEvent("onSquadmemberDie",true)
addEventHandler("onSquadmemberDie",getRootElement(),removeAttachedSquadStuff)

function drawPedTags()
	for i,v in ipairs(getElementsByType("ped")) do
		local name = getElementData(v,"name")
		if name then
			local x,y,z = getElementPosition(v)
			local cx,cy,cz = getCameraMatrix()
			if isLineOfSightClear(cx,cy,cz,x,y,z,true,true,false,true,false,true,false,v) then
				if getDistanceBetweenPoints3D(cx,cy,cz,x,y,z) <= 45 then
					local px,py = getScreenFromWorldPosition(x,y,z+0.3,0.06)
					if px then
						local hp = getElementHealth(v)
						if hp > 0 then
							local width = dxGetTextWidth(name,1,"default")
							local armor = getPedArmor(v)
							local r,g,b = 255,255,255
							if getElementData(v,"pedteam") then
								r,g,b = getTeamColor(getElementData(v,"pedteam"))
							end
							
							local ucAlpha = 128

							hp = hp * 7.52
							hp = hp / ( 750 / 510 )
								local lRed = 0
							local lGreen = 0
							if hp > 255 then
								lRed = 512 - hp
								if lRed < 0 then
									lRed = 0
								end
								if lRed > 255 then
									lRed = 255
								end
								lGreen = 255
							elseif hp <= 255 then
								lRed = 255
								lGreen = hp
							end
							
							-- nametags with shadow
							dxDrawText(name, px + 1, py + 1, px + 1, py + 1, tocolor(0, 0, 0, 255), 1, "default", "center", "center", false, false)
							dxDrawText(name, px, py, px, py, tocolor(r, g, b, 255), 1, "default", "center", "center", false, false)

							local lRedBlack = lRed * 0.33
							local lGreenBlack = lGreen * 0.33

							-- health and armor bar
							-- TR - TL - BR - BL
							local fHeight = sy * 0.011
							local fWidth = sx * 0.060
							local fTopOffset = sy * 0.025
							local fSizeIncreaseBorder = sx * 0.003
							local fRemovedWidth = fWidth - (hp / 512 * fWidth)
							local fMaxArmor = 100
							local fArmorAlpha = ( armor / fMaxArmor ) * 255

							-- Base rectangle
							local vecTopLeftBaseX = px - fWidth * 0.5
							local vecTopLeftBaseY = py + fTopOffset
							local vecBotRightBaseX = px + fWidth * 0.5
							local vecBotRightBaseY = py + fTopOffset + fHeight
							
							-- background
							local vecTopLeftX = vecTopLeftBaseX - fSizeIncreaseBorder
							local vecTopLeftY = vecTopLeftBaseY - fSizeIncreaseBorder
							local vecBotRightX = vecBotRightBaseX + fSizeIncreaseBorder
							local vecBotRightY = vecBotRightBaseY + fSizeIncreaseBorder
							
							dxDrawRectangle(vecTopLeftX, vecTopLeftY, vecBotRightX - vecTopLeftX, vecBotRightY - vecTopLeftY, tocolor(0, 0, 0, ucAlpha))
							
							if armor > 0 then
							
	 							-- armor background
	 							vecTopLeftX = vecTopLeftBaseX - fSizeIncreaseBorder
	 							vecTopLeftY = vecTopLeftBaseY - fSizeIncreaseBorder
	 							vecBotRightX = vecBotRightBaseX + fSizeIncreaseBorder
	 							vecBotRightY = vecBotRightBaseY + fSizeIncreaseBorder
								 
	 							dxDrawRectangle(vecTopLeftX, vecTopLeftY, vecBotRightX - vecTopLeftX, vecBotRightY - vecTopLeftY, tocolor(179, 177, 167, fArmorAlpha))
							
							end
							
							-- the colored bit
							vecTopLeftX = vecTopLeftBaseX
							vecTopLeftY = vecTopLeftBaseY
							vecBotRightX = vecBotRightBaseX - fRemovedWidth
							vecBotRightY = vecBotRightBaseY
							
							dxDrawRectangle(vecTopLeftX, vecTopLeftY, vecBotRightX - vecTopLeftX, vecBotRightY - vecTopLeftY, tocolor(lRed, lGreen, 0, ucAlpha))
							
							-- the black bit
							vecTopLeftX = vecTopLeftBaseX + fWidth - fRemovedWidth
							vecTopLeftY = vecTopLeftBaseY
							vecBotRightX = vecBotRightBaseX
							vecBotRightY = vecBotRightBaseY
														
							dxDrawRectangle(vecTopLeftX, vecTopLeftY, vecBotRightX - vecTopLeftX, vecBotRightY - vecTopLeftY, tocolor(lRedBlack, lGreenBlack, 0, ucAlpha))
						end
					end
				end
			end
		end
	end
end
addEventHandler("onClientRender",getRootElement(),drawPedTags)