local timelimit = 600000
local setuptime = 10000
local respawntime = 10000
local capturepoints = {}
local playedRounds = 0
local endtime = 10000 -- mehr? :D

local bluteam = createTeam("Blu",0,0,255)
setElementData(bluteam,"id",-1)
local redteam = createTeam("Red",255,0,0)
setElementData(redteam,"id",1)

local currentmap
local juststarted = true

local botslist =
{
[1] = {"Joe",30,30},
[2] = {"Pete",46,27},
[3] = {"Doug",60,31},
[4] = {"Sue",169,34},
[5] = {"Claire",195,28},
[6] = {"Lou",121,24},
[7] = {"Francis",124,26},
[8] = {"Nick",144,9}
}
local teamsetup = {1,2,3}

local botspawntimers = {}

function resourceStart()
	for i,v in ipairs(getElementsByType("player")) do
		showPlayerHudComponent(v,"area_name",false)
	end
end
addEventHandler("onResourceStart",getResourceRootElement(getThisResource()),resourceStart)

function joinHandler()
	showPlayerHudComponent(source,"area_name",false)
	cameraTable = get(getResourceName(currentmap)..".camera")
	if cameraTable and cameraTable[1] and cameraTable[2] then
		cx=cameraTable[1][1]
		cy=cameraTable[1][2]
		cz=cameraTable[1][3]
		clx=cameraTable[2][1]
		cly=cameraTable[2][2]
		clz=cameraTable[2][3]
		
		if (cx and cy and cz and clx and cly and clz) then
			setCameraMatrix(source,cx,cy,cz,clx,cly,clz)
			fadeCamera(source,true)
		end
	end
end
addEventHandler("onPlayerJoin",getRootElement(),joinHandler)

function teamJoin(team)
	if team == bluteam then
		spawn(source,bluteam,true)
	elseif team == redteam then
		spawn(source,redteam,true)
	else
		for i,v in ipairs(getElementsByType("ped")) do
			if getElementData(v,"squadleader") == source then
				for i1,v1 in ipairs(getAttachedElements(v)) do
					destroyElement(v1)
				end
				triggerClientEvent("onSquadmemberDie",v)
				destroyElement(v)
			end
		end
		setPlayerTeam(source,nil)
		killPed(source)
		setElementPosition(source,0,0,0)
		cameraTable = get(getResourceName(currentmap)..".camera")
		if cameraTable and cameraTable[1] and cameraTable[2] then
			cx=cameraTable[1][1]
			cy=cameraTable[1][2]
			cz=cameraTable[1][3]
			clx=cameraTable[2][1]
			cly=cameraTable[2][2]
			clz=cameraTable[2][3]
			
			if (cx and cy and cz and clx and cly and clz) then
				setCameraMatrix(source,cx,cy,cz,clx,cly,clz)
				fadeCamera(source,true)
			end
		end
	end
end
addEvent("onTeamJoin",true)
addEventHandler("onTeamJoin",getRootElement(),teamJoin)

function spawn(player,team,firstspawn)
	if firstspawn then
		for i,v in ipairs(getElementsByType("ped")) do
			if getElementData(v,"squadleader") == player then
				for i1,v1 in ipairs(getAttachedElements(v)) do
					destroyElement(v1)
				end
				triggerClientEvent("onSquadmemberDie",v)
				destroyElement(v)
			end
		end
		if team == bluteam then
			local order = 0
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder < order then
					order = cporder
				end
			end
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder == order then
					local allchildren = getElementChildren(getElementChild(v,0))
					local spawns = {}
					for i1,v1 in ipairs(allchildren) do
						if getElementType(v1) == "bluspawn" then
							table.insert(spawns,v1)
						end
					end
					local randomnumber = math.random(1,#spawns)
					local randx = math.random(0,6)-3
					local randy = math.random(0,6)-3
					spawnPlayer(player,getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),getElementData(spawns[randomnumber],"skin"),0,0,team)
					
					local squadmembers = {}
					
					for i=1,3,1 do
						local ped
						if i == 1 then
							local pedchoice = teamsetup[1]
							ped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx+1,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),botslist[pedchoice][2],0,0,team,botslist[pedchoice][3],"following",player)
							setElementData(ped,"name",botslist[pedchoice][1])
							setElementData(ped,"pedweapon",botslist[pedchoice][3])
							setElementData(ped,"pedskin",botslist[pedchoice][2])
						elseif i == 2 then
							local pedchoice = teamsetup[2]
							ped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy+1,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),botslist[pedchoice][2],0,0,team,botslist[pedchoice][3],"following",player)
							setElementData(ped,"name",botslist[pedchoice][1])
							setElementData(ped,"pedweapon",botslist[pedchoice][3])
							setElementData(ped,"pedskin",botslist[pedchoice][2])
						elseif i == 3 then
							local pedchoice = teamsetup[3]
							ped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx+1,getElementData(spawns[randomnumber],"posY")+randy+1,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),botslist[pedchoice][2],0,0,team,botslist[pedchoice][3],"following",player)
							setElementData(ped,"name",botslist[pedchoice][1])
							setElementData(ped,"pedweapon",botslist[pedchoice][3])
							setElementData(ped,"pedskin",botslist[pedchoice][2])
						end
						setElementData(ped,"squadleader",player)
						setElementData(ped,"pedteam",team)
						table.insert(squadmembers,ped)
					end
					
					triggerClientEvent(player,"onClientSendSquadmembers",player,squadmembers)
					
					fadeCamera(player,true)
					setCameraTarget(player,player)
				end
			end
		elseif team == redteam then
			local order = 0
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder > order then
					order = cporder
				end
			end
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder == order then
					local allchildren = getElementChildren(getElementChild(v,0))
					local spawns = {}
					for i1,v1 in ipairs(allchildren) do
						if getElementType(v1) == "redspawn" then
							table.insert(spawns,v1)
						end
					end
					local randomnumber = math.random(1,#spawns)
					local randx = math.random(0,6)-3
					local randy = math.random(0,6)-3
					spawnPlayer(player,getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),getElementData(spawns[randomnumber],"skin"),0,0,team)
					
					local squadmembers = {}
					
					for i=1,3,1 do
						local ped
						if i == 1 then
							local pedchoice = teamsetup[1]
							ped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx+1,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),botslist[pedchoice][2],0,0,team,botslist[pedchoice][3],"following",player)
							setElementData(ped,"name",botslist[pedchoice][1])
							setElementData(ped,"pedweapon",botslist[pedchoice][3])
							setElementData(ped,"pedskin",botslist[pedchoice][2])
						elseif i == 2 then
							local pedchoice = teamsetup[2]
							ped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy+1,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),botslist[pedchoice][2],0,0,team,botslist[pedchoice][3],"following",player)
							setElementData(ped,"name",botslist[pedchoice][1])
							setElementData(ped,"pedweapon",botslist[pedchoice][3])
							setElementData(ped,"pedskin",botslist[pedchoice][2])
						elseif i == 3 then
							local pedchoice = teamsetup[3]
							ped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx+1,getElementData(spawns[randomnumber],"posY")+randy+1,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),botslist[pedchoice][2],0,0,team,botslist[pedchoice][3],"following",player)
							setElementData(ped,"name",botslist[pedchoice][1])
							setElementData(ped,"pedweapon",botslist[pedchoice][3])
							setElementData(ped,"pedskin",botslist[pedchoice][2])
						end
						setElementData(ped,"squadleader",player)
						setElementData(ped,"pedteam",team)
						table.insert(squadmembers,ped)
					end
					
					triggerClientEvent(player,"onClientSendSquadmembers",player,squadmembers)
					
					fadeCamera(player,true)
					setCameraTarget(player,player)
				end
			end
		end
	else
		if tonumber(getElementData(getPlayerTeam(player),"id")) == -1 then
			local lastcp
			for i,v in ipairs(capturepoints) do
				if tonumber(getElementData(v,"state")) == -1 then
					if not lastcp or tonumber(getElementData(v,"order")) > lastcp then
						lastcp = tonumber(getElementData(v,"order"))
					end
				end
			end
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder == lastcp then
					local allchildren = getElementChildren(getElementChild(v,0))
					local spawns = {}
					for i1,v1 in ipairs(allchildren) do
						if getElementType(v1) == "bluspawn" then
							table.insert(spawns,v1)
						end
					end
					local randomnumber = math.random(1,#spawns)
					local randx = math.random(0,6)-3
					local randy = math.random(0,6)-3
					spawnPlayer(player,getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),getElementData(spawns[randomnumber],"skin"),0,0,team)
					fadeCamera(player,true)
					setCameraTarget(player,player)
				end
			end
		elseif tonumber(getElementData(getPlayerTeam(player),"id")) == 1 then
			local lastcp
			for i,v in ipairs(capturepoints) do
				if tonumber(getElementData(v,"state")) == 1 then
					if not lastcp or tonumber(getElementData(v,"order")) < lastcp then
						lastcp = tonumber(getElementData(v,"order"))
					end
				end
			end
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder == lastcp then
					local allchildren = getElementChildren(getElementChild(v,0))
					local spawns = {}
					for i1,v1 in ipairs(allchildren) do
						if getElementType(v1) == "redspawn" then
							table.insert(spawns,v1)
						end
					end
					local randomnumber = math.random(1,#spawns)
					local randx = math.random(0,6)-3
					local randy = math.random(0,6)-3
					spawnPlayer(player,getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),getElementData(spawns[randomnumber],"skin"),0,0,team)
					fadeCamera(player,true)
					setCameraTarget(player,player)
				end
			end
		end
	end
end

function startupMap(map,spawnPlayers)
	if juststarted then
		currentmap = map
		cameraTable  = get(getResourceName(map)..".camera")
		if cameraTable and cameraTable[1] and cameraTable[2] then
			cx=cameraTable[1][1]
			cy=cameraTable[1][2]
			cz=cameraTable[1][3]
			clx=cameraTable[2][1]
			cly=cameraTable[2][2]
			clz=cameraTable[2][3]
	
			if (cx and cy and cz and clx and cly and clz) then
				for i,v in ipairs(getElementsByType("player")) do
					setCameraMatrix(v,cx,cy,cz,clx,cly,clz)
					fadeCamera(v,true)
				end
			end
		end
		for i,v in ipairs(botspawntimers) do
			if isTimer(v) then
				killTimer(v)
			end
		end
		botspawntimers = {}
		for i,v in ipairs(getElementsByType("capturepoint",getResourceRootElement(map))) do
			local parent = createElement("pointparent")
			setElementParent(v,parent)
			local marker
			local blip
			
			
			if getElementData(v,"startstate") == "Blu" then
				marker = createMarker(getElementData(v,"posX"),getElementData(v,"posY"),getElementData(v,"posZ"),"cylinder",getElementData(v,"size"),0,0,255,50)
				setElementData(parent,"state",-1)
				blip = createBlipAttachedTo(marker,0,3,0,0,255,255,-1000)
			elseif getElementData(v,"startstate") == "Red" then
				marker = createMarker(getElementData(v,"posX"),getElementData(v,"posY"),getElementData(v,"posZ"),"cylinder",getElementData(v,"size"),255,0,0,50)
				setElementData(parent,"state",1)
				blip = createBlipAttachedTo(marker,0,3,255,0,0,255,-1000)
			elseif getElementData(v,"startstate") == "Neutral" then
				marker = createMarker(getElementData(v,"posX"),getElementData(v,"posY"),getElementData(v,"posZ"),"cylinder",getElementData(v,"size"),100,100,100,100)
				setElementData(parent,"state",0)
				blip = createBlipAttachedTo(marker,0,3,100,100,100,255,-1000)
			end
			addEventHandler("onMarkerHit",marker,cpHit)
			setElementParent(marker,parent)
			setElementParent(blip,parent)
			setElementVisibleTo(blip,getRootElement(),false)
			-- experimental
			
			-- /experimental
			setElementData(parent,"order",getElementData(v,"order"))
			setElementData(parent,"captime",getElementData(v,"captime"))
			setElementData(parent,"challenger",false)
			setElementData(parent,"progress",0)
			setElementData(parent,"challengers",0)
			
			table.insert(capturepoints,parent)
		end
		juststarted = false
		for i,v in ipairs(capturepoints) do
			if tonumber(getElementData(v,"state")) == -1 then
				for i1,v1 in ipairs(capturepoints) do
					if tonumber(getElementData(v1,"order")) + 1 == tonumber(getElementData(v,"order")) then
						if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) and tonumber(getElementData(v1,"state")) ~= 0 and tonumber(getElementData(v,"state")) ~= 0 then
							setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
						end
					end
				end
			elseif tonumber(getElementData(v,"state")) == 1 then
				for i1,v1 in ipairs(capturepoints) do
					if tonumber(getElementData(v1,"order")) - 1 == tonumber(getElementData(v,"order")) then
						if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) and tonumber(getElementData(v1,"state")) ~= 0 and tonumber(getElementData(v,"state")) ~= 0 then
							setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
						end
					end
				end
			else
				for i1,v1 in ipairs(capturepoints) do
					if tonumber(getElementData(v1,"order")) - 1 == tonumber(getElementData(v,"order")) or tonumber(getElementData(v1,"order")) + 1 == tonumber(getElementData(v,"order")) then
						if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) then
							setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
						end
					end
				end
			end
		end
		if spawnPlayers then
			for i,v in ipairs(getElementsByType("player")) do
				setPlayerTeam(v,nil)
			end
			triggerClientEvent("showTeamSelection",getRootElement())
		end
	else
		outputDebugString("Reset all CP data")
		
		for i,v in ipairs(getElementsByType("marker"),getResourceRootElement(getThisResource())) do
			destroyElement(v)
		end
		
		for i,v in ipairs(getElementsByType("blip"),getResourceRootElement(getThisResource())) do
			destroyElement(v)
		end
		
		for i,v in ipairs(getElementsByType("pointparent"),getResourceRootElement(getThisResource())) do
			if isTimer(capturepoints[v]) then
				killTimer(capturepoints[v])
				capturepoints[v] = nil
			end
			destroyElement(v)
		end
		
		resetMapInfo()
		juststarted = true
		capturepoints = {}
		--bluteam = createTeam("Blu",0,0,255)
		--setElementData(bluteam,"id",-1)
		--redteam = createTeam("Red",255,0,0)
		--setElementData(redteam,"id",1)
		
		triggerClientEvent("onClientGamemodeMapStart",getRootElement())
		startupMap(map,true)
	end
end
addEventHandler("onGamemodeMapStart",getRootElement(),startupMap)

function newRound()
	playedRounds = playedRounds + 1
	for i,v in ipairs(botspawntimers) do
		if isTimer(v) then
			killTimer(v)
		end
	end
	botspawntimers = {}
	capturepoints = {}
	for i,v in ipairs(getElementsByType("ped")) do
		local squadleader = getElementData(v,"squadleader")
		triggerClientEvent(squadleader,"onSquadmemberDie",v)
		for i1,v1 in ipairs(getAttachedElements(v)) do
			destroyElement(v1)
		end
		destroyElement(v)
	end
	for i,v in ipairs(getElementsByType("pointparent")) do
		if getElementData(getElementChild(v,0),"startstate") == "Blu" then
			setMarkerColor(getElementChild(v,1),0,0,255,50)
			setBlipColor(getElementChild(v,2),0,0,255,255)
			setElementData(v,"state",-1)
		elseif getElementData(getElementChild(v,0),"startstate") == "Red" then
			setMarkerColor(getElementChild(v,1),255,0,0,50)
			setBlipColor(getElementChild(v,2),255,0,0,255)
			setElementData(v,"state",1)
		elseif getElementData(getElementChild(v,0),"startstate") == "Neutral" then
			setMarkerColor(getElementChild(v,1),100,100,100,100)
			setBlipColor(getElementChild(v,2),100,100,100,255)
			setElementData(v,"state",0)
		end
		--addEventHandler("onMarkerHit",getElementChild(v,1),cpHit)
		--setElementParent(marker,v)
		setElementVisibleTo(getElementChild(v,2),getRootElement(),false)

		
		setElementData(v,"order",getElementData(v,"order"))
		setElementData(v,"captime",getElementData(v,"captime"))
		setElementData(v,"challenger",false)
		setElementData(v,"progress",0)
		setElementData(v,"goal",getElementData(v,"goal"))
		setElementData(v,"challengers",0)
		
		table.insert(capturepoints,v)
	end
	for i,v in ipairs(capturepoints) do
		if tonumber(getElementData(v,"state")) == -1 then
			for i1,v1 in ipairs(capturepoints) do
				if tonumber(getElementData(v1,"order")) + 1 == tonumber(getElementData(v,"order")) then
					if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) and tonumber(getElementData(v1,"state")) ~= 0 and tonumber(getElementData(v,"state")) ~= 0 then
						setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
					end
				end
			end
		elseif tonumber(getElementData(v,"state")) == 1 then
			for i1,v1 in ipairs(capturepoints) do
				if tonumber(getElementData(v1,"order")) - 1 == tonumber(getElementData(v,"order")) then
					if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) and tonumber(getElementData(v1,"state")) ~= 0 and tonumber(getElementData(v,"state")) ~= 0 then
						setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
					end
				end
			end
		else
			for i1,v1 in ipairs(capturepoints) do
				if tonumber(getElementData(v1,"order")) - 1 == tonumber(getElementData(v,"order")) or tonumber(getElementData(v1,"order")) + 1 == tonumber(getElementData(v,"order")) then
					if tonumber(getElementData(v1,"state")) ~= tonumber(getElementData(v,"state")) then
						setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
					end
				end
			end
		end
	end
	for i,v in ipairs(getElementsByType("player")) do
		spawn(v,getPlayerTeam(v),true)
	end
end

function cpHit(player)
	if getElementType(player) == "player" then
		local parent = getElementParent(source)
		local challenger = tonumber(getElementData(getPlayerTeam(player),"id"))
		local cporder = tonumber(getElementData(parent,"order"))
		local state = tonumber(getElementData(parent,"state"))
		local capOk = false
		
		for i,v in ipairs(capturepoints) do
			if tonumber(getElementData(v,"order")) - challenger == cporder then
				if tonumber(getElementData(v,"state")) == challenger then
					if tonumber(getElementData(parent,"state")) ~= challenger then
						capOk = true
					end
				end
			end
		end
		
		if capOk then
			if not getElementData(parent,"challenger") then
				beginCapture(source,state,challenger)
			end
		end
	elseif getElementType(player) == "ped" and call(getResourceFromName("Slothbot"),"isPedBot",player) == true then
		local parent = getElementParent(source)
		local challenger = tonumber(getElementData(getElementData(player,"pedteam"),"id"))
		local cporder = tonumber(getElementData(parent,"order"))
		local state = tonumber(getElementData(parent,"state"))
		local capOk = false
		
		for i,v in ipairs(capturepoints) do
			if tonumber(getElementData(v,"order")) - challenger == cporder then
				if tonumber(getElementData(v,"state")) == challenger then
					if tonumber(getElementData(parent,"state")) ~= challenger then
						capOk = true
					end
				end
			end
		end
		
		if capOk then
			if not getElementData(parent,"challenger") then
				beginCapture(source,state,challenger)
			end
		end
	end
end

function beginCapture(marker,oldstate,challenger)
	local parent = getElementParent(marker)
	if not getElementData(parent,"challenger") and not isTimer(capturepoints[parent]) then
		capturepoints[parent] = setTimer(cpProgress,50,0,marker,oldstate,challenger)
		setElementData(parent,"challenger",challenger)
		triggerClientEvent("onCaptureBegin",parent,challenger,oldstate)
	end
end

function cpProgress(marker,oldstate,challenger)
	local parent = getElementParent(marker)
	local players = getElementsWithinColShape(getElementColShape(marker),"player")
	local bots = {}
	for i,v in ipairs(getElementsWithinColShape(getElementColShape(marker),"ped")) do
		if call(getResourceFromName("Slothbot"),"isPedBot",v) then
			table.insert(bots,v)
		end
	end
	
	local attacker = 0
	local attackerteam = challenger
	local defender = 0
	local defenderteam = - challenger
	
	local noowner = false
	if oldstate == 0 then
		noowner = true
	end
	
	for i,v in ipairs(players) do
		if not isPedDead(v) then
			if getElementData(getPlayerTeam(v),"id") == attackerteam then
				--if not getPedOccupiedVehicle(v) then
					attacker = attacker + 1
				--end
			elseif getElementData(getPlayerTeam(v),"id") == defenderteam then
				--if not getPedOccupiedVehicle(v) then
					defender = defender + 1
				--end
			end
		end
	end
	
	for i,v in ipairs(bots) do
		if not isPedDead(v) then
			if getElementData(getElementData(v,"pedteam"),"id") == attackerteam then
				--if not getPedOccupiedVehicle(v) then
					attacker = attacker + 1
				--end
			elseif getElementData(getElementData(v,"pedteam"),"id") == defenderteam then
				--if not getPedOccupiedVehicle(v) then
					defender = defender + 1
				--end
			end
		end
	end
	
	if attacker == 0 and defender == 0 then
		local newProgress = getElementData(parent,"progress") - 25
		setElementData(parent,"progress",newProgress)
		setElementData(parent,"challengers",attacker)
		setElementData(parent,"blocked",false)
	elseif noowner then
		if challenger == -1 then
			if attacker > defender then
				local newProgress = getElementData(parent,"progress") + ((attacker - defender) * 50)
				setElementData(parent,"progress",newProgress)
				setElementData(parent,"challengers",attacker-defender)
				setElementData(parent,"blocked",false)
			elseif defender > attacker then
				local newProgress = getElementData(parent,"progress") - ((defender - attacker) * 50)
				setElementData(parent,"progress",newProgress)
				setElementData(parent,"blocked",false)
			else
				setElementData(parent,"blocked",true)
			end
		elseif challenger == 1 then
			if defender > attacker then
				local newProgress = getElementData(parent,"progress") - ((defender - attacker) * 50)
				setElementData(parent,"progress",newProgress)
				setElementData(parent,"blocked",false)
			elseif attacker > defender then
				local newProgress = getElementData(parent,"progress") + ((attacker - defender) * 50)
				setElementData(parent,"progress",newProgress)
				setElementData(parent,"challengers",attacker-defender)
				setElementData(parent,"blocked",false)
			else
				setElementData(parent,"blocked",true)
			end
		end
	else
		if defender == 0 then
			local newProgress = getElementData(parent,"progress") + (attacker * 50)
			setElementData(parent,"blocked",false)
			setElementData(parent,"progress",newProgress)
			setElementData(parent,"challengers",attacker)
		elseif attacker == 0 then	
			local newProgress = getElementData(parent,"progress") - ((defender * 20)+10)
			setElementData(parent,"blocked",false)
			setElementData(parent,"progress",newProgress)
			setElementData(parent,"challengers",attacker)
		else
			if attacker > 0 then
				setElementData(parent,"blocked",true)
			else
				setElementData(parent,"blocked",false)
			end
			--capture blocked, no change
		end
	end
	
	if tonumber(getElementData(parent,"progress")) >= tonumber(getElementData(parent,"captime")) then
		--capture complete
		setElementData(parent,"progress",0)
		killTimer(capturepoints[parent])
		capturepoints[parent] = nil
		setElementData(parent,"challenger",false)
		setElementData(parent,"state",challenger)
		local contributors = {}
		for i,v in ipairs(getElementsWithinColShape(getElementColShape(marker),"player")) do
			if tonumber(getElementData(getPlayerTeam(v),"id")) == challenger then
				if not isPedDead(v) then
					table.insert(contributors,v)
				end
			end
		end
		for i,v in ipairs(getElementsWithinColShape(getElementColShape(marker),"ped")) do
			if tonumber(getElementData(getElementData(v,"pedteam"),"id")) == challenger then
				if not isPedDead(v) then
					table.insert(contributors,v)
				end
			end
		end
		outputCapMessage(contributors,challenger,oldstate)
		if challenger == -1 then
			setMarkerColor(marker,0,0,255,50)
			setBlipColor(getElementChild(parent,2),0,0,255,255)
			local order = 0
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder > order then
					order = cporder
				end
			end
			if order == tonumber(getElementData(parent,"order")) then
				roundEnd(bluteam,getElementsWithinColShape(getElementColShape(marker),"player"))
			else
				triggerClientEvent("onPointCapture",parent,challenger,oldstate)
			end
		elseif challenger == 1 then
			setMarkerColor(marker,255,0,0,50)
			setBlipColor(getElementChild(parent,2),255,0,0,255)
			local order = 0
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder < order then
					order = cporder
				end
			end
			if order == tonumber(getElementData(parent,"order")) then
				roundEnd(redteam,getElementsWithinColShape(getElementColShape(marker),"player"))
			else
				triggerClientEvent("onPointCapture",parent,challenger,oldstate)
			end
		end
		for i,v in ipairs(capturepoints) do
			if tonumber(getElementData(v,"order")) - challenger == tonumber(getElementData(parent,"order")) then
				if isTimer(capturepoints[v]) then
					killTimer(capturepoints[v])
					capturepoints[v] = nil
				end
			setElementData(v,"progress",0)
			setElementData(v,"challenger",false)
			end
		end
	for i,v in ipairs(capturepoints) do
		if challenger == -1 then
			if tonumber(getElementData(v,"order")) - 1 == tonumber(getElementData(parent,"order")) then
				setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
			elseif tonumber(getElementData(v,"order")) + 1 == tonumber(getElementData(parent,"order")) then
				setElementVisibleTo(getElementChild(v,2),getRootElement(),false)
			end
		elseif challenger == 1 then
			if tonumber(getElementData(v,"order")) + 1 == tonumber(getElementData(parent,"order")) then
				setElementVisibleTo(getElementChild(v,2),getRootElement(),true)
			elseif tonumber(getElementData(v,"order")) - 1 == tonumber(getElementData(parent,"order")) then
				setElementVisibleTo(getElementChild(v,2),getRootElement(),false)
			end
		end
	end
	elseif tonumber(getElementData(parent,"progress")) <= 0 then
		--captrue fail and end
		if not noowner or (attacker == 0 and defender == 0) then
			setElementData(parent,"progress",0)
			if attacker == 0 then
				killTimer(capturepoints[parent])
				capturepoints[parent] = nil
				setElementData(parent,"challenger",false)
				setElementData(parent,"blocked",false)
			end
		else
			-- could cause issues when somhow the value returns to exactly 0
			if tonumber(getElementData(parent,"progress")) < 0 then
				setElementData(parent,"progress",- getElementData(parent,"progress"))
				killTimer(capturepoints[parent])
				capturepoints[parent] = setTimer(cpProgress,50,0,marker,oldstate,- challenger)
				setElementData(parent,"challenger",- challenger)
			--else
				
			end
			--
		end
	end
end

function outputCapMessage(elementsInCol,challenger,oldstate)
	local attackerString = ""
	for i,v in ipairs(elementsInCol) do
		if getElementType(v) == "player" then
			if i == 1 then
				attackerString = getPlayerName(v)
			else
				attackerString = attackerString..", "..getPlayerName(v)
			end
		elseif getElementType(v) == "ped" then
			if i == 1 then
				attackerString = getElementData(v,"name")
			else
				attackerString = attackerString..", "..getElementData(v,"name")
			end
		end
	end
	local pr,pg,pb
	local cr,cg,cb
	if oldstate == -1 then
		pr,pg,pb = 0,0,255
		cr,cg,cb = 255,0,0
	elseif oldstate == 1 then
		pr,pg,pb = 255,0,0
		cr,cg,cb = 0,0,255
	else
		pr,pg,pb = 100,100,100
		if challenger == -1 then
			cr,cg,cb = 0,0,255
		elseif challenger == 1 then
			cr,cg,cb = 255,0,0
		end
	end
	exports.killmessages:outputMessage(
			{attackerString,{"padding",width=3},{"image",path="materials/capture.png",resource=getThisResource(),width=20},{"padding",width=3},{"color",r=pr,g=pg,b=pb},"Control Point"},getRootElement(),cr,cg,cb)
end

function roundEnd(team,players)
	setTimer(newRound,10000,1)
	triggerClientEvent("onRoundEnd",team)
	outputChatBox(getTeamName(team).." won the game! New game in 10 seconds.")
	for i,v in ipairs(getElementsByType("team")) do
		if v ~= team then
			for i1,v1 in ipairs(getPlayersInTeam(v)) do
				setPedAnimation(v1,"ped","cower",-1,true,false,false)
				setPedWeaponSlot(v1,0)
			end
		end
	end
	for i,v in ipairs(getElementsByType("ped")) do
		if getElementData(v,"pedteam") ~= team then
			if not isPedDead(v) then
				call(getResourceFromName("Slothbot"),"setBotAttackEnabled",v,false)
				setPedAnimation(v,"ped","cower",-1,true,false,false)
				setPedWeaponSlot(v,0)
			end
		end
	end
end

function deathHandler(ammo,killer,weapon,bodypart)
	setTimer(triggerClientEvent,5000,1,source,"enterSpectatorMode",source)
	setTimer(preSpawnCheck,respawntime,1,source,false)
	for i,v in ipairs(getAttachedElements(source)) do
		if getElementType(v) == "blip" then
			destroyElement(v)
		end
	end
end
addEventHandler("onPlayerWasted",getRootElement(),deathHandler)

function botDied()
	local squadleader = getElementData(source,"squadleader")
	triggerClientEvent(squadleader,"onSquadmemberDie",source)
	for i,v in ipairs(getAttachedElements(source)) do
		destroyElement(v)
	end
	
	local killtimer = setTimer(spawnBot,respawntime,1,getElementData(source,"name"),squadleader,tonumber(getElementData(source,"pedweapon")),tonumber(getElementData(source,"pedskin")))
	table.insert(botspawntimers,killtimer)
end
addEvent("onBotDied",true)
addEventHandler("onBotDied",getRootElement(),botDied)
addEvent("onBotWasted",true)
addEventHandler("onBotWasted",getRootElement(),botDied)

function spawnBot(pedname,player,pedweapon,pedskin)
	if isElement(player) then
		local team = getPlayerTeam(player)
		if tonumber(getElementData(getPlayerTeam(player),"id")) == -1 then
			local lastcp
			for i,v in ipairs(capturepoints) do
				if tonumber(getElementData(v,"state")) == -1 then
					if not lastcp or tonumber(getElementData(v,"order")) > lastcp then
						lastcp = tonumber(getElementData(v,"order"))
					end
				end
			end
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder == lastcp then
					local allchildren = getElementChildren(getElementChild(v,0))
					local spawns = {}
					for i1,v1 in ipairs(allchildren) do
						if getElementType(v1) == "bluspawn" then
							table.insert(spawns,v1)
						end
					end
					local randomnumber = math.random(1,#spawns)
					local randx = math.random(0,6)-3
					local randy = math.random(0,6)-3
	
					local newped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),pedskin,0,0,team,pedweapon,"waiting")
					setElementData(newped,"name",pedname)
					setElementData(newped,"squadleader",player)
					setElementData(newped,"pedteam",team)
					setElementData(newped,"pedweapon",pedweapon)
					setElementData(newped,"pedskin",pedskin)
					
					triggerClientEvent(player,"onClientSendSquadmembers",player,{newped})
				end
			end
		elseif tonumber(getElementData(getPlayerTeam(player),"id")) == 1 then
			local lastcp
			for i,v in ipairs(capturepoints) do
				if tonumber(getElementData(v,"state")) == 1 then
					if not lastcp or tonumber(getElementData(v,"order")) < lastcp then
						lastcp = tonumber(getElementData(v,"order"))
					end
				end
			end
			for i,v in ipairs(capturepoints) do
				local cporder = tonumber(getElementData(v,"order"))
				if cporder == lastcp then
					local allchildren = getElementChildren(getElementChild(v,0))
					local spawns = {}
					for i1,v1 in ipairs(allchildren) do
						if getElementType(v1) == "redspawn" then
							table.insert(spawns,v1)
						end
					end
					local randomnumber = math.random(1,#spawns)
					local randx = math.random(0,6)-3
					local randy = math.random(0,6)-3
					
					local newped = call(getResourceFromName("Slothbot"),"spawnBot",getElementData(spawns[randomnumber],"posX")+randx,getElementData(spawns[randomnumber],"posY")+randy,getElementData(spawns[randomnumber],"posZ"),getElementData(spawns[randomnumber],"rotZ"),pedskin,0,0,team,pedweapon,"waiting")
					setElementData(newped,"name",pedname)
					setElementData(newped,"squadleader",player)
					setElementData(newped,"pedteam",team)
					setElementData(newped,"pedweapon",pedweapon)
					setElementData(newped,"pedskin",pedskin)
					
					triggerClientEvent(player,"onClientSendSquadmembers",player,{newped})
				end
			end
		end
	end
end

function preSpawnCheck(player,firstspawn)
	if isPedDead(player) then
		spawn(player,getPlayerTeam(player),false)
	end
end

function quitHandler()
	for i,v in ipairs(getAttachedElements(source)) do
		destroyElement(v)
	end
	for i,v in ipairs(getElementsByType("ped")) do
		if getElementData(v,"squadleader") == player then
			for i1,v1 in ipairs(getAttachedElements(v)) do
				destroyElement(v1)
			end
			destroyElement(getElementData(v,"targetmarker"))
			destroyElement(v)
		end
	end
end
addEventHandler("onPlayerQuit",getRootElement(),quitHandler)

function spawnHandler()
	triggerClientEvent(source,"endSpec",source,nil,source)
	setPedAnimation(source)
	local r,g,b = getTeamColor(getPlayerTeam(source))
	local blip = createBlipAttachedTo(source,0,1,r,g,b,255,0,99999,getRootElement())
	setElementVisibleTo(blip,getRootElement(),false)
	for i,v in ipairs(getPlayersInTeam(getPlayerTeam(source))) do
		setElementVisibleTo(blip,v,true)
	end
	giveWeapon(source,30,1000)
	giveWeapon(source,16,3)
end
addEventHandler("onPlayerSpawn",getRootElement(),spawnHandler)

function checkHeadshot(attacker,weapon,bodypart)
    if bodypart == 9 and weapon >= 22 then
	    killPed(source,attacker,weapon,bodypart)
	end
end
addEventHandler("onPlayerDamage",getRootElement(),checkHeadshot)

function killFunction(player)
	killPed(player)
end
addCommandHandler("kill",killFunction)

function headshotKillmessage(killer,weapon,bodypart)
	if bodypart == 9 then
		cancelEvent()
		local sourceTeam,killerTeam = getPlayerTeam(source),getPlayerTeam(killer)
		local rK,gK,bK = getPlayerNametagColor(killer)
		local rS,gS,bS = getPlayerNametagColor(source)
		exports.killmessages:outputMessage(
			{getPlayerName(killer),{"padding",width=3},{"icon",id=weapon},{"padding",width=3},
			{"icon",id=256},{"padding",width=3},{"color",r=rS,g=gS,b=bS},getPlayerName(source)},
			getRootElement(),rK,gK,bK)
	end
end
addEventHandler("onPlayerKillMessage",getRootElement(),headshotKillmessage)