local AI = getResourceFromName("Slothbot")
local peds = {}

function startPedFollow(unit)
	doForAll(unit,"setBotFollow",{source})
end
addEvent("doMakePedFollow",true)
addEventHandler("doMakePedFollow",getRootElement(),startPedFollow)

function startPedWait(unit)
	if isElement(unit) then
		call(AI,"setBotGuard",unit,getElementPosition(unit))
		if not peds[unit] then
			peds[unit] = {}
		else
			if isTimer(peds[unit]["waittimer"]) then
				killTimer(peds[unit]["waittimer"])
			end
		end
		peds[unit]["waittimer"] = setTimer(call,15000,1,AI,"setBotWait",unit)
	elseif type(unit) == "table" then
		for i,v in ipairs(unit) do
			call(AI,"setBotGuard",v,getElementPosition(v))
			if not peds[v] then
				peds[v] = {}
			else
				if isTimer(peds[v]["waittimer"]) then
					killTimer(peds[v]["waittimer"])
				end
			end
			peds[v]["waittimer"] = setTimer(call,15000,1,AI,"setBotWait",v)
		end
	end
end
addEvent("doMakePedWait",true)
addEventHandler("doMakePedWait",getRootElement(),startPedWait)

function pedStopFire(unit)
	doForAll(unit,"setBotAttackEnabled",{false})
end
addEvent("doMakePedStopFire",true)
addEventHandler("doMakePedStopFire",getRootElement(),pedStopFire)

function pedStartFire(unit)
	doForAll(unit,"setBotAttackEnabled",{true})
end
addEvent("doMakePedStartFire",true)
addEventHandler("doMakePedStartFire",getRootElement(),pedStartFire)

function pedMoveTo(unit,x,y,z)
	if isElement(unit) then
		call(AI,"setBotGuard",unit,x,y,z,false)
	elseif type(unit) == "table" then
		for i,v in ipairs(unit) do
			call(AI,"setBotGuard",v,x,y,z,false)
		end
	end
end
addEvent("doMakePedMoveTo",true)
addEventHandler("doMakePedMoveTo",getRootElement(),pedMoveTo)

function pedGuardPosition(unit,x,y,z)
	if isElement(unit) then
		call(AI,"setBotGuard",unit,x,y,z,true)
	elseif type(unit) == "table" then
		for i,v in ipairs(unit) do
			call(AI,"setBotGuard",v,x,y,z,true)
		end
	end
end
addEvent("doMakePedGuardPosition",true)
addEventHandler("doMakePedGuardPosition",getRootElement(),pedGuardPosition)

function pedGuardHere(unit,x,y,z)
	call(AI,"setBotGuard",unit,x,y,z)
end
addEvent("doMakePedGuardHere",true)
addEventHandler("doMakePedGuardHere",getRootElement(),pedGuardHere)

function pedAttack(unit,target)
	call(AI,"setBotChase",unit,target)
end
addEvent("doMakePedAttack",true)
addEventHandler("doMakePedAttack",getRootElement(),pedAttack)

function doForAll(unit,callfunction,objective)
	if isElement(unit) then
		call(AI,callfunction,unit,unpack(objective))
	elseif type(unit) == "table" then
		for i,v in ipairs(unit) do
			call(AI,callfunction,v,unpack(objective))
		end
	end
end