local sx,sy = guiGetScreenSize()
local midx,midy = sx*0.5,sy*0.5

local localplayer = getLocalPlayer()

local showmenu = false
local drawnsub1 = false
local drawnsub2 = false
local selected = 1

local rr,rg,rb = 0,0,0 --rectangle base
local rhr,rhg,rhb = 128,128,128 --rectangle header
local cr,cg,cb = 255,255,255 --default text
local hr,hg,hb = 255,0,0 --header text
local sr,sg,sb = 255,255,0 --selected text
local br,bg,bb = 112,112,112 --border

local textheight = 20
local border = 5
local menuwidth = 90
local menupadding = 90
local listoffset = 3
local headeroffset = -2
local textleftspace = 3
local meunuborder = 2
local endheight = 4

local temporarycontents
local selectedunit

local enemymarker = createMarker(0,0,0,"arrow",0.5,255,0,0,0)
setElementData(localplayer,"enemymarker",enemymarker)

local contenttable =
{ 	["name"] = "menu",
	{["name"] = "movement",
		{["name"] = "move to", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnitsAndMarkTarget,["actionfunc"] = makePedMoveTo},
		{["name"] = "follow", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedFollow},
		{["name"] = "wait", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedWait},
	},
	{["name"] = "combat",
		{["name"] = "attack", ["unitchoice"] = true,["highlightcolor"] = {255,0,0},["tablefunc"] = getEnemyCloseUnits,["actionfunc"] = makePedAttack},
		{["name"] = "guard", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnitsAndMarkTarget,["actionfunc"] = makePedGuard},
		{["name"] = "guard here", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedGuardHere},
		{["name"] = "hold fire", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedStopFire},
		{["name"] = "open fire", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedStartFire},
	},
	--[[
	{["name"] = "misc",
		{["name"] = "cover me", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedBla},
		{["name"] = "rush", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedBlu},
		{["name"] = "defend point", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedBlop},
		{["name"] = "capture point", ["unitchoice"] = true,["tablefunc"] = getFriendlyUnits,["actionfunc"] = makePedBlip},
	},
	--]]
}

function showMenu()
	showmenu = true
	toggleControl("next_weapon",false)
	toggleControl("previous_weapon",false)
	toggleControl("look_behind",false)
end
addCommandHandler("showsquadmenu",showMenu)
bindKey("b","down","showsquadmenu")

function hideMenu()
	showmenu = false
	drawnsub1 = false
	drawnsub2 = false
	
	toggleControl("next_weapon",true)
	toggleControl("previous_weapon",true)
	toggleControl("look_behind",true)
	
	temporarycontents = nil
	selected = 1
	
	setMarkerColor(getElementData(getLocalPlayer(),"targetmarker"),255,255,0,0)
	
	unhighlightoldselection()
end
addCommandHandler("hidesquadmenu",hideMenu)
bindKey("b","up","hidesquadmenu")

function drawMenu()
	if showmenu then
		dxDrawRectangle(midx-border,midy-border+textheight,menuwidth,#contenttable*textheight+border,tocolor(rr,rg,rb))
		
		--dxDrawRectangle(midx-border,midy-border,menuwidth,textheight+border,tocolor(rhr,rhg,rhb))
		
		dxDrawImage(midx-border,midy-border,menuwidth,textheight+border,"squadmats/header.png")
		
		dxDrawRectangle(midx-border,midy-border+textheight,meunuborder,#contenttable*textheight+border,tocolor(br,bg,bb))
		dxDrawRectangle(midx-border+menuwidth-meunuborder,midy-border+textheight,meunuborder,#contenttable*textheight+border,tocolor(br,bg,bb))
		dxDrawImage(midx-border,midy+(#contenttable+1)*textheight,menuwidth,endheight,"squadmats/end.png")
		
		dxDrawText(contenttable["name"],midx+textleftspace,midy+headeroffset,0,0,tocolor(hr,hg,hb,255),1,"default-bold")
		for k,v in pairs(contenttable) do
			if type(v) == "table" then
				dxDrawText(v["name"],midx+textleftspace,midy+textheight*k+listoffset,0,0,tocolor(cr,cg,cb,255),1,"default")
			end
		end
		if drawnsub1 then
			dxDrawRectangle(midx-border+menupadding,midy-border+(drawnsub1+1)*textheight+listoffset,menuwidth,#contenttable[drawnsub1]*textheight+border,tocolor(rr,rg,rb))
			
			--dxDrawRectangle(midx-border+menupadding,midy-border+drawnsub1*textheight,menuwidth,textheight+border,tocolor(rhr,rhg,rhb))
			
			dxDrawImage(midx-border+menupadding,midy-border+drawnsub1*textheight+listoffset,menuwidth,textheight+border,"squadmats/header.png")
			
			dxDrawRectangle(midx-border+menupadding,midy-border+(drawnsub1+1)*textheight+listoffset,meunuborder,#contenttable[drawnsub1]*textheight+border,tocolor(br,bg,bb))
			dxDrawRectangle(midx-border+menupadding+menuwidth-meunuborder,midy-border+(drawnsub1+1)*textheight+listoffset,meunuborder,#contenttable[drawnsub1]*textheight+border,tocolor(br,bg,bb))
			dxDrawImage(midx-border+menupadding,midy+#contenttable[drawnsub1]*textheight+(drawnsub1+1)*textheight+listoffset,menuwidth,endheight,"squadmats/end.png")
			
			dxDrawText(contenttable[drawnsub1]["name"],midx+menupadding+textleftspace,midy+drawnsub1*textheight+listoffset+headeroffset,0,0,tocolor(hr,hg,hb,255),1,"default-bold")
			for k,v in pairs(contenttable[drawnsub1]) do
				if type(v) == "table" then
					dxDrawText(v["name"],midx+menupadding+textleftspace,midy+textheight*k+textheight*drawnsub1+2*listoffset,0,0,tocolor(cr,cg,cb,255),1,"default")
				end
			end
			if drawnsub2 then
				if temporarycontents then
					dxDrawRectangle(midx-border+menupadding*2,midy-border+drawnsub1*textheight+drawnsub2*textheight+textheight+2*listoffset,menuwidth,#temporarycontents*textheight+border,tocolor(rr,rg,rb))
					
					--dxDrawRectangle(midx-border+menupadding*2,midy-border+drawnsub1*textheight+drawnsub2*textheight,menuwidth,textheight+border,tocolor(rhr,rhg,rhb))
					
					dxDrawImage(midx-border+menupadding*2,midy-border+drawnsub1*textheight+drawnsub2*textheight+2*listoffset,menuwidth,textheight+border,"squadmats/header.png")
					
					dxDrawRectangle(midx-border+menupadding*2,midy-border+(drawnsub1+1)*textheight+drawnsub2*textheight+2*listoffset,meunuborder,#temporarycontents*textheight+border,tocolor(br,bg,bb))
					dxDrawRectangle(midx-border+menupadding*2+menuwidth-meunuborder,midy-border+(drawnsub1+1)*textheight+drawnsub2*textheight+2*listoffset,meunuborder,#temporarycontents*textheight+border,tocolor(br,bg,bb))
					dxDrawImage(midx-border+menupadding*2,midy+#temporarycontents*textheight+(drawnsub1+1)*textheight+drawnsub2*textheight+2*listoffset,menuwidth,endheight,"squadmats/end.png")
					
					dxDrawText(contenttable[drawnsub1][drawnsub2]["name"],midx+menupadding*2+textleftspace,midy+drawnsub1*textheight+drawnsub2*textheight+2*listoffset+headeroffset,0,0,tocolor(hr,hg,hb,255),1,"default-bold")
					for k,v in pairs(temporarycontents) do
						if isElement(v) then
							if getElementType(v) == "ped" then
							dxDrawText(getElementData(v,"name"),midx+menupadding*2+textleftspace,midy+textheight*k+textheight*drawnsub1+textheight*drawnsub2+3*listoffset,0,0,tocolor(cr,cg,cb,255),1,"default")
							elseif getElementType(v) == "player" then
								dxDrawText(getPlayerName(v),midx+menupadding*2+textleftspace,midy+textheight*k+textheight*drawnsub1+textheight*drawnsub2+3*listoffset,0,0,tocolor(cr,cg,cb,255),1,"default")
							end
						else
							if type(v) == "string" then
								dxDrawText(v,midx+menupadding*2+textleftspace,midy+textheight*k+textheight*drawnsub1+textheight*drawnsub2+3*listoffset,0,0,tocolor(cr,cg,cb,255),1,"default")
							end
						end
					end
					local selectr,selectg,selectb = sr,sg,sb
					if contenttable[drawnsub1][drawnsub2]["highlightcolor"] then
						selectr,selectg,selectb = unpack(contenttable[drawnsub1][drawnsub2]["highlightcolor"])
					end
					if isElement(temporarycontents[selected]) then
						if getElementType(temporarycontents[selected]) == "ped" then
							dxDrawText(getElementData(temporarycontents[selected],"name"),midx+menupadding*2+textleftspace,midy+textheight*selected+textheight*drawnsub1+textheight*drawnsub2+3*listoffset,0,0,tocolor(selectr,selectg,selectb,255),1,"default")
						elseif getElementType(temporarycontents[selected]) == "player" then
							dxDrawText(getPlayerName(temporarycontents[selected]),midx+menupadding*2+textleftspace,midy+textheight*selected+textheight*drawnsub1+textheight*drawnsub2+3*listoffset,0,0,tocolor(selectr,selectg,selectb,255),1,"default")
						end
					else
						if type(temporarycontents[selected]) == "string" then
							dxDrawText(temporarycontents[selected],midx+menupadding*2+textleftspace,midy+textheight*selected+textheight*drawnsub1+textheight*drawnsub2+3*listoffset,0,0,tocolor(selectr,selectg,selectb,255),1,"default")
						end
					end
				end
			else
				local selectr,selectg,selectb = sr,sg,sb
				if contenttable[drawnsub1]["highlightcolor"] then
					selectr,selectg,selectb = unpack(contenttable[drawnsub1]["highlightcolor"])
				end
				dxDrawText(contenttable[drawnsub1][selected]["name"],midx+menupadding+textleftspace,midy+textheight*selected+textheight*drawnsub1+2*listoffset,0,0,tocolor(selectr,selectg,selectb,255),1,"default")
			end
		else
			local selectr,selectg,selectb = sr,sg,sb
			if contenttable["highlightcolor"] then
				selectr,selectg,selectb = unpack(contenttable["highlightcolor"])
			end
			dxDrawText(contenttable[selected]["name"],midx+textleftspace,midy+textheight*selected+listoffset,0,0,tocolor(selectr,selectg,selectb,255),1,"default")
		end
	end
end
addEventHandler("onClientRender",getRootElement(),drawMenu)

function selectionDown()
	if showmenu then
		selected = selected + 1
		if drawnsub2 then
			if selected > #temporarycontents then
				selected = 1
			end
		elseif drawnsub1 then
			if selected > #contenttable[drawnsub1] then
				selected = 1
			end
		else
			if selected > #contenttable then
				selected = 1
			end
		end
		if drawnsub2 then
			highlightselection(temporarycontents[selected])
		end
	end
end
addCommandHandler("squadmenudown",selectionDown)
bindKey("mouse_wheel_down","down","squadmenudown")

function selectionUp()
	if showmenu then
		selected = selected - 1
		if selected <= 0 then
			if drawnsub2 then
				selected = #temporarycontents
			elseif drawnsub1 then
				selected = #contenttable[drawnsub1]
			else
				selected = #contenttable
			end
		end
		if drawnsub2 then
			highlightselection(temporarycontents[selected])
		end
	end
end
addCommandHandler("squadmenuup",selectionUp)
bindKey("mouse_wheel_up","down","squadmenuup")

function selectCommand()
	if drawnsub2 then
		contenttable[drawnsub1][drawnsub2]["actionfunc"](returnSingleUnitOrTable(selectedunit))
	elseif drawnsub1 then
		if contenttable[drawnsub1][selected]["unitchoice"] then
			drawnsub2 = selected
			temporarycontents = contenttable[drawnsub1][selected]["tablefunc"]()
			selected = 1
			highlightselection(temporarycontents[1])
		else
			contenttable[drawnsub1][selected]["actionfunc"](returnSingleUnitOrTable(selectedunit))
		end
	elseif showmenu then
		drawnsub1 = selected
		selected = 1
	end
end
addCommandHandler("squadmenuselect",selectCommand)
bindKey("mouse3","down","squadmenuselect")

function returnSingleUnitOrTable(unit)
	if isElement(unit) then
		return unit
	elseif type(unit) == "string" and unit == "all" then
		local entrytable = {}
		for i,v in ipairs(temporarycontents) do
			if isElement(v) then
				table.insert(entrytable,v)
			end
		end
		return entrytable
	end
end

function highlightselection(newselection)
	if isElement(newselection) then
		if selectedunit ~= newselection then
			if type(selectedunit) == "string" then
				unhighlightoldselection()
			else
				unhighlightoldselection(selectedunit)
			end
		end
		if getElementType(newselection) == "ped" then
			if getElementData(newselection,"pedteam") == getPlayerTeam(localplayer) then
				for i,v in ipairs(getAttachedElements(newselection)) do
					if getElementType(v) == "marker" then
						setMarkerColor(v,255,255,0,128)
					elseif getElementType(v) == "blip" then
						setBlipColor(v,255,255,0,255)
						setBlipSize(v,2)
					end
				end
			else
				attachElements(enemymarker,newselection)
				setElementAttachedOffsets(enemymarker,0,0,1.5)
			end
		elseif getElementType(newselection) == "player" then
			attachElements(enemymarker,newselection)
			setElementAttachedOffsets(enemymarker,0,0,1.5)
		end
	elseif type(newselection) == "string" and newselection == "all" then
		for i,v in ipairs(temporarycontents) do
			if isElement(v) then
				for i1,v1 in ipairs(getAttachedElements(v)) do
					if getElementType(v1) == "marker" then
						setMarkerColor(v1,255,255,0,128)
					elseif getElementType(v1) == "blip" then
						setBlipColor(v1,255,255,0,255)
						setBlipSize(v1,2)
					end
				end
			end
		end
	end
	selectedunit = newselection
end

function unhighlightoldselection(selectedelement)
	if selectedelement then
		if isElement(selectedelement) then
			if getElementType(selectedelement) == "ped" then
				if getElementData(selectedelement,"squadleader") == getLocalPlayer() then
					for i,v in ipairs(getAttachedElements(selectedelement)) do
						if getElementType(v) == "marker" then
							setMarkerColor(v,255,255,255,128)
						elseif getElementType(v) == "blip" then
							setBlipColor(v,255,255,255,255)
							setBlipSize(v,1)
						end
					end
				end
			end
		end
	else
		for i,v in ipairs(getElementsByType("ped")) do
			if getElementData(v,"squadleader") == getLocalPlayer() then
				for i1,v1 in ipairs(getAttachedElements(v)) do
					if getElementType(v1) == "marker" then
						setMarkerColor(v1,255,255,255,128)
					elseif getElementType(v1) == "blip" then
						setBlipColor(v1,255,255,255,255)
						setBlipSize(v1,1)
					end
				end
			end
		end
		detachElements(enemymarker)
		setElementPosition(enemymarker,0,0,0)
	end
end