/*==============================================================================

Gamemode:  LethaL's Capture The Flag
Version:   The Farm



==============================================================================*/

#include <a_samp>

#define COLOR_GREY 0xAFAFAFAA
#define COLOR_GREEN 0x33AA33AA
#define COLOR_RED 0xFF0000AA //red2
#define COLOR_BLUE 0x0000BBAA
#define COLOR_LIGHTBLUE 0x33CCFFAA
#define COLOR_DARKRED 0x660000AA
#define COLOR_WHITE 0xFFFFFFAA

#define ADMIN_SPEC_TYPE_NONE 0
#define ADMIN_SPEC_TYPE_PLAYER 1
#define ADMIN_SPEC_TYPE_VEHICLE 2

#define Team_Blue 1
#define Team_Red 2

#define ScoreToWin 20


enum playerinfo {
	team,
	flagholder,
};
new PlayerInfo[MAX_PLAYERS][playerinfo];

new TeamBalanceOn;

// Pickups And Objects
new redflag;
new blueflag;
new TelePickUp;
new TelePickDown;
new redflagob;
new blueflagob;

new FirstHayOb;
new LastHayOb;

new hangar;
new garagedoor;
new DoorStatus;
new HangarStatus;

//flag variables
new redflagdropped;
new blueflagdropped;

new RedFlagTaken;
new BlueFlagTaken;

new RedFlagHolder;
new BlueFlagHolder;

new rname[MAX_PLAYER_NAME];
new bname[MAX_PLAYER_NAME];

//score variables
new redscore;
new bluescore;
new redwins;
new bluewins;
new Score[256];
new Wins[256];
new HolderStr[256];
new HolderStr2[256];

new PlayerKills[MAX_PLAYERS];
new PlayerCaptures[MAX_PLAYERS];
new KillScoreOld;
new CaptureScoreOld;
//===========================[ Timers ]=========================================
new FlagTimer;
new PlayerMapIconTimer;
new TeamKillTimer;
new HayTimer;
//=========================[ Farm Zones ]=======================================
new Blue_Area;
new Red_Area;
//=========================[ TextDraws ]========================================
new Text:scoretext;
new Text:winstext;
new Text:flagholdertext;
new Text:flagholdertext2;

// Death Spec
/*new Count[MAX_PLAYERS];   (can mess it up)
new Counter[MAX_PLAYERS];

new gSpectateID[MAX_PLAYERS];
new gSpectateType[MAX_PLAYERS];*/

//messages
new CurrentMsg;
new MsgTimer;
//=========================[ Random Spawn ]=====================================

new Float:Team1Spawns[3][4] = { // blue
{-1079.40, -1234.15, 128.81, 282.89},
{-1027.11, -1184.67, 129.21, 266.35},
{-1024.11, -1221.99, 129.21, 182.51}
};

new Float:Team2Spawns[3][4] = { // red
{-1197.34, -1069.50, 128.81, 56.03},
{-1184.98, -1095.31, 129.21, 282.89},
{-1202.71, -1143.51, 128.81, 282.89}
};

//=========================[ Forwards ]=========================================

forward RandomSpawnTeam2(playerid);
forward RandomSpawnTeam1(playerid);
forward SetGameWin(const string[]);
forward OnDeathSpecOff(playerid);
forward SpawnCounter(playerid);
forward DestroyPickupEx( p );
forward SettingPlayerTeam();
forward ContinueGame();
forward HayUpdate();
forward Msg();
forward Copyleft(playerid);

//=========================[ Weapon Drop ]=======================================

#define MAX_DROP_AMOUNT				-1 
#define MAX_DROP_LIFETIME			12 

#define WEAPON_SLOTS				13
#define INVALID_PICKUP				-1
#define MAX_PICKUPS					90
#define PICKUP_TYPE					19

enum pickup
{
	creation_time,
	weapon,
	ammo,
	timer,
	cash
}
new pickups [ MAX_PICKUPS ][ pickup ];

new weapons[] = // -1 to disable
{
	-1, // no fists
	331, // - Brass Knuckles
	333, // Golf Club
	334, // Night Stick
	335, // Knife
	336, // baseball bat
	337, // shovel
	338, // pool cue
	339, // katama
	341, // chainsaw
	321, // regular dildo
	322, // white dildo
	323, // Medium, white vibrator
	324, // smaill, silver vibrator
	325, // flowers
	326, // cane
	342, // grendade
	343, // tear gas
	344, // molotov
	359, // RPG rocket - we can't pick up those, do we oO.  We do now xD
	360, // Heat-Seeking Rocket   -1
	-1, // Hydra rocket
	346, // colt 45
	347, // colt 45 + silencer
	348, // deagle
	349, // shotgun
	350, // sawn-off
	351, // spaz
	352, // micro-uzi
	353, // mp5
	355, // ak47
	356, // m4
	372, // tec9
	357, // country rifle
	358, // sniper rifle
	359, // rocket launcher
	360, // heat-seeking rocket launcher
	361, // flamethrower
	362, // minigun
	363, // sachtel charges
	-1, // detonator
	365, // spray can
	366, // fire extinguisher
	367, // camera
	-1, // night-vision goggles
	-1, // heat-vision goggles
	371 // parachute
};



main()
{
	print("\n-------------------------------------");
	print(" LethaL's Capture The Flag  [ LCTF ]");
	print(" Farm Version 3");
	print("-------------------------------------\n");
}

public OnGameModeInit()
{
	format(Score,sizeof(Score),"~w~Team Scores: ~r~%d/%d ~w~/ ~b~%d/%d",redscore,ScoreToWin,bluescore,ScoreToWin);
    scoretext = TextDrawCreate(410.0,425,Score);

	format(Wins,sizeof(Wins),"~w~Team Wins: ~r~%d ~w~/ ~b~%d",redwins,bluewins);
    winstext = TextDrawCreate(50.0,425,Wins);

	format(HolderStr,sizeof(HolderStr),"~w~Flag Holders:~n~~r~-");
    flagholdertext = TextDrawCreate(250.0,410, HolderStr);

	format(HolderStr2,sizeof(HolderStr2),"~b~-");
    flagholdertext2 = TextDrawCreate(250.0,428, HolderStr2);
    
	SetGameModeText("Capture The Flag: The Farm");
	EnableStuntBonusForAll(false);
	UsePlayerPedAnims();
//	SetWorldTime(3);
	SetWeather(11);
	AllowAdminTeleport(1);

	//=============[ Red Team ]=============//
	AddPlayerClass(101, 1958.3783, 1343.1572, 15.3746, 269.1425, 29, 550, 22, 550, 18, 55); // close range
	AddPlayerClass(101, 1958.3783, 1343.1572, 15.3746, 269.1425, 27, 550, 24, 550, 31, 550); // medium range
	AddPlayerClass(101, 1958.3783, 1343.1572, 15.3746, 269.1425, 34, 550, 24, 550, 31, 550); // long range
	//=============[ Blue Team ]============//
	AddPlayerClass(217, 1958.3783, 1343.1572, 15.3746, 269.1425, 29, 550, 22, 550, 18, 55); // close range
	AddPlayerClass(217, 1958.3783, 1343.1572, 15.3746, 269.1425, 27, 550, 24, 550, 31, 550); // medium range
	AddPlayerClass(217, 1958.3783, 1343.1572, 15.3746, 269.1425, 34, 550, 24, 550, 31, 550); // long range

//=========================[ The Farm ]=========================================

	CreateObject(8493, -1163.44, -1043.13, 138.26,  0.00, -45.0000, 180.0000);//Ship in Las Venturas
	CreateObject(17061, -1048.67, -1296.29, 127.24,  0.000, 0.000, 0.000);// barn 1 south
	CreateObject(17061, -1210.44, -1040.13, 127.16, 0.000, 0.000, -180.000);// barn 2 north
	CreateObject(17057, -1047.96, -1218.87, 127.79, 0.000, 0.000, 0.000);// hay
	CreateObject(17057, -1047.96, -1220.50, 127.79, 0.000, 0.000, 180.000);// hay 2
	CreateObject(11502, -1127.69, -1195.84, 127.21,  0.000, 0.000, 79.81); //blue barn
	CreateObject(3279, -1120.06, -1252.84, 126.81,  0.000, 0.000,  0.00);// tower
	
	hangar = CreateObject(18250, -1017.46, -1055.74, 134.00, 0.00, 0.00, 0.00);//hangar
	garagedoor = CreateObject(16775, -1004.51, -1089.74, 128.21, 0.00, 0.00, 90.00); // garage door
	
	CreateObject(11326, -996.98, -1103.03, 129.21, 0.00, 0.00, 90.00); //garage
	CreateObject(9901, -996.15, -1161.02, 129.00, 0.00, 0.00, 0.00);// clock tower
	CreateObject(901, -999.49, -1190.85, 129.28, 0.00, 0.00, 0.00);// rock
	CreateObject(8832, -1161.53, -1217.68, 138.06, 0.00, 17.00,90.00); // bridge
	
	CreateObject(3625, -1052.14, -1180.00, 130.58, 0.00, 0.00, 90.00); // containers jump
	CreateObject(10757, -1169.82, -1265.41, 153.53, 0.00, 0.00, 0.00); //plane
	CreateObject(5299, -1187.23, -1275.21, 150.09, 0.00, 0.00, 0.00); //red water tower
	CreateObject(3626, -1212.54, -1224.00, 129.35, 0.00, 0.00, 180.00); // blue hut
	CreateObject(13640, -1113.16, -1113.34, 128.56, 0.00, 0.00, 0.00);// logs ramp
	
 	LoadHay();
	
	new ObCount = CreateObject(3461, 3644.163574, -1673.094971, 10.066670, 3.4377, 0.8595, 0.0000);	DestroyObject(ObCount);
	printf("Number of objects = %d", ObCount-1);

//=========================[ Vehicles ]=========================================

	CreateVehicle(471, -1148.88, -1156.88, 129.21,  307.07, -1, -1, -1); //quad
	CreateVehicle(562,-1000.1195,-1091.1879,128.8485,272.1329,-1,-1,-1); // Elegy in garage
	AddVehicleComponent(2,1034); AddVehicleComponent(2,1038); AddVehicleComponent(2,1147);
	AddVehicleComponent(2,1010); AddVehicleComponent(2,1073); ChangeVehiclePaintjob(2,0);
	CreateVehicle(562,-1009.0313,-1045.5725,128.8815,268.6743,-1,-1,-1); // Elegy in hangar
	AddVehicleComponent(3,1034); AddVehicleComponent(3,1038); AddVehicleComponent(3,1147);
	AddVehicleComponent(3,1010); AddVehicleComponent(3,1073); ChangeVehiclePaintjob(3,1);
	
//=========================[ Pickups ]==========================================

	CreatePickup(1240, 2, -1065.57, -1186.17, 141.40);// health on water tower
	CreatePickup(361, 2, -1078.23, -1157.85, 129.21); // flame ship inside shed
	CreatePickup(342, 2, -1198.41, -1169.71, 129.21); // grenade ammu inside hay
	CreatePickup(358, 2,-1148.66, -1167.53, 152.71 ); // rifle on hay
	
	TelePickUp = CreatePickup(1254, 23, -1011.82, -1150.71, 129.21); 
	TelePickDown = CreatePickup(1254, 23, -1018.56, -1157.01, 157.45);
	
	redflag = CreatePickup(1276,2,-1048.10, -1308.82, 131.502);
	blueflag = CreatePickup(1276,2,-1211.13, -1028.18, 131.54);

//==========================[ Team  Zone ]======================================

	Blue_Area = GangZoneCreate(-1217.17, -1299.20,  -995.50, -1161.95);
	Red_Area = GangZoneCreate(-1217.17, -1161.95, -995.50,-1024.53);

//==========================[ Timers & more]====================================

    redflagdropped = 0;
    blueflagdropped = 0;

    RedFlagHolder = 1337;
    BlueFlagHolder = 1337;
    
    TeamBalanceOn = 1;
    
    FlagTimer = SetTimer("FlagIcon",2000,true);
    PlayerMapIconTimer = SetTimer("HideMarker",2000,true);
    HayTimer = SetTimer("HayUpdate",15000,true);

	CurrentMsg = 1;
	//MsgTimer = SetTimer("Msg", 600000, true); //10 mins
	return 1;
}

public OnGameModeExit()
{
	SetTimer("DelayedGmx",5000,false);

	print("\n-------------------------------------");
	print("           LCTF Unloaded");
	print("-------------------------------------\n");
}

public OnPlayerConnect(playerid)
{
	GameTextForPlayer(playerid,"~w~capture~n~~b~the flag~n~~g~the farm",4000,1);
	SendClientMessage(playerid,COLOR_BLUE,"_______________________________________________");
	SendClientMessage(playerid,COLOR_WHITE,"          Welcome To Capture The Flag");
	SendClientMessage(playerid,COLOR_WHITE,"                  The Farm");
	SendClientMessage(playerid,COLOR_RED,"_______________________________________________");

	PlayerInfo[playerid][flagholder] = 0;
	PlayerKills[playerid] = 0;
	PlayerCaptures[playerid] = 0;

	TextDrawShowForPlayer(playerid,scoretext);
	TextDrawShowForPlayer(playerid,winstext);
	TextDrawShowForPlayer(playerid,flagholdertext);
	TextDrawShowForPlayer(playerid,flagholdertext2);
	
	GangZoneShowForPlayer(playerid, Blue_Area, COLOR_BLUE);
	GangZoneShowForPlayer(playerid, Red_Area, COLOR_RED);
	
 	TeamKillTimer = SetTimerEx("SettingPlayerTeam",900,1,"i",playerid);
 	Copyleft(playerid);
	return 1;
}

public OnPlayerRequestClass(playerid, classid)
{
	SetPlayerInterior(playerid,0);
	SetPlayerColor(playerid, COLOR_GREY);
	PlayerPlaySound( playerid, 1068, 0.0, 0.0, 0.0 );
	PlayerInfo[playerid][team] = 3;

	if(classid == 0) GameTextForPlayer(playerid,"~r~Red Team~n~~w~Short Range",700,6);
	if(classid == 1) GameTextForPlayer(playerid,"~r~Red Team~n~~w~Medium Range",700,6);
	if(classid == 2) GameTextForPlayer(playerid,"~r~Red Team~n~~w~Long Range",700,6);
	
	if(classid == 3) GameTextForPlayer(playerid,"~b~Blue Team~n~~w~Short Range",700,6);
	if(classid == 4) GameTextForPlayer(playerid,"~b~Blue Team~n~~w~Medium Range",700,6);
	if(classid == 5) GameTextForPlayer(playerid,"~b~Blue Team~n~~w~Long Range",700,6);
	
	switch (classid) {
	    case 0, 1, 2: {
	    	SetPlayerFacingAngle(playerid,45.42);
		    SetPlayerPos(playerid, -1048.07, -1220.41, 131.80);
		    SetPlayerCameraPos(playerid, -1061.44, -1195.41, 139.39);
		    SetPlayerCameraLookAt(playerid, -1048.07, -1222.41, 131.80);
			PlayerInfo[playerid][team] = Team_Red;
		}
	    case 3, 4, 5: {
		    SetPlayerFacingAngle(playerid, 45.42);
		    SetPlayerPos(playerid, -1048.07, -1220.41, 131.80);
		    SetPlayerCameraPos(playerid, -1061.44, -1195.41, 139.39);
		    SetPlayerCameraLookAt(playerid, -1048.07, -1222.41, 131.80);
		    PlayerInfo[playerid][team] = Team_Blue;
		}
	}
	return 1;
}

public OnPlayerSpawn(playerid)
{
	PlayerInfo[playerid][flagholder] = 0;
	SetPlayerWorldBounds(playerid, -995.50, -1218.22, -1024.53, -1310.20 );
	PlayerPlaySound( playerid, 1069, 0.0, 0.0, 0.0) ;

	if(!IsPlayerAdmin(playerid))	{
	SetVehicleParamsForPlayer(2,playerid,false,true);
	SetVehicleParamsForPlayer(3,playerid,false,true);
	} else {
	SetVehicleParamsForPlayer(2,playerid,false,false);
	SetVehicleParamsForPlayer(3,playerid,false,false); }
	
	if(GetPlayerScore(playerid) <101)	{
 	SetPlayerArmour(playerid, GetPlayerScore(playerid));
	} else {
	SetPlayerArmour(playerid, 100);	}

//-----[ Team Balancing Comment To Disabled ]-----//

	if(TeamBalanceOn == 1)
	{
		new RedCount; new BlueCount;
		for(new i=0; i<MAX_PLAYERS; i++)
		{
			if(IsPlayerConnected(i))
			{
				if(PlayerInfo[i][team] == Team_Blue)
				{
					BlueCount++;
				}
				else if(PlayerInfo[i][team] == Team_Red)
				{
					RedCount++;
				}
			}
		}
		if(RedCount > BlueCount+1 && PlayerInfo[playerid][team] == Team_Red) {
		PlayerInfo[playerid][team] = Team_Blue;
		SendClientMessage(playerid,COLOR_BLUE,"You have been automatically switched to blue team to even out teams");
		} else if(BlueCount > RedCount+2 && PlayerInfo[playerid][team] == Team_Blue) {
		PlayerInfo[playerid][team] = Team_Red;
		SendClientMessage(playerid,COLOR_RED,"You have been automatically switched to red team to even out teams");
		}
	}
//--------------------------------------------------//

	if(PlayerInfo[playerid][team] == Team_Blue)
	{
		SetPlayerColor(playerid, COLOR_BLUE);
		SetPlayerSkin(playerid, 217);
		new rand = random(sizeof(Team1Spawns));
		SetPlayerPos(playerid, Team1Spawns[rand][0], Team1Spawns[rand][1], Team1Spawns[rand][2]);

	}
	else if(PlayerInfo[playerid][team] == Team_Red)
	{
		SetPlayerSkin(playerid, 101);
		SetPlayerColor(playerid, COLOR_RED);
		new rand = random(sizeof(Team2Spawns));
		SetPlayerPos(playerid, Team2Spawns[rand][0], Team2Spawns[rand][1], Team2Spawns[rand][2]);
	}
	return 1;
}


public OnPlayerDeath(playerid, killerid, reason) 
{
	PlayerKills[killerid]++;

    SendDeathMessage(killerid,playerid,reason);
	SetPlayerScore(killerid, (GetPlayerScore(killerid)+1) );
	
    if(PlayerInfo[playerid][team] == Team_Blue && PlayerInfo[playerid][flagholder] == 1) {
        DisablePlayerCheckpoint(playerid);
		PlayerInfo[playerid][flagholder] = 0;
		BlueFlagHolder = 1337;
		DestroyObject(blueflagob);
		SetPlayerColor(playerid,COLOR_BLUE);
		new Float:DPos[3]; GetPlayerPos(playerid, DPos[0],DPos[1],DPos[2]);
		blueflag = CreatePickup(1276,2,DPos[0],DPos[1],DPos[2] );
		blueflagdropped = 1;
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s died & dropped~n~the ~b~blue flag",string);
		GameTextForAll(string,2500,6);
    }
    
    if(PlayerInfo[playerid][team] == Team_Red && PlayerInfo[playerid][flagholder] == 1) {
        DisablePlayerCheckpoint(playerid);
		PlayerInfo[playerid][flagholder] = 0;
		RedFlagHolder = 1337;
		DestroyObject(redflagob);
		SetPlayerColor(playerid,COLOR_RED);
		new Float:DPos[3]; GetPlayerPos(playerid, DPos[0],DPos[1],DPos[2]);
		redflag = CreatePickup(1276,2,DPos[0],DPos[1],DPos[2] );
		redflagdropped = 1;
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s died & dropped~n~ the ~r~red flag",string);
		GameTextForAll(string,2500,6);
    }
    
    DropWeapons( playerid );

/*//-------------------------------------
	if(killerid == INVALID_PLAYER_ID)
	{
    	SendDeathMessage(INVALID_PLAYER_ID,playerid,reason);
	}
	else
	{
		if(IsPlayerInAnyVehicle(killerid))
		{
			SetPlayerInterior(playerid,GetPlayerInterior(killerid));
			TogglePlayerSpectating(playerid, 1);
			PlayerSpectateVehicle(playerid, GetPlayerVehicleID(killerid));
			gSpectateID[playerid] = killerid;
			gSpectateType[playerid] = ADMIN_SPEC_TYPE_VEHICLE;
		}
		else
		{
			SetPlayerInterior(playerid,GetPlayerInterior(killerid));
			TogglePlayerSpectating(playerid, 1);
			PlayerSpectatePlayer(playerid, killerid);
			gSpectateID[playerid] = killerid;
			gSpectateType[playerid] = ADMIN_SPEC_TYPE_PLAYER;
		}

		Count[playerid] = 10;
		Counter[playerid] = SetTimerEx("SpawnCounter", 1000, 1,"i",playerid);
		SetTimerEx("OnDeathSpecOff",10000,0,"d",playerid);
	}
//-------------------------------------*/
	return 1;
}


public OnPlayerEnterCheckpoint(playerid)
{

    if(PlayerInfo[playerid][team] == Team_Red && PlayerInfo[playerid][flagholder] == 1) {
		DisablePlayerCheckpoint(playerid);
		PlayerInfo[playerid][flagholder] = 0;
		DestroyObject(redflagob);
		redflagdropped = 0;
		RedFlagTaken = 0;
		RedFlagHolder = 1337;
		SetPlayerColor(playerid,COLOR_RED);
		redflag = CreatePickup(1276,2,-1048.10, -1308.82, 131.502);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s has ~n~captured the~n~~r~red flag",string);
		GameTextForAll(string,2500,6);
		PlayerCaptures[playerid]++;
		SetPlayerScore(playerid,( GetPlayerScore(playerid)+1 ) );
		redscore++;
		if(redscore < ScoreToWin) {
		format(Score,sizeof(Score),"~w~Team Scores: ~r~%d/%d ~w~/ ~b~%d/%d",redscore,ScoreToWin,bluescore,ScoreToWin);
    	TextDrawSetString(scoretext,Score);
    	} else {
    	redscore = 0; bluescore = 0;   	redwins++;
		format(Score,sizeof(Score),"~w~Team Scores: ~r~%d ~w~/ ~b~%d",redscore,bluescore);
    	TextDrawSetString(scoretext,Score);
		format(Wins,sizeof(Wins),"~w~Team Wins: ~r~%d ~w~/ ~b~%d",redwins,bluewins);
    	TextDrawSetString(winstext,Wins);
    	SetGameWin("~r~Red Team");
    	}
    }
    
    if(PlayerInfo[playerid][team] == Team_Blue && PlayerInfo[playerid][flagholder] == 1) {
		DisablePlayerCheckpoint(playerid);
		PlayerInfo[playerid][flagholder] = 0;
		DestroyObject(blueflagob);
		blueflagdropped = 0;
		BlueFlagTaken = 0;
		BlueFlagHolder = 1337;
		SetPlayerColor(playerid,COLOR_BLUE);
		blueflag = CreatePickup(1276,2,-1211.13, -1028.18, 131.54);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~ %s has ~n~captured the~n~~b~blue flag",string);
		GameTextForAll(string,2500,6);
		PlayerCaptures[playerid]++;
		SetPlayerScore(playerid,( GetPlayerScore(playerid)+1 ) );
		bluescore++;
		if(bluescore < ScoreToWin) {
		format(Score,sizeof(Score),"~w~Team Scores: ~r~%d/%d ~w~/ ~b~%d/%d",redscore,ScoreToWin,bluescore,ScoreToWin);
    	TextDrawSetString(scoretext,Score);
    	} else {
    	redscore = 0; bluescore = 0;   	bluewins++;
		format(Score,sizeof(Score),"~w~Team Scores: ~r~%d ~w~/ ~b~%d",redscore,bluescore);
    	TextDrawSetString(scoretext,Score);
		format(Wins,sizeof(Wins),"~w~Team Wins: ~r~%d ~w~/ ~b~%d",redwins,bluewins);
    	TextDrawSetString(winstext,Wins);
		SetGameWin("~b~Blue Team");
    	}
    }

	return 1;
}


public SetGameWin(const string[])
{
	new KillScore;
	new name[MAX_PLAYER_NAME];
	new kstring[256];
	for(new i=0; i<MAX_PLAYERS; i++)
	{
		if (IsPlayerConnected(i))
		{
   			KillScore = PlayerKills[i];
			if (KillScore > KillScoreOld)
			{
				KillScoreOld = KillScore;
				GetPlayerName(i, name, sizeof(name));
				format(kstring, sizeof(kstring), "%s has most kills :)", name);
//				SendClientMessageToAll(COLOR_GREEN, kstring);
			}
		}
	}

	new CaptureScore;
	new cname[MAX_PLAYER_NAME];
	new cstring[256];
	for(new i=0; i<MAX_PLAYERS; i++)
	{
		if (IsPlayerConnected(i))
		{
   			CaptureScore = PlayerCaptures[i];
			if (CaptureScore > CaptureScoreOld)
			{
				CaptureScoreOld = CaptureScore;
				GetPlayerName(i, cname, sizeof(cname));
				format(cstring, sizeof(cstring), "%s has most captures :)", cname);
//				SendClientMessageToAll(COLOR_RED, cstring);
			}
		}
	}
	
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
	    if(IsPlayerConnected(i))
	    {
			TogglePlayerControllable(i, false);
			PlayerInfo[i][flagholder] = 0;
			PlayerKills[i] = 0;
			PlayerCaptures[i] = 0;
		}
	}
  	new str[256];	format(str,sizeof(str),"%s~n~~w~has won the~n~round~n~~n~%s has most kills~n~%s has most flag captures",string,name,cname);
	GameTextForAll(str,5000,3);


	SetTimer("ContinueGame",5000,0);
}

public ContinueGame()
{
	for(new i = 0; i < MAX_PLAYERS; i++)
    {
  	 	if(IsPlayerConnected(i))
	    {
			TogglePlayerControllable(i, true);
			SpawnPlayer(i);
		}
	}
	new CGstr[64]; format(CGstr,sizeof(CGstr),"~w~round %d",(bluewins + redwins)+1);
	GameTextForAll(CGstr,4000,3);
}


public OnPlayerPickUpPickup(playerid, pickupid)
{
//-------------------[ Steal your flag from the other teams base ]--------------
	if(pickupid == redflag && redflagdropped == 0 && PlayerInfo[playerid][team] == Team_Red) {
        PlayerInfo[playerid][flagholder] = 1;
		SetPlayerCheckpoint(playerid, -1211.59, -1027.42, 128.26,5.0); // red base
	    DestroyPickup(redflag);
		RedFlagTaken = 1;
		RedFlagHolder = playerid;
	    SetPlayerColor(playerid,COLOR_DARKRED);
	    redflagob = CreateObject(1276,0.1,0.1,0.1,0.1,0.1,0.1);
	    AttachObjectToPlayer(redflagob,playerid,0,0,2,0,0,0);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s has~n~taken the~n~ ~r~red flag",string);
		GameTextForAll(string,2500,6);
	    return 1;
	}
	if(pickupid == blueflag && blueflagdropped == 0 && PlayerInfo[playerid][team] == Team_Blue) {
		PlayerInfo[playerid][flagholder] = 1;
	    SetPlayerCheckpoint(playerid,-1047.67, -1308.68, 128.54,5.0);// blue base
	    DestroyPickup(blueflag);
		BlueFlagTaken = 1;
		BlueFlagHolder = playerid;
	    SetPlayerColor(playerid,COLOR_LIGHTBLUE);
	    blueflagob = CreateObject(1276,0.1,0.1,0.1,0.1,0.1,0.1);
	    AttachObjectToPlayer(blueflagob,playerid,0,0,2,0,0,0);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s has~n~taken the~n~~b~blue flag",string);
		GameTextForAll(string,2500,6);
	    return 1;
	}
//------------[ Return other teams flag after the other team drops it ]---------
	if(pickupid == redflag && redflagdropped == 1 && PlayerInfo[playerid][team] == Team_Blue) {
		DisablePlayerCheckpoint(playerid);
		PlayerInfo[playerid][flagholder] = 0;
	    DestroyPickup(redflag);
	    redflagdropped = 0;
	    RedFlagTaken = 0;
		RedFlagHolder = 1337;
		redflag = CreatePickup(1276,2,-1048.10, -1308.82, 131.502);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s has~n~returned the~n~~r~red flag",string);
		GameTextForAll(string,2500,6);
		return 1;
	}
	if(pickupid == blueflag && blueflagdropped == 1 && PlayerInfo[playerid][team] == Team_Red) {
		DisablePlayerCheckpoint(playerid);
		PlayerInfo[playerid][flagholder] = 0;
		DestroyPickup(blueflag);
		blueflagdropped = 0;
		BlueFlagTaken = 0;
		BlueFlagHolder = 1337;
		blueflag = CreatePickup(1276,2,-1211.13, -1028.18, 131.54);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s has~n~returned the~n~ ~b~blue flag",string);
		GameTextForAll(string,2500,6);
		return 1;
    }
//--------------------[ pickup own flag after your team mate dies ]-------------
	if(pickupid == redflag && redflagdropped == 1 && PlayerInfo[playerid][team] == Team_Red) {
        PlayerInfo[playerid][flagholder] = 1;
		SetPlayerCheckpoint(playerid, -1211.59, -1027.42, 128.26,5.0); // red base
	    DestroyPickup(redflag);
		RedFlagTaken = 1;
		RedFlagHolder = playerid;
	    SetPlayerColor(playerid,COLOR_DARKRED);
	    redflagob = CreateObject(1276,0.1,0.1,0.1,0.1,0.1,0.1);
	    AttachObjectToPlayer(redflagob,playerid,0,0,2,0,0,0);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s has~n~picked up the~n~ ~r~red flag",string);
		GameTextForAll(string,2500,6);
	    return 1;
	}
	if(pickupid == blueflag && blueflagdropped == 1 && PlayerInfo[playerid][team] == Team_Blue) {
		PlayerInfo[playerid][flagholder] = 1;
	    SetPlayerCheckpoint(playerid,-1047.67, -1308.68, 128.54,5.0);// blue base
	    DestroyPickup(blueflag);
		BlueFlagTaken = 1;
		BlueFlagHolder = playerid;
	    SetPlayerColor(playerid,COLOR_LIGHTBLUE);
	    blueflagob = CreateObject(1276,0.1,0.1,0.1,0.1,0.1,0.1);
	    AttachObjectToPlayer(blueflagob,playerid,0,0,2,0,0,0);
		new string[256];	GetPlayerName(playerid,string,sizeof(string));
		format(string,sizeof(string),"~w~%s has~n~picked up the~n~~b~blue flag",string);
		GameTextForAll(string,2500,6);
	    return 1;
	}


//-------------------------[ Teleports for clock tower ]------------------------
	if(pickupid == TelePickUp) SetPlayerPos(playerid, -1017.37, -1160.87, 168.60);
	if(pickupid == TelePickDown) SetPlayerPos(playerid, -1001.57, -1189.87, 134.79);

	return 0;
}


public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	if( (!IsPlayerAdmin(playerid)) && PlayerInfo[playerid][flagholder] == 1) {
	new Float:x,Float:y,Float:z; GetPlayerPos(playerid,x,y,z); SetPlayerPos(playerid,x,y,z+1);
    SendClientMessage(playerid,COLOR_RED,"Flag holders cant use this vehicle");
	return 1;
	}
	return 0;
}


public OnPlayerCommandText(playerid, cmdtext[])
{
	new cmd[256], tmp[256], string[256], idx;
	new name[MAX_PLAYER_NAME];
	cmd = strtok(cmdtext, idx);

//======================[ Player Commands ]=====================================


	if(strcmp(cmd, "/passflag", true) == 0)
		{
        if(PlayerInfo[playerid][flagholder] == 0) return
			SendClientMessage(playerid, COLOR_RED, "ERROR: You dont have the flag");
		
	    new player1;
		tmp = strtok(cmdtext, idx);

		if(!strlen(tmp)) return
			SendClientMessage(playerid, COLOR_RED, "USAGE: /passflag [playerid]");

		player1 = strval(tmp);
		if(!IsPlayerConnected(player1) || player1 == INVALID_PLAYER_ID) return
			SendClientMessage(playerid, COLOR_RED, "ERROR: Player Not Connected");
		if(PlayerInfo[playerid][team] != PlayerInfo[player1][team]) return
			SendClientMessage(playerid, COLOR_RED, "ERROR: This Player Is Not On Your Team");
		tmp = strtok(cmdtext, idx);

		if(PlayerInfo[playerid][team] == Team_Blue)
  		{
	   		if(GetDistanceBetweenPlayers(playerid, player1) > 5)
			{
		    	SendClientMessage(playerid, COLOR_RED, "You are too far away from your team mate");
			    return 1;
		    }
			else
		    {
	    		PlayerInfo[playerid][flagholder] = 0; PlayerInfo[player1][flagholder] = 1;
			    SetPlayerCheckpoint(player1,-1047.67, -1308.68, 128.54,5.0); DisablePlayerCheckpoint(playerid);
			    SetPlayerColor(playerid,COLOR_BLUE); SetPlayerColor(player1,COLOR_LIGHTBLUE);
				BlueFlagHolder = player1;
		    	AttachObjectToPlayer(blueflagob,player1,0,0,2,0,0,0);
				GetPlayerName(playerid,string,sizeof(string));		GetPlayerName(player1, name, sizeof(name));
				format(string,sizeof(string),"~w~%s has~n~passed the~n~~b~blue flag~n~~w~to %s",string, name);
				GameTextForAll(string,2500,6);
		    }
		}

		if(PlayerInfo[playerid][team] == Team_Red)
	    {
	   		if(GetDistanceBetweenPlayers(playerid, player1) > 5)
		    {
		    	SendClientMessage(playerid, COLOR_RED, "You are too far away from your team mate");
			    return 1;
			}
			else
			{
	    		PlayerInfo[playerid][flagholder] = 0; PlayerInfo[player1][flagholder] = 1;
			    SetPlayerCheckpoint(player1, -1211.59, -1027.42, 128.26,5.0);		 DisablePlayerCheckpoint(playerid);
			    SetPlayerColor(playerid,COLOR_RED); SetPlayerColor(player1,COLOR_DARKRED);
				RedFlagHolder = player1;
		    	AttachObjectToPlayer(redflagob,player1,0,0,2,0,0,0);
				GetPlayerName(playerid,string,sizeof(string));		GetPlayerName(player1, name, sizeof(name));
				format(string,sizeof(string),"~w~%s has~n~passed the~n~~r~red flag~n~~w~to %s",string, name);
				GameTextForAll(string,2500,6);
			}
		}
  		return 1;
	}

   	if(strcmp(cmd, "/switch", true) == 0)
	{
	    if(PlayerInfo[playerid][flagholder] == 1)
		return SendClientMessage(playerid, COLOR_RED, "You cant switch teams because you have the flag");

	    if(PlayerInfo[playerid][team] == Team_Red)
		{
	   		GameTextForPlayer(playerid,"~b~Changing Team. . .",3000,3);
			PlayerInfo[playerid][team] = Team_Blue; SetPlayerColor(playerid, COLOR_BLUE);
			SetPlayerSkin(playerid, 217);
			SetTimerEx("DelayTeamSwitch",3000,0,"d",playerid);
	   	}
		else if(PlayerInfo[playerid][team] == Team_Blue)
  		{
   			GameTextForPlayer(playerid,"~r~Changing Team. . .",3000,3);
   			SetTimerEx("DelayTeamSwitch",3000,0,"d",playerid);
			PlayerInfo[playerid][team] = Team_Red; SetPlayerColor(playerid, COLOR_RED);
			SetPlayerSkin(playerid, 101);
		}
		return 1;
	}

	if(strcmp(cmd, "/idea", true) == 0)
	{
		new length = strlen(cmdtext);
		if(length < 11) return SendClientMessage(playerid,COLOR_RED,"ERROR: What is the idea / suggestion ?");

		new File:SavePosFile, ip[50], year,month,day, hour,minute,second;
		
		GetPlayerIp(playerid,ip,sizeof(ip) );	GetPlayerName(playerid, name, sizeof(name));
		getdate(year,month,day); gettime(hour,minute,second);

		SavePosFile = fopen("CTFideas.txt",io_append);
		format(string,sizeof(string),"[%d.%d.%d %d:%d] %s,%d,%s>%s\r\n",day,month,year,hour,minute, name,playerid,ip,cmdtext[6]);
		fwrite(SavePosFile,string);
		fclose(SavePosFile);

		GameTextForPlayer(playerid,"~n~Idea Sent",1000,6);
		PlayerPlaySound(playerid,1057,0.0,0.0,0.0);
	 	return 1;
	}
	

	if(strcmp(cmd, "/kill", true) == 0) return SetPlayerHealth(playerid,0);

 	if(strcmp(cmd, "/help", true) == 0)   {
 	SendClientMessage(playerid,COLOR_WHITE,"____________________________________________________________________________");
	SendClientMessage(playerid,COLOR_WHITE,"	     LethaL's Capture The Flag - Help");
	SendClientMessage(playerid,COLOR_WHITE,"Objective: The aim is to capture your flag from the others teams base, and");
	SendClientMessage(playerid,COLOR_WHITE,"returning it to the checkpoint in your base. You can gain points by killing");
	SendClientMessage(playerid,COLOR_WHITE,"the opposing team and by capturing your flag.");
	format(string, sizeof(string), "Teams need %d points to win the round", ScoreToWin); SendClientMessage(playerid,COLOR_WHITE,string);
	SendClientMessage(playerid,COLOR_WHITE,"Type: /commands for a list of useful commands");
	SendClientMessage(playerid,COLOR_WHITE,"____________________________________________________________________________");
	return 1;	}

 	if(strcmp(cmd, "/commands", true) == 0)   {
	SendClientMessage(playerid,COLOR_WHITE,"_______________________________________________________________");
	SendClientMessage(playerid,COLOR_WHITE,"	     Capture The Flag Commands");
    SendClientMessage(playerid,COLOR_WHITE,"/kill,  /help,  /passflag,  /switch");
    SendClientMessage(playerid,COLOR_WHITE,"Type: ' ; ' for team chat");
    if(IsPlayerAdmin(playerid)) SendClientMessage(playerid,COLOR_RED,"Admin only: /setCTFscore, /forceswitch, /teambalance, /ubound, /end");
    if(IsPlayerAdmin(playerid)) SendClientMessage(playerid,COLOR_RED,"            /updatehay, /garage, /hangar, hangardown");
    SendClientMessage(playerid,COLOR_WHITE,"________________________________________________________________");
	return 1;	}

 	if(strcmp(cmd, "/rules", true) == 0)   {
	SendClientMessage(playerid,COLOR_WHITE,"_______________________________________________________________");
	SendClientMessage(playerid,COLOR_WHITE,"	      Capture The Flag Rules");
    SendClientMessage(playerid,COLOR_WHITE,"DO NOT: Cheat, Spawn kill, Flame, Spam, Teamkill");
    SendClientMessage(playerid,COLOR_WHITE,"        Impersonate players or admins");
    SendClientMessage(playerid,COLOR_WHITE,"Allowed: All bugs accept no reload bug xD");
    SendClientMessage(playerid,COLOR_WHITE,"________________________________________________________________");
	return 1;	}

//======================[ Admin Commands ]======================================
 	if(strcmp(cmd, "/setctfscore", true) == 0)
	{
 	if(IsPlayerAdmin(playerid))
 	{
	    new rs, bs, rw, bw;
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp)) return
		SendClientMessage(playerid, COLOR_RED, "USAGE: /setscore [red score] [blue score] [red wins] [blue wins]");

		rs = strval(tmp);
		if(rs>ScoreToWin) return SendClientMessage(playerid,COLOR_RED, "ERROR: Invalid score");
		tmp = strtok(cmdtext, idx);
		bs = strval(tmp);
		if(bs>ScoreToWin) return SendClientMessage(playerid,COLOR_RED, "ERROR: Invalid score");
 		tmp = strtok(cmdtext, idx);
 		rw = strval(tmp);
		tmp = strtok(cmdtext, idx);
        bw = strval(tmp);
		tmp = strtok(cmdtext, idx);

 	    redscore = rs; bluescore = bs;
 	    redwins = rw; bluewins = bw;

		GetPlayerName(playerid, name, sizeof(name));
		format(string, sizeof(string), "[CTF]: %s has changed the score", name); SendClientMessageToAll(COLOR_RED, string); print(string);
 	    } else {
    SendClientMessage(playerid, COLOR_RED, "You are not an admin !"); }
    return 1;
	}

 	if(strcmp(cmd, "/forceswitch", true) == 0)
	{
 	if(IsPlayerAdmin(playerid))
 	{
	    new player1 , player1name[MAX_PLAYER_NAME];
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))	{
		SendClientMessage(playerid, COLOR_RED, "USAGE: /forceswitch [[playerid]");
		return 1;	}

		player1 = strval(tmp);
		if(!IsPlayerConnected(player1) || player1 == INVALID_PLAYER_ID) return
		SendClientMessage(playerid, COLOR_RED, "ERROR: Player Not Connected");
		tmp = strtok(cmdtext, idx);

	    if(PlayerInfo[player1][team] == Team_Red)
		{
	   		GameTextForPlayer(player1,"Changing Team. . .",3000,3);
			PlayerInfo[player1][team] = Team_Blue; SetPlayerColor(player1, COLOR_BLUE);
			SetPlayerSkin(playerid, 217); SpawnPlayer(player1);
	   	}
		else if(PlayerInfo[player1][team] == Team_Blue)
  		{
		   	GameTextForPlayer(player1,"Changing Team. . .",3000,3);
			PlayerInfo[player1][team] = Team_Red; SetPlayerColor(player1, COLOR_RED);
			SetPlayerSkin(playerid, 101); SpawnPlayer(player1);
		}

		GetPlayerName(playerid, name, sizeof(name)); GetPlayerName(player1, player1name, sizeof(player1name));
		format(string, sizeof(string), "[CTF]: Administrator %s has forced %s to switch teams", name, player1name);
		SendClientMessageToAll(COLOR_RED, string);
 	    } else {
    SendClientMessage(playerid, COLOR_RED, "You are not an admin !"); }
    return 1;
	}
		
 	if(strcmp(cmd, "/end", true) == 0)
	{
	    if(IsPlayerAdmin(playerid))
	    {
	    SendClientMessageToAll(COLOR_GREY, "[SERVER]: Gamemode ending..");
		GameModeExit();
	    } else {
    	SendClientMessage(playerid, COLOR_GREY,"You are not an admin !");
    	}
		return 1;
    }

 	if(strcmp(cmd, "/teambalance", true) == 0)
	{
	    if(IsPlayerAdmin(playerid))
	    {
	        if(TeamBalanceOn == 0)
	        {
		    	TeamBalanceOn = 1;
				GetPlayerName(playerid, name, sizeof(name));
				format(string, sizeof(string), "[CTF]: Administrator %s has turned team balancing on", name);
				SendClientMessageToAll(COLOR_RED, string);
			}
			else
			{
		    	TeamBalanceOn = 0;
				GetPlayerName(playerid, name, sizeof(name));
				format(string, sizeof(string), "[CTF]: Administrator %s has turned team balancing off", name);
				SendClientMessageToAll(COLOR_RED, string);
			}
 	    }
 		else
 		{
		    SendClientMessage(playerid, COLOR_RED, "You are not an admin !");
		}
	    return 1;
	}


 	if(strcmp(cmd, "/ubound", true) == 0)
	{
	 	if(IsPlayerAdmin(playerid))
 		{
		    new player1, pname[256];
			tmp = strtok(cmdtext, idx);
			if(!strlen(tmp)) return SendClientMessage(playerid, COLOR_RED, "USAGE: /forceswitch [[playerid]");

			player1 = strval(tmp);
			if(!IsPlayerConnected(player1) || player1 == INVALID_PLAYER_ID) return
				SendClientMessage(playerid, COLOR_RED, "ERROR: Player Not Connected");
			tmp = strtok(cmdtext, idx);

			GetPlayerName(playerid, name, sizeof(name)); GetPlayerName(player1, pname, sizeof(pname));
			format(string, sizeof(string), "[CTF]: Administrator %s has removed your world boundaries", name);
			SendClientMessage(player1,COLOR_RED, string);
			format(string, sizeof(string), "[CTF]: You have removed %s's world boundaries", pname);
			SendClientMessage(playerid,COLOR_RED, string);
			SetPlayerWorldBounds(player1, 9999.9, -9999.9, 9999.9, -9999.9 );
		}
	 	else
 		{
		    SendClientMessage(playerid, COLOR_RED, "You are not an admin !");
		}
	    return 1;
	}

 	if(strcmp(cmd, "/updatehay", true) == 0)
	{
	 	if(IsPlayerAdmin(playerid))
 		{
			DeleteHay();
			LoadHay();
		}
	 	else
 		{
		    SendClientMessage(playerid, COLOR_RED, "You are not an admin !");
		}
	    return 1;
	}

 	if(strcmp(cmd, "/scores", true) == 0)
	{
	 	if(IsPlayerAdmin(playerid))
 		{
		    new player1, pname[256];
			tmp = strtok(cmdtext, idx);
			if(!strlen(tmp)) return SendClientMessage(playerid, COLOR_RED, "USAGE: /scores [[playerid]");

			player1 = strval(tmp);
			if(!IsPlayerConnected(player1) || player1 == INVALID_PLAYER_ID) return
				SendClientMessage(playerid, COLOR_RED, "ERROR: Player Not Connected");
			tmp = strtok(cmdtext, idx);

			GetPlayerName(player1, pname, sizeof(pname));
			format(string, sizeof(string), "[CTF scores]: %d>%s >flag holder>%d>kills>%d>captures%d",player1, pname,PlayerInfo[player1][flagholder],PlayerKills[player1],PlayerCaptures[player1] );
			SendClientMessage(player1,COLOR_RED, string);
		}
	 	else
 		{
		    SendClientMessage(playerid, COLOR_RED, "You are not an admin !");
		}
	    return 1;
	}

 	if(strcmp(cmd, "/hangar", true) == 0)
	{
	 	if(IsPlayerAdmin(playerid))
 		{
 		    if(HangarStatus == 1)
		 	{
				MoveObject(hangar,-1017.46, -1055.74, 134.00, 5.0);
				HangarStatus = 0;
			}
			else
			{
				MoveObject(hangar,-1017.46, -1055.74, 139.00, 5.0);
				HangarStatus = 1;
			}
		}
	 	else {
		    SendClientMessage(playerid, COLOR_RED, "You are not an admin !");
		}
	    return 1;
	}

 	if(strcmp(cmd, "/garage", true) == 0)
	{
	 	if(IsPlayerAdmin(playerid))
 		{
	 		new Float:Pos[3]; GetObjectPos(garagedoor,Pos[0], Pos[1], Pos[2] );
			if(DoorStatus == 1)
			{
			    
				MoveObject(garagedoor,Pos[0], Pos[1], Pos[2]+5, 7.0);
				DoorStatus = 0;
			}
			else
			{
				MoveObject(garagedoor,Pos[0], Pos[1], Pos[2]-5, 7.0);
				DoorStatus = 1;
			}
		}
	 	else {
		    SendClientMessage(playerid, COLOR_RED, "You are not an admin !");
		}
	    return 1;
	}
	
 	if(strcmp(cmd, "/hangardown", true) == 0)	{
	 	if(IsPlayerAdmin(playerid))
 		{
			MoveObject(hangar,-1017.46, -1055.74, 130.00, 5.0);
		}
	 	else
		{
		    SendClientMessage(playerid, COLOR_RED, "You are not an admin !");
		}
	    return 1;
	}
	
	
	return 0;
}


forward FlagIcon();
public FlagIcon()
{

//====[ Flag Map Icon ]====//

	if(blueflagdropped == 0 && BlueFlagTaken == 1)
 	{
		new Float:FPos[3]; GetPlayerPos(BlueFlagHolder,FPos[0], FPos[1], FPos[2] );
		for(new i = 0; i < MAX_PLAYERS; i++) SetPlayerMapIcon(i, 1, FPos[0], FPos[1], FPos[2],53,0);
	}
	else if(blueflagdropped == 0 && BlueFlagTaken == 0)
	{
		for(new i = 0; i < MAX_PLAYERS; i++) SetPlayerMapIcon(i, 1, -1211.13, -1028.18, 131.54, 53,1);
	}

	if(redflagdropped == 0 && RedFlagTaken == 1)
	{
		new Float:FPos[3]; GetPlayerPos(RedFlagHolder,FPos[0], FPos[1], FPos[2] );
		for(new i = 0; i < MAX_PLAYERS; i++) SetPlayerMapIcon(i, 2, FPos[0], FPos[1], FPos[2],53,0);
	}
	else if(redflagdropped == 0 && RedFlagTaken == 0)
	{
		for(new i = 0; i < MAX_PLAYERS; i++) SetPlayerMapIcon(i, 2, -1048.10, -1308.82, 131.502, 53,0);
	}

//====[ Flag Holder Text ]====//

	if(RedFlagHolder == 1337)	{
	format(HolderStr,sizeof(HolderStr),"~w~Flag Holders:~n~~r~-",RedFlagHolder);
	TextDrawSetString(flagholdertext,HolderStr);
	}	else	{
	GetPlayerName(RedFlagHolder,rname, sizeof(rname));
	format(HolderStr,sizeof(HolderStr),"~w~Flag Holders:~n~~r~%s",rname);
	TextDrawSetString(flagholdertext,HolderStr);
	}

	if(BlueFlagHolder == 1337)	{
	format(HolderStr2,sizeof(HolderStr2),"~b~-",BlueFlagHolder);
	TextDrawSetString(flagholdertext2,HolderStr2);
	}	else	{
	GetPlayerName(BlueFlagHolder,bname, sizeof(bname));
	format(HolderStr2,sizeof(HolderStr2),"~b~%s",bname);
	TextDrawSetString(flagholdertext2,HolderStr2);
	}


}

//==============================================================================
public OnPlayerText(playerid,text[])
{
  if(text[0] == ';') {
    new name[24], string[256];
    GetPlayerName(playerid, name, 24);
    format(string, sizeof(string), "%s (TeamChat): %s", name, text[1]);

    for(new i = 0; i < MAX_PLAYERS; i++) {
          if(IsPlayerConnected(i)) {
                if(PlayerInfo[i][team] == PlayerInfo[playerid][team])
                SendClientMessage(i, GetPlayerColor(playerid), string);
                }
          }
	return 0;
	}
  return 1;
}

//==============================================================================
public DestroyPickupEx( p )
{
	DestroyPickup( p );
	pickups[ p ][ creation_time ] = 0;
	pickups[ p ][ weapon ] = 0;
	pickups[ p ][ ammo ] = 0;
}
//==============================================================================
DropWeapons( playerid )
{
	new Float: px, Float: py, Float: pz;
	new hour,minute,second;
	new year, month,day;
	gettime(hour, minute, second);
	getdate(year, month, day);

	GetPlayerPos( playerid, px, py, pz );

	new weapon_slots[WEAPON_SLOTS + 1][2];
	new used_weapon_slots;

	for( new i = 0; i < WEAPON_SLOTS; i ++ )
	{
		GetPlayerWeaponData( playerid, i, weapon_slots[ i ][ 0 ], weapon_slots[ i ][ 1 ]);
		if( i == 0 && weapon_slots[ i ][ 0 ] == 0 ) weapon_slots[ i ][ 1 ] = 0; // no fist...

		if( weapon_slots[ i ][ 1 ] > 0 && weapon_slots[ i ][ 0 ] < sizeof( weapons ) && weapons[ weapon_slots[ i ][ 0 ] ] != -1 )
		{
			used_weapon_slots ++;
		}
		else
		{
		    weapon_slots[ i ][ 0 ] = 0;
		    weapon_slots[ i ][ 1 ] = 0;
		}
	}
	// Create the pickups
	new used_weapon_slots2 = used_weapon_slots;
	for( new i = 0; i < WEAPON_SLOTS; i ++ )
	{
	    if( weapon_slots[ i ][ 1 ] > 0 )
	    {
			new Float:angle = 360.0 - float(used_weapon_slots--) * ( 360.0 / float(used_weapon_slots2) );

			new p = CreatePickup( weapons[ weapon_slots[ i ][ 0 ] ], PICKUP_TYPE, px + floatsin(angle,degrees) * (used_weapon_slots2/2 + 1.0), py + floatcos(angle,degrees) * (used_weapon_slots2/2 + 1.0), pz );
			if( p == INVALID_PICKUP )
			{
				new lowest_time;
				new _id;
				for( new j = 0; j < MAX_PICKUPS; j ++ )
				{
					if( pickups[ j ][ creation_time ] < lowest_time )
					{
					    lowest_time = pickups[ j ][ creation_time ];
					    _id = j;
					}
				}

				DestroyPickupEx( _id );
				KillTimer( pickups[ _id ][ timer ] );

				p = CreatePickup( weapons[ weapon_slots[ i ][ 0 ] ], PICKUP_TYPE, px + floatsin(angle,degrees) * (used_weapon_slots2/2 + 1.0), py + floatcos(angle,degrees) * (used_weapon_slots2/2 + 1.0), pz );
			}
			pickups[ p ][ creation_time ] = 1;
			pickups[ p ][ weapon ] = weapon_slots[ i ][ 0 ];
			pickups[ p ][ ammo ] = weapon_slots[ i ][ 1 ];
			#if MAX_DROP_AMOUNT != -1
		    if( pickups[ p ][ ammo ] > MAX_DROP_AMOUNT )
		    {
		        pickups[ p ][ ammo ] = MAX_DROP_AMOUNT;
		    }
		    #endif
			pickups[ p ][ timer ] = SetTimerEx("DestroyPickupEx", MAX_DROP_LIFETIME * 1000, 0, "i", p);
		}
	}
}

forward HideMarker();
public HideMarker()
{
	for (new i = 0; i < MAX_PLAYERS; i++)
	{
		for (new x = 0; x < MAX_PLAYERS; x++)
		{
		if(PlayerInfo[i][team] == PlayerInfo[x][team]) SetPlayerMarkerForPlayer(i,x,GetPlayerColor(x));
			else SetPlayerMarkerForPlayer(i,x, ( GetPlayerColor(x) & 0xFFFFFF00) );
		}
	}
  	return 1;
}

public SettingPlayerTeam()
{
    for(new playerid; playerid < 200; playerid++)
        SetPlayerTeam(playerid, PlayerInfo[playerid][team] );
    return 1;
}


stock GetDistanceBetweenPlayers(playerid, playerid2)
{
    new Float:x1, Float:y1, Float:z1, Float:x2, Float:y2, Float:z2;
    new Float:tmpdis;
    GetPlayerPos(playerid, x1, y1, z1);
    GetPlayerPos(playerid2, x2, y2, z2);
    tmpdis = floatsqroot(floatpower(floatabs(floatsub(x2, x1)), 2) + floatpower(floatabs(floatsub(y2, y1)), 2) + floatpower(floatabs(floatsub(z2, z1)), 2));
    return floatround(tmpdis);
}

//==============================================================================
forward DelayedGmx();
public DelayedGmx()
{
	GangZoneDestroy(Blue_Area);
	GangZoneDestroy(Red_Area);

	KillTimer(FlagTimer);
	KillTimer(PlayerMapIconTimer);
	KillTimer(TeamKillTimer);
	KillTimer(MsgTimer);
	KillTimer(HayTimer);
	
	TextDrawDestroy(scoretext);
	TextDrawDestroy(winstext);
	TextDrawDestroy(flagholdertext);
	TextDrawDestroy(flagholdertext2);
	return 1;
}

forward DelayTeamSwitch(playerid);
public DelayTeamSwitch(playerid)
{
	SpawnPlayer(playerid);
}
//==============================================================================
/*
public SpawnCounter(playerid)
{
    Count[playerid] --;
    if (Count[playerid] > 0) {
    new tmp[256];
    format(tmp, sizeof tmp, "~w~~n~~n~~n~~n~~n~~n~~n~~n~Spawn in : %s", TimeConvert(Count[playerid]));
	GameTextForPlayer(playerid,tmp,1000,3);
	}
	if (Count[playerid] < 0.1) KillTimer(Counter[playerid] );
}

TimeConvert(seconds) {
	new tmp[256];
 	new minutes = floatround(seconds/60);
	seconds -= minutes*60;
	format(tmp, sizeof(tmp), "%02d", seconds);
	return tmp;
}


public OnDeathSpecOff(playerid)
{
	TogglePlayerSpectating(playerid, 0);
	SpawnPlayer(playerid);
}
*/
//==============================================================================

stock LoadHay()
{
	FirstHayOb = CreateObject(3374, -1212.91, -1168.08, 129.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1208.91, -1168.08, 132.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1204.91, -1168.08, 135.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1200.91, -1168.08, 138.21, 0.00, 0.00, 0.00); //hay cube    going up
	CreateObject(3374, -1196.91, -1168.08, 141.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1192.91, -1168.08, 144.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1188.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube

	CreateObject(3374, -1184.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1180.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1176.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1172.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1168.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube   going along
	CreateObject(3374, -1164.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1160.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube

	CreateObject(3374, -1156.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1152.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube   going along a bit higher below the next lot
	CreateObject(3374, -1148.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1144.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube

	CreateObject(3374, -1156.91, -1168.08, 150.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1152.91, -1168.08, 150.21, 0.00, 0.00, 0.00); //hay cube   going along a bit higher
	CreateObject(3374, -1148.91, -1168.08, 150.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1144.91, -1168.08, 150.21, 0.00, 0.00, 0.00); //hay cube

	CreateObject(3374, -1140.91, -1168.08, 147.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1136.91, -1168.08, 144.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1132.91, -1168.08, 141.21, 0.00, 0.00, 0.00); //hay cube   going down
	CreateObject(3374, -1128.91, -1168.08, 138.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1124.91, -1168.08, 135.21, 0.00, 0.00, 0.00); //hay cube
	CreateObject(3374, -1120.91, -1168.08, 132.21, 0.00, 0.00, 0.00); //hay cube
	LastHayOb = CreateObject(3374, -1116.91, -1168.08, 129.21, 0.00, 0.00, 0.00); //hay cube
}

stock DeleteHay()
{
	for(new i=FirstHayOb; i<LastHayOb; i++) DestroyObject(i);
}

public HayUpdate()
{
	DeleteHay();
	LoadHay();
}

//==============================================================================

public Msg() {
	switch(CurrentMsg) {
		case 1: { 	SendClientMessageToAll(COLOR_WHITE, "TIP: Type /help to find out the aim of the game");
					return CurrentMsg++;    }
		case 2: {	SendClientMessageToAll(COLOR_WHITE, "INFO: Anti Team killing is enabled");
					return CurrentMsg++;	}
		 case 3: {	SendClientMessageToAll(COLOR_WHITE, "We are looking for good ideas. Type /idea to tell us");
					return CurrentMsg++;    }
		 case 4: {	SendClientMessageToAll(COLOR_WHITE, "WARNING: Cheats not allowed! Type /rules for more info. Type /report to report a player");
					return CurrentMsg++;    }
		 case 5: {	SendClientMessageToAll(COLOR_WHITE, "Type /stunt to take a break from capture the flag.");
					return CurrentMsg++;    }
		 case 6: {	SendClientMessageToAll(COLOR_WHITE, "WARNING: Spawn killing is not allowed! Type /rules for more info");
					return CurrentMsg++;    }
		 case 7: {	SendClientMessageToAll(COLOR_WHITE, "TIP: There are hidden pickups all over the map, can you find them?");
					return CurrentMsg++;    }
		 case 8: {	SendClientMessageToAll(COLOR_WHITE, "INFO: The more kills you get the more armour you spawn with.");
					return CurrentMsg++;   }
		 case 9: {	SendClientMessageToAll(COLOR_WHITE, "TIP: You can pass the flag by typing /passflag");
					return CurrentMsg++;    }
		 case 10: {	new msgstr[256]; format(msgstr,sizeof(msgstr),"INFO: Red Team needs %d more captures to win",ScoreToWin - redscore);
					SendClientMessageToAll(COLOR_WHITE, msgstr);
					return CurrentMsg++;    }
		 case 11: { new msgstr[256]; format(msgstr,sizeof(msgstr),"INFO: Blue Team needs %d more captures to win",ScoreToWin - bluescore);
					SendClientMessageToAll(COLOR_WHITE, msgstr);
					return CurrentMsg++;    }
		 case 12: {	SendClientMessageToAll(COLOR_WHITE, "TIP: Registered players can save their stats. Type /stats to view yours");
            		return CurrentMsg++;   }
	     case 13: {	SendClientMessageToAll(COLOR_WHITE, "TIP: This is a team game. Type ; for team chat");
					return 	CurrentMsg = 1;     }
	}
	return 1;
}
//=================================================================================================================================
strtok(const string[], &index)
{
	new length = strlen(string);
	while ((index < length) && (string[index] <= ' '))
	{
		index++;
	}

	new offset = index;
	new result[20];
	while ((index < length) && (string[index] > ' ') && ((index - offset) < (sizeof(result) - 1)))
	{
		result[index - offset] = string[index];
		index++;
	}
	result[index - offset] = EOS;
	return result;
}
//==============================================================================
public Copyleft(playerid)
{
SendClientMessage(playerid, 0x33AA33AA, "Mode Provided by www.samp-rus.com (   samp-rus.com)");
return 1;
}
