// Simple script functions.   ,      pawn-
// : 16.12.2012 12:34
#if defined _easyfuncs_included
	#endinput
#endif
#define _easyfuncs_included
#define MAX_POINTS ( 100 ) //  
#define vehEngine_on ( 1 )
#define vehEngine_off ( 0 )
#define vehEngine_not_use ( -1 )
#define vehLights_on ( 1 )
#define vehLights_off ( 0 )
#define vehLights_not_use ( -1 )
#define vehAlarm_on ( 1 )
#define vehAlarm_off ( 0 )
#define vehAlarm_not_use ( -1 )
#define vehDoors_on ( 1 )
#define vehDoors_off ( 0 )
#define vehDoors_not_use ( -1 )
#define vehBonnet_on ( 1 )
#define vehBonnet_off ( 0 )
#define vehBonnet_not_use ( -1 )
#define vehBoot_on ( 1 )
#define vehBoot_off ( 0 )
#define vehBoot_not_use ( -1 )
#define vehObjective_on ( 1 )
#define vehObjective_off ( 0 )
#define vehObjective_not_use ( -1 )
forward onPlayerTarget( playerid, targetid );

static VehNames[][] = {"Landstalker","Bravura","Buffalo","Linerunner","Pereniel","Sentinel","Dumper","Firetruck","Trashmaster","Stretch","Manana","Infernus","Voodoo",
"Pony","Mule","Cheetah","Ambulance","Leviathan","Moonbeam","Esperanto","Taxi","Washington","Bobcat","Mr Whoopee","BF Injection","Hunter","Premier","Enforcer","Securicar",
"Banshee","Predator","Bus","Rhino","Barracks","Hotknife","Trailer","Previon","Coach","Cabbie","Stallion","Rumpo","RC Bandit","Romero","Packer","Monster Truck","Admiral",
"Squalo","Seasparrow","Pizzaboy","Tram","Trailer","Turismo","Speeder","Reefer","Tropic","Flatbed","Yankee","Caddy","Solair","Berkley's RC Van","Skimmer","PCJ-600","Faggio",
"Freeway","RC Baron","RC Raider","Glendale","Oceanic","Sanchez","Sparrow","Patriot","Quad","Coastguard","Dinghy","Hermes","Sabre","Rustler","ZR-350","Walton","Regina","Comet",
"BMX","Burrito","Camper","Marquis","Baggage","Dozer","Maverick","News Chopper","Rancher","FBI Rancher","Virgo","Greenwood","Jetmax","Hotring","Sandking","Blista Compact","Police Maverick",
"Boxville","Benson","Mesa","RC Goblin","Hotring Racer", "Hotring Racer","Bloodring Banger","Rancher","Super GT","Elegant","Journey","Bike","Mountain Bike","Beagle","Cropdust",
"Stunt","Tanker","RoadTrain","Nebula","Majestic","Buccaneer","Shamal","Hydra","FCR-900","NRG-500","HPV1000","Cement Truck","Tow Truck","Fortune","Cadrona","FBI Truck","Willard",
"Forklift","Tractor","Combine","Feltzer","Remington","Slamvan","Blade","Freight","Streak","Vortex","Vincent","Bullet","Clover","Sadler","Firetruck","Hustler","Intruder","Primo",
"Cargobob","Tampa","Sunrise","Merit","Utility","Nevada","Yosemite","Windsor","Monster Truck","Monster Truck","Uranus","Jester","Sultan","Stratum","Elegy","Raindance",
"RC Tiger","Flash","Tahoma","Savanna","Bandito","Freight","Trailer","Kart","Mower","Duneride","Sweeper","Broadway","Tornado","AT-400","DFT-30","Huntley","Stafford","BF-400",
"Newsvan","Tug","Trailer","Emperor","Wayfarer","Euros","Hotdog","Club","Trailer","Trailer","Andromada","Dodo","RC Cam","Launch","Police (LSPD)","Police (SFPD)","Police (LVPD)",
"Police Ranger","Picador","S.W.A.T. Van","Alpha","Phoenix","Glendale","Sadler","Luggage Trailer","Luggage Trailer","Stair Trailer","Boxville","Farm Plow","Utility Trailer"};
enum
{
	NOT_USE,
	USE
}

enum tpinfo
{
	tppickup,
	bool:tpstatus,
	Float:tpx,
	Float:tpy,
	Float:tpz,
	Float:tpFacingAngle,
	tpinterior,
	tpvirtual,
	bool:tpisvehicle
}new teleportPoints[ MAX_POINTS ][ tpinfo ];
enum skill
{
	PISTOL,			
	PISTOL_SILENCED,		
	DESERT_EAGLE,		
	SHOTGUN,				
	SAWNOFF_SHOTGUN,		
	SPAS12_SHOTGUN,		
	MICRO_UZI,			
	MP5,					
	AK47,				
	M4,					
	SNIPERRIFLE			
};
static 
		PlayerSkill[ MAX_PLAYERS ][ skill ],
		Text3D:label[ MAX_PLAYERS ],
		textLable[ MAX_PLAYERS ],
		plDialog[ MAX_PLAYERS ],
		Text3D:vlabel[ MAX_PLAYERS ],
		vtextLable[ MAX_PLAYERS ],
		admincolor,
		bool:serverLocked,
		e_vint[ MAX_VEHICLES ],
		bool:rpnames,
		maxID;
	
/*

	:
		setPlayerSkillLevel(playerid,types,skil) -    . 
	:
		playerid - ID ,     .
		types -  (    FS ).
		skill -     
	    .
	
*/
stock setPlayerSkillLevel( playerid, types, skil )
{
	SetPlayerSkillLevel( playerid, types, skil );
	switch( types )
	{
		case 0:PlayerSkill[ playerid ][ PISTOL ] = skil;
		case 1:PlayerSkill[ playerid ][ PISTOL_SILENCED ] = skil;
		case 2:PlayerSkill[ playerid ][ DESERT_EAGLE ] = skil;
		case 3:PlayerSkill[ playerid ][ SHOTGUN ] = skil;
		case 4:PlayerSkill[ playerid ][ SAWNOFF_SHOTGUN ] = skil;
		case 5:PlayerSkill[ playerid ][ SPAS12_SHOTGUN ] = skil;
		case 6:PlayerSkill[ playerid ][ MICRO_UZI ] = skil;
		case 7:PlayerSkill[ playerid ][ MP5 ] = skil;
		case 8:PlayerSkill[ playerid ][ AK47 ] = skil;
		case 9:PlayerSkill[ playerid ][ M4 ] = skil;
		case 10:PlayerSkill[ playerid ][ SNIPERRIFLE ] = skil;
	}
	return 999;
}

/*

	:
		setPlayerSkillLevelToAll(types,skil) -      .
	:
		types -  (    FS ).
		skill -     
	    .
	
*/

stock setPlayerSkillLevelToAll( types, skil )
{
	for( new i = GetMaxPlayers(); i >= 0; --i )
		if( IsPlayerConnected( i ) )
			setPlayerSkillLevel( i, types, skil );
	return 1;
}
/*

	:
		getPlayerSkillLevel(playerid,types) -       
	:
		playerid - ID ,     .
		types -  (    FS ).
	     ( ).

*/

stock getPlayerSkillLevel( playerid, types )
{
	switch( types )
	{
		case 0: 	return PlayerSkill[ playerid ][ PISTOL ];
		case 1: 	return PlayerSkill[ playerid ][ PISTOL_SILENCED ];
		case 2: 	return PlayerSkill[ playerid ][ DESERT_EAGLE ];
		case 3: 	return PlayerSkill[ playerid ][ SHOTGUN ];
		case 4: 	return PlayerSkill[ playerid ][ SAWNOFF_SHOTGUN ];
		case 5:		return PlayerSkill[ playerid ][ SPAS12_SHOTGUN ];
		case 6: 	return PlayerSkill[ playerid ][ MICRO_UZI ];
		case 7: 	return PlayerSkill[ playerid ][ MP5 ];
		case 8: 	return PlayerSkill[ playerid ][ AK47 ];
		case 9: 	return PlayerSkill[ playerid ][ M4 ];
		case 10:	return PlayerSkill[ playerid ][ SNIPERRIFLE ];
		default:	return 0;
	}
	return 0;
}

/*

	:
		LockServer(bool:param) -  
	:
		bool:param - \  (true\false)

	    

*/

stock LockServer( bool:param )
{
	serverLocked = param;
	return 1;
}

/*

	:
		getGameModeText() -    .
	    .

*/

stock getGameModeText()
{
	new str[ 64 ]; 
	GetServerVarAsString( "gamemodetext", str, sizeof( str ) ); 
	return str;
}

/*

	:
		getNumPlayersOnline() -   ,   
	    .

*/

stock getNumPlayersOnline()
{
	new 
		kolvo;
	for( new i = GetMaxPlayers(); i >= 0; --i )
	{
		if( IsPlayerConnected( i ) && !IsPlayerNPC( i ) )kolvo++;
	}
	return kolvo;
}

/*

	:
		getGravity() -     
	    .

*/

stock getGravity()
{
	new 
		str[ 64 ]; 
	GetServerVarAsString( "gravity", str, sizeof( str ) ); 
	return str; 
}

/*

	:
		getServerWeather() -  ID ,      .
	    .

*/

stock getServerWeather()
	return GetServerVarAsInt( "weather" ); 

/*

	:
		getPlayerName(playerid) -   
	:
		playerid - ID ,     
	   .

*/

stock getPlayerName( playerid )
{
	new 
		pname[ MAX_PLAYER_NAME ];
	GetPlayerName( playerid, pname, sizeof( pname ) );
	return pname;
}

/*

	:
		Float:getPlayerHealth(playerid) -      
	:
		playerid - ID ,      
	     .

*/

stock Float:getPlayerHealth( playerid )
{
	new 
		Float:phealth;
	GetPlayerHealth( playerid, phealth );
	return phealth;
}

/*

	:
		givePlayerHealth(playerid,Float:health) -    
	:
		playerid - ID ,    
		Float:health -  
	    .

*/

stock givePlayerHealth( playerid, Float:health )
{
	new 
		Float:phealth;
	GetPlayerHealth( playerid, phealth );
	if( phealth + health >= 100) return SetPlayerHealth( playerid, 100 );
	SetPlayerHealth(playerid, phealth + health );
	return 1;
}

/*
	:
		Float:getPlayerArmour(playerid) -     
	:
		playerid - ID 
	      (Float)

*/

stock Float:getPlayerArmour( playerid )
{
	new 
		Float:armour;
	GetPlayerArmour( playerid, armour );
	return armour;
}

/*

	:
		givePlayerArmour(playerid,Float:armour)-     ,       100,   .
	:
		playerid - ID 
		Float:armour -  
	    .

*/

stock givePlayerArmour( playerid, Float:armour )
{
	new Float:parmour;
	GetPlayerArmour( playerid, parmour );
	if( parmour + armour >= 100 )return SetPlayerArmour( playerid, 100.0 );
	SetPlayerArmour( playerid,parmour + armour );
	return 1;
}

/*

	:
		getPlayerIP(playerid) -  IP- 
	:
		playerid - ID ,     IP-
	  IP- 

*/

stock getPlayerIP( playerid )
{
	new 
		pIP[ 16 ];
	GetPlayerIp( playerid, pIP, sizeof( pIP ) );
	return pIP;
}

/*
	:
		getPlayerID(name[]) -  ID   .
	:
		name[] - (!) 
	  ID  ,  INVALID_PLAYER_ID.
	
*/

stock getPlayerID( name[] )
{
	new
		pname[ MAX_PLAYER_NAME ];
	for( new i = GetMaxPlayers() ; i >= 0; --i )
	{
		if( IsPlayerConnected( i ) )
		{
			GetPlayerName( i, pname, sizeof( pname ) );
			if( !strcmp( name, pname, true) ) return i;
		}
	}
	return INVALID_PLAYER_ID;
}

/*
	:
		bool:isAdminsOnline() -    -  rcon  
	 true  , false  .
	
*/

stock bool:isAdminsOnline()
{
	for( new i = GetMaxPlayers(); i >= 0; --i )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) ) return true;
	return false;
}

/*
	:
		sendMessageToAdmins( color, msg[] ) -   RCON-
	:
		 color -  
		 msg[] - 
	    
	
*/

stock bool:sendMessageToAdmins( color, msg[] )
{
	for( new i = GetMaxPlayers(); i >= 0; --i )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) )
			SendClientMessage( i, color, msg );
	return true;
}

/*

	:
		clearChatToPlayer(playerid) -     
	:
		playerid - ID 
	    .

*/

stock bool:clearChatToPlayer( playerid )
{
	for( new i = 0; i < 20; i++ ) 
		SendClientMessage( playerid, 0xffffff, " " );
	return true;
}

/*

	:
		clearChatToAll() -     ,   
	 .
	    .

*/

stock bool:clearChatToAll()
{
	for( new i = 0; i < 20; i++ )
		SendClientMessageToAll( 0xfffffff," " );
	return true;
}

/*
	
	:
		sendPersonalMessage(playerid,targetid,color,string[]) -      . 
	:
		playerid - ID  
		targetid - ID  
		color -  
		string[] -  (   ! ..   )
	    .

*/

stock bool:sendPersonalMessage( playerid, targetid, color,string[] )
{
	if( IsPlayerConnected( playerid ) && IsPlayerConnected( targetid ) )
	{
		new 
			str[ 128 ];
		format( str, sizeof( str ), "*PM-sent to:%s(ID:%i): %s", getPlayerName( targetid ), targetid, string );
		SendClientMessage( playerid, color, str );
		format( str, sizeof( str ), "*PM-received from:%s(ID:%i): %s", getPlayerName( playerid ), playerid, string );
		SendClientMessage( targetid, color, str );
		return true;
	}
	return false;
}

/*

	:
		getPlayerInfo(playerid,&Float:x,&Float:y,&Float:z,&Float:FacingAngle,&Float:health,&Float:armour,&pstate,&interior,&virtual,&skin,&team,&ping,&color)     
	:
		playerid - ID 
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:FacingAngle -   
		Float:health - 
		Float:armour - 
		interior - ID 
		virtual - ID  
		skin - ID 
		team - ID 
		ping -  
		color-  
	   .

*/

stock getPlayerInfo( playerid, &Float:x, &Float:y, &Float:z, &Float:FacingAngle, &Float:health, &Float:armour, &pstate, &interior, &virtual, &skin, &team, &ping, &color )
{
	if( IsPlayerConnected( playerid ) )
	{
		GetPlayerPos( playerid, x, y, z );
		GetPlayerFacingAngle( playerid, FacingAngle );
		GetPlayerHealth( playerid, health );
		GetPlayerArmour( playerid, armour );
		pstate = GetPlayerState( playerid );
		interior = GetPlayerInterior( playerid );
		virtual = GetPlayerVirtualWorld( playerid );
		skin = GetPlayerSkin( playerid );
		team = GetPlayerTeam( playerid );
		ping = GetPlayerPing( playerid );
		color = GetPlayerColor( playerid );
		return 1;
	}
	return INVALID_PLAYER_ID;
}

/*

	:
		setPlayerColorForAll(color) -      
	:
		color - (Hex)
	    .

*/

stock setPlayerColorForAll( color )
{
	for( new i = GetMaxPlayers(); i >= 0; --i )
		if( IsPlayerConnected( i ) )
			SetPlayerColor( i, color );
	return 1;
}

/*

	:
		setAdminsColor(color) -         (  RCON-  ) RCON-
	:
		color - (Hex)
	    .

*/

stock setAdminsColor( color )
{
	admincolor = color;
	for( new i =GetMaxPlayers(); i>= 0; --i )
		if( IsPlayerConnected( i ) && IsPlayerAdmin( i ) )SetPlayerColor( i, color );
	return color;
}

/*

	:
		createPlayer3DtextLableEx(playerid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0) - ,   
	:
		playerid - ID ,     
		text[] - (Text 3D)
		color -  
		Float:x -  
		Float:y -  Y
		Float:z -  Z 
		Float:DrawDistance -  
		virtual -  
		testLOS -     .
	    .        .
	
*/

stock bool:createPlayer3DtextLableEx( playerid, text[], color, Float:x = 0.0, Float:y = 0.0, Float:z = 0.7, Float:DrawDistance = 100.0, virtual = 0, testLOS = 0 )
{
	if( !IsPlayerConnected( playerid ) && textLable[ playerid ] == USE )return 0;
	label[ playerid ] = Create3DTextLabel( text, color, 0.0, 0.0, 0.0, DrawDistance, virtual, testLOS );
	Attach3DTextLabelToPlayer( label[ playerid ], playerid, x, y, z );
	textLable[ playerid ] = USE;
	return true;
}

/*

	:
		deletePlayer3DtextLableEx(playerid) -     .
	:
		playerid - ID 
	    .

*/

stock bool:deletePlayer3DtextLableEx( const playerid )
{
	if( !IsPlayerConnected( playerid ) && textLable[ playerid ] == NOT_USE )return 0;
	Delete3DTextLabel( label[ playerid ] );
	textLable[ playerid ] = NOT_USE;
	return true;
}

/*

	:
		updatePlayer3DtextLableEx(playerid,color,text[]) -     
	:
		playerid - ID 
		color -  
		text[] - 
	    .

*/

stock bool:updatePlayer3DtextLableEx( playerid, color, text[] )
{
	if( !IsPlayerConnected( playerid ) && textLable[ playerid ] == NOT_USE )return 0;
	Update3DTextLabelText( label[ playerid ], color, text );
	return true;
}

/*
	
	:
		getWeaponSlot(weaponid) -      ID .
	:
		weaponid - ID (0-50)
	  ID .
	
*/

stock getWeaponSlot( weaponid )
{
	switch( weaponid )
	{
		case 0,1:return 0;
		case 2..9: return 1;
		case 22,23,24:return 2;
		case 25,26,27:return 3;
		case 28,29,32:return 4;
		case 30,31:return 5;
		case 33,34:return 6;
		case 35,36,37,38:return 7;
		case 16,17,18,39:return 8;
		case 41,42,43:return 9;
		case 10..15:return 10;
		case 44,45,46:return 11;
		default:return 12;
	}
	return 12;
}

/*

	:
		givePlayerMoneyToPlayer( playerid, targetid, amount ) -    .
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
	    .

*/

stock bool:givePlayerMoneyToPlayer( const playerid, const targetid, const amount )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	if( GetPlayerMoney( playerid ) < amount ) return false;
	GivePlayerMoney( playerid, -amount );
	GivePlayerMoney( targetid, amount );
	return true;
}

/*

	:
		givePlayerMoneyToPlayerEx( playerid, targetid, amount, Float: range ) -   ,      
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
		Float: range -   .
	    .

*/

stock bool:givePlayerMoneyToPlayerEx( const playerid, const targetid, const amount, Float: range )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	if( GetPlayerMoney( playerid ) < amount ) return false;
	new 
		Float:pos[ 3 ];
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	if( !IsPlayerInRangeOfPoint( playerid, range, pos[ 0 ], pos[ 1 ], pos[ 2 ] ) ) return false;
	GivePlayerMoney( playerid, -amount );
	GivePlayerMoney( targetid, amount );
	return true;
}

/*

	:
		givePlayerHealthToPlayer( playerid, targetid, Float: amount ) -    
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
	    .

*/

stock bool:givePlayerHealthToPlayer( const playerid, const targetid, Float: amount )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: health;
	GetPlayerHealth( playerid, health );
	if( health < amount ) return false;
	givePlayerHealth( playerid, -amount );
	givePlayerHealth( targetid, amount );
	return true;
}

/*

	:
		givePlayerHealthToPlayerEx( playerid, targetid, Float: amount, Float: range ) -   ,      
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
		Float: range -   .
	    .

*/

stock bool:givePlayerHealthToPlayerEx( const playerid, const targetid, Float: amount, Float: range )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: health,
		Float:pos[ 3 ];
	GetPlayerHealth( playerid, health );
	if( health < amount ) return false;
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	if( !IsPlayerInRangeOfPoint( playerid, range, pos[ 0 ], pos[ 1 ], pos[ 2 ] ) ) return false;
	givePlayerHealth( playerid, -amount );
	givePlayerHealth( targetid, amount );
	return true;
}

/*

	:
		givePlayerArmourToPlayer( const playerid, const targetid, Float: amount ) -    
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
	    .

*/

stock bool:givePlayerArmourToPlayer( const playerid, const targetid, Float: amount )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: armour;
	GetPlayerHealth( playerid, armour );
	if( armour < amount ) return false;
	givePlayerArmour( playerid, -amount );
	givePlayerArmour( targetid, amount );
	return true;
}

/*

	:
		givePlayerArmourToPlayerEx( playerid, targetid, Float: amount, Float: range ) -   ,      
	:
		playerid - ID ,   
		targetid - ID ,   
		amount -  
		Float: range -   .
	    .

*/

stock bool:givePlayerArmourToPlayerEx( const playerid, const targetid, Float: amount, Float: range )
{
	if( !IsPlayerConnected( targetid ) || !IsPlayerConnected( playerid ) )return false;
	new 
		Float: armour,
		Float:pos[ 3 ];
	GetPlayerHealth( playerid, armour );
	if( armour < amount ) return false;
	GetPlayerPos( targetid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
	if( !IsPlayerInRangeOfPoint( playerid, range, pos[ 0 ], pos[ 1 ], pos[ 2 ] ) ) return false;
	givePlayerArmour( playerid, -amount );
	givePlayerArmour( targetid, amount );
	return true;
}

/*

	:
		setPlayerPosEx(playerid,Float:x,Float:y,Float:z,Float:FacingAngle,interior=0,virtual=0) -       .
	:
		playerid - ID ,      
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:FacingAngle -   
		interior - ID (  )
		virtual - ID  (  )
	    

*/

stock bool:setPlayerPosEx( playerid, Float:x, Float:y, Float:z, Float:FacingAngle, interior = 0, virtual = 0 )
{
	SetPlayerPos( playerid, x, y, z);
	SetPlayerFacingAngle( playerid, FacingAngle );
	SetPlayerInterior( playerid, interior );
	SetPlayerVirtualWorld( playerid, virtual );
	return true;
}

/*

	:
		getPlayerPosEx(playerid,&Float:x,&Float:y,&Float:z,&Float:FacingAngle,&interior,&virtual) -      ,  ,   
	
		playerid - ID 
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:FacingAngle -   
		interior - ID 
		virtual - ID  
	      , ID   ID  ,     .

*/

stock bool:getPlayerPosEx( playerid, &Float:x, &Float:y, &Float:z, &Float:FacingAngle, &interior, &virtual )
{
	GetPlayerPos( playerid, x, y, z );
	GetPlayerFacingAngle( playerid, FacingAngle );
	interior=GetPlayerInterior( playerid );
	virtual=GetPlayerVirtualWorld( playerid );
	return true;
}

/*

	:
		isPickupWeaponModel(modelid) -   ,      .
	:
		modelid -  
	  1(true)  ,  0(false)  .

*/

stock bool:isPickupWeaponModel( const modelid )
	return ( modelid > 320 && modelid < 372 ) ? ( true ) : ( false );

/*

	:
		getWeaponName(weaponid) -     
	:
		weaponid - ID (0-50)
	      

*/

stock getWeaponName( weaponid )
{
	new 
		weanr[ 50 ];
	switch ( weaponid ) 
	{
		case 0: weanr = "";
		case 1: weanr = "";
		case 2: weanr = " ";
		case 3: weanr = " ";
		case 4: weanr = "";
		case 5: weanr = " ";
		case 6: weanr = "";
		case 7: weanr = " ";
		case 8: weanr = "";
		case 9: weanr = "";
		case 10: weanr = "";
		case 11: weanr = "";
		case 12: weanr = "";
		case 13: weanr = "";
		case 14: weanr = " ";
		case 15: weanr = "";
		case 16: weanr = "";
		case 17: weanr = " ";
		case 18: weanr = " ";
		case 19: weanr = "";
		case 20: weanr = "";
		case 21: weanr = "";
		case 22: weanr = "";
		case 23: weanr = "  ";
		case 24: weanr = " ";
		case 25: weanr = "";
		case 26: weanr = "";
		case 27: weanr = " ";
		case 28: weanr = " 10";
		case 29: weanr = "5";
		case 30: weanr = "";
		case 31: weanr = "4";
		case 32: weanr = "9";
		case 33: weanr = " ";
		case 34: weanr = " ";
		case 35: weanr = "";
		case 36: weanr = " ";
		case 37: weanr = "";
		case 38: weanr = "";
		case 39: weanr = "";
		case 40: weanr = "";
		case 41: weanr = "";
		case 42: weanr = "";
		case 43: weanr = "";
		case 44: weanr = "";
		case 45: weanr = "";
		case 46: weanr = "";
		case 47: weanr = "";
		case 48: weanr = "";
		case 49: weanr = "";
		case 50: weanr = " ";
		default:weanr = "Unknown";
	}
	return weanr;
}

/*

	:
		getFileInfo(filename[],&lines,&bytes) -     .
	:
		filename[] -  
		lines -     
		bytes -    ( )
	     

*/

stock bool:getFileInfo( filename[], &lines, &bytes )
{
	new 
		count,
		File:file,
		idx[ 100 ];
	if( ( file = fopen( filename, io_read ) ) )
	{
		while( fread( file, idx ) )count++;
		fclose( file );
		lines = count;
		bytes = flength( file );
		return true;
	}
	return false;
}

/*

	:
		setVehicleInterior(vehicleid,interior) -    
	:
		vehicleid - ID 
		interior - ID 
	    

*/

stock bool:setVehicleInterior( const vehicleid, const interior )
{
	e_vint[ vehicleid ] = interior;
	LinkVehicleToInterior( vehicleid, e_vint[ vehicleid ] );
	return true;
}

/*

	:
		getVehicleInterior(vehicleid) -      
	:
		vehicleid - ID 
	  ID .

*/

stock getVehicleInterior( vehicleid )return e_vint[ vehicleid ];

/*

	:
		setVehiclePosEx(vehicleid,Float:x,Float:y,Float:z,Float:RotateAngle,interior=0,virtual=0) -   ,   
	:
		vehicleid - ID 
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:RotateAngle -   
		interior - ID 
		virtual - ID  
	    .

*/

stock bool:setVehiclePosEx( vehicleid, Float:x, Float:y, Float:z, Float:RotateAngle, interior = 0, virtual = 0 )
{
	SetVehiclePos( vehicleid, x, y, z );
	SetVehicleZAngle( vehicleid, RotateAngle );
	SetVehicleInterior( vehicleid, interior );
	SetVehicleVirtualWorld( vehicleid, virtual );
	return true;
}

/*

	:
		getVehicleInfo(vehicleid,&Float:x,&Float:y,&Float:z,&Float:RotateAngle,&Float:health,&interior,&virtual,&model) -    
	:
		vehicleid - ID 
		Float:x -  
		Float:y -  Y
		Float:z -  Z
		Float:RotateAngle -  
		Float:health - 
		interior - ID 
		virtual - ID  
		model-  
	     .

*/

stock bool:getVehicleInfo( vehicleid, &Float:x, &Float:y, &Float:z, &Float:RotateAngle, &Float:health, &interior, &virtual, &model )
{
	if( vehicleid == INVALID_VEHICLE_ID ) return 0;
	GetVehiclePos( vehicleid, x ,y, z );
	GetVehicleZAngle( vehicleid, RotateAngle );
	GetVehicleHealth( vehicleid, health );
	interior = getVehicleInterior( vehicleid );
	virtual = GetVehicleVirtualWorld( vehicleid );
	model = GetVehicleModel( vehicleid );
	return true;
}

/*

	:
		turnCarEngine(vehicleid, status) - \  
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock bool:turnCarEngine( vehicleid, status )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
   	GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, status, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return true;
}

/*

	:
		isCarEngineRunned(vehicleid) -    .
	:
		vehicleid - ID 
	  : 1 -  0 

*/

stock isCarEngineRunned( vehicleid )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( eengine == VEHICLE_PARAMS_ON) ? true : false;
}

/*

	:
		turnCarLights(vehicleid, status) - \ 
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock turnCarLights( vehicleid, status )
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, status, ealarm, edoors, ebonnet, eboot, eobjective );
	return 1;
}

/*

	:
		isCarLightsOn(vehicleid) -     
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock isCarLightsOn( vehicleid )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( elights == VEHICLE_PARAMS_ON ) ? true: false;
}

/*

	:
	turnCarAlarm(vehicleid, status) - \   
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock turnCarAlarm( vehicleid, status )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	SetVehicleParamsEx( vehicleid, eengine, elights, status, edoors, ebonnet, eboot, eobjective );
	return 1;
}

/*

	:
		isCarAlarmActive(vehicleid) -   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock isCarAlarmActive( vehicleid )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( ealarm==VEHICLE_PARAMS_ON )? true : false;
}

/*

	:
		turnCarDoors(vehicleid, status) - \   
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock turnCarDoors( vehicleid, status )
{
	if(v ehicleid==INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, status, ebonnet, eboot, eobjective );
	return 1;
}

/*

	:
		isCarDoorsOpen(vehicleid) -   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock isCarDoorsOpen( vehicleid )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( edoors == VEHICLE_PARAMS_ON ) ? true : false;
}

/*

	:
		turnCarBonnet(vehicleid, status) - \  
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock turnCarBonnet( vehicleid, status )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, status, eboot, eobjective );
	return 1;
}

/*

	:
		isCarBonnetOpen(vehicleid) -   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock isCarBonnetOpen( vehicleid )
{
	if(vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return ( ebonnet == VEHICLE_PARAMS_ON) ? true : false;
}

/*

	:
		turnCarBoot(vehicleid, status) - \  
	:
		vehicleid - ID 
		status - \  (1\0)
	    .

*/

stock turnCarBoot( vehicleid, status )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
   	SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, status, eobjective );
	return 1;
}

/*

	:
		isCarBootOpen(vehicleid) -   
	:
		vehicleid - ID 
	   : (1),  (0)

*/

stock isCarBootOpen( vehicleid )
{
	if(vehicleid==INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( eboot== VEHICLE_PARAMS_ON ) ? true: false;
}

/*

	:
		turnCarObjective(vehicleid, status) -    
	:
		vehicleid - ID 
		status - \  \ \ (1\0)
	    .

*/

stock turnCarObjective( vehicleid, status )
{
	if( vehicleid == INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
    SetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, status );
	return 1;
}

/*

	:
		isCarObjective(vehicleid) -    
	:
		vehicleid - ID 
	   :  (1),   (0)

*/

stock isCarObjective( vehicleid )
{
	if( vehicleid==INVALID_VEHICLE_ID )return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx( vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective );
	return ( eboot == VEHICLE_PARAMS_ON ) ? true : false ;
}

/*

	:
		createVehicle3DtextLableEx(vehicleid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0) -    
	:
		vehicleid - ID ,     
		text[] - (Text 3D)
		color -  
		Float:x -  
		Float:y -  Y
		Float:z -  Z 
		Float:DrawDistance -  
		virtual -  
		testLOS -     .
	    .        .

*/

stock createVehicle3DtextLableEx( vehicleid, text[], color, Float:x=0.0, Float:y=0.0, Float:z=0.7, Float:DrawDistance=100.0, virtual=0, testLOS=0 )
{
	if( vehicleid == INVALID_VEHICLE_ID || vtextLable[ vehicleid ] == USE )return 0;
	vlabel[vehicleid]=Create3DTextLabel( text, color, 0.0, 0.0, 0.0, DrawDistance, virtual, testLOS );
	Attach3DTextLabelToVehicle( vlabel[ vehicleid ], vehicleid, x, y, z );
	vtextLable[ vehicleid ] = USE;
	return 1;
}

/*

	:
		deleteVehicle3DtextLableEx(vehicleid)  -     
	:
		playerid - ID 
	    .

*/

stock deleteVehicle3DtextLableEx( vehicleid )
{
	if( vehicleid == INVALID_VEHICLE_ID || vtextLable[ vehicleid ] == NOT_USE )return 0;
	Delete3DTextLabel( vlabel[ vehicleid ] );
	vtextLable[ vehicleid ] = NOT_USE;
	return 1;
}

/*

	:
		updateVehicle3DtextLableEx(vehicleid,color,text[]) -    
	:
		vehicleid - ID 
		color -  
		text[] - 
	    .

*/

stock updateVehicle3DtextLableEx( vehicleid, color, text[] )
{
	if( vtextLable[ vehicleid ] == NOT_USE )return 0;
	Update3DTextLabelText( vlabel[ vehicleid ], color, text );
	return 1;
}

/*

	:
		getVehicleName(vehicleid) -   .
	:
		vehicleid - ID 
	   .

*/

stock getVehicleName( vehicleid )
{
	new result[ 50 ],
		modelid;
	modelid = GetVehicleModel( vehicleid );
	strmid( result, VehNames[ modelid - 400 ], 0, strlen( VehNames[ modelid - 400 ] ), 255 );
	return result;
}

/*

	:
		randomEx(min,max) -       .
	:
		min -  ,   
		max -  ,   
	   ,   .

*/

stock randomEx( minarg, maxarg )
	return random( maxarg - minarg + 1 ) + minarg;

/*

	:
		createTeleportPoint(teleportid,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false) -   .
	:
		teleportid - ID  (  ! !       !)
		Float:x -    
		Float:y -  Y  
		Float:z -  Z  
		Float:newx -    
		Float:newy -  Y  
		Float:newz -  Z  
		Float:newFacingAngle -  
		interior - ID ( .  :0)
		virtual - ID  ( .  :0)
		bool:isvehicle -        (false)      (true)
	    .

*/

stock createTeleportPoint( e_ptp, Float:x, Float:y, Float:z, Float:newx, Float:newy, Float:newz, Float:newFacingAngle, interior=0, virtual=0, bool:isvehicle = false )
{
	if(teleportPoints[ e_ptp ][ tpstatus ] == false )
	{
		teleportPoints[ e_ptp ][ tpstatus ] = true;
		teleportPoints[ e_ptp ][ tpx ] = newx;
		teleportPoints[ e_ptp ][ tpy ] = newy;
		teleportPoints[ e_ptp ][ tpz ] = newz;
		teleportPoints[ e_ptp ][ tpFacingAngle ] = newFacingAngle;
		teleportPoints[ e_ptp ][ tpinterior ] = interior;
		teleportPoints[ e_ptp ][ tpvirtual ] = virtual;
		teleportPoints[ e_ptp ][ tpisvehicle ] = isvehicle;
		if( isvehicle == false )teleportPoints[ e_ptp ][ tppickup ] = CreatePickup( 1318, 2, x, y, z );
		if( isvehicle == true )teleportPoints[ e_ptp ][ tppickup ] = CreatePickup( 1318, 14, x, y, z );
		return e_ptp;
	}
	return 1;
}

/*

	:
		destroyTeleportPoint(tppointid) -   
	:
		teleportid - ID  
	    .

*/

stock destroyTeleportPoint( tppointid )
{
	if( teleportPoints[ tppointid ][ tpstatus ] == true )
	{
		DestroyPickup( teleportPoints[ tppointid ][ tppickup ] );
		teleportPoints[ tppointid ][ tpstatus ] = false;
		return 1;
	}
	return 0;
}

/*

	:
		isValidTeleportPoint(tppointid) -     .
	:
		teleportid - ID  
	  true    false   .

*/

stock bool:isValidTeleportPoint( tppointid )
	return teleportPoints[ tppointid ][ tpstatus ];

/*

	:
		updateTeleportPoint(e_ptp,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false) -    
	:
		teleportid - ID  (    ID,   (-1))
		Float:x -    
		Float:y -  Y  
		Float:z -  Z  
		Float:newx -    
		Float:newy -  Y  
		Float:newz -  Z  
		Float:newFacingAngle -  
		interior - ID ( .  :0)
		virtual - ID  ( .  :0)
		bool:isvehicle -        (false)      (true)
	    .

*/

stock updateTeleportPoint( e_ptp, Float:x, Float:y, Float:z, Float:newx, Float:newy, Float:newz, Float:newFacingAngle, interior=0, virtual=0, bool:isvehicle = false )
{
	if( teleportPoints[ e_ptp ][ tpstatus ] == true )
	{
		DestroyPickup( teleportPoints[ e_ptp ][ tppickup ] );
		teleportPoints[ e_ptp ][ tpx ] = newx;
		teleportPoints[ e_ptp ][ tpy ] = newy;
		teleportPoints[ e_ptp ][ tpz ] = newz;
		teleportPoints[ e_ptp ][ tpFacingAngle ] = newFacingAngle;
		teleportPoints[ e_ptp ][ tpinterior ] = interior;
		teleportPoints[ e_ptp ][ tpvirtual ] = virtual;
		teleportPoints[ e_ptp ][ tpisvehicle ] = isvehicle;
		if( isvehicle == false )teleportPoints[ e_ptp ][ tppickup ]=CreatePickup( 1318, 2, x, y, z );
		if(isvehicle == true )teleportPoints[ e_ptp ][ tppickup ] = CreatePickup( 1318, 14, x, y, z );
		return e_ptp;
	}
	return 1;
}

/*

	:
		setRPNamesOnly() -     Non-RP 
	   
	    .

*/

stock setRPNamesOnly()
{
	rpnames = true;
	return 1;
}

e_onPlayerPickup( playerid, pickupid )
{
	for( new i = 0; i < MAX_POINTS; i++ )
	{
		if( pickupid == teleportPoints[ i ][ tppickup ] )
		{
			if( teleportPoints[ i ][ tpstatus ] == true )
			{
				SetPlayerPos( playerid, teleportPoints[ i ][ tpx ], teleportPoints[ i ][ tpy ], teleportPoints[ i ][ tpz ] );
				SetPlayerFacingAngle(playerid,teleportPoints[i][tpFacingAngle]);
				SetPlayerInterior(playerid,teleportPoints[i][tpinterior]);
				SetPlayerVirtualWorld(playerid,teleportPoints[i][tpvirtual]);
				if( teleportPoints[ i ][ tpisvehicle ] == true )
				{
					if( IsPlayerInAnyVehicle( playerid ) )
					{
						new vehicleid = GetPlayerVehicleID( playerid );
						SetVehicleVirtualWorld( vehicleid, teleportPoints[ i ][ tpvirtual ] );
						setVehicleInterior( vehicleid, teleportPoints[ i ][ tpinterior ] );
						SetVehiclePos( vehicleid, teleportPoints[ i ][ tpx ], teleportPoints[ i ][ tpy ], teleportPoints[ i ][ tpz ] );
						SetVehicleZAngle( vehicleid, teleportPoints[ i ][ tpFacingAngle ] );
						PutPlayerInVehicle( playerid,vehicleid,0);
					}
				}
			}
		}
	}
}

/*

	:
		strcharsplit(const string[], &index, seperator=' ') -  strtok,   
	:
		const string[] -    
		&index -     
		seperator=' ' - .
	    seperator  seperator

*/

stock strcharsplit( const string[], &index, seperator=' ' )
{
	new result[ 20 ], 
		i = 0;
	if( index != 0 ) index++;
	while ( string[ index ] && string[ index ] != seperator )
	{
		result[ i++ ] = string[ index++ ];
	}
	return result;
}

/*

	:
		StopVehicle(vehicleid) -   
	:
		vehicleid - ID    .
	    .

*/

stock StopVehicle( vehicleid ) 
	return SetVehicleVelocity( vehicleid, 0.0, 0.0, 0.0 );

/*

	:
		GetVehicleSpeed(vehicleid) -   .
	:
		vehicleid - ID    .
	    .

*/

stock GetVehicleSpeed( vehicleid )
{ 
    new Float:Vx,
		Float:Vy,
		Float:Vz,
		Float:rtn; 
    GetVehicleVelocity( vehicleid, Vx, Vy, Vz ); 
    rtn = floatsqroot( Vx * Vx + Vy * Vy + Vz * Vz ); 
    return floatround( rtn * 100 ); 
}

/*

	:
		SetVehicleSpeed(vehicleid, Float:speed) -    .
	:
		vehicleid - ID .
		Float:speed -  .
	    .

*/

stock SetVehicleSpeed( vehicleid, Float: speed )
{ 
	new 
		Float: x1, 
		Float: y1, 
		Float: z1, 
		Float: x2, 
		Float: y2, 
		Float: z2, 
		Float: a; 
	GetVehicleVelocity( vehicleid, x1, y1, z1 ); 
	GetVehiclePos( vehicleid, x2, y2, z2 ); 
	GetVehicleZAngle( vehicleid, a ); 
	a = 360 - a; 
	x1 = ( floatsin( a, degrees ) * ( speed / 100 ) + floatcos( a, degrees ) * 0 + x2 ) - x2; 
	y1 = ( floatcos( a, degrees ) * ( speed/ 100 ) + floatsin( a, degrees ) * 0 + y2 ) - y2; 
	SetVehicleVelocity( vehicleid, x1, y1, z1 ); 
	return 1;
}

/*

	:
		givePlayerWeaponEx(playerid,{id}) -   .
	:
		playerid - ID ,    
		{id} -  ,  ,  .
	  Stepashka,  sk47
	    .

*/

stock givePlayerWeaponEx( ... )
{ 
	if ( numargs() % 2 == 0 ) return 0; 
	for ( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i + 1 ) && getarg( i ) ) 
		{ 
			GivePlayerWeapon( getarg( 0 ), getarg( i ), getarg(i + 1) ); 
			i++; 
		} 
	} 
	return 1; 
}

/*

	:
		addVehicleComponentEx(vehicleid, {id}) -    
	:
		vehicleid - ID ,    
		{id} -  ,     
	    .

*/

stock addVehicleComponentEx( ... )
{ 
	if ( numargs() % 2 == 0 ) return 0; 
	for ( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i ) ) 
			AddVehicleComponent( getarg( 0 ), getarg( i ) ); 
	} 
	return 1; 
}

/*
	
	:
		removeVehicleComponentEx(vehicleid, {id}) -     
	:
		vehicleid - ID ,    
		{id} -  ,     
	    .

*/

stock removeVehicleComponentEx( ... )
{ 
	if ( numargs() % 2 == 0 ) return 0; 
	for ( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i ) ) 
			RemoveVehicleComponent( getarg( 0 ), getarg( i ) ); 
	} 
	return 1; 
}

/*

	:
		GiveVehicleHealth( vehicleid, Float: amount ) -      
	:
		vehicleid - ID ,    
		Float: amount -   
	    .

*/

stock GiveVehicleHealth( vehicleid, Float: amount )
{
	new 
		Float:vhealth;
	GetVehicleHealth( vehicleid, vhealth );
	SetVehicleHealth( vehicleid, vhealth + amount );
	return 1;
}

/*

	:
		Float:floatRandom(Float:val) -        0  val
	:
		Float:val -  
	    float
	
*/

stock Float:floatRandom( Float:val ) 
	return float( random( floatround( val ) * 100 ) ) / 100;

/*

	:
		Float:floatRandomEx(Float:min,Float:max) -        min  max
	:
		Float:min -  
		Float:max -  
	    float  min  max
	
*/

stock Float:floatRandomEx( Float:min, Float:max )
{
	if( min > max ) return 0.0;
	new	
		maxval = floatround( max ) * 100,
		minval = floatround( min ) * 100,
		val;
	do
	{
		val = random( maxval );
	}
	while( val < minval );
	return float( val ) / 100;
}

/*

	:
		isEmail( string[] ) -      e-mail
	:
		string -  
	  true  string - e-mail  false  
*/

stock bool: isEmail( const string[] )
{
	if( strfind( string, "@", true, -1 ) == -1 ) return false;
	new 
		part[ 3 ][ 50 ],
		idx = 0;
	part[ 0 ] = strcharsplit( string, idx, '@' );
	part[ 1 ] = strcharsplit( string, idx, '.' );
	part[ 2 ] = strcharsplit( string, idx, '.' );
	if( strlen( part[ 0 ] ) < 3 ) return false;
	if( strlen( part[ 1 ] ) < 2 ) return false;
	if( strlen( part[ 2 ] ) < 2 ) return false;
	return true;
}

/*

	:
		abs( num ) -    num
	:
		num -   .

*/

stock abs( num )
	return num = ( num < 0 ) ? ( num * (-1) ) : ( num );

/*

	:
		preLoadAnim( const  playerid, animlib[] ) -      animlib.
	:
		playerid - ID     
		animlib -  .

*/

stock preLoadAnim( const  playerid, animlib[] )
	return	ApplyAnimation( playerid, animlib, "null", 0.0, 0, 0, 0, 0, 0 );

/*

	:
		SendFormatMessage(playerid,color,const format[],{Float,_}:...) -    
	:
		playerid - ID ,   
		color -  
		format[] - 
		{Float,_}:... - 
	    .

*/

#if !defined SendFormatMessage 
          new FALSE = false; 
          #pragma unused FALSE 
          #define SendFormatMessage(%0,%1,%2,%3) do{ new str[128]; format(str, 128, %2, %3); SendClientMessage(%0, %1, str); } while(FALSE) 
#endif

/*

	:
		SendFormatMessageToAll(color,const format[],{Float,_}:...) -       .
	:
		color -  
		format[] - 
		{Float,_}:... - 
	    .

*/

#if !defined SendFormatMessageToAll  
          #pragma unused FALSE 
          #define SendFormatMessageToAll(%0,%1,%2,%3) do{ new str[128]; format(str, 128, %2, %3); SendClientMessageToAll(%0, %1, str); } while(FALSE) 
#endif

/*

	:
		getLastPlayerID() -   ID  .   .( )

*/

#define getLastPlayerID() maxID

e_onPlayerConnect( playerid )
{
	maxID = ( maxID < playerid ) ? ( playerid ) : ( maxID );
	if( rpnames == true )
	{
		static colid,
			pname[ MAX_PLAYER_NAME ];
		GetPlayerName( playerid, pname, sizeof( pname ) );
		for( new i = 0; i < strlen( pname );i++ )
			if( !strfind( pname[ i ], "_", true ) )colid++;
		if( !colid || colid > 1 )
		{
			SendClientMessage( playerid, 0xff0000ff, "     \"_\"!" );
			printf( "%s was kicked. Reason: Not RP-nick", pname );
			Kick( playerid );
		}
	}
	if( serverLocked == true )SendClientMessage( playerid, 0xFFFFFFFF, "-> Server is {FF0000}Locked" ), Kick( playerid );
	if( admincolor != 0 && IsPlayerAdmin( playerid ) )SetPlayerColor( playerid, admincolor );
	SetTimerEx( "PlayerTarget", 1000, false, "i", playerid );
}

e_OnPlayerDisconnect( playerid )
{
    do maxID--;
    while( ( IsPlayerNPC( playerid ) || ( !IsPlayerConnected( maxID ) ) ) && ( maxID > 0 ) );
	return 1;
}

stock e_showPlayerDialog( playerid, dialogid, style, title[], text[], button1[], button2[] )
{
	ShowPlayerDialog( playerid, dialogid, style, title[], text[], button1[], button2[] );
	plDialog[ playerid ] = true;
	return 1;
}

/*

	:
		isDialogShowedForPlayer( playerid ) -       
	:
		playerid - ID  
	  tru  ,  false  .

*/

stock isDialogShowedForPlayer( playerid )
	return ( plDialog[ playerid ] == true ) ? ( 1 ) : ( 1 );

/*

	:
		hideDialog( playerid ) -       OnDialogResponse      
	:
		playerid - ID 
	    .

*/

stock hideDialog( playerid )
{
	plDialog[ playerid ] = false;
	return 1;
}

#define ShowPlayerDialog e_showPlayerDialog

forward PlayerTarget( playerid );

public PlayerTarget( playerid )
{
	if( IsPlayerConnected( playerid ) )
	{
		new 
			target = GetPlayerTargetPlayer( playerid );
		if( target != INVALID_PLAYER_ID ) CallRemoteFunction( "onPlayerTarget", "ii", playerid, target );
		SetTimerEx( "PlayerTarget", 1000, false, "i", playerid );
	}
	return 1;
}

/*

	:
		givePlayerMoneyToAll( amount ) -   
	:
		amount -  
	    .

*/

stock bool: givePlayerMoneyToAll( const playerid, const amount )
{
	for( new i = GetMaxPlayers(); i >= 0; i-- )
		if( IsPlayerConnected( i ) )
			GivePlayerMoney( i, amount );
	return false;
}

/*

	:
		givePlayerHealthToAll( Float: amount ) -   
	:
		amount -  
	    .

*/

stock bool: givePlayerHealthToAll( Float: amount )
{
	new 
		Float: health;
	for( new i = GetMaxPlayers(); i >= 0; i-- )
	{
		if( IsPlayerConnected( i ) )
		{
			GetPlayerHealth( i, health );
			SetPlayerHealth( i, health + amount );
		}
	}
	return false;
}

/*

	:
		givePlayerArmourToAll( amount ) -    
	:
		amount -  
	    .

*/

stock bool: givePlayerArmourToAll( Float: amount )
{
	new 
		Float: armour;
	for( new i = GetMaxPlayers(); i >= 0; i-- )
	{
		if( IsPlayerConnected( i ) )
		{
			GetPlayerArmour( i, armour );
			SetPlayerArmour( i, armour + amount );
		}
	}
	return false;
}

/*

	:
		isPlayerNameOnline( const nickname[] ) -         
	:
		nickname[] -  
	 true    ,  false -  .

*/

stock bool: isPlayerNameOnline( const nickname[ MAX_PLAYER_NAME ] )
{
	new 
		string[ MAX_PLAYER_NAME ];
	for( new i = GetMaxPlayers(); i >= 0; i-- )
	{
		if( IsPlayerConnected( i ) )
		{
			GetPlayerName( i, string, sizeof( string ) );
			if( !strcmp( string, nickname, true ) ) return true;
		}
	}
	return false;
}

/* 
 *   forum.sa-mp.com/showthread.php?t=38965&page=29
 */
#define disableBadword(%1) for(new i=0; i<strlen(text); i++) if(strfind(text[i], %1, true) == 0) for(new a=0; a<256; a++) if (a >= i && a < i+strlen(%1)) text[a] = '*'

/*

	:
		isValidVehicleModel( const modelid ) -    ID  
	:
		modelid -  ID 
	 true -     false -   .

*/

#define IsValidVehicleModel(%1) (400 <= %1 && %1 <= 611)

/*

	:
		givePlayerVehicle( playerid, modelid ) -   
	:
		playerid - ID ,    
		modelid - ID  
	 true   , false -  

*/

stock bool: givePlayerVehicle( const playerid, const modelid )
{
    if( !IsPlayerInAnyVehicle( playerid ) && modelid > 399 && modelid < 612 )
    {
        new Float:x, Float:y, Float:z, Float:a, vehicle;
        GetPlayerPos( playerid, x, y, z );
        GetPlayerFacingAngle( playerid, a );
        vehicle = CreateVehicle( modelid, x, y, z, a, -1, -1, 50000 );
        PutPlayerInVehicle( playerid, vehicle, 0 );
		return true;
    }
	return false;
}

/*

	:
		getTime( ) -    
	    ::

*/

stock getTime( )
{
    new
		string[ 9 ],
		var[ 3 ];   
    gettime( var[ 0 ], var[ 1 ], var[ 2 ] );
    format( string, sizeof( string ), "%02d:%02d:%02d", var[ 0 ], var[ 1 ], var[ 2 ] );
    return string;
}

/*

	:
		RangeBan( playerid ) -     IP-. : 127.0.**.**
	:
		playerid - ID ,   
	    .

*/

stock RangeBan( playerid )
{
    new 
		pos, 
		string[ 32 ];
    GetPlayerIp( playerid, string, 16 );
    pos = strfind( string, ".", false, 0 );
    pos = strfind( string, ".", false, pos + 1 );
    strmid( string, string, 0, pos + 1, 16 );
    format( string, 32, "banip %s*.*", string );
    return SendRconCommand( string );
}

/*

	:
		ArePlayersConnected() -       1   
	  true    1   false   

*/

stock bool: ArePlayersConnected()
{
    for( new i = 0; i < MAX_PLAYERS; i++ )
        if( IsPlayerConnected( i ) ) return true;
    return false;
}

/*

	:
		RandomPlayer() -  ID   .
	  INVALID_PLAYER_ID     

*/

stock RandomPlayer()
{
    new 
		p = INVALID_PLAYER_ID;
    if( ArePlayersConnected() )
    {
        while( !IsPlayerConnected( p ) )
            p = random( GetMaxPlayers() + 1 );
        return p;
    }
    else return INVALID_PLAYER_ID;
}

/*

	:
		GetRandomFromInput( arg1, arg2, ... argN ) -      
	   argN.

*/

stock GetRandomFromInput(...)
{
    new 
		input[ 100 ], 
		generate;
    if( numargs() == 0 ) return -1;
    for( new i = 0; i < numargs(); i++ )
        input[ i ] = getarg( i );
    generate = random( numargs() );
    return input[ generate ];
}

/*

	:
		disableCapsLock( text[] ) -      .
	:
		text[] -  
	   .(    ;    !!)

*/
#define disableCapsLock(%0) new caps; while ( %0[ ++caps ] ){ if( 'A' <=%0[ caps ] <= 'Z' ) %0[ caps ] |= 0x20; if( '' <= %0[ caps ] <= '' ) %0[ caps ] |= 0x20; }

/*

	:
		getPlayerShopName( playerid ) -   ,    
	:
		playerid - ID 
	    http://wiki.sa-mp.com/wiki/ShopNames

*/

 stock getPlayerShopName( const playerid )
{
	new	
		result[ 24 ];
	
	if( IsPlayerInRangeOfPoint( playerid, 30.0, 374.0000, -119.6410, 1001.4922 ) ) result = "FDPIZA";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 375.5660, -68.2220, 1001.5151 ) ) result = "FDBURG";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 368.7890, -6.8570, 1001.8516 ) ) result = "FDCHICK";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 296.5395, -38.2739, 1001.515 ) ) result = "AMMUN1";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 295.7359, -80.6865, 1001.5156 ) ) result = "AMMUN2";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 290.2011, -109.5698, 1001.5156 ) ) result = "AMMUN3";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 308.1619, -141.2549, 999.6016 ) ) result = "AMMUN4";
	else if( IsPlayerInRangeOfPoint( playerid, 30.0, 312.7883, -166.0069, 999.6010 ) ) result = "AMMUN5";
	else result = "Unknown";
	return result;
}

/*

	:
		fwriteEx( filename[], string[] ) -    .   !
	:
		filename[] -  
		string[] -  
	    .

*/

stock fwriteEx( filename[], string[] )
{
	new 
		hour,
		minute,
		sec,
		str[ 256 ],
		File: file;

	gettime( hour, minute, sec );
	format( str, 64, "logs/%s.log", filename );
	file = fopen( stringer, io_append );
	format( str, 158, "[LOGS]: [%d:%d:%d]  %s\r\n", hour, minute, sec, string );
	for( new io = 0; io < strlen( str ); io++ )
		fputchar( file, str[ io ], false );
	fclose( file );
}
/*
 *	
 */