/*
 * ======================
 * EasyINI v0.1 beta
 * ======================
 *
 *  The contents of this file are subject to the Mozilla Public License      
 *  Version 1.1 (the "License"); you may not use this file except in         
 *  compliance with the License. You may obtain a copy of the License at     
 *  http://www.mozilla.org/MPL/                                              
 *                                                                           
 *  Software distributed under the License is distributed on an "AS IS"      
 *  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the  
 *  License for the specific language governing rights and limitations       
 *  under the License.                                                       
 *
 *  The Original Code is EasyINI Squirrel INI Parser.
 *
 *  The Initial Developer of the Original Code is Jones Nathan Sperandio.
 */
 
class
	EasyINI
{
	lastsec = null;
	sections = {};
	filename = "";
	
	constructor(fname)
	{
		filename = fname;
		fileCreate(fname);
		local
			tf = eFile(fname, "r");
		sections.clear();
		lastsec = null;
		while(!tf.eos())
		{
			local
				line = tf.readline(),
				res = regexp(@"\[[\C]+]").search(line);
			
			if(!line.len() || line[0] == ';')
			{
				continue;
			}
				
			if(res != null)
			{
				local
					secname = line.slice(res.begin+1, res.end-1);
				if(findSection(secname) == null)
				{
					createSection(secname);
				}				
				lastsec = secname;
				continue;
			}
			
			if(lastsec == null)
			{
				continue;
			}
			
			res = regexp("=").search(line);
			if(res != null)
			{
				setKey(lastsec, line.slice(0, res.begin), line.slice(res.end));
			}			
		}
	}
	
	/*
	 * Internal Methods
	 */
	 
	function
		createSection(name)
	{
		return (sections[name] <- {});
	}
	
	function
		findSection(name)
	{
		if(sections.rawin(name))
		{
			return sections[name];
		}
		return null;
	}
	
	function
		createKey(section, key, val)
	{
		if(findSection(section) != null)
		{
			sections[section][key] <- val;
			return true;
		}
		else
		{
			createSection(section);
			local
				s = findSection(section);
			if(s == null)
			{
				log("Some serious shit happened. Tell the scripter about that.");
				return false;
			}
			s[key] <- val;
			return true;
		}
		return false;
	}
	
	/*
	 * Public Methods
	 */
	 
	function
		keyExists(section, key)
	{
		local
			s = findSection(section);
		if(s == null)
		{
			return false;
		}
		return (s.rawin(key));
	}
	
	function
		setKey(section, key, val)
	{
		if(val == null)
		{
			throw "EasyINI Exception: Value must not be null!";
		}
		if(!keyExists(section, key))
		{
			createKey(section, key, val.tostring());
		}
		else
		{
			findSection(section)[key] <- val.tostring();
		}
	}
	
	function
		getKey(section, key)
	{
		if(!keyExists(section, key))
		{
			return null;
		}
		return sections[section][key];		
	}
	
	function
		deleteKey(section, key)
	{
		if(!keyExists(section, key))
		{
			return false;
		}
		return delete sections[section][key];
	}
	
	function
		deleteSection(name)
	{
		if(findSection(name) == null)
		{
			return false;
		}
		return delete sections[name];
	}
	
	function
		logData()
	{
		foreach(i,s in sections)
		{
			log("[" + i + "]");
			foreach(j,k in s)
			{
				log(j + "=" + k);
			}
		}
	}
	
	function
		reloadData()
	{
		sections.clear();
		lastsec = null;
		local
			tf = eFile(fname, "r");
		while(!tf.eos())
		{
			local
				line = tf.readline();
				res = regexp(@"\[[\C]+]").secReg.search(line);
			
			if(!line.len() || line[0] == ';')
			{
				continue;
			}
				
			if(res != null)
			{
				local
					secname = line.slice(res.begin+1, res.end-1);
				if(findSection(secname) == null)
				{
					createSection(secname);
				}				
				lastsec = secname;
				continue;
			}
			if(lastsec == null)
			{
				continue;
			}
			res = regexp("=").secReg.search(line);
			if(res != null)
			{
				setKey(lastsec, line.slice(0, res.begin), line.slice(res.end));
			}
		}		
	}
	
	function
		saveData()
	{
		local tf = eFile(filename, "w");
		tf.writeline(";C'Admin file generated by EasyINI");
		foreach(i,s in sections)
		{
			tf.writeline("[" + i + "]");
			foreach(j,k in s)
			{
				tf.writeline(j + "=" + k);
			}
		}		
	}
}

function
	fileCreate(filename)
{
	local tf = file(filename, "a+");
	tf = null;
	return true;
}

class
	eFile extends file
{
	function
		readline()
	{
		local
			result = "";
		while(!this.eos())
		{
			local
				c = this.readn('c');
			if(c == '\n' || !c)
			{
				return result;
			}
			if(c == '\r')
			{
				continue;
			}
			result += c.tochar();
		}
		return result;
	}
	function
		writeline(line)
	{
		foreach(char in line)
		{
			this.writen(char, 'c');
		}
		this.writen('\n', 'c');
	}
}

function playerFileExists(filename)
{
	try
	{
		file(filename, "r");
	}
	catch (E)
	{
		return false;
	}
	return true;
}