/* EKup filterscript for race
 *
 * (c) Copyright 2007, EKup
 * This file is provided as is (no warranties).
 */

//--------------------------------------------------------------------

new RacesDir[256] = "Eracing";              //  

//------------------------------------------------------------------------------
//   
new isLinux = false;
new ticks = 0;
new tickDelay = 500;
//
//------------------------------------------------------------------------------
//-----------------------------------------
new RaceEnabled = 1;                    //  
new isEventEnabled = 0;                 //   
new isCommandEnabled = 0;               //      
new IsPossibleCreateRace = 0;           //   
new DelFromRaceIfDied = 1;              //  ,  
new isSoundsEnabled = 1;                //  
new ShowRaceTextForAll = 0;             //        
new IsAdminPutInRace = 0;               //      (0),     (1)
new IsPlacePrizeInRace = 0;             //    
new PrizePlacec[MAX_START_POS_InRace];  //   
new NumBestPlayersRace = 3;             //    
new isSaveRaceResults = 0;              //   
new isBestRacersListEnabled = 1;        //         
new LongCreateRaceInfo = 0;             ///      
new TimeBeforeStartRace = 10;           //       
new isUpdateOldRaces=1;                 //      
new isCopyRecordsOnUpdate=0;            //    


new Admins = 0;                         //  (0- , 1- , 2- ,   )
new AdminPassword[256];

//------------------------------------------------------------------------------

//,   ,   .
new Float:QuitPlace[Max_Siz_QuitPlace][4];
new siz_QuitPlace = 0;                  //  ,   ,   

//------------------------------------------------------------------------------
//Best Racers list
//------------------------------------------------------------------------------

new Text:BestRacerListName;
new BestRacerListNameText[] = "Best Racers on route:";
new BestRacersTextNoRacers[] = "No finished racers";
new BestRacersText[] = "%2.2d - %24.24s Time: %21.21s";
//------------------------------------------------------------------------------

InitParams()
{
	if((GetTickCount() != tickcount()) || (GetTickCount() < 0))
	{
           isLinux = true;
           SetTimer("UpdateTicks", tickDelay, 1);
	}
	else isLinux = false;
    isParamInited = 1;
    SetTimer("UpdateCPTimer", 2000, 1);
    if(isBestRacersListEnabled != 0)
        BestRacerListName = TextDrawCreate(BestRacerListNameX, BestRacerListNameY, BestRacerListNameText);
}

//   
LoadParamFromConfig()
{
    if(!dini_Exists(ConfigFile)) return 0;
    if(dini_Isset(ConfigFile, "RacesDir")) RacesDir = dini_Get(ConfigFile,"RacesDir");
    if(dini_Isset(ConfigFile, "RaceEnabled")) RaceEnabled = dini_Int(ConfigFile,"RaceEnabled");
    if(dini_Isset(ConfigFile, "isEventEnabled")) isEventEnabled = dini_Int(ConfigFile,"isEventEnabled");
    if(dini_Isset(ConfigFile, "isCommandEnabled")) isCommandEnabled = dini_Int(ConfigFile,"isCommandEnabled");
    if(dini_Isset(ConfigFile, "IsPossibleCreateRace")) IsPossibleCreateRace = dini_Int(ConfigFile,"IsPossibleCreateRace");
    if(dini_Isset(ConfigFile, "DelFromRaceIfDied")) DelFromRaceIfDied = dini_Int(ConfigFile,"DelFromRaceIfDied");
    if(dini_Isset(ConfigFile, "isSoundsEnabled")) isSoundsEnabled = dini_Int(ConfigFile,"isSoundsEnabled");
    if(dini_Isset(ConfigFile, "ShowRaceTextForAll")) ShowRaceTextForAll = dini_Int(ConfigFile,"ShowRaceTextForAll");
    if(dini_Isset(ConfigFile, "IsAdminPutInRace")) IsAdminPutInRace = dini_Int(ConfigFile,"IsAdminPutInRace");
    if(dini_Isset(ConfigFile, "IsPlacePrizeInRace")) IsPlacePrizeInRace = dini_Int(ConfigFile,"IsPlacePrizeInRace");
    if(dini_Isset(ConfigFile, "NumBestPlayersRace")) NumBestPlayersRace = dini_Int(ConfigFile,"NumBestPlayersRace");
    if(dini_Isset(ConfigFile, "SaveRaceResults")) isSaveRaceResults = dini_Int(ConfigFile,"SaveRaceResults");
    if(dini_Isset(ConfigFile, "isBestRacersListEnabled")) isBestRacersListEnabled = dini_Int(ConfigFile,"isBestRacersListEnabled");
    if(dini_Isset(ConfigFile, "LongCreateRaceInfo")) LongCreateRaceInfo = dini_Int(ConfigFile,"LongCreateRaceInfo");
    if(dini_Isset(ConfigFile, "TimeBeforeStartRace")) TimeBeforeStartRace = dini_Int(ConfigFile,"TimeBeforeStartRace");
    
    if(dini_Isset(ConfigFile, "isUpdateOldRaces")) isUpdateOldRaces = dini_Int(ConfigFile,"isUpdateOldRaces");
    if(dini_Isset(ConfigFile, "isCopyRecordsOnUpdate")) TimeBeforeStartRace = dini_Int(ConfigFile,"isCopyRecordsOnUpdate");
    
    
    if(dini_Isset(ConfigFile, "Admins")) Admins = dini_Int(ConfigFile,"Admins");
    if(Admins == 2)
    {
        if(dini_Isset(ConfigFile, "AdminsPassword")) AdminPassword = dini_Get(ConfigFile,"AdminsPassword");
        else Admins = 0;
    }
	new tmp[256];
	for(new i=1; i<=MAX_START_POS_InRace; i++)
    {
		format(tmp, sizeof(tmp), "PrizePlace_%d", i);
		if(dini_Isset(ConfigFile, tmp)) PrizePlacec[i-1] = dini_Int(ConfigFile,tmp);
    }
    //    
    siz_QuitPlace = 0;
	for(new i = 0; i < Max_Siz_QuitPlace; i++)
	{
        format(tmp, sizeof(tmp), "PositionExit[%d][X]", i);
        if(dini_Isset(ConfigFile, tmp))
            QuitPlace[i][0] = dini_Float(ConfigFile, tmp);
		else break;
        format(tmp, sizeof(tmp), "PositionExit[%d][Y]", i);
        if(dini_Isset(ConfigFile, tmp))
            QuitPlace[i][1] = dini_Float(ConfigFile, tmp);
		else break;
        format(tmp, sizeof(tmp), "PositionExit[%d][Z]", i);
        if(dini_Isset(ConfigFile, tmp))
            QuitPlace[i][2] = dini_Float(ConfigFile, tmp);
		else break;
        format(tmp, sizeof(tmp), "PositionExit[%d][ang]", i);
        if(dini_Isset(ConfigFile, tmp))
            QuitPlace[i][3] = dini_Float(ConfigFile, tmp);
		else break;
		siz_QuitPlace = i + 1;
	}
	if(siz_QuitPlace != 0)
	{
		format(tmp, sizeof(tmp), "Read %d quit place for races in config file", siz_QuitPlace);
		printf(tmp);
	}
	else
	{
        QuitPlace[0][0] = 1003.9700;
        QuitPlace[0][1] = -1087.3330;
        QuitPlace[0][2] = 23.8281;
        QuitPlace[0][3] = 0.0;
        QuitPlace[1][0] = 1010.7438;
        QuitPlace[1][1] = -1087.5986;
        QuitPlace[1][2] = 23.8281;
        QuitPlace[1][3] = 0.0;
        QuitPlace[2][0] = 1018.7885;
        QuitPlace[2][1] = -1088.6763;
        QuitPlace[2][2] = 23.8281;
        QuitPlace[2][3] = 0.0;
        QuitPlace[3][0] = 1025.0581;
        QuitPlace[3][1] = -1088.5126;
        QuitPlace[3][2] = 23.8349;
        QuitPlace[3][3] = 0.0;
        QuitPlace[4][0] = 1031.2050;
        QuitPlace[4][1] = -1088.1266;
        QuitPlace[4][2] = 23.8281;
        QuitPlace[4][3] = 0.0;
        QuitPlace[5][0] = 1043.6034;
        QuitPlace[5][1] = -1087.7129;
        QuitPlace[5][2] = 23.8281;
        QuitPlace[5][3] = 0.0;
        siz_QuitPlace = 6;
        format(tmp, sizeof(tmp), "Quit places for races don`t found in config file. Load default coordinates", siz_QuitPlace);
		printf(tmp);
	}
    return RaceEnabled;
}
