#include <a_samp>
#include <file>
#include <core>
#include <time>
#include <string>
#include <dini>
#include Routs.pwn
//#include <uf>

/* EKup filterscript for race
 *
 * (c) Copyright 2007, EKup
 * This file is provided as is (no warranties).
 */

//--------------------------------------------------------------------

// 
new COL_RACES = 0;

//    
new IsRaceExist[MAX_RACES];

//  
new RaceNames[MAX_RACES][256];

//      
new vechTypesForRouts[MAX_RACES];

//------------------------------------------------------------------------------

//      IsRaceExist
CheckRaces()
{
	new tmp[255];
	COL_RACES = 0;
	printf("Check all races:");
	numLoads = 0;
	getdate(yearCreate, monthCreate, dayCreate);
	NumBestPlayers = 0;
    for(new i=0; i<MAX_RACES; i++)
    {
        IsRaceExist[i] = 0;
		format(tmp, sizeof(tmp), RaceFileName, RacesDir, i);
		if(fexist(tmp))
		{
			 LoadBaseParamAboutRace(i);
			 IsRaceExist[i] = 1;
			 COL_RACES++;
 	         format(tmp, sizeof(tmp), " %d race load", i);
             printf(tmp);
             format(tmp, sizeof(tmp), InfoFileName, RacesDir, i);
             if(!fexist(tmp)) UpdateInfoFile(i);
		}
    }
    if(isUpdateOldRaces != 0)
      for(new i=0; i<MAX_RACES; i++)
      {
		if(IsRaceExist[i] == 0)
		{
			format(tmp, sizeof(tmp), RaceFileName, "Race", i);
			if(fexist(tmp))
			{
                oldLoadRace(i);
                NewSaveRace(i);
                fremove(tmp);
                format(tmp, sizeof(tmp), InfoFileName, "Race", i);
                fremove(tmp);
                format(tmp, sizeof(tmp), " Old race number %d converted and removed", i);
                printf(tmp);
                LoadBaseParamAboutRace(i);
			    IsRaceExist[i] = 1;
			    COL_RACES++;
			}
		}
      }
    format(tmp, sizeof(tmp), "Check complete. Load %d races", COL_RACES);
	printf(tmp);
}

//     
LoadRace(NumRace)
{
	//     ,  
	new tmp[MAX_STRING];
	if(NUMBER_RACE == NumRace)
	{
        if(isBestRacersListEnabled != 0)
            InitBestPlayersListDraw();
        numLoads++;
	    UpdateInfoFile(NumRace);
	    return true;
	}
	// 
	new FileName[MAX_STRING];
	format(FileName, sizeof(FileName), RaceFileName, RacesDir, NumRace);
	if(!fexist(FileName)) return false;
	// 
	new File:fohnd;
	new tmpres[MAX_STRING];
	new tfl[10][50];
	fohnd=fopen(FileName,io_read);
	if(!fohnd) return false;
	//
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    format(RaceName, sizeof(RaceName), "%s", tfl[0]);
    //
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    format(RaceDescript, sizeof(RaceDescript), "%s", tfl[0]);
    //
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    format(RaceAutor, sizeof(RaceAutor), "%s", tfl[0]);
    // 
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    TypeVechicle = strval(tfl[0]);
    //
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    RaceInteriorID = strval(tfl[0]);
    //
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    RoutTimeout = strval(tfl[0]);
    // 
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    NUMBER_START_POS_FOR_RACE = strval(tfl[0]);
    // 
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    NUMBER_CHECKPOINTS_FOR_RACE = strval(tfl[0]);

    for(new i=0; i<NUMBER_START_POS_FOR_RACE; i++)
    {
        private_ExtractNextStrFromFile(fohnd, tmpres, sizeof(tmpres));
        split(tmpres, tfl, ',');
        PositionBase[i][0] = floatstr(tfl[0]);
        PositionBase[i][1] = floatstr(tfl[1]);
        PositionBase[i][2] = floatstr(tfl[2]);
        PositionBase[i][3] = floatstr(tfl[3]);
    }
    for(new i=0; i<NUMBER_CHECKPOINTS_FOR_RACE; i++)
    {
        private_ExtractNextStrFromFile(fohnd, tmpres, sizeof(tmpres));
        split(tmpres, tfl, ',');
        CheckPointBase[i][0] = floatstr(tfl[0]);
        CheckPointBase[i][1] = floatstr(tfl[1]);
        CheckPointBase[i][2] = floatstr(tfl[2]);
        CheckPointBase[i][3] = floatstr(tfl[3]);
    }
	fclose(fohnd);
	if(NUMBER_START_POS_FOR_RACE <=0) return false;
	if(NUMBER_CHECKPOINTS_FOR_RACE<= 0) return false;

	if((RoutTimeout < 1) || (RoutTimeout > 60)) RoutTimeout = 10;
	
	//  
	new Float:tmpDis;
	new routDisTmp;
	RoutDistance = floatround(floatsqroot(floatpower(floatabs(floatsub(CheckPointBase[0][0],PositionBase[0][0])),2)+
		                                  floatpower(floatabs(floatsub(CheckPointBase[0][1],PositionBase[0][1])),2)+
							              floatpower(floatabs(floatsub(CheckPointBase[0][2],PositionBase[0][2])),2)));
    for(new i=1; i<NUMBER_START_POS_FOR_RACE; i++)
	{
		routDisTmp = floatround(floatsqroot(floatpower(floatabs(floatsub(CheckPointBase[0][0],PositionBase[i][0])),2)+
		                                    floatpower(floatabs(floatsub(CheckPointBase[0][1],PositionBase[i][1])),2)+
							                floatpower(floatabs(floatsub(CheckPointBase[0][2],PositionBase[i][2])),2)));
		if(routDisTmp < RoutDistance) RoutDistance = routDisTmp;
	}
	for(new i = 0; i < NUMBER_CHECKPOINTS_FOR_RACE - 1; i++)
	{
         tmpDis = floatsqroot(floatpower(floatabs(floatsub(CheckPointBase[i][0],CheckPointBase[i+1][0])),2)+
		                      floatpower(floatabs(floatsub(CheckPointBase[i][1],CheckPointBase[i+1][1])),2)+
							  floatpower(floatabs(floatsub(CheckPointBase[i][2],CheckPointBase[i+1][2])),2));
		 RoutDistance += floatround(tmpDis);
	}
	//   INFO 
	format(FileName, sizeof(FileName), InfoFileName, RacesDir, NumRace);
	if(!fexist(FileName)) return false;
	fohnd=fopen(FileName,io_read);
	//  
	private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    numLoads = strval(tfl[0]) + 1;
    //    
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, ',');
    yearCreate = strval(tfl[0]);
    monthCreate = strval(tfl[1]);
    dayCreate = strval(tfl[2]);
    format(AddRoutDate, sizeof(AddRoutDate), "%2.2d.%2.2d.%4.4d", dayCreate, monthCreate, yearCreate);

	//   
	NumBestPlayers = 0;
	if(isBestRacersListEnabled != 0)
	{
	    IsStatChange = 0;
	    for(new i = 0; i < NumBestPlayersRace; i++)
	    {
			if(!fread(fohnd, tmp)) break;
			StripNewLine(tmp);
			split(tmp, tfl, ',');
			format(BestPlayers_Names[i], MAX_STRING, "%s", tfl[0]);
			BestPlayers_Times[i] = strval(tfl[1]);
		    NumBestPlayers++;
	    }
	   
	    InitBestPlayersListDraw();
	}
	fclose(fohnd);
	NUMBER_RACE = NumRace;
	UpdateInfoFile(NumRace);
	return true;
}

oldLoadRace(NumRace)
{
	new tmp[255];
	new tmpres[255];
	//, :     
    new isRaceTimeoutChanged = 0;
    new isNumStartPosChanged=0;
    new isNumCPChanged=0;
    new isRaceAuthorChanged=0;
    new isRaceDescrChanged=0;
    new isRaceNameChanged=0;
    new isRaceInteriorChanged=0;
    new isTypeVechChanged=0;
    new isSPChanged[MAX_START_POS_InRace][4];
    for(new i = 0; i < MAX_START_POS_InRace; i++)
	{
       isSPChanged[i][0] = 0;
       isSPChanged[i][1] = 0;
       isSPChanged[i][2] = 0;
       isSPChanged[i][3] = 0;
	}
    new isCPChanged[MAX_CP_InRace][4];
    for(new i = 0; i < MAX_CP_InRace; i++)
	{
       isCPChanged[i][0] = 0;
       isCPChanged[i][1] = 0;
       isCPChanged[i][2] = 0;
       isCPChanged[i][3] = 0;
	}
	// 
	format(tmp, sizeof(tmp), RaceFileName, "Race", NumRace);
	if(!fexist(tmp)) return false;
	// 
	new File:fohnd;
	fohnd=fopen(tmp,io_read);
	if(!fohnd) return false;
	while(fread(fohnd,tmpres))
	{
		StripNewLine(tmpres);
		if(extractStr(tmpres, "RaceName=", RaceName, sizeof(RaceName))) isRaceNameChanged = 1;
		else if(extractStr(tmpres, "RaceDescript=", RaceDescript, sizeof(RaceDescript))) isRaceDescrChanged = 1;
             else if(extractStr(tmpres, "RaceAutor=", RaceAutor, sizeof(RaceAutor))) isRaceAuthorChanged = 1;
                  else if(extractInt(tmpres, "NumberCP=", NUMBER_CHECKPOINTS_FOR_RACE))
					   {
                           if((NUMBER_CHECKPOINTS_FOR_RACE < 1) || (NUMBER_CHECKPOINTS_FOR_RACE > MAX_CP_InRace))
                           {
                               fclose(fohnd);
                               return false;
                           }
                           else isNumCPChanged = 1;
					   }
					   else if(extractInt(tmpres, "NumberStartPos=", NUMBER_START_POS_FOR_RACE))
							{
                               if((NUMBER_START_POS_FOR_RACE < 1) || (NUMBER_START_POS_FOR_RACE > MAX_START_POS_InRace))
                               {
                                  fclose(fohnd);
                                  return false;
                               }
                               else isNumStartPosChanged = 1;
					        }
					        else if(extractInt(tmpres, "TypeVechicle=", TypeVechicle)) isTypeVechChanged = 1;
                                 else if(extractInt(tmpres, "InteriorID=", RaceInteriorID)) isRaceInteriorChanged = 1;
                                      else if(extractInt(tmpres, "RaceTimeout=", RoutTimeout)) isRaceTimeoutChanged = 1;
										   else
										   {
											  if(ifStrStartedFromStr(tmpres, "PositionBase"))
											  {
											     new maxSP;
											     if(isNumStartPosChanged == 1) maxSP = NUMBER_START_POS_FOR_RACE;
											     else maxSP = MAX_START_POS_InRace;
											     for(new k = 0; k < maxSP; k++)
											     {
                                                    format(tmp, sizeof(tmp), "PositionBase[%d][X]", k);
                                                    if(extractFloat(tmpres, tmp, PositionBase[k][0])) isSPChanged[k][0] = 1;
                                                    else
                                                    {
                                                      format(tmp, sizeof(tmp), "PositionBase[%d][Y]", k);
                                                      if(extractFloat(tmpres, tmp, PositionBase[k][1])) isSPChanged[k][1] = 1;
                                                      else
                                                      {
                                                        format(tmp, sizeof(tmp), "PositionBase[%d][Z]", k);
                                                        if(extractFloat(tmpres, tmp, PositionBase[k][2])) isSPChanged[k][2] = 1;
                                                        else
                                                        {
                                                          format(tmp, sizeof(tmp), "PositionBase[%d][ang]", k);
                                                          if(extractFloat(tmpres, tmp, PositionBase[k][3])) isSPChanged[k][3] = 1;
                                                        }
                                                      }
                                                    }
											     }
											  }
											  else
											  {
                                                 if(ifStrStartedFromStr(tmpres, "CheckPointBase"))
											     {
                                                    new maxCP;
											        if(isNumCPChanged == 1) maxCP = NUMBER_CHECKPOINTS_FOR_RACE;
											        else maxCP = MAX_CP_InRace;
											        for(new k = 0; k < maxCP; k++)
											        {
                                                       format(tmp, sizeof(tmp), "CheckPointBase[%d][X]", k);
                                                       if(extractFloat(tmpres, tmp, CheckPointBase[k][0])) isCPChanged[k][0] = 1;
                                                       else
                                                       {
                                                         format(tmp, sizeof(tmp), "CheckPointBase[%d][Y]", k);
                                                         if(extractFloat(tmpres, tmp, CheckPointBase[k][1])) isCPChanged[k][1] = 1;
                                                         else
                                                         {
                                                           format(tmp, sizeof(tmp), "CheckPointBase[%d][Z]", k);
                                                           if(extractFloat(tmpres, tmp, CheckPointBase[k][2])) isCPChanged[k][2] = 1;
                                                           else
                                                           {
                                                             format(tmp, sizeof(tmp), "CheckPointBase[%d][siz]", k);
                                                             if(extractFloat(tmpres, tmp, CheckPointBase[k][3])) isCPChanged[k][3] = 1;
                                                           }
                                                         }
                                                       }
											        }
											     }
											  }
										   }
	}
	fclose(fohnd);
	if(isTypeVechChanged == 0)
	{
        TypeVechicle = 255;
        isTypeVechChanged = 1;
	}
	if(isRaceInteriorChanged == 0)
	{
        RaceInteriorID = 0;
        isRaceInteriorChanged = 1;
	}
	if(isRaceTimeoutChanged == 0)
	{
        RoutTimeout = 10;
        isRaceTimeoutChanged = 1;
	}
	else if((RoutTimeout < 1) || (RoutTimeout > 60)) RoutTimeout = 10;
	if((isRaceNameChanged == 0) ||
	   (isRaceDescrChanged == 0) ||
	   (isRaceAuthorChanged == 0) ||
	   (isNumCPChanged == 0) ||
	   (isNumStartPosChanged == 0)) return false;
	for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	   if((isSPChanged[i][0] == 0) ||
	      (isSPChanged[i][1] == 0) ||
		  (isSPChanged[i][2] == 0) ||
		  (isSPChanged[i][3] == 0)) return false;
	for(new i = 0; i < NUMBER_CHECKPOINTS_FOR_RACE; i++)
	   if((isCPChanged[i][0] == 0) ||
	      (isCPChanged[i][1] == 0) ||
		  (isCPChanged[i][2] == 0) ||
		  (isCPChanged[i][3] == 0)) return false;
	//   INFO 
	format(tmpres, sizeof(tmpres), InfoFileName, "Race", NumRace);
	if(!fexist(tmpres)) return false;
	fohnd=fopen(tmpres,io_read);
	NumBestPlayers = 0;
	while(fread(fohnd,tmpres))
	{
		StripNewLine(tmpres);
		if(!extractInt(tmpres, "numLoads=", numLoads))
         if(!extractInt(tmpres, "dateOfCreate_Year=", yearCreate))
          if(!extractInt(tmpres, "dateOfCreate_Month=", monthCreate))
           if(!extractInt(tmpres, "dateOfCreate_Day=", dayCreate))
             for(new i = 0; i < NumBestPlayersRace; i++)
	         {
                 format(tmp, sizeof(tmp), "BestPlayers[%d][Name]=", i+1);
                 if(extractStr(tmpres, tmp, BestPlayers_Names[i], 255)) NumBestPlayers++;
                 else
				 {
                     format(tmp, sizeof(tmp), "BestPlayers[%d][Time]=", i+1);
				     extractInt(tmpres, tmp, BestPlayers_Times[i]);
				 }
	         }

		  
	}
	fclose(fohnd);
    return true;
}

NewSaveRace(NumRace)
{
	new tmp[255];
	new File:f;
	format(tmp, sizeof(tmp), RaceFileName, RacesDir, NumRace);
	if(fexist(tmp)) return false;
    f = fopen(tmp, io_write);
    if(!f) return false;
    format(tmp, sizeof(tmp), " %s//", RaceName);
	private_SaveParam(f, tmp); // 
    format(tmp, sizeof(tmp), " %s//", RaceDescript);
	private_SaveParam(f, tmp); //
    format(tmp, sizeof(tmp), "%s//", RaceAutor);
	private_SaveParam(f, tmp); //
    format(tmp, sizeof(tmp), "%d// ", TypeVechicle);
	private_SaveParam(f, tmp); //  
    format(tmp, sizeof(tmp), "%d//", RaceInteriorID);
	private_SaveParam(f, tmp); //
    format(tmp, sizeof(tmp), "%d//", RoutTimeout);
	private_SaveParam(f, tmp); //
	format(tmp, sizeof(tmp), "%d//   ", NUMBER_START_POS_FOR_RACE);
	private_SaveParam(f, tmp); //   
	format(tmp, sizeof(tmp), "%d// ", NUMBER_CHECKPOINTS_FOR_RACE);
	private_SaveParam(f, tmp); // 
	//  
	for(new i=0; i<NUMBER_START_POS_FOR_RACE; i++)
	{
		 format(tmp, sizeof(tmp), "%f,%f,%f,%f,//  %d", PositionBase[i][0], PositionBase[i][1], PositionBase[i][2], PositionBase[i][3], i+1);
		 private_SaveParam(f, tmp); // 
	}
	// 
	for(new i=0; i<NUMBER_CHECKPOINTS_FOR_RACE; i++)
	{
         format(tmp, sizeof(tmp), "%f,%f,%f,%f,// %d", CheckPointBase[i][0], CheckPointBase[i][1], CheckPointBase[i][2], CheckPointBase[i][3], i+1);
		 private_SaveParam(f, tmp); //
	}
	fclose(f);
	//--
	if(isCopyRecordsOnUpdate == 0) NumBestPlayers=0;
	UpdateInfoFile(NumRace);
	//--
	vechTypesForRouts[NumRace] = TypeVechicle;
	format(RaceNames[NumRace], 255, "%s", RaceName);
	return true;
}

//    
GetRaceDescr(numRace, Descr[], sizDescr)
{
    new tfl[10][50];
	new tmp[255];
    if((numRace<0) || (numRace>=MAX_RACES)) return 0;
	if(!IsRaceExist[numRace]) return 0;
	// 
	new FileName[MAX_STRING];
	format(FileName, sizeof(FileName), RaceFileName, RacesDir, numRace);
	// 
	new File:fohnd;
	fohnd=fopen(FileName,io_read);
	//
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    //
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    format(Descr, sizDescr, "%s", tfl[0]);
    //
	fclose(fohnd);
	return 1;
}

GetFirstEmptyRace()
{
	for(new i = 0; i<MAX_RACES; i++)
	{
	    if(!IsRaceExist[i]) return i;
	}
	return -1;
	    
}

LoadBaseParamAboutRace(NumRace)
{
    new tfl[10][50];
	new tmp[255];
	format(tmp, sizeof(tmp), RaceFileName, RacesDir, NumRace);
	// 
	new File:fohnd;
	fohnd=fopen(tmp,io_read);
	//
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    format(RaceNames[NumRace], 255, "%s", tfl[0]);
    //
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    //
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    // 
    private_ExtractNextStrFromFile(fohnd, tmp, sizeof(tmp));
    split(tmp, tfl, '/');
    vechTypesForRouts[NumRace] = strval(tfl[0]);
	fclose(fohnd);
}

UpdateInfoFile(NumRace)
{
    new tmp[255];
    format(tmp, sizeof(tmp), InfoFileName, RacesDir, NumRace);
    if(fexist(tmp)) fremove(tmp);
    

	new File:f = fopen(tmp, io_write);
    format(tmp, sizeof(tmp), "%d// ", numLoads);
	private_SaveParam(f, tmp); // 

	format(tmp, sizeof(tmp), "%d,%d,%d,// ", yearCreate, monthCreate, dayCreate);
	private_SaveParam(f, tmp); // 
	for(new i = 0; i < NumBestPlayers; i++)
	{
		 format(tmp, sizeof(tmp), "%s,%d,// %d", BestPlayers_Names[i], BestPlayers_Times[i], i+1);
         private_SaveParam(f, tmp); //
	}
	IsStatChange = 0;
	fclose(f);
}

DelRaceFile(num)
{
    new FileName1[255];
    new FileName2[255];
    format(FileName1, sizeof(FileName1), RaceFileName, RacesDir, num);
    format(FileName2, sizeof(FileName2), InfoFileName, RacesDir, num);
    return dini_Remove(FileName1) & dini_Remove(FileName2);
}

//------------------------------------------------------------------------------
extractStr(str[], foundedString[], changedStr[], siz)
{
	if(ifStrStartedFromStr(str, foundedString))
	{
        format(changedStr, siz, "%s", ExtractStringAfterEqu(str));
        return true;
	}
	return false;
}

extractInt(str[], foundedString[], &changedParam)
{
	if(ifStrStartedFromStr(str, foundedString))
	{
        changedParam = strval(ExtractStringAfterEqu(str));
        return true;
	}
	return false;
}

extractFloat(str[], foundedString[], &Float:changedParam)
{
	if(ifStrStartedFromStr(str, foundedString))
	{
        changedParam = floatstr(ExtractStringAfterEqu(str));
        return true;
	}
	return false;
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

//      
TestSpeedLoadFiles()
{
    new tmp[100];
    new tmp3[256];
    new time1, time;
	new C = 0;
	print(" Start load routs");
    for(new i=0; i<MAX_RACES; i++)
    {
		format(tmp, sizeof(tmp), "%s/Race%d.dat", RacesDir, i);
		if(dini_Exists(tmp))
		{
			 time1 = GetTickCountEx();
			 LoadRace(i);
			 time = GetTickCountEx() - time1;
			 tmp3 = TimeToTexts(time);
			 format(tmp, sizeof(tmp), "Race number %d checked. Time: %s", i, tmp3);
			 printf(tmp);
			 C++;
		}
    }
    format(tmp, sizeof(tmp), "Check complete. Load %d races", C);
	printf(tmp);
}
