//------------------------------------------------------------------------------

//
new TimerID;
new TekOtshet;

new routCreateH;
new routCreateM;
new routCreateS;

//------------------------------------------------------------------------------

new MaxPlayerID = -1;       //   ,      

//------------------------------------------------------------------------------

public OnPlayerEnterRaceCheckpoint(playerid)
{
	new place;
	new tmp[255];
	new FinishTime;
	if(!isPlayerInAnyRace(playerid)) return 0;
	if(!GetPlayerPlace(playerid, place)) return 0;
	if(MainCheck[place] < (NUMBER_CHECKPOINTS_FOR_RACE-1))
	{
		 //  
		 DisablePlayerRaceCheckpoint(playerid);
		 PlayPlayerSound(playerid, sound_EnterCP);
         MainCheck[place]++;
         ShowCheckPoint(playerid, place);
		 format(tmp, sizeof(tmp), Text7, MainCheck[place], NUMBER_CHECKPOINTS_FOR_RACE, PlayerPosOnCP(place)); //: %d/%d.  - %d
		 SendPlayerScriptText(playerid, tmp);
		 //   
		 new ptime = GetTickCountEx();
		 new numCPForPl = MainCheck[place] - 1;
		 if(IsPlayerConnected(ID_LastPlayerInCP[numCPForPl]))
		 {
			 new deltaTime = ptime - Time_LastPlayerInCP[numCPForPl];
			 new t[256];
			 new name[50];
             t = TimeToTexts(deltaTime);
             GetPlayerName(ID_LastPlayerInCP[numCPForPl], name, sizeof(name));
             format(tmp, sizeof(tmp), Text161, name, ID_LastPlayerInCP[numCPForPl], t); //   %s,    %s
             SendPlayerScriptText(playerid, tmp);
		 }
		 ID_LastPlayerInCP[numCPForPl] = playerid;
		 Time_LastPlayerInCP[numCPForPl] = ptime;
         return 1;
	}
	//  .
	//
	if(AlreadyFinish <= (IsPlacePrizeInRace-1))
	{
		 format(tmp, sizeof(tmp), Mess, PrizePlacec[AlreadyFinish]); //     %d
		 SendPlayerScriptText(playerid, tmp);
		 GivePlayerMoney(playerid, PrizePlacec[AlreadyFinish]);
	}
	// 
	FinishTime = GetTickCountEx();
	new TimeForRace = FinishTime - StartTime;
	// 
	AlreadyFinish++;
	isRacerFinished[place] = 1;
	Event_FinishInRace(playerid, /*numRace, */TimeForRace, AlreadyFinish);
	// ,    
	new num = GetNumberRacers();
	if(num == 0)
    {
	    DelRace();
	}
    return 1;
}

//------------------------------------------------------------------------------

// 
RaceInit()
{
	MAX_RACERS = NUMBER_START_POS_FOR_RACE;
	for(new i = 0; i < sizeof(MainCheck); i++) MainCheck[i] = 0;
	for(new i = 0; i < sizeof(PositionOccup); i++) PositionOccup[i] = -1;
	for(new i = 0; i < sizeof(isRacerFinished); i++) isRacerFinished[i] = 0;
	for(new i = 0; i < sizeof(ID_LastPlayerInCP); i++) ID_LastPlayerInCP[i] = -1;
	IDRaceOperator = -1;
	AlreadyFinish = 0;
	NumberRacersOnStart = 0;
	RaceStatus = 1;
	CreateTime = GetTickCountEx();
	Event_CreateRace(/*numRace, */NUMBER_RACE, RoutDistance, NUMBER_CHECKPOINTS_FOR_RACE, NUMBER_START_POS_FOR_RACE, RaceName);
	return 1;
}

//------------------------------------------------------------------------------

//  
AddRacer(playerid)
{
	new place;
	new tmp[256];
	new name[30];
	if(RaceStatus == 2)
	{
        SendPlayerScriptText(playerid, Text12); //     ,    
		return 0;
	}
	if((RaceStatus == 1) || (RaceStatus == 3))
	{

	    if(isPlayerInAnyRace(playerid)) return 0;
        if(!GetFreePlace(place)) return 0;
        if(!TeleportRacerToStart(playerid, place)) return 0;
        GetPlayerName(playerid, name, sizeof(name));
        new num = GetNumberRacers();
        // ,   
	    if((num == 1) && (IsAdminPutInRace == 0))
	    {
            IDRaceOperator = playerid;
	        SendPlayerScriptText(playerid, Text11); //!!     ( /start)
	        // 
		    format(tmp, sizeof(tmp), Text1, name); // - %s   
		    SendAllScriptText(tmp);
	    }
	    //   
        Event_EnterRace(playerid, /*numRace, */place);
        return 1;
	}
	return 0;
}

AddRacer_OnPos(playerid, pos)
{
	if((RaceStatus != 1)  && (RaceStatus != 3)) return false;
    new name[30];
    new tmp[256];
	if((pos<0) || (pos>=NUMBER_START_POS_FOR_RACE)) return false;
	if(PositionOccup[pos] != -1)
	   if(isRacerFinished[pos] != 2) return false;
	if(isPlayerInAnyRace(playerid)) return false;
	if(!TeleportRacerToStart(playerid, pos)) return false;
    GetPlayerName(playerid, name, sizeof(name));
    new num = GetNumberRacers();
    // ,   
	if((num == 1) && (IsAdminPutInRace == 0))
	{
       IDRaceOperator = playerid;
	   SendPlayerScriptText(playerid, Text11); //!!     ( /start)
	   // 
	   format(tmp, sizeof(tmp), Text1, name); // - %s   
	   SendAllScriptText(tmp);
	}
	//   
    Event_EnterRace(playerid, /*numRace, */pos);
    return true;
}

//------------------------------------------------------------------------------

//   
DelRacer(playerid)
{
	new place;
	if(RaceStatus == 0) return 1;
	if(!isPlayerInAnyRace(playerid)) return 1;
	// 
    GetPlayerPlace(playerid, place);
	isRacerFinished[place] = 2;
	if((RaceStatus == 1)  || (RaceStatus == 3))
	{
	   if(IsPlayerConnected(playerid) && (isBestRacersListEnabled != 0)) HideBestPlayersListForGamer(playerid);
	   if(GetPlayerState(playerid) != PLAYER_STATE_WASTED) TeleportRacerToExit(playerid);
	}
	// 
	if(IsPlayerConnected(playerid))
	{
	    Event_ExitRace(playerid/*, numRace*/);
	}
	if(((RaceStatus == 1) || (RaceStatus == 3)) && (playerid == IDRaceOperator)) DelRace();
	//,  
	new num = GetNumberRacers();
	if(num == 0)
	{
	    DelRace();
    }
	return 1;
}

//------------------------------------------------------------------------------

// 
DelRace()
{
	if(RaceStatus == 0) return 0;
	if((RaceStatus == 1)  || (RaceStatus == 3))
	{
		for(new i = NUMBER_START_POS_FOR_RACE - 1; i >= 0; i--)
		{
			if((PositionOccup[i] != -1) && (isRacerFinished[i] == 0))
			{
                isRacerFinished[i] = 2;
	            if(IsPlayerConnected(PositionOccup[i]))
	            {
				   if(isBestRacersListEnabled != 0) HideBestPlayersListForGamer(PositionOccup[i]);
				   if(GetPlayerState(PositionOccup[i]) != PLAYER_STATE_WASTED) TeleportRacerToExit(PositionOccup[i]);
				   Event_ExitRace(PositionOccup[i]/*, numRace*/);
				}
			}
		}
		RaceStatus = 0; 
	}
	if(RaceStatus == 2)
	{
        for(new i = NUMBER_START_POS_FOR_RACE - 1; i >= 0; i--)
		{
			if((PositionOccup[i] != -1) && (isRacerFinished[i] == 0))
			{
                isRacerFinished[i] = 2;
				if(IsPlayerConnected(PositionOccup[i]))
	            {
                    Event_ExitRace(PositionOccup[i]/*, numRace*/);
                }
			}
		}
		RaceStatus = 0; 
		//   ,   
		if(isBestRacersListEnabled != 0)
		    if(IsStatChange != 0) UpdateInfoFile(NUMBER_RACE);
	}
	Event_DeleteRace(/*numRace, */);
	return 1;
}

//------------------------------------------------------------------------------

// ( )
RunRace()
{
	if(RaceStatus != 3) return;
	for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	{
		if((PositionOccup[i] != -1) && (isRacerFinished[i] == 0))
		{
            ShowCheckPoint(PositionOccup[i], i);
            if(IsPlayerInAnyVehicle(PositionOccup[i]))
               TogglePlayerControlInVechicle(GetPlayerVehicleID(PositionOccup[i]), 1);
            else TogglePlayerControllable(PositionOccup[i], 1);
            if(isBestRacersListEnabled != 0)
                HideBestPlayersListForGamer(PositionOccup[i]);
		}
	}
	RaceStatus = 2;
	Event_StartRace(/*numRace*/);
}

//------------------------------------------------------------------------------

//     (   )
IsPlayerInRace(playerid)
{
	if(RaceStatus == 0) return 0;
	for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	{
	   if((PositionOccup[i] == playerid) && (isRacerFinished[i] == 0)) return 1;
	}
	return 0;
}

//------------------------------------------------------------------------------

//   
GetPlayerPlace(playerid, &place)
{
	for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	{
	    if(PositionOccup[i] == playerid)
	    {
		   place = i;
		   return 1;
	    }
	}
	return 0;
}

//------------------------------------------------------------------------------

// ,    
GetNumberRacers()
{
	new number = 0;
	for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	{
		if((PositionOccup[i] != -1) && (isRacerFinished[i] == 0)) number++;
	}
	return number;
}

//------------------------------------------------------------------------------
//   
public Otschet()
{
	new str[10];
	if(RaceStatus == 0)
	{
        KillTimer(TimerID);
	}
	if(TekOtshet>=0)
	{
	    format(str, sizeof(str), "%d", TekOtshet);
        SendRacersGameText(str);
        if(isSoundsEnabled != 0) PlaySoundForRacers(sound_StartRace1);
	}
	if(TekOtshet == 0)
	{
         if(isSoundsEnabled != 0) PlaySoundForRacers(sound_StartRace2);
		 RunRace();
		 SendRacersGameText(Text10);
		 KillTimer(TimerID);
	}
	TekOtshet--;
}

//------------------------------------------------------------------------------
//   
public Timer_Timeout(start_time)
{
	if((start_time == StartTime) && (RaceStatus == 2))
	{
         DelRace();
         SendAllScriptText(Text160);
	}
}

//------------------------------------------------------------------------------

//  
RunOtschet()
{
	if(RaceStatus == 3) return;
    SendAllScriptText(Text20);
    TekOtshet = maxOtsch;
    RaceStatus = 3;
    TimerID = SetTimer("Otschet", 1000, 1);
}

//------------------------------------------------------------------------------

//    
TeleportRacerToStart(playerid, position)
{
     if(!IsCarTypeCorrectly(playerid, NUMBER_RACE))
     {
         SendPlayerScriptText(playerid, Text13); //    
         return 0;
     }
     if(IsPlayerInAnyVehicle(playerid))
     {
	    new vechID = GetPlayerVehicleID(playerid);
        VechicleTeleport1(vechID, PositionBase[position][0], PositionBase[position][1], PositionBase[position][2], PositionBase[position][3], RaceInteriorID);
        TogglePlayerControlInVechicle(vechID, 0);
	 }
	 else
	 {
         SetPlayerPos(playerid, PositionBase[position][0], PositionBase[position][1], PositionBase[position][2]);
         SetPlayerFacingAngle(playerid, PositionBase[position][3]);
         SetPlayerInterior(playerid, RaceInteriorID);
         TogglePlayerControllable(playerid, 0);
         SetCameraBehindPlayer(playerid);
	 }
	 //      ,   
	 new Menu:tmpMenu = GetPlayerMenu(playerid);
	 if(IsValidMenu(tmpMenu)) HideMenuForPlayer(tmpMenu, playerid);
	 //
	 PositionOccup[position] = playerid;
	 isRacerFinished[position] = 0;
	 NumberRacersOnStart++;
	 if(isBestRacersListEnabled != 0)
	     ShowBestPlayersListForGamer(playerid);
	 return 1;
}

//------------------------------------------------------------------------------

//   
TeleportRacerToExit(playerid)
{
	 if((RaceStatus == 1) || (RaceStatus == 3)) NumberRacersOnStart--;
     if(IsPlayerConnected(playerid))
	 {
	     DisablePlayerRaceCheckpoint(playerid);
	     if((RaceStatus == 1) || (RaceStatus == 3))
	     {
             new i = minrandom(0, siz_QuitPlace);
	         if(i > siz_QuitPlace - 1) i = siz_QuitPlace-1;
	         new vechID;
             if(IsPlayerInAnyVehicle(playerid))
	         {
                 vechID = GetPlayerVehicleID(playerid);
                 VechicleTeleport1(vechID, QuitPlace[i][0], QuitPlace[i][1], QuitPlace[i][2], QuitPlace[i][3], 0);
                 TogglePlayerControlInVechicle(vechID, 1);
	         }
	         else
	         {
                 SetPlayerPos(playerid, QuitPlace[i][0], QuitPlace[i][1], QuitPlace[i][2]);
                 SetPlayerFacingAngle(playerid, QuitPlace[i][3]);
                 SetPlayerInterior(playerid, 0);
                 TogglePlayerControllable(playerid, 1);
	         }
	     }
	     SetCameraBehindPlayer(playerid);
	 }
     return 1;
}


//      
TeleportRacerToExitAnyway(playerid)
{
     if(IsPlayerConnected(playerid))
	 {
	     DisablePlayerRaceCheckpoint(playerid);
             new i = minrandom(0, siz_QuitPlace);
	         if(i > siz_QuitPlace - 1) i = siz_QuitPlace-1;
	         new vechID;
             if(IsPlayerInAnyVehicle(playerid))
	         {
                 vechID = GetPlayerVehicleID(playerid);
                 VechicleTeleport1(vechID, QuitPlace[i][0], QuitPlace[i][1], QuitPlace[i][2], QuitPlace[i][3], 0);
                 TogglePlayerControlInVechicle(vechID, 1);
	         }
	         else
	         {
                 SetPlayerPos(playerid, QuitPlace[i][0], QuitPlace[i][1], QuitPlace[i][2]);
                 SetPlayerFacingAngle(playerid, QuitPlace[i][3]);
                 SetPlayerInterior(playerid, 0);
                 TogglePlayerControllable(playerid, 1);
	         }
	     SetCameraBehindPlayer(playerid);
	 }
     return 1;
}
//------------------------------------------------------------------------------

//    
ShowCheckPoint(playerid, place)
{
	new simplyCP;
	new finishCP;
	if((TypeVechicle & Car_Type_Cons_Air) != 0 &&    //     ()
	   (TypeVechicle & Car_Type_Cons_Car) == 0 &&
	   (TypeVechicle & Car_Type_Cons_Heavy) == 0 &&
	   (TypeVechicle & Car_Type_Cons_Bike) == 0 &&
	   (TypeVechicle & Car_Type_Cons_Sea) == 0)
	{
        simplyCP = 3;
	    finishCP = 4;
	}
	else
	{
        simplyCP = 1;
	    finishCP = 0;
	}
	if(MainCheck[place] == (NUMBER_CHECKPOINTS_FOR_RACE-1))
	{
	    SetPlayerRaceCheckpoint(playerid, simplyCP, CheckPointBase[MainCheck[place]][0], CheckPointBase[MainCheck[place]][1], CheckPointBase[MainCheck[place]][2], CheckPointBase[MainCheck[place]][0], CheckPointBase[MainCheck[place]][1], CheckPointBase[MainCheck[place]][2],CheckPointBase[MainCheck[place]][3]);
	}
	else SetPlayerRaceCheckpoint(playerid, finishCP, CheckPointBase[MainCheck[place]][0], CheckPointBase[MainCheck[place]][1], CheckPointBase[MainCheck[place]][2], CheckPointBase[MainCheck[place]+1][0], CheckPointBase[MainCheck[place]+1][1], CheckPointBase[MainCheck[place]+1][2],CheckPointBase[MainCheck[place]][3]);
	return 1;
}

//------------------------------------------------------------------------------

//      
GetFreePlace(&place)
{
	for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	{
		if((PositionOccup[i] == -1) || (isRacerFinished[i] == 2))
		{
			place = i;
			return 1;
		}
	}
	return 0;
}
//------------------------------------------------------------------------------

//,     .
public UpdateCPTimer()
{
    new place;
	if(RaceStatus!=2) return;
	for(new i=0; i<=MaxPlayerID; i++)
	{
	    if(GetPlayerPlace(i, place)) 
	    {
	       if(isRacerFinished[place] == 0) 
	       {
	          ShowCheckPoint(i, place);
	       }
	    }
	}
}

//------------------------------------------------------------------------------

IsCarTypeCorrectly(playerid, numRout)
{
	if(!IsPlayerInAnyVehicle(playerid)) return (GetBit(vechTypesForRouts[numRout], 8) == 1);
	new vechID = GetPlayerVehicleID(playerid);
	new modelID = GetVehicleModel(vechID);
    if((modelID == 538) || (modelID == 449)) return 0;
    new vechType = GetVehicleType(vechID);
    switch(vechType)
	{
	   case VTYPE_CAR: return (GetBit(vechTypesForRouts[numRout], 7) == 1);
	   case VTYPE_HEAVY: return (GetBit(vechTypesForRouts[numRout], 6) == 1);
	   case VTYPE_BIKE: return (GetBit(vechTypesForRouts[numRout], 5) == 1);
	   case VTYPE_AIR: return (GetBit(vechTypesForRouts[numRout], 4) == 1);
	   case VTYPE_SEA: return (GetBit(vechTypesForRouts[numRout], 3) == 1);
    }
    return 0;
    
}
//------------------------------------------------------------------------------

PlayerPosOnCP(place)
{
	new pos = 1;
	for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	{
		 if((MainCheck[i] >= MainCheck[place]) && (i != place) && (PositionOccup[i] != -1)) pos++;
	}
	return pos;
}

//------------------------------------------------------------------------------

SendRacersGameText(const str[])
{
	 for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	 {
         if(PositionOccup[i] != -1)
            if(isRacerFinished[i] == 0)
            {
               GameTextForPlayer(PositionOccup[i], str, 2000, 3);
		    }
	 }
}

//------------------------------------------------------------------------------

SendRacersText(const str[])
{
	 if(ShowRaceTextForAll != 0)
		 SendAllScriptText(str);
	 else
	     for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	     {
             if(PositionOccup[i] != -1)
             {
                 SendPlayerScriptText(PositionOccup[i], str);
		     }
	     }
}

//------------------------------------------------------------------------------

PlaySoundForRacers(soundID)
{
     for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	 {
         if(PositionOccup[i] != -1)
         {
              PlayPlayerSound(PositionOccup[i], soundID);
		 }
	 }
}

//------------------------------------------------------------------------------

PlaySoundForAllPlayers(soundID)
{
	 for(new i = 0; i <= MaxPlayerID; i++)
	 {
		 if(IsPlayerConnected(i))
		 {
             PlayPlayerSound(i, soundID);
		 }
	 }
}

//------------------------------------------------------------------------------
//  , ,    (..    )
isPlayerInAnyRace(playerid)
{
     for(new i = 0; i < NUMBER_START_POS_FOR_RACE; i++)
	 {
         if(PositionOccup[i] == playerid)
		    if(isRacerFinished[i] == 0) return 1;
	 }
	 return 0;
}

//------------------------------------------------------------------------------

GetTickCountEx()
{
   if(isLinux) return ticks;
   else return tickcount();
}

public UpdateTicks()
{
    ticks += tickDelay;
}


//------------------------------------------------------------------------------

Event_CreateRace(/*numRace, */numRout, routDistance, numCP, numSP, Rname[])
{
     gettime(routCreateH, routCreateM, routCreateS);
	 new tmp[255];
	 format(tmp, sizeof(tmp), Text165, numRout, RaceName); //  %d (: `%s`)
	 SendAllScriptText(tmp);/*
	 new dis[256];
	 dis = DistanceToTexts(float(routDistance));*/
	 if(LongCreateRaceInfo != 0)
	 {
	    format(tmp, sizeof(tmp), Text166, routDistance, numCP, numSP, RoutTimeout); // : %d; (%d ,  %d ). : %d 
	    SendAllScriptText(tmp);
	    format(tmp, sizeof(tmp), Text163, numLoads, AddRoutDate); // %d-   ( : %s)
	    SendAllScriptText(tmp);
        SendAllScriptText(Text164); // /inrace,    
     }
     if(isSoundsEnabled != 0) PlaySoundForAllPlayers(sound_LoadRace);
     if(isEventEnabled != 0)
        CallRemoteFunction("sERace_CreateRaceEx", "dddds", numRout, routDistance, numCP, numSP, Rname);
}

Event_StartRace(/*numRace*/)
{
     StartTime = GetTickCountEx();
     gettime(routCreateH, routCreateM, routCreateS);
	 SetTimerEx("Timer_Timeout", RoutTimeout*60*1000, 0, "%d", StartTime);
     SendAllScriptText(Text9); // !!!
     if(isEventEnabled != 0)
        CallRemoteFunction("sERace_StartRace", "");
}

Event_DeleteRace(/*numRace, */)
{
     SendAllScriptText(Text4); // 
     if(isSoundsEnabled != 0) PlaySoundForAllPlayers(sound_DeleteRace);
     if(isEventEnabled != 0)
        CallRemoteFunction("sERace_DeleteRace", "");
}

Event_RacerKilled(playerid, killerid)
{
     if(isEventEnabled != 0)
        CallRemoteFunction("sERace_RacerKilled", "dd", playerid, killerid);
}

Event_EnterRace(playerid, /*numRace, */position)
{
     new name[30];
     new tmp[255];
     new numRacers = GetNumberRacers();
     GetPlayerName(playerid, name, sizeof(name));
     SendPlayerScriptText(playerid, Text6); //   !!!  
	 format(tmp, sizeof(tmp), Text14, NUMBER_RACE, RaceName); //    %d (%s)
	 SendPlayerScriptText(playerid, tmp);
	 format(tmp, sizeof(tmp), Text29, RaceAutor); //"  - %s"
	 SendPlayerScriptText(playerid, tmp);
	 
	 format(tmp, sizeof(tmp), Text166, RoutDistance, NUMBER_CHECKPOINTS_FOR_RACE, NUMBER_START_POS_FOR_RACE, RoutTimeout); // : %d; (%d ,  %d ). : %d 
	 SendPlayerScriptText(playerid, tmp);
	 format(tmp, sizeof(tmp), Text163, numLoads, AddRoutDate); // %d-   ( : %s)
	 SendPlayerScriptText(playerid, tmp);
	    
     format(tmp, sizeof(tmp), Text2, name, position, numRacers, MAX_RACERS); // - %s      %d (%d  %d)
	 SendRacersText(tmp);
	 if(isSoundsEnabled != 0) PlaySoundForRacers(sound_EnterRace);
	 if(isEventEnabled != 0)
        CallRemoteFunction("sERace_EnterRace", "dd", playerid, position);
}

Event_ExitRace(playerid/*, numRace*/)
{
     new name[30];
     new tmp[255];
     DisablePlayerRaceCheckpoint(playerid);
     GetPlayerName(playerid, name, sizeof(name));
	 format(tmp, sizeof(tmp), Text3, name, GetNumberRacers()); // - %s   .  %d
	 SendRacersText(tmp);
	 if(isSoundsEnabled != 0) PlaySoundForRacers(sound_ExitRace);
	 if(isEventEnabled != 0)
        CallRemoteFunction("sERace_ExitRace", "d", playerid);
     TeleportRacerToExitAnyway(playerid);
}

Event_FinishInRace(playerid, /*numRace, */playerTime, pos)
{
    new name[30];
    new tmp[255];
    if(isSoundsEnabled != 0) PlayPlayerSound(playerid, sound_FinishRacer);
    DisablePlayerRaceCheckpoint(playerid);
    GetPlayerName(playerid, name, sizeof(name));
	format(tmp, sizeof(tmp), Text21, name, pos); // %s  %d - 
	SendRacersText(tmp);
	new t[256];
	t = TimeToTexts(playerTime);
	format(tmp, sizeof(tmp), Text22, t); //,   : %s
	SendRacersText(tmp);
	if(isBestRacersListEnabled != 0)
	    UpdateBestPlayersList(playerid, playerTime);
	//  --------------------------------------------------------------
	if(isSaveRaceResults !=0)
	{
	   new ttt[256];
	   new f[] = "FinRace.txt";
	   if(pos == 1)
	   {
	       if(!isFile(f)) CreateFile(f);
	       new day, month, year;
	       getdate(year, month, day);
	       format(ttt, sizeof(ttt), "Race Name: %50.50s; Date: %2.2d.%2.2d.%4.4d%d%d", RaceName, day, month, year, 1, 1);
	       ttt[79] = 13;
	       ttt[80] = 10;
	       WriteInFileToEnd(f, ttt);
	       format(ttt, sizeof(ttt), "Place_Name_____________________Time(ms)%d%d", 1, 1);
	       ttt[39] = 13;
	       ttt[40] = 10;
	       WriteInFileToEnd(f, ttt);
	   }
	   format(ttt, sizeof(ttt), "%5.5d_%24.24s %10.10d%d%d", pos, name, playerTime, 1, 1);
	   ttt[41] = 13;
	   ttt[42] = 10;
	   WriteInFileToEnd(f, ttt);
	}
	//   -------------------------------------------------------
	if(isEventEnabled != 0)
        CallRemoteFunction("sERace_FinishInRace", "dddd", playerid, playerTime, pos, NumberRacersOnStart);
    TeleportRacerToExitAnyway(playerid);
}
