
 #if defined _MyTime_included
	#endinput
#endif
#define _MyTime_included

forward IfSecondDateLarger(DateTime:MinDate, DateTime:MaxDate);
forward TimeToInt(ETime:input);
forward ETime:TimeBetweenTwoDate(DateTime:MinDate, DateTime:MaxDate);
forward TimeToStr(Time:input, out[], len);

enum DateTime
{
	 day,
	 mounth,
	 year,
	 hour,
	 minute,
	 second
}

enum ETime
{
     hour,
	 minute,
	 second
}

public IfSecondDateLarger(DateTime:MinDate, DateTime:MaxDate)
{
	 if(MaxDate[year] < MinDate[year]) return 0;
	 if(MaxDate[year] > MinDate[year]) return 1;
	 //  
	 if(MaxDate[mounth] < MinDate[mounth]) return 0;
	 if(MaxDate[mounth] > MinDate[mounth]) return 1;
	 //  
	 if(MaxDate[day] < MinDate[day]) return 0;
	 if(MaxDate[day] > MinDate[day]) return 1;
	 //  
	 if(MaxDate[hour] < MinDate[hour]) return 0;
	 if(MaxDate[hour] > MinDate[hour]) return 1;
	 //  
	 if(MaxDate[minute] < MinDate[minute]) return 0;
	 if(MaxDate[minute] > MinDate[minute]) return 1;
	 //  
	 if(MaxDate[second] < MinDate[second]) return 0;
	 return 1;
}

public TimeToInt(ETime:input)
{
	 return 3600 * input[hour] + 60 * input[minute] + input[second];
}

public ETime:TimeBetweenTwoDate(DateTime:MinDate, DateTime:MaxDate)
{
     if(!IfSecondDateLarger(MinDate, MaxDate)) return 0;
     new yr = MaxDate[year] - MinDate[year];
     new mh = MaxDate[mounth] - MinDate[mounth];
     if(mh < 0)
     {
		 yr--;
		 mh += 12;
     }
     new dy = MaxDate[day] - MinDate[day];
     if(dy < 0)
     {
		 mh--;
		 dy+=30;
     }
     new hr = MaxDate[hour] - MinDate[hour];
     if(hr < 0)
     {
		 dy--;
		 hr+=24;
     }
     new mn = MaxDate[minute] - MinDate[minute];
     if(mn < 0)
     {
		 hr--;
		 mn+=60;
     }
     new sc = MaxDate[second] - MinDate[second];
     if(sc < 0)
     {
		mn--;
		sc+=60;
     }
     /*
     new summaryDay = yr * 365 + mh * 30 + dy;
     new summaryHour = summaryDay * 24 + hr;
     new summaryMin = summaryHour * 60 + mn;
     new summarySec = summaryMin * 60 + sc;*/
     new ETime:t;
     t[hour] = ((yr*12 + mh)*30 + dy)*24 + hr;
     t[minute] = mn;
     t[second] = sc;
}

public TimeToStr(ETime:input, out[], len)
{
     out[0] = 0;
     new tmp[256];
     if(input[hour] !=0 ) format(out, len, "%d (); ", input[hour]);
     if(input[minute] !=0 ) format(tmp, sizeof(tmp), "%s%d ; ", out, input[minute]);
     format(out, len, "%s", tmp);
     if(input[second] !=0 ) format(tmp, sizeof(tmp), "%s%d ; ", out, input[second]);
     format(out, len, "%s", tmp);
     if(strlen(out) == 0) format(out, len, "%s", "0 ");
}
