/* EKup file functions
 *
 * (c) Copyright 2007, EKup
 * This file is provided as is (no warranties).
 */
 
 /*     
  *   ,     .
  */
  
#if defined _EKup_files_included
  #endinput
#endif
#define _EKup_files_included

#include <fun_EKup>

forward OpenFile(name[], &File:fil);
forward CloseFile(File:fil);
forward WriteInFile(File:fil, const st[], sek);
forward WriteInFileToEnd(name[], st[]);
forward ReadFromFile(File:fil, sek, st[], length);
forward ReadFromFile2(name[], sek, st[], length);
forward isFile(name[]);
forward CreateFile(name[]);
forward GetSizeOfFile(File:fil);
forward FindStringInFile(name[], tmp[]);
forward ReadTextToEOS(name[], seek, tmp[]);
forward eDini_Get(filename[],key[], out[]);
forward eDini_Int(filename[],key[], &out);
forward eDini_Float(filename[],key[], &Float:out);



//-----------------------------------------------------------------------

/*   .
 *  0,   , 1 -   .
 * name -  
 * fil -    
 */
public OpenFile(name[], &File:fil)
{
     if(fexist(name))
	 {
  		fil = fopen(name, io_readwrite);
		return 1;
	 }
	 else
	 {
	    return 0;
     }
}

//------------------------------------------------------------------------------

/*   .
 *  0,   , 1 -   .
 * fil -   ,   
 */
public CloseFile(File:fil)
{
	 return fclose(fil);
}

//------------------------------------------------------------------------------

/*    .
 *    
 * fil -   
 * st - ,   
 * sek - ,    
 */
public WriteInFile(File:fil, const st[], sek)
{
	 fseek(fil, sek);
	 fwrite(fil, st);
	 return 1;
}

//------------------------------------------------------------------------------

/* ,    
 *    
 * fil -   
 * st - ,   
 */
public WriteInFileToEnd(name[], st[])
{
	 new File:f;
	 OpenFile(name, f);
	 fseek(f, 0, seek_end);
	 fwrite(f, st);
	 CloseFile(f);
	 return 1;
}

//------------------------------------------------------------------------------

/*    .
 *    
 * sek - ,    
 * st -    
 * length -   
 */
public ReadFromFile(File:fil, sek, st[], length)
{
	 new l = flength(fil);
	 if(sek > l) return 0;
     fseek(fil, sek,  seek_start);
     fread(fil, st, length+1);
     st[length] = 0;
     return 1;
}

public ReadFromFile2(name[], sek, st[], length)
{
     new File:fil;
     if(!OpenFile(name, fil)) return -1;
	 new l = flength(fil);
	 if(sek > l)
	 {
         CloseFile(fil);
	     return 0;
	 }
     fseek(fil, sek, seek_start);
     fread(fil, st, length+1);
     st[length] = 0;
     CloseFile(fil);
     return 1;
}

//    (       )
ReadConf(File:f, st[], siz, minLen=5)
{
   new tmp[256];
   while(fread(f, tmp))
   {
      if((strlen(tmp) < minLen) ||
	     ifStrStartedFromStr(tmp, "//") ||
		 ifStrStartedFromStr(tmp, "*")  ||
		 ifStrStartedFromStr(tmp, "#"))
		   continue;
	  format(st, siz, "%s", tmp);
	  return true;
   }
   return false;
}
#pragma unused ReadConf

//------------------------------------------------------------------------------

/* ,   
 *  1,   
 *  0   
 */
public isFile(name[])
{
     if(fexist(name))
	 {
		return 1;
	 }
	 else
	 {
	    return 0;
     }
}

//------------------------------------------------------------------------------

/* ,  
 *   ,  
 */
public CreateFile(name[])
{
	 new File:f;
     f = fopen(name, io_write);
	 CloseFile(f);
	 return 1;
}

//------------------------------------------------------------------------------

/* ,     
 */
public GetSizeOfFile(File:fil)
{
	 return flength(fil);
}

//------------------------------------------------------------------------------

/* ,      tmp     .
 *  (-1),   
 */

public FindStringInFile(name[], tmp[])
{
	new tmpLen = strlen(tmp);
	new tsek = 0;
	new buff[2];
	new File:fil;
    if(!OpenFile(name, fil)) return -1;
    //ReadFromFile(File:fil, sek, st[], length)
    
	while(ReadFromFile(fil, tsek, buff, 1))
	{
		if(buff[0] == tmp[0])
		{
             CloseFile(fil);
             if(!OpenFile(name, fil)) return -1;
			 for(new i = 1; i < tmpLen; i++)
			 {
				  if(!ReadFromFile(fil, tsek + i, buff, 1)) break;//i = tmpLen+10;
				  else if(buff[0] != tmp[i])
				       {
                          //tsek++;
				          //i = tmpLen+10;
				          break;
				       }
				       else if(i == tmpLen-1)
				            {
                                 //CloseFile(f);
				                 return tsek;
				            }
			 }
			 CloseFile(fil);
			 if(!OpenFile(name, fil)) return -1;
		}
		tsek++;
	}
	CloseFile(fil);
	return -1;
}
/*public FindStringInFile(name[], tmp[])
{
	new tmpLen = strlen(tmp);
	new tsek = 0;
	new buff[2];
	while(ReadFromFile2(name, tsek, buff, 1))
	{
		if(buff[0] == tmp[0])
		{
			 for(new i = 1; i < tmpLen; i++)
			 {
				  if(!ReadFromFile2(name, tsek + i, buff, 1)) break;//i = tmpLen+10;
				  else if(buff[0] != tmp[i])
				       {
                          //tsek++;
				          //i = tmpLen+10;
				          break;
				       }
				       else if(i == tmpLen-1)
				            {
                                 //CloseFile(f);
				                 return tsek;
				            }
			 }
		}
		tsek++;
	}
	//CloseFile(f);
	return -1;
}*/

//------------------------------------------------------------------------------

/* ,          
 */
public ReadTextToEOS(name[], seek, tmp[])
{
	new buff[2];
	new sk = 0;
	while(ReadFromFile2(name, seek + sk, buff, 1))
	{
		if(buff[0] == 13)
		{
             if(ReadFromFile2(name, seek + sk + 1, buff, 1))
			     if(buff[0] == 10)
				 {
					 tmp[sk] = 0;
					 //CloseFile(f);
				     return 1;
				 }
		}
		tmp[sk] = buff[0];
		sk++;
	}
	tmp[sk] = 0;
	//CloseFile(f);
	return 1;
}

//------------------------------------------------------------------------------

/* ,      key=tmp   tmp
 */

public eDini_Get(filename[],key[], out[])
{
    // ,       
    new temp[256];
    new k = 0; //     
	new i; //  ,   	
	if(ReadFromFile2(filename, 0, temp, strlen(key)))
	{
		 k = 1;
		 for(new m = 0; m < strlen(key); m++)
		 {
			 if(temp[m] != key[m])
			 {
				 k = 0; //     
				 break;
			 }
		 }
	}
	if(k == 1) i = 0;
	else
	{
	   new foundStr[256];
	   format(foundStr, sizeof(foundStr), "%d%d%s=", 1,1,key);
	   foundStr[0] = 13; foundStr[1] = 10;
	   i = FindStringInFile(filename, foundStr);
	   if(i == -1) return 0;
	}
	ReadTextToEOS(filename, i + 3 + strlen(key), out);
	return 1;
}

public eDini_Int(filename[],key[], &out)
{
	new tmp[256];
	if(!eDini_Get(filename,key, tmp)) return 0;
	out = strval(tmp);
	return 1;
}

public eDini_Float(filename[],key[], &Float:out)
{
	new tmp[256];
	if(!eDini_Get(filename,key, tmp)) return 0;
	out = floatstr(tmp);
	return 1;
}
