/*  SA:MP Functions for work with vechicles
 *      
 *   - EKup
 *  : 15.07.2007
 *  : 1.2
 */

#include <a_samp>

#if defined _vechicles_EKup_included
	#endinput
#endif
#define _vechicles_EKup_included


#define MAX_STRING 255
#define VTYPE_CAR 1
#define VTYPE_HEAVY 2
#define VTYPE_BIKE 3
#define VTYPE_AIR 4
#define VTYPE_SEA 5
#define MAX_PICKUPS 999


forward VehicleDriverID(vehicleid);                                                      //  
forward GetDistanceToCar(playerid,carid);                                                //  
forward GetClosestCar(playerid);                                                         //  
forward GetVehicles();                                                                   //  
forward VehicleDriverName(vehicleid, name[], len);                                       //  
forward IsPlayerPassenger(playerid);                                                     //   
forward IsPlayerDriver(playerid);                                                        //   
forward IsPlayerOnFoot(playerid);                                                        //   
forward IsPlayerOnBike(playerid);                                                        //   
forward IsPlayerOnBicycle(playerid);                                                     //   
forward IsPlayerInBoat(playerid);                                                        //    (, )
forward IsPlayerInHelicopter(playerid);                                                  //    
forward IsPlayerInMonsterTruck(playerid);                                                //    -
forward IsPlayerInPlane(playerid);                                                       //    
forward IsPlayerInQuad(playerid);                                                        //    Quad
forward IsPlayerInCar(playerid);                                                         //    
forward IsPlayerInTrain(playerid);                                                       //    
//IsPlayerInTaxi(playerid)
forward GetVehicleName(vehicleid, name[], len);                                          // 
forward GetVehicleName2(vehiclemodels, name[], len);                                     // 
//isVehmodelCorrectly(vModel)
forward IsVehicleConnected(vehicleid);                                                   //  
//isVehicleEmpty(vehicleid);                                                             //  
forward IsVehicleInUse(vehicleid);                                                       //     
forward GetVehicleType(vid);                                                             // 
//GetVehicleTypeName(vType)                                                              //  
forward VechicleTeleport1(vechID, Float:x, Float:y, Float:z, Float:ang, interiorID);     //   (  )
forward VechicleTeleport2(playerid, Float:x, Float:y, Float:z, Float:ang, interiorID);   //   (  )
forward TogglePlayerControlInVechicle(vechID, toggle);                                   ///     
forward SetPlayerVechicleHealth(playerid, Float:health);                                 // ""  
forward HealthPlayerVechicle(playerid);                                                  //  
forward SendMessageForPlayerInVech(vechID, color, message[]);                            //     



new vehicleNames[][] = {
   "Landstalker",
   "Bravura",
   "Buffalo",
   "Linerunner",
   "Pereniel",
   "Sentinel",
   "Dumper",
   "Firetruck",
   "Trashmaster",
   "Stretch",
   "Manana",
   "Infernus",
   "Voodoo",
   "Pony",
   "Mule",
   "Cheetah",
   "Ambulance",
   "Leviathan",
   "Moonbeam",
   "Esperanto",
   "Taxi",
   "Washington",
   "Bobcat",
   "Mr Whoopee",
   "BF Injection",
   "Hunter",
   "Premier",
   "Enforcer",
   "Securicar",
   "Banshee",
   "Predator",
   "Bus",
   "Rhino",
   "Barracks",
   "Hotknife",
   "Trailer", //artict1
   "Previon",
   "Coach",
   "Cabbie",
   "Stallion",
   "Rumpo",
   "RC Bandit",
   "Romero",
   "Packer",
   "Monster",
   "Admiral",
   "Squalo",
   "Seasparrow",
   "Pizzaboy",
   "Tram",
   "Trailer", //artict2
   "Turismo",
   "Speeder",
   "Reefer",
   "Tropic",
   "Flatbed",
   "Yankee",
   "Caddy",
   "Solair",
   "Berkley's RC Van",
   "Skimmer",
   "PCJ-600",
   "Faggio",
   "Freeway",
   "RC Baron",
   "RC Raider",
   "Glendale",
   "Oceanic",
   "Sanchez",
   "Sparrow",
   "Patriot",
   "Quad",
   "Coastguard",
   "Dinghy",
   "Hermes",
   "Sabre",
   "Rustler",
   "ZR3 50",
   "Walton",
   "Regina",
   "Comet",
   "BMX",
   "Burrito",
   "Camper",
   "Marquis",
   "Baggage",
   "Dozer",
   "Maverick",
   "News Chopper",
   "Rancher",
   "FBI Rancher",
   "Virgo",
   "Greenwood",
   "Jetmax",
   "Hotring",
   "Sandking",
   "Blista Compact",
   "Police Maverick",
   "Boxville",
   "Benson",
   "Mesa",
   "RC Goblin",
   "Hotring Racer", //hotrina
   "Hotring Racer", //hotrinb
   "Bloodring Banger",
   "Rancher",
   "Super GT",
   "Elegant",
   "Journey",
   "Bike",
   "Mountain Bike",
   "Beagle",
   "Cropdust",
   "Stunt",
   "Tanker", //petro
   "RoadTrain",
   "Nebula",
   "Majestic",
   "Buccaneer",
   "Shamal",
   "Hydra",
   "FCR-900",
   "NRG-500",
   "HPV1000",
   "Cement Truck",
   "Tow Truck",
   "Fortune",
   "Cadrona",
   "FBI Truck",
   "Willard",
   "Forklift",
   "Tractor",
   "Combine",
   "Feltzer",
   "Remington",
   "Slamvan",
   "Blade",
   "Freight",
   "Streak",
   "Vortex",
   "Vincent",
   "Bullet",
   "Clover",
   "Sadler",
   "Firetruck", //firela
   "Hustler",
   "Intruder",
   "Primo",
   "Cargobob",
   "Tampa",
   "Sunrise",
   "Merit",
   "Utility",
   "Nevada",
   "Yosemite",
   "Windsor",
   "Monster", //monstera
   "Monster", //monsterb
   "Uranus",
   "Jester",
   "Sultan",
   "Stratum",
   "Elegy",
   "Raindance",
   "RC Tiger",
   "Flash",
   "Tahoma",
   "Savanna",
   "Bandito",
   "Freight", //freiflat
   "Trailer", //streakc
   "Kart",
   "Mower",
   "Duneride",
   "Sweeper",
   "Broadway",
   "Tornado",
   "AT-400",
   "DFT-30",
   "Huntley",
   "Stafford",
   "BF-400",
   "Newsvan",
   "Tug",
   "Trailer", //petrotr
   "Emperor",
   "Wayfarer",
   "Euros",
   "Hotdog",
   "Club",
   "Trailer", //freibox
   "Trailer", //artict3
   "Andromada",
   "Dodo",
   "RC Cam",
   "Launch",
   "Police Car (LSPD)",
   "Police Car (SFPD)",
   "Police Car (LVPD)",
   "Police Ranger",
   "Picador",
   "S.W.A.T. Van",
   "Alpha",
   "Phoenix",
   "Glendale",
   "Sadler",
   "Luggage Trailer", //bagboxa
   "Luggage Trailer", //bagboxb
   "Stair Trailer", //tugstair
   "Boxville",
   "Farm Plow", //farmtr1
   "Utility Trailer" //utiltr1
};



public VehicleDriverID(vehicleid) //  
{
  new i;
  for (i=0;i<MAX_PLAYERS;i++)
  {
      if ((IsPlayerConnected(i))&&(GetPlayerVehicleID(i)==vehicleid)&&(GetPlayerState(i)==PLAYER_STATE_DRIVER))  return i;
  }
  return -1;
}

public GetDistanceToCar(playerid,carid) //  
{
	new Float:dis;
	new Float:x1,Float:y1,Float:z1,Float:x2,Float:y2,Float:z2;
	if (!IsPlayerConnected(playerid))
	{
	     return -1;
	}
	GetPlayerPos(playerid,x1,y1,z1);
	GetVehiclePos(carid,x2,y2,z2);
	dis = floatsqroot(floatpower(floatabs(floatsub(x2,x1)),2)+floatpower(floatabs(floatsub(y2,y1)),2)+floatpower(floatabs(floatsub(z2,z1)),2));
	return floatround(dis);
}

public GetClosestCar(playerid) //  
{
	if (!IsPlayerConnected(playerid))
	{
	     return -1;
	}
	new Float:prevdist = 100000.000;
	new prevcar;
	for (new carid = 0; carid < MAX_VEHICLES; carid++)
	{
        new Float:dist = GetDistanceToCar(playerid,carid);
	    if ((dist < prevdist))
		{
	         prevdist = dist;
	         prevcar = carid;
        }
	}
	return prevcar;
}

public GetVehicles() //  
{
    new maxv;
    new tmp;
    for(new i = 0; i < MAX_VEHICLES; i++)
	{
        tmp = GetVehicleModel(i);
        if(tmp!=0) maxv++;
    }
    return maxv;
}

public VehicleDriverName(vehicleid, name[], len) //  
{
     new playername[MAX_PLAYER_NAME];
     for(new i = 0; i < MAX_PLAYERS; i++)
	 {
         if(IsPlayerConnected(i))
	     {
             if(IsPlayerInVehicle(i,vehicleid))
			 {
                 GetPlayerName(i,playername,sizeof(playername));
                 format(name, len, "%s", playername);
                 return 1;
             }
         }
     }
     return 0;
}

public IsPlayerPassenger(playerid) //
{
    new playerstate = GetPlayerState(playerid);
    if(playerstate == PLAYER_STATE_PASSENGER) return 1;
    return 0;
}

public IsPlayerDriver(playerid) //
{
    new playerstate = GetPlayerState(playerid);
    if(playerstate == PLAYER_STATE_DRIVER) return 1;
    return 0;
}

public IsPlayerOnFoot(playerid) //
{
    new playerstate = GetPlayerState(playerid);
    if(playerstate == PLAYER_STATE_ONFOOT)return 1;
    return 0;
}

public IsPlayerOnBike(playerid) //
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
         new vehicleid = GetPlayerVehicleID(playerid);
         new vehiclemodel = GetVehicleModel(vehicleid);
         switch(vehiclemodel)
         {
             case 448:return 1;
             case 461:return 1;
             case 462:return 1;
             case 463:return 1;
             case 468:return 1;
             case 521:return 1;
             case 522:return 1;
             case 523:return 1;
             case 581:return 1;
             case 586:return 1;
         }
     }
     return 0;
}

public IsPlayerOnBicycle(playerid) //
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
              case 481:return 1;
              case 509:return 1;
              case 510:return 1;
          }
     }
     return 0;
}

public IsPlayerInBoat(playerid) // (, )
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
              case 430:return 1;
              case 446:return 1;
              case 452:return 1;
              case 453:return 1;
              case 454:return 1;
              case 472:return 1;
              case 473:return 1;
              case 484:return 1;
              case 493:return 1;
              case 595:return 1;
          }
     }
     return 0;
}

public IsPlayerInHelicopter(playerid) // 
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
              case 417:return 1;
              case 425:return 1;
              case 447:return 1;
              case 465:return 1;
              case 469:return 1;
              case 487:return 1;
              case 488:return 1;
              case 497:return 1;
              case 501:return 1;
              case 548:return 1;
              case 563:return 1;
          }
	 }
     return 0;
}

public IsPlayerInMonsterTruck(playerid) //-
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
              case 406:return 1;
              case 444:return 1;
              case 556:return 1;
              case 557:return 1;
 	      }
     }
     return 0;
}

public IsPlayerInPlane(playerid) //
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
              case 460:return 1;
              case 464:return 1;
              case 476:return 1;
              case 511:return 1;
              case 512:return 1;
              case 513:return 1;
              case 519:return 1;
              case 520:return 1;
              case 539:return 1;
              case 553:return 1;
              case 577:return 1;
              case 592:return 1;
              case 593:return 1;
          }
     }
     return 0;
}

public IsPlayerInQuad(playerid) //Quad
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
               case 471:return 1;
          }
     }
     return 0;
}

public IsPlayerInTrain(playerid) //
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
               case 537:return 1;
               case 538:return 1;
          }
     }
     return 0;
}

IsPlayerInTaxi(playerid)
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
               case 420:return 1;
               //case 538:return 1;
          }
     }
     return 0;
}
#pragma unused IsPlayerInTaxi

public IsPlayerInCar(playerid) // 
{
     if(IsPlayerInAnyVehicle(playerid))
	 {
          new vehicleid = GetPlayerVehicleID(playerid);
          new vehiclemodel = GetVehicleModel(vehicleid);
          switch(vehiclemodel)
          {
              case 448:return 0;
              case 461:return 0;
              case 462:return 0;
              case 463:return 0;
              case 468:return 0;
              case 521:return 0;
              case 522:return 0;
              case 523:return 0;
              case 581:return 0;
              case 586:return 0;
              case 481:return 0;
              case 509:return 0;
              case 510:return 0;
              case 430:return 0;
              case 446:return 0;
              case 452:return 0;
              case 453:return 0;
              case 454:return 0;
              case 472:return 0;
              case 473:return 0;
              case 484:return 0;
              case 493:return 0;
              case 595:return 0;
              case 417:return 0;
              case 425:return 0;
              case 447:return 0;
              case 465:return 0;
              case 469:return 0;
              case 487:return 0;
              case 488:return 0;
              case 497:return 0;
              case 501:return 0;
              case 548:return 0;
              case 563:return 0;
              case 406:return 0;
              case 444:return 0;
              case 556:return 0;
              case 557:return 0;
              case 573:return 0;
              case 460:return 0;
              case 464:return 0;
              case 476:return 0;
              case 511:return 0;
              case 512:return 0;
              case 513:return 0;
              case 519:return 0;
              case 520:return 0;
              case 539:return 0;
              case 553:return 0;
              case 577:return 0;
              case 592:return 0;
              case 593:return 0;
              case 471:return 0;
          }
          return 1;
	 }
	 return 0;
}

public GetVehicleName(vehicleid, name[], len) // 
{
     new vehiclemodels = GetVehicleModel(vehicleid);
     new num = vehiclemodels - 400;
	 format(name, len, "%s", vehicleNames[num]);
	 return 1;
}

public GetVehicleName2(vehiclemodels, name[], len) // 
{
     new num = vehiclemodels - 400;
	 format(name, len, "%s", vehicleNames[num]);
	 return 1;
}

isVehModelCorrectly(vModel)
{
   if((vModel < 400) || (vModel > 611)) return false;
   return true;
}
#pragma unused isVehModelCorrectly

public IsVehicleConnected(vehicleid) //  
{
    new Float:x;
    new Float:y;
    new Float:z;
    GetVehiclePos(vehicleid, x, y, z);
    if(z != 0 && x!= 0 && y != 0) return 1;
    return 0;
}

public IsVehicleInUse(vehicleid) //    
{
    new vdid = VehicleDriverID(vehicleid);
    if(vdid != -1) return 1;
    return 0;
}

isVehicleEmpty(vehicleid) //  
{
   for(new i=0; i<MAX_PLAYERS; i++)
	  if(IsPlayerConnected(i) && IsPlayerInVehicle(i, vehicleid)) return false;
   return true;
}
#pragma unused isVehicleEmpty

public GetVehicleType(vid) // 
{
	new type;
	new carmodel =GetVehicleModel(vid);

	switch(carmodel) {
	// ================== CARS =================================================
	case
	416,   //ambulan  -  car
	445,   //admiral  -  car
	602,   //alpha  -  car
	485,   //baggage  -  car
	568,   //bandito  -  car
	429,   //banshee  -  car
	499,   //benson  -  car
	424,   //bfinject,   //car
	536,   //blade  -  car
	496,   //blistac  -  car
	504,   //bloodra  -  car
	422,   //bobcat  -  car
	609,   //boxburg  -  car
	498,   //boxville,   //car
	401,   //bravura  -  car
	575,   //broadway,   //car
	518,   //buccanee,   //car
	402,   //buffalo  -  car
	541,   //bullet  -  car
	482,   //burrito  -  car
	431,   //bus  -  car
	438,   //cabbie  -  car
	457,   //caddy  -  car
	527,   //cadrona  -  car
	483,   //camper  -  car
	524,   //cement  -  car
	415,   //cheetah  -  car
	542,   //clover  -  car
	589,   //club  -  car
	480,   //comet  -  car
	596,   //copcarla,   //car
	599,   //copcarru,   //car
	597,   //copcarsf,   //car
	598,   //copcarvg,   //car
	578,   //dft30  -  car
	486,   //dozer  -  car
	507,   //elegant  -  car
	562,   //elegy  -  car
	585,   //emperor  -  car
	427,   //enforcer,   //car
	419,   //esperant,   //car
	587,   //euros  -  car
	490,   //fbiranch,   //car
	528,   //fbitruck,   //car
	533,   //feltzer  -  car
	544,   //firela  -  car
	407,   //firetruk,   //car
	565,   //flash  -  car
	455,   //flatbed  -  car
	530,   //forklift,   //car
	526,   //fortune  -  car
	466,   //glendale,   //car
	604,   //glenshit,   //car
	492,   //greenwoo,   //car
	474,   //hermes  -  car
	434,   //hotknife,   //car
	502,   //hotrina  -  car
	503,   //hotrinb  -  car
	494,   //hotring  -  car
	579,   //huntley  -  car
	545,   //hustler  -  car
	411,   //infernus,   //car
	546,   //intruder,   //car
	559,   //jester  -  car
	508,   //journey  -  car
	571,   //kart  -  car
	400,   //landstal,   //car
	403,   //linerun  -  car
	517,   //majestic,   //car
	410,   //manana  -  car
	551,   //merit  -  car
	500,   //mesa  -  car
	418,   //moonbeam,   //car
	572,   //mower  -  car
	423,   //mrwhoop  -  car
	516,   //nebula  -  car
	582,   //newsvan  -  car
	467,   //oceanic  -  car
	404,   //peren  -  car
	514,   //petro  -  car
	603,   //phoenix  -  car
	600,   //picador  -  car
	413,   //pony  -  car
	426,   //premier  -  car
	436,   //previon  -  car
	547,   //primo  -  car
	489,   //rancher  -  car
	441,   //rcbandit,   //car
	594,   //rccam  -  car
	564,   //rctiger  -  car
	515,   //rdtrain  -  car
	479,   //regina  -  car
	534,   //remingtn,   //car
	505,   //rnchlure,   //car
	442,   //romero  -  car
	440,   //rumpo  -  car
	475,   //sabre  -  car
	543,   //sadler  -  car
	605,   //sadlshit,   //car
	495,   //sandking,   //car
	567,   //savanna  -  car
	428,   //securica,   //car
	405,   //sentinel,   //car
	535,   //slamvan  -  car
	458,   //solair  -  car
	580,   //stafford,   //car
	439,   //stallion,   //car
	561,   //stratum  -  car
	409,   //stretch  -  car
	560,   //sultan  -  car
	550,   //sunrise  -  car
	506,   //supergt  -  car
	601,   //swatvan  -  car
	574,   //sweeper  -  car
	566,   //tahoma  -  car
	549,   //tampa  -  car
	420,   //taxi  -  car
	459,   //topfun  -  car
	576,   //tornado  -  car
	583,   //tug  -  car
	451,   //turismo  -  car
	558,   //uranus  -  car
	552,   //utility  -  car
	540,   //vincent  -  car
	491,   //virgo  -  car
	412,   //voodoo  -  car
	478,   //walton  -  car
	421,   //washing  -  car
	529,   //willard  -  car
	555,   //windsor  -  car
	456,   //yankee  -  car
	554,   //yosemite,   //car
	477   //zr3	50  -  car
	: type = VTYPE_CAR;

// ================== BIKES ====================================================
	case
	581,   //bf400  -  bike
	523,   //copbike  -  bike
	462,   //faggio  -  bike
	521,   //fcr900  -  bike
	463,   //freeway  -  bike
	522,   //nrg500  -  bike
	461,   //pcj600  -  bike
	448,   //pizzaboy,   //bike
	468,   //sanchez  -  bike
	586,   //wayfarer,   //bike
	509,   //bike  -  bmx
	481,   //bmx  -  bmx
	510,   //mtbike  -  bmx
	471   //quad  -  quad
	: type = VTYPE_BIKE;

// ================== SEA ======================================================
	case
	472,   //coastg  -  boat
	473,   //dinghy  -  boat
	493,   //jetmax  -  boat
	595,   //launch  -  boat
	484,   //marquis  -  boat
	430,   //predator,   //boat
	453,   //reefer  -  boat
	452,   //speeder  -  boat
	446,   //squalo  -  boat
	454   //tropic  -  boat
	: type = VTYPE_SEA;

// ================== AIR ======================================================
	case
	548,   //cargobob,   //heli
	425,   //hunter  -  heli
	417,   //leviathn,   //heli
	487,   //maverick,   //heli
	497,   //polmav  -  heli
	563,   //raindanc,   //heli
	501,   //rcgoblin,   //heli
	465,   //rcraider,   //heli
	447,   //seaspar  -  heli
	469,   //sparrow  -  heli
	488,   //vcnmav  -  heli
	592,   //androm  -  plane
	577,   //at	400  -  plane
	511,   //beagle  -  plane
	512,   //cropdust,   //plane
	593,   //dodo  -  plane
	520,   //hydra  -  plane
	553,   //nevada  -  plane
	464,   //rcbaron  -  plane
	476,   //rustler  -  plane
	519,   //shamal  -  plane
	460,   //skimmer  -  plane
	513,   //stunt  -  plane
	539   //vortex  -  plane
	: type = VTYPE_AIR;

// ================== HEAVY ====================================================
	case
	588,   //hotdog  -  car
	437,   //coach  -  car
	532,   //combine  -  car
	433,   //barracks,   //car
	414,   //mule  -  car
	443,   //packer  -  car
	470,   //patriot  -  car
	432,   //rhino  -  car
	525,   //towtruck,   //car
	531,   //tractor  -  car
	408,   //trash  -  car
	406,   //dumper  -  mtruck
	573,   //duneride,   //mtruck
	444,   //monster  -  mtruck
	556,   //monstera,   //mtruck
	557,   //monsterb,   //mtruck
	435,   //artict1  -  trailer
	450,   //artict2  -  trailer
	591,   //artict3  -  trailer
	606,   //bagboxa  -  trailer
	607,   //bagboxb  -  trailer
	610,   //farmtr1  -  trailer
	584,   //petrotr  -  trailer
	608,   //tugstair,   //trailer
	611,   //utiltr1  -  trailer
	590,   //freibox  -  train
	569,   //freiflat,   //train
	537,   //freight  -  train
	538,   //streak  -  train
	570,   //streakc  -  train
	449   //tram  -  train
	: type = VTYPE_HEAVY;
	}
	return type;
}

GetVehicleTypeName(vType)
{
   new tmp[256];
   switch(vType)
   {
	  case VTYPE_CAR: format(tmp, sizeof(tmp), "%s", "  ");
	  case VTYPE_HEAVY: format(tmp, sizeof(tmp), "%s", " '' ");
	  case VTYPE_BIKE: format(tmp, sizeof(tmp), "%s", " /");
	  case VTYPE_AIR: format(tmp, sizeof(tmp), "%s", "  ");
	  case VTYPE_SEA: format(tmp, sizeof(tmp), "%s", "  ");
	  default: format(tmp, sizeof(tmp), "%s", " ");
   }
   return tmp;
}
#pragma unused GetVehicleTypeName

//   (  )
public VechicleTeleport1(vechID, Float:x, Float:y, Float:z, Float:ang, interiorID)
{
	new tID = -1;
	if(IsTrailerAttachedToVehicle(vechID)) tID = GetVehicleTrailer(vechID);
    SetVehiclePos(vechID, x, y, z);
    SetVehicleZAngle(vechID, ang);
    LinkVehicleToInterior(vechID, interiorID);
    if(tID != -1)
    {
         AttachTrailerToVehicle(tID, vechID);
         LinkVehicleToInterior(tID, interiorID);
    }
    for(new i = 0; i < MAX_PLAYERS; i++)
    {
		 if(IsPlayerInVehicle(i, vechID))
		 {
		    SetPlayerInterior(i, interiorID);
		    SetCameraBehindPlayer(i);
		 }
    }
    return 1;
}

//   (  )
public VechicleTeleport2(playerid, Float:x, Float:y, Float:z, Float:ang, interiorID)
{
	if(!IsPlayerInAnyVehicle(playerid))
	{
        SetPlayerPos(playerid, x, y, z);
        SetPlayerFacingAngle(playerid, ang);
        SetPlayerInterior(playerid, interiorID);
	    return 1;
	}
	new vechID = GetPlayerVehicleID(playerid);
	return VechicleTeleport1(vechID, x, y, z, ang, interiorID);
}

///     
public TogglePlayerControlInVechicle(vechID, toggle)
{
    for(new i = 0; i < MAX_PLAYERS; i++)
    {
		 if(IsPlayerInVehicle(i, vechID)) TogglePlayerControllable(i, toggle);
    }
}

// ""  
public SetPlayerVechicleHealth(playerid, Float:health)
{
	if(!IsPlayerInAnyVehicle(playerid)) return 0;
	new tmp = GetPlayerVehicleID(playerid);
	SetVehicleHealth(tmp, health);
	return 1;
}

//  
public HealthPlayerVechicle(playerid)
{
	return SetPlayerVechicleHealth(playerid, 1000.0);
}

public SendMessageForPlayerInVech(vechID, color, message[])
{
   for(new i = 0; i < MAX_PLAYERS; i++)
    {
		 if(IsPlayerInVehicle(i, vechID))
		 {
		    SendClientMessage(i, color, message);
		 }
    }
}

removeAllFromVehicle(vechID)
{
	for(new i=0; i<MAX_PLAYERS; i++)
	   if(IsPlayerConnected(i))
		   if(IsPlayerInVehicle(i, vechID)) RemovePlayerFromVehicle(i);
}
#pragma unused removeAllFromVehicle

removeAllFromVehicleEx(vechID)
{
	new Float:xx, Float:yy, Float:zz;
	for(new i=0; i<MAX_PLAYERS; i++)
	   if(IsPlayerConnected(i))
		   if(IsPlayerInVehicle(i, vechID))
		   {
		       RemovePlayerFromVehicle(i);
		       GetPlayerPos(i, xx, yy, zz);
		       SetPlayerPos(i, xx, yy, zz+2.0);
		   }
}
#pragma unused removeAllFromVehicleEx

IsPlayerVechHaveTrailer(playerid)
{
	if(!IsPlayerConnected(playerid)) return false;
	if(!IsPlayerInAnyVehicle(playerid)) return false;
	return IsTrailerAttachedToVehicle(GetPlayerVehicleID(playerid));
}
#pragma unused IsPlayerVechHaveTrailer

GetPlayerCarName(playerid)
{
   new tmp[256];
   tmp[0]=0;
   if(IsPlayerConnected(playerid))
	  if(IsPlayerInAnyVehicle(playerid))
         GetVehicleName(GetPlayerVehicleID(playerid), tmp, sizeof(tmp));
      else format(tmp, sizeof(tmp), "%s", "On foot");
   return tmp;
}
#pragma unused GetPlayerCarName
