//   .   ,  
checkDB(patch[])//0 -  ; -1 -  ; -2 -   ; >0 -   ( )
{
   if(!fexist(patch)) return 0;
   base = db_open(DBPatch);
   new DBResult:myresult;
   myresult = db_query(base, "SELECT * FROM baseInfo");
   if(db_num_rows(myresult) == 0)
   {
     db_close(base);
     return -2;
   }
   new tmp[MAX_STRING];
   db_get_field_assoc(myresult, "DBVersion", tmp, sizeof(tmp));
   new vr = strval(tmp);
   if(vr <= 0)
   {
       db_close(base);
       return -2;
   }
   if(vr != DBVersion)
   {
      db_close(base);
      return vr;
   }
   new k=0;
   for(new i=0; i<maxNumBands; i++)
   {
	  format(tmp, sizeof(tmp), "SELECT * FROM bands WHERE id=%d", i);
	  myresult = db_query(base, tmp);
	  if(db_num_rows(myresult) == 0) 
	  {
          format(tmp, sizeof(tmp), "INSERT INTO bands (id, enabled) VALUES (%d, 0)", i);
          db_query(base, tmp);
          k++;
	  }
   }
   if(k!=0)
   {
	  format(tmp, sizeof(tmp), "  %d   ", k);
	  printf(tmp);
   }
   return -1;
}

DB_GetNumProfiles()
{
   new DBResult:result;
   new tmp[255];
   format(tmp, sizeof(tmp), "SELECT count(id) FROM mainParam");
   SQlite_Select2(result, tmp);
   db_get_field(result, 0, tmp, sizeof(tmp));
   return strval(tmp);
}

isPlayerInDB(name[])
{
   if(GetPlayerIdInBD(name) != -1) return true;
   return false;
}

GetPlayerIdInBD(name[])//      -1
{
   new tmp[MAX_STRING];
   new name2[MAX_STRING];
   new DBResult:myresult;
   name2 = strlowerMy(name);
   format(tmp, sizeof(tmp), "SELECT id FROM mainParam WHERE lower(name)='%s'", name2);
   SQlite_Select2(myresult, tmp);
   if(db_num_rows(myresult) == 0) return -1;
   db_get_field_assoc(myresult, "id", tmp, sizeof(tmp));
   return strval(tmp);
}

GetProfilesByIP(ip[], &DBResult:result)
{
   new tmp[MAX_STRING];
   format(tmp, sizeof(tmp), "SELECT * FROM AllColumn WHERE ip='%s'", ip);
   SQlite_Select2(result, tmp);
}

findPlayer(name[], &DBResult:result)
{
   new tmp[MAX_STRING];
   new name2[MAX_STRING];
   name2 = strlowerMy(name);
   format(tmp, sizeof(tmp), "SELECT id, name FROM mainParam WHERE lower(name) LIKE '%s' LIMIT 0, 10", name2);
   SQlite_Select2(result, tmp);
}

GetPlayerInfoFromBdByID(id, &DBResult:result)
{
   new tmp[MAX_STRING];
   format(tmp, sizeof(tmp), "SELECT * FROM AllColumn WHERE id=%d", id);
   SQlite_Select2(result, tmp);
}

DeleteProfileFromBD(pID)
{
   new tmp[MAX_STRING];
   for(new i=0; i<maxNumBands; i++)
	 if((bands[i][enabled] != 0) && (bands[i][bMainID] == pID))
	 {
         format(tmp, sizeof(tmp), "  %s       .", bands[i][bName]);
         SendAllBandsText(tmp);
         SaveToLog(tmp, 7, i);
         DeleteBand(i);
     }
   for(new i=0; i<NumHouses; i++)
	 if((Houses[i][_isLoaded] != 0) && (Houses[i][_ownerType] == 1) && (Houses[i][_owner] == pID))
	 {
         HouseSell(i);
         format(tmp, sizeof(tmp), "  %d        (%d)", i, pID);
         SaveToLog(tmp, 10);
	 }
   format(tmp, sizeof(tmp), "DELETE FROM mainParam WHERE id=%d", pID);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "DELETE FROM secondParam WHERE id=%d", pID);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "DELETE FROM times WHERE id=%d", pID);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "DELETE FROM profileParam WHERE id=%d", pID);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "DELETE FROM eracingRecords WHERE playerBdID=%d", pID);
   DB_Update(tmp);
}

delOldProfiles(pTime)
{
        new DBResult:result;
        new qwr[256];
        new tmp[256];
        //    ,   
        format(qwr, sizeof(qwr), "LastActivityTimeNew<%d AND band>-1 AND bandStatus=0 LIMIT 0, 10", pTime);
        new numR = SQlite_Select(result, "id, band", qwr);
        new k=0;
        new id[50];
        new bandID[50];
        new numDeleted=0;
        while((numR>0) && (k<100))
        {
           for(new i=0; i<db_num_rows(result); i++)
           {
             db_get_field_assoc(result, "id", id, sizeof(id));
             db_get_field_assoc(result, "band", bandID, sizeof(bandID));
             format(tmp, sizeof(tmp), "  %s       .", bands[strval(bandID)][bName]);
             SaveToLog(tmp, 7, strval(bandID));
             DeleteBand(strval(bandID));
             numDeleted++;
             db_next_row(result);
           }
           db_free_result(result);
           numR = SQlite_Select(result, "id, band", qwr);
           k++;
        }
        if(k==300)
        {
			printf(" :       ,       (100)");
			return;
        }
        else printf("  : %d", numDeleted);
        k=0;
        numDeleted=0;
        // ,    
        format(qwr, sizeof(qwr), "LastActivityTimeNew<%d AND house>-1", pTime);
	    new houseID[50];
	    numR = SQlite_Select(result, "id, house", qwr);
	    while((numR>0) && (k<100))
        {
           for(new i=0; i<db_num_rows(result); i++)
           {
             db_get_field_assoc(result, "id", id, sizeof(id));
             db_get_field_assoc(result, "house", houseID, sizeof(houseID));
             HouseSell(strval(houseID));
             format(tmp, sizeof(tmp), "UPDATE mainParam SET house=-1 WHERE id=%s", id);
             DB_Update(tmp);
             numDeleted++;
             format(tmp, sizeof(tmp), "  %d        (%d)", strval(houseID), strval(id));
             SaveToLog(tmp, 10);
             db_next_row(result);
           }
           db_free_result(result);
           numR = SQlite_Select(result, "id, band", qwr);
           k++;
        }
        if(k==500)
        {
			printf(" :       ,       (100)");
			return;
        }
	    else printf("  : %d", numDeleted);
	    format(tmp, sizeof(tmp), "SELECT count(id) FROM AllColumn WHERE LastActivityTimeNew<%d", pTime);
	    SQlite_Select2(result, tmp);
	    db_get_field(result, 0, id, sizeof(id));
	    numDeleted = strval(id);
	    printf(" %d .... ", numDeleted);
	    // 
	    format(qwr, sizeof(qwr), "LastActivityTimeNew<%d LIMIT 0,10", pTime);
	    numR = SQlite_Select(result, "id", qwr);
	    k=0;
	    while((numR>0) && (k<100))
	    {
           for(new i=0; i<db_num_rows(result); i++)
           {
               db_get_field_assoc(result, "id", id, sizeof(id));
               DeleteProfileFromBD(strval(id));
               db_next_row(result);
           }
           db_free_result(result);
           numR = SQlite_Select(result, "id", qwr);
		   k++;
	       printf(" %d  %d", k, IntDiv(numDeleted, 10));
	    }
	    printf("    ");
}

ReadParamsFromErpgStatsTab1(&MPCount, &MPYear, &MPMouth, &MPDay, &MPHour, &MPMin, &MPSec)
{
   new tmp[MAX_STRING];
   new DBResult:myresult;
   if(SQlite_Select2(myresult, "SELECT * FROM erpgParam") == 0) return false;
   db_get_field_assoc(myresult, "max_players_count", tmp, sizeof(tmp));
   MPCount = strval(tmp);
   db_get_field_assoc(myresult, "max_players_Year", tmp, sizeof(tmp));
   MPYear = strval(tmp);
   db_get_field_assoc(myresult, "max_players_Mouth", tmp, sizeof(tmp));
   MPMouth = strval(tmp);
   db_get_field_assoc(myresult, "max_players_Day", tmp, sizeof(tmp));
   MPDay = strval(tmp);
   db_get_field_assoc(myresult, "max_players_Hour", tmp, sizeof(tmp));
   MPHour = strval(tmp);
   db_get_field_assoc(myresult, "max_players_Min", tmp, sizeof(tmp));
   MPMin = strval(tmp);
   db_get_field_assoc(myresult, "max_players_Sec", tmp, sizeof(tmp));
   MPSec = strval(tmp);
   return true;
}

ReadParamsFromErpgStatsTab2(&BDCreateTimeYear, &BDCreateTimeMouth, &BDCreateTimeDay, &BDCreateTimeHour, &BDCreateTimeMin, &BDCreateTimeSec)
{
   new tmp[MAX_STRING];
   new DBResult:myresult;
   if(SQlite_Select2(myresult, "SELECT * FROM erpgParam") == 0) return false;
   db_get_field_assoc(myresult, "create_time_year", tmp, sizeof(tmp));
   BDCreateTimeYear = strval(tmp);
   db_get_field_assoc(myresult, "create_time_Mouth", tmp, sizeof(tmp));
   BDCreateTimeMouth = strval(tmp);
   db_get_field_assoc(myresult, "create_time_Day", tmp, sizeof(tmp));
   BDCreateTimeDay = strval(tmp);
   db_get_field_assoc(myresult, "create_time_Hour", tmp, sizeof(tmp));
   BDCreateTimeHour = strval(tmp);
   db_get_field_assoc(myresult, "create_time_Min", tmp, sizeof(tmp));
   BDCreateTimeMin = strval(tmp);
   db_get_field_assoc(myresult, "create_time_Sec", tmp, sizeof(tmp));
   BDCreateTimeSec = strval(tmp);
   return true;
}

SaveMaxPlayersCount(count, y, m, d, h, mn, s)
{
   new tmp[MAX_STRING];
   format(tmp, sizeof(tmp), "UPDATE erpgParam SET max_players_count=%d, \
                                                  max_players_Year=%d, \
												  max_players_Mouth=%d, \
												  max_players_Day=%d, \
												  max_players_Hour=%d, \
												  max_players_Min=%d, \
												  max_players_Sec=%d", count, y, m, d, h, mn, s);
   DB_Update(tmp);
   return true;
}

LoadBands()
{
   new tmp[MAX_STRING];
   new DBResult:myresult;
   for(new i=0; i<maxNumBands; i++)
   {
       bands[i][bHouseID] = -1;
       format(tmp, sizeof(tmp), "SELECT * FROM bands WHERE id=%d", i);
       if(SQlite_Select2(myresult, tmp) == 0) bands[i][enabled] = 0;
       else
       {
           db_get_field_assoc(myresult, "enabled", tmp, sizeof(tmp));
           bands[i][enabled] = strval(tmp);
           if(bands[i][enabled] != 0)
           {
               db_get_field_assoc(myresult, "name", bands[i][bName], MaxBandName);
               db_get_field_assoc(myresult, "mainID", tmp, sizeof(tmp));
               bands[i][bMainID] = strval(tmp);
               db_get_field_assoc(myresult, "color", tmp, sizeof(tmp));
               bands[i][bColor] = strval(tmp);
               db_get_field_assoc(myresult, "moneys", tmp, sizeof(tmp));
               bands[i][bMoneys] = strval(tmp);
               db_get_field_assoc(myresult, "sumKills", tmp, sizeof(tmp));
               bands[i][bKills] = strval(tmp);
               db_get_field_assoc(myresult, "sumDeaths", tmp, sizeof(tmp));
               bands[i][bDeaths] = strval(tmp);/*
               db_get_field_assoc(myresult, "Reputation", tmp, sizeof(tmp));
               bands[i][bReputation] = strval(tmp);*/
               db_get_field_assoc(myresult, "bExp", tmp, sizeof(tmp));
               bands[i][bExp] = strval(tmp);
               bands[i][isChanged] = 0;
           }
       }
   }
   for(new i=0; i<maxNumBands; i++)
       for(new k=0; k<maxNumBands; k++)
		  if((k != i) &&(bands[i][enabled] != 0) && (bands[k][enabled] != 0))
		  {
            format(tmp, sizeof(tmp), "SELECT * FROM bRelations WHERE band1ID=%d AND band2ID=%d", i, k);
            if(SQlite_Select2(myresult, tmp) == 0)
            {
                 format(tmp, sizeof(tmp), "INSERT INTO bRelations (band1ID, band2ID, rDateStart) VALUES (%d, %d, '%d:%d:%d')", i, k, erpgInfo[BDCreateTime_Year], erpgInfo[BDCreateTime_Mouth], erpgInfo[BDCreateTime_Day]);
			     DB_Update(tmp);
            }
            else
            {
                db_get_field_assoc(myresult, "rDateStart", bandsRelations[i][k][dateUpdateStatus], Max_Date_Len);
                db_get_field_assoc(myresult, "rStatus", tmp, sizeof(tmp));
                bandsRelations[i][k][_status] = strval(tmp);
                db_get_field_assoc(myresult, "kills", tmp, sizeof(tmp));
                bandsRelations[i][k][_kills] = strval(tmp);
                bandsRelations[i][k][_oldKills] = strval(tmp);
                //_oldKills
            }
          }
}

UpdateBand(id)
{
   new tmp[MAX_STRING];
   format(tmp, sizeof(tmp), "UPDATE bands SET enabled=%d, \
                                              name='%s', \
                                              mainID=%d, \
											  color=%d, \
											  moneys=%d, \
											  sumKills=%d, \
											  sumDeaths=%d, \
											  bExp=%d WHERE id=%d", bands[id][enabled],
											                              bands[id][bName],
																		  bands[id][bMainID],
																		  bands[id][bColor],
																		  bands[id][bMoneys],
																		  bands[id][bKills],
																		  bands[id][bDeaths],
																		  bands[id][bExp],
																		  id);
   DB_Update(tmp);
   for(new k=1; k<maxNumBands; k++)
	  if((k!=id) && (bands[k][enabled] != 0))
		 if(bandsRelations[id][k][_kills] != bandsRelations[id][k][_oldKills])
		 {
               format(tmp, sizeof(tmp), "UPDATE bRelations SET kills=%d WHERE band1ID=%d AND band2ID=%d", bandsRelations[id][k][_kills], id, k);
               DB_Update(tmp);
               bandsRelations[id][k][_oldKills] = bandsRelations[id][k][_kills];
		 }
   bands[id][isChanged] = 0;
}

UpdateBandRelations(band1, band2)
{
   new tmp[MAX_STRING];
   format(tmp, sizeof(tmp), "UPDATE bRelations SET rStatus=%d WHERE band1ID=%d AND band2ID=%d", bandsRelations[band1][band2][_status], band1, band2);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "UPDATE bRelations SET rStatus=%d WHERE band1ID=%d AND band2ID=%d", bandsRelations[band1][band2][_status], band2, band1);
   DB_Update(tmp);
}

CreateBand(nBand, name[], mainPlayerID)
{
   if((nBand < 0) || (nBand >= maxNumBands)) return;
   bands[nBand][enabled]= 1;
   format(bands[nBand][bName], MaxBandName, "%s", name);
   bands[nBand][bMainID] = mainPlayerID;
   bands[nBand][bColor] = defaultBandColor;
   bands[nBand][bMoneys] = 0;
   bands[nBand][bKills] = 0;
   bands[nBand][bDeaths] = 0;
   bands[nBand][bExp] = 0;
   UpdateBand(nBand);
   //reg_Date
   new tmp[MAX_STRING];
   new tmp2[256];
   GetDateToString_Now(tmp2, sizeof(tmp2));
   format(tmp, sizeof(tmp), "UPDATE bands SET reg_Date='%s' WHERE id=%d", tmp2,
																		 nBand);
   DB_Update(tmp);
   new yr, mn, dy;
   getdate(yr, mn, dy);
   for(new i=0; i<maxNumBands; i++)
	  if((i!=nBand) && (bands[i][enabled] != 0))
	  {
         format(tmp, sizeof(tmp), "UPDATE bRelations SET rStatus=0, kills=0, rDateStart='%d:%d:%d' WHERE band1ID=%d AND band2ID=%d", yr,
		                                                                                                                             mn,
																																	 dy,
																																	 nBand,
																		                                                             i);
         DB_Update(tmp);
         format(tmp, sizeof(tmp), "UPDATE bRelations SET rStatus=0, kills=0, rDateStart='%d:%d:%d' WHERE band1ID=%d AND band2ID=%d", yr,
		                                                                                                                             mn,
																																	 dy,
																																	 i,
																																	 nBand);
         DB_Update(tmp);
         bandsRelations[nBand][i][_kills] = 0;
         bandsRelations[nBand][i][_status] = 0;
         bandsRelations[nBand][i][_oldKills] = 0;
         format(bandsRelations[nBand][i][dateUpdateStatus], Max_Date_Len, "%d:%d:%d", yr, mn, dy);
	  }
}

DeleteBand(nBand)
{
   if((nBand < 0) || (nBand >= maxNumBands)) return;
   if(bands[nBand][enabled] == 0) return;
   for(new i = 0; i <= MaxPlayerID; i++)
   {
	   if(IsPlayerConnected(i))
         if(PlayerParams[i][IsPlayerLogined] != 0)
	       if(PlayerParams[i][playerBand] == nBand)
	       {
              SendPlayerModText(i, "  .    :))", 0xAA3333AA);
              setPlayerBandStatus(i, -1, 0, TypeRegBase);
              #if defined _Zones_Included
		      hideZonesForPlayer(i);
		      #endif
           }
   }
   bands[nBand][enabled] = 0;
   UpdateBand(nBand);
   if(bands[nBand][bHouseID] != -1)
   {
       HouseSell(bands[nBand][bHouseID]);
       bands[nBand][bHouseID] = -1;
   }
   new tmp[MAX_STRING];
   format(tmp, sizeof(tmp), "UPDATE mainParam SET band=-1, bandStatus=0 WHERE band=%d", nBand);
   DB_Update(tmp);
}

GetBandPlayers(bID, &DBResult:result, &startNum, &countN)
{
   new tmp[MAX_STRING];
   if(startNum < 0) startNum = 0;
   if((countN - startNum) > 20) countN = startNum + 20;
   format(tmp, sizeof(tmp), "SELECT id, name, ip, bandStatus, LastActivityTime FROM AllColumn WHERE band=%d ORDER BY bandStatus ASC LIMIT %d, %d", bID, startNum, countN);
   SQlite_Select2(result, tmp);
}

RemovePlayerFromBand(playerid, bandID)
{
   new tmp[MAX_STRING];
   new DBResult:result;
   format(tmp, sizeof(tmp), "SELECT name FROM mainParam WHERE band=%d AND id=%d", bandID, playerid);
   if(SQlite_Select2(result, tmp) ==0) return false;
   format(tmp, sizeof(tmp), "UPDATE mainParam SET band=-1, bandStatus=0 WHERE id=%d", playerid);
   DB_Update(tmp);
   return true;
}

ChangePlayerStatusInBand(playerid, bandID, newStatus)
{
   new tmp[MAX_STRING];
   new DBResult:result;
   format(tmp, sizeof(tmp), "SELECT name FROM mainParam WHERE band=%d AND id=%d", bandID, playerid);
   if(SQlite_Select2(result, tmp) ==0) return false;
   format(tmp, sizeof(tmp), "UPDATE mainParam SET bandStatus=%d WHERE id=%d", newStatus, playerid);
   DB_Update(tmp);
   return true;
}

SetMainPlayerInBand(playerid, bandID)
{
   new tmp[MAX_STRING];
   new DBResult:result;
   format(tmp, sizeof(tmp), "SELECT name FROM mainParam WHERE band=%d AND id=%d", bandID, playerid);
   if(SQlite_Select2(result, tmp) ==0) return false;
   format(tmp, sizeof(tmp), "UPDATE mainParam SET bandStatus=0 WHERE id=%d", playerid);
   DB_Update(tmp);
   return true;
}

GetBandNumPlayers(bandID)
{
   new tmp[256];
   new DBResult:result;
   format(tmp, sizeof(tmp), "SELECT count(id) FROM AllColumn WHERE band=%d", bandID);
   SQlite_Select2(result, tmp);
   if(db_num_rows(result) == 0) return 0;
   db_get_field(result, 0, tmp, sizeof(tmp));
   return strval(tmp);
}

//------------------------------------------------

LoadHousesInfoFromBD()
{
    new DBResult:myresult;
    new tmp[255];
    new tmp2[255];
    for(new i=0; i<NumHouses; i++)
    {
		 format(tmp, sizeof(tmp), "SELECT * FROM Houses WHERE HouseID=%d", i);
         if(SQlite_Select2(myresult, tmp) == 0) return false;
         db_get_field_assoc(myresult, "ownerType", tmp2, sizeof(tmp2));
         Houses[i][_ownerType] = strval(tmp2);
         if((Houses[i][_ownerType] < 0) || (Houses[i][_ownerType] > 2)) Houses[i][_ownerType] = 0;
         if(Houses[i][_ownerType] == 0)
         {
              Houses[i][_owner] = -1;
              Houses[i][_isForSale] = 0;
              Houses[i][_ownerValue] = 0;
         }
         else
         {
             db_get_field_assoc(myresult, "isForSale", tmp2, sizeof(tmp2));
             Houses[i][_isForSale] = strval(tmp2);
             db_get_field_assoc(myresult, "saleValue", tmp2, sizeof(tmp2));
             Houses[i][_ownerValue] = strval(tmp2);
             db_get_field_assoc(myresult, "vault", tmp2, sizeof(tmp2));
             Houses[i][_vault] = strval(tmp2);
             db_get_field_assoc(myresult, "ownerID", tmp2, sizeof(tmp2));
             Houses[i][_owner] = strval(tmp2);
             if(Houses[i][_ownerType] == 1)
             {
                 format(tmp, sizeof(tmp), "SELECT * FROM mainParam WHERE id=%d", Houses[i][_owner]);
                 if(SQlite_Select2(myresult, tmp) == 0)
                 {
                     Houses[i][_owner] = -1;
                     Houses[i][_isForSale] = 0;
                     Houses[i][_ownerValue] = 0;
                     Houses[i][_ownerType] = 0;
                 }
                 else
                 {
                     db_get_field_assoc(myresult, "name", Houses[i][ownerName], MAX_PLAYER_NAME);
                 }
             }
             else
             {
                 format(tmp, sizeof(tmp), "SELECT * FROM bands WHERE id=%d", Houses[i][_owner]);
                 if(SQlite_Select2(myresult, tmp) == 0)
                 {
                     Houses[i][_owner] = -1;
                     Houses[i][_isForSale] = 0;
                     Houses[i][_ownerValue] = 0;
                     Houses[i][_ownerType] = 0;
                 }
                 else
                 {
					 if((Houses[i][_owner] <0) || (Houses[i][_owner] >= sizeof(bands)))
					 {
                        Houses[i][_owner] = -1;
                        Houses[i][_isForSale] = 0;
                        Houses[i][_ownerValue] = 0;
                        Houses[i][_ownerType] = 0;
                     }
                     else
                      if(bands[Houses[i][_owner]][enabled] == 0)
                      {
                         Houses[i][_owner] = -1;
                         Houses[i][_isForSale] = 0;
                         Houses[i][_ownerValue] = 0;
                         Houses[i][_ownerType] = 0;
                      }
                      else
                      {
                         db_get_field_assoc(myresult, "name", Houses[i][ownerName], MAX_PLAYER_NAME);
                         bands[Houses[i][_owner]][bHouseID] = i;
                      }
                 }
             }
         }
    }
    for(new i=0; i<NumHouses; i++)
    {
			for(new k=0; k<Houses[i][_maxHouseVechs]; k++)
			{
                 format(tmp, sizeof(tmp), "SELECT * FROM HousesCars WHERE HouseID=%d AND NumberCar=%d", i, k);
                 if(SQlite_Select2(myresult, tmp) == 0)
                 {
                     HouseVechs[i][k][_HouseVechs_ID] = -1;
                     HouseVechs[i][k][_HouseVechs_Tuning] = 0;
                     HouseVechs[i][k][_HouseVechs_Lock] = 0;
                 }
                 else
                 {
                     db_get_field_assoc(myresult, "CarModel", tmp2, sizeof(tmp2));
                     HouseVechs[i][k][_HouseVechs_ID] = INVALID_VEHICLE_ID;
                     HouseVechs[i][k][_HousesVechs_Model] = strval(tmp2);
                     //
                     
                     if(!isVehModelCorrectly(HouseVechs[i][k][_HousesVechs_Model]))
                     {
                          HouseVechs[i][k][_HouseVechs_ID] = -1;
                          HouseVechs[i][k][_HousesVechs_Model] = 0;
                          HouseVechs[i][k][_HouseVechs_Tuning] = 0;
                          HouseVechs[i][k][_HouseVechs_Lock] = 0;
                     }
                     else
                     {
                         
                         LoadMagVech(HouseVechs[i][k][_HousesVechs_Model], i, k);
                         db_get_field_assoc(myresult, "TuningType", tmp2, sizeof(tmp2));
                         HouseVechs[i][k][_HouseVechs_Tuning] = strval(tmp2);
                         db_get_field_assoc(myresult, "LockDoor", tmp2, sizeof(tmp2));
                         HouseVechs[i][k][_HouseVechs_Lock] = strval(tmp2);
                         db_get_field_assoc(myresult, "Color1", tmp2, sizeof(tmp2));
                         HouseVechs[i][k][_color1] = strval(tmp2);
                         db_get_field_assoc(myresult, "Color2", tmp2, sizeof(tmp2));
                         HouseVechs[i][k][_color2] = strval(tmp2);
                     }
                 }
			}
    }
    return true;
}

UpdateHouse(houseID)
{
    new tmp[255];
    format(tmp, sizeof(tmp), "UPDATE Houses SET ownerID=%d, \
	                                            ownerType=%d, \
												isForSale=%d, \
												saleValue=%d, \
												vault=%d \
												WHERE HouseID=%d", Houses[houseID][_owner],
												                   Houses[houseID][_ownerType],
																   Houses[houseID][_isForSale],
																   Houses[houseID][_ownerValue],
																   Houses[houseID][_vault],
																   houseID);
    DB_Update(tmp);
}

BuyHouseCarBD(HouseID, numberSlot, CarModel)
{
    new tmp[255];
    format(tmp, sizeof(tmp), "INSERT INTO HousesCars (HouseID, NumberCar, CarModel, CarID) VALUES (%d, %d, %d, 0)", HouseID, numberSlot, CarModel);
    DB_Update(tmp);
}

SellHouseCarBD(HouseID, numberSlot)
{
    new tmp[255];
    format(tmp, sizeof(tmp), "DELETE FROM HousesCars WHERE HouseID=%d AND NumberCar=%d", HouseID, numberSlot);
    DB_Update(tmp);
}

UpdateHouseCarId_BD(HouseID, numberSlot, CarModel)
{
    new tmp[255];
    format(tmp, sizeof(tmp), "UPDATE HousesCars SET CarModel=%d WHERE HouseID=%d AND NumberCar=%d", CarModel, HouseID, numberSlot);
    DB_Update(tmp);
}

UpdateHouseCarBD(HouseID, numberSlot)
{
	if((numberSlot<0) || (numberSlot >=MaxVechsToHous)) return;
	if(HouseVechs[HouseID][numberSlot][_HouseVechs_ID] == -1) return;
    new tmp[255];
    format(tmp, sizeof(tmp), "UPDATE HousesCars SET TuningType=%d, \
	                                                LockDoor=%d, \
												    Color1=%d, \
												    Color2=%d \
												    WHERE HouseID=%d \
												    AND NumberCar=%d", HouseVechs[HouseID][numberSlot][_HouseVechs_Tuning],
													                   HouseVechs[HouseID][numberSlot][_HouseVechs_Lock],
																	   HouseVechs[HouseID][numberSlot][_color1],
																	   HouseVechs[HouseID][numberSlot][_color2],
																	   HouseID,
																	   numberSlot);
    DB_Update(tmp);
}

#if defined _Zones_Included
LoadZonesFromBD()
{
    new DBResult:myresult;
    new tmp[255];
    for(new i=0; i<MaxNumZones; i++)
    {
	   format(tmp, sizeof(tmp), "SELECT * FROM Zones WHERE zoneID=%d", i);
	   if(SQlite_Select2(myresult, tmp) == 0) return false;
       db_get_field_assoc(myresult, "bandID", tmp, sizeof(tmp));
       Zones[i][numBand] = strval(tmp);
       if(Zones[i][numBand] != -1)
		  if(!isBandReal(Zones[i][numBand])) Zones[i][numBand] = -1;
    }
    return true;
}

CaptureZoneBD(zID, bID)
{
     new tmp[255];
     format(tmp, sizeof(tmp), "UPDATE Zones SET bandID=%d WHERE zoneID=%d", bID, zID);
     DB_Update(tmp);
}
#endif

// 
#if defined _bussiness_Enabled
LoadBussinessInfoFromBD()
{
    new DBResult:myresult;
    new tmp[255];
    new tmp2[255];
    for(new i=0; i<NumBussiness; i++)
    {
		 format(tmp, sizeof(tmp), "SELECT * FROM Bussinesses WHERE BussinessID=%d", i);
         if(SQlite_Select2(myresult, tmp) == 0) return false;
         db_get_field_assoc(myresult, "ownerType", tmp2, sizeof(tmp2));
         Bussinesses[i][_ownerType] = strval(tmp2);
         if((Bussinesses[i][_ownerType] < 0) || (Bussinesses[i][_ownerType] > 2)) Bussinesses[i][_ownerType] = 0;
         if(Bussinesses[i][_ownerType] == 0)
         {
              Bussinesses[i][_owner] = -1;
              Bussinesses[i][_isForSale] = 0;
              Bussinesses[i][_ownerValue] = 0;
         }
         else
         {
             db_get_field_assoc(myresult, "isForSale", tmp2, sizeof(tmp2));
             Bussinesses[i][_isForSale] = strval(tmp2);
             db_get_field_assoc(myresult, "saleValue", tmp2, sizeof(tmp2));
             Bussinesses[i][_ownerValue] = strval(tmp2);
             db_get_field_assoc(myresult, "Vault", tmp2, sizeof(tmp2));
             Bussinesses[i][Vault] = strval(tmp2);
             db_get_field_assoc(myresult, "Stock", tmp2, sizeof(tmp2));
             Bussinesses[i][Stock] = strval(tmp2);
             db_get_field_assoc(myresult, "ownerID", tmp2, sizeof(tmp2));
             Bussinesses[i][_owner] = strval(tmp2);
             if(Bussinesses[i][_ownerType] == 1)
             {
                 format(tmp, sizeof(tmp), "SELECT * FROM mainParam WHERE id=%d", Bussinesses[i][_owner]);
                 if(SQlite_Select2(myresult, tmp) == 0)
                 {
                     Bussinesses[i][_owner] = -1;
                     Bussinesses[i][_isForSale] = 0;
                     Bussinesses[i][_ownerValue] = 0;
                     Bussinesses[i][_ownerType] = 0;
                 }
                 else
                 {
                     db_get_field_assoc(myresult, "name", Bussinesses[i][ownerName], MAX_PLAYER_NAME);
                 }
             }
             else
             {
                 format(tmp, sizeof(tmp), "SELECT * FROM bands WHERE id=%d", Bussinesses[i][_owner]);
                 if(SQlite_Select2(myresult, tmp) == 0)
                 {
                     Bussinesses[i][_owner] = -1;
                     Bussinesses[i][_isForSale] = 0;
                     Bussinesses[i][_ownerValue] = 0;
                     Bussinesses[i][_ownerType] = 0;
                 }
                 else
                 {
					 if((Bussinesses[i][_owner] <0) || (Bussinesses[i][_owner] >= sizeof(bands)))
					 {
                        Bussinesses[i][_owner] = -1;
                        Bussinesses[i][_isForSale] = 0;
                        Bussinesses[i][_ownerValue] = 0;
                        Bussinesses[i][_ownerType] = 0;
                     }
                     else
                      if(bands[Bussinesses[i][_owner]][enabled] == 0)
                      {
                         Bussinesses[i][_owner] = -1;
                         Bussinesses[i][_isForSale] = 0;
                         Bussinesses[i][_ownerValue] = 0;
                         Bussinesses[i][_ownerType] = 0;
                      }
                      else
                      {
                         db_get_field_assoc(myresult, "name", Bussinesses[i][ownerName], MAX_PLAYER_NAME);
                      }
                 }
             }
         }
    }
    return true;
}

UpdateBussiness(bussinessID)
{
    new tmp[255];
    format(tmp, sizeof(tmp), "UPDATE Bussinesses SET ownerID=%d, \
	                                            ownerType=%d, \
												isForSale=%d, \
												saleValue=%d, \
												Vault=%d, \
												Stock=%d \
												WHERE BussinessID=%d", Bussinesses[bussinessID][_owner],
												                   Bussinesses[bussinessID][_ownerType],
																   Bussinesses[bussinessID][_isForSale],
																   Bussinesses[bussinessID][_ownerValue],
																   Bussinesses[bussinessID][Vault],
																   Bussinesses[bussinessID][Stock],
																   bussinessID);
	SaveToDebugLog(tmp);
    DB_Update(tmp);
}

UpdateAllBussiness()
{
	for(new i = 0; i<sizeof(Bussinesses); i++)
	{
	    if(Bussinesses[i][_isLoaded] == 1)
	    {
            UpdateBussiness(i);
	    }
	}
}
#endif
//  

//   

SavePlayerCarInDB(playerid, carid)
{
	if(!IsPlayerHaveCarInDB(playerid, carid)) return false;
	new tmp[1024];
	format(tmp, sizeof(tmp), "UPDATE PlayerCars SET Owner=%d, \
	                                            Slot=%d, \
	                                            ID=%d, \
	                                            Cost=%d, \
	                                            Colour1=%d, \
	                                            Colour2=%d, \
	                                            Paintjob=%d, \
	                                            Exhaust=%d, \
	                                            Frontbumper=%d, \
	                                            Rearbumper=%d, \
	                                            Roof=%d, \
	                                            Spoiler=%d, \
	                                            Sideskirts1=%d, \
	                                            Sideskirts2=%d, \
	                                            Wheels=%d, \
	                                            Nitro=%d, \
	                                            Hydro=%d, \
	                                            Stereo=%d, \
	                                            Body=%d, \
	                                            X=%f, \
	                                            Y=%f, \
	                                            Z=%f, \
	                                            A=%f \
	                                            WHERE Owner=%d AND Slot=%d",
	                                            PlCar[playerid][carid][Car_Owner],
	                                            carid,
	                                            PlCar[playerid][carid][Car_ID],
	                                            PlCar[playerid][carid][Car_Cost],
	                                            PlCar[playerid][carid][Car_Colour1],
	                                            PlCar[playerid][carid][Car_Colour2],
	                                            PlCar[playerid][carid][Car_Paintjob],
	                                            PlCar[playerid][carid][Car_Exhaust],
	                                            PlCar[playerid][carid][Car_Frontbumper],
	                                            PlCar[playerid][carid][Car_Rearbumper],
	                                            PlCar[playerid][carid][Car_Roof],
	                                            PlCar[playerid][carid][Car_Spoiler],
	                                            PlCar[playerid][carid][Car_Sideskirt],
	                                            0,
	                                            PlCar[playerid][carid][Car_Wheels],
	                                            PlCar[playerid][carid][Car_Nitro],
	                                            PlCar[playerid][carid][Car_Hydro],
	                                            PlCar[playerid][carid][Car_Stereo],
	                                            PlCar[playerid][carid][Car_Body],
	                                            PlCar[playerid][carid][PCar_X],
	                                            PlCar[playerid][carid][PCar_Y],
	                                            PlCar[playerid][carid][PCar_Z],
	                                            PlCar[playerid][carid][PCar_A],
												PlayerParams[playerid][id_BD],
												carid
												);
    DB_Update(tmp);
    return true;
}

LoadPlayerCarFromDB(playerid, carid)
{
    if(!IsPlayerHaveCarInDB(playerid, carid)) return false;
    new DBResult:myresult;
    new tmp[255], tmp2[255];
	new id = PlayerParams[playerid][id_BD];
	format(tmp, sizeof(tmp), "SELECT * FROM PlayerCars WHERE Owner=%d AND Slot=%d", id, carid);
	if(SQlite_Select2(myresult, tmp) == 0) return false;
	db_get_field_assoc(myresult, "Owner", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Owner] = strval(tmp2);
	db_get_field_assoc(myresult, "Slot", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Slot] = strval(tmp2);
	db_get_field_assoc(myresult, "ID", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_ID] = strval(tmp2);
	db_get_field_assoc(myresult, "Cost", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Cost] = strval(tmp2);
	db_get_field_assoc(myresult, "Colour1", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Colour1] = strval(tmp2);
	db_get_field_assoc(myresult, "Colour2", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Colour2] = strval(tmp2);
	db_get_field_assoc(myresult, "Paintjob", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Paintjob] = strval(tmp2);
	db_get_field_assoc(myresult, "Exhaust", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Exhaust] = strval(tmp2);
	db_get_field_assoc(myresult, "Frontbumper", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Frontbumper] = strval(tmp2);
	db_get_field_assoc(myresult, "Rearbumper", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Rearbumper] = strval(tmp2);
	db_get_field_assoc(myresult, "Roof", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Roof] = strval(tmp2);
	db_get_field_assoc(myresult, "Spoiler", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Spoiler] = strval(tmp2);
	db_get_field_assoc(myresult, "Sideskirts1", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Sideskirt] = strval(tmp2);
	db_get_field_assoc(myresult, "Wheels", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Wheels] = strval(tmp2);
	db_get_field_assoc(myresult, "Nitro", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Nitro] = strval(tmp2);
	db_get_field_assoc(myresult, "Hydro", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Hydro] = strval(tmp2);
	db_get_field_assoc(myresult, "Stereo", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Stereo] = strval(tmp2);
	db_get_field_assoc(myresult, "Body", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][Car_Body] = strval(tmp2);
	db_get_field_assoc(myresult, "X", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][PCar_X] = strval(tmp2);
	db_get_field_assoc(myresult, "Y", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][PCar_Y] = strval(tmp2);
	db_get_field_assoc(myresult, "Z", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][PCar_Z] = strval(tmp2);
	db_get_field_assoc(myresult, "A", tmp2, sizeof(tmp2));
	PlCar[playerid][carid][PCar_A] = strval(tmp2);
	return true;
}

SavePlayerCarsInDB(playerid)
{
	for(new carid; carid < MAX_CARS; carid++)
	{
		SavePlayerCarInDB(playerid, carid);
	}
	return true;
}

LoadPlayerCarsFromDB(playerid)
{
	for(new carid; carid < MAX_CARS; carid++)
	{
		LoadPlayerCarFromDB(playerid, carid);
	}
	return true;
}
AddPlayerCarInDB(playerid, carid)
{
	new tmp[255];
	new id = PlayerParams[playerid][id_BD];
	format(tmp, sizeof(tmp), "INSERT INTO PlayerCars (Owner, Slot) VALUES ('%d', '%d');", id, carid);
	DB_Update(tmp);
	SavePlayerCarInDB(playerid, carid);
	return true;
}

IsPlayerHaveCarInDB(playerid, carid)
{
	new DBResult:myresult;
	new tmp[255];
	new id = PlayerParams[playerid][id_BD];
	format(tmp, sizeof(tmp), "SELECT * FROM PlayerCars WHERE Owner=%d AND Slot=%d", id, carid);
	if(SQlite_Select2(myresult, tmp) == 0) return false;
	if(db_num_rows(myresult) > 0) return true;
	return false;
}

DeletePlayerCarFromDB(playerid, carid)
{
    new id = PlayerParams[playerid][id_BD];
	if(!IsPlayerHaveCarInDB(playerid, carid)) return false;
	new tmp[255];
	format(tmp, sizeof(tmp), "DELETE FROM PlayerCars WHERE Owner=%d AND Slot=%d", id, carid);
	DB_Update(tmp);
	return true;
}

/*GetPlayerCarFromDB(playerid, carid)
{
	new DBResult:myresult;
	new tmp[255], tmp2[255];
	new id = PlayerParams[playerid][id_BD];
	format(tmp, sizeof(tmp), "SELECT * FROM PlayerCars WHERE Owner=%d AND Slot=%d", id, carid);
	if(SQlite_Select2(myresult, tmp) == 0) return false;

}*/

//   

//   ---------------------------------------------------

GetBestKillsPlayers(&DBResult:result)
{
   SQlite_Select2(result, "SELECT id, name, kills FROM AllColumn ORDER BY kills DESC LIMIT 0, 10");
}

GetBestTimePlayers(&DBResult:result)
{
   SQlite_Select2(result, "SELECT id, name, GameTimeNew FROM AllColumn ORDER BY GameTimeNew DESC LIMIT 0, 10");
}

GetBestExpPlayers(&DBResult:result)
{
   SQlite_Select2(result, "SELECT id, name, experience FROM AllColumn ORDER BY experience DESC LIMIT 0, 10");
}

//------------------------------------------------------------------------------
setMissionStatInBD(BD_id, missionID, newState)
{
    if(isMissionsEnabled == 0) return;
	new missName[50];
	switch(missionID)
	{
		 case 0: format(missName, sizeof(missName), "%s", "TruckerMissStats");//
		 case 1: format(missName, sizeof(missName), "%s", "BusMissStats");// 
		 case 2: format(missName, sizeof(missName), "%s", "CarExportMissStats");// 
		 case 3: format(missName, sizeof(missName), "%s", "TrainMissStats");// 
		 case 4: format(missName, sizeof(missName), "%s", "cashBoxStats");//cashBox
		 case 5: format(missName, sizeof(missName), "%s", "TaxiMissStats");//taxi
		 default: return;
	}
	new tmp[256];
	format(tmp, sizeof(tmp), "UPDATE secondParam SET %s=%d WHERE id=%d", missName, newState, BD_id);
    DB_Update(tmp);
}
//------------------------------------------------------------------------------

//
UpdateDepozitsIncrease(typeDepozit, Float:increase)
{
    new Float:TmpIncrease = floatdiv(increase, 100.0);
	new tmp[256];
	format(tmp, sizeof(tmp), "UPDATE BankDepozits SET Moneys=Moneys+Moneys*%f WHERE DepozitType=%d", TmpIncrease, typeDepozit);
    DB_Update(tmp);
}

UpdateDepozitsCrash(typeDepozit)
{
	new tmp[256];
	format(tmp, sizeof(tmp), "UPDATE BankDepozits SET DepozitType=0 WHERE DepozitType=%d", typeDepozit);
    DB_Update(tmp);
}

FindFreeDepozit()
{
   new DBResult:myresult;
   if(SQlite_Select2(myresult, "SELECT depozitNum FROM BankDepozits WHERE DepozitType=0 ORDER BY depozitNum DESC LIMIT 0, 1") == 0) return -1;
   new tmp[50];
   db_get_field_assoc(myresult, "depozitNum", tmp, sizeof(tmp));
   return strval(tmp);
}

IsDepozitEmpty(num)
{
   new tmp[256];
   new DBResult:myresult;
   format(tmp, sizeof(tmp), "SELECT * FROM BankDepozits WHERE depozitNum=%d", num);
   if(SQlite_Select2(myresult, tmp) == 0) return true;
   db_get_field_assoc(myresult, "DepozitType", tmp, sizeof(tmp));
   if(strval(tmp) == 0) return true;
   return false;
}

GetDepozitInfo(num, password[], sizPass, &Dmoneys, &typeDepoz, &DCreateTime, &DLastActivityTyme)
{
   new tmp[256];
   new DBResult:myresult;
   format(tmp, sizeof(tmp), "SELECT * FROM BankDepozits WHERE depozitNum=%d", num);
   if(SQlite_Select2(myresult, tmp) == 0) return false;
   db_get_field_assoc(myresult, "password", password, sizPass);
   db_get_field_assoc(myresult, "CreateDate", tmp, sizeof(tmp));
   DCreateTime=strval(tmp);
   db_get_field_assoc(myresult, "LastActivityDate", tmp, sizeof(tmp));
   DLastActivityTyme=strval(tmp);
   db_get_field_assoc(myresult, "Moneys", tmp, sizeof(tmp));
   Dmoneys=strval(tmp);
   db_get_field_assoc(myresult, "DepozitType", tmp, sizeof(tmp));
   typeDepoz=strval(tmp);
   return true;
}

CreateDepozit(num, password[], Dmoneys, typeDepoz)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "UPDATE BankDepozits SET DepozitType=%d, \
                                                     password='%s', \
													 CreateDate=%d, \
													 LastActivityDate=%d, \
													 Moneys=%d WHERE depozitNum=%d", typeDepoz,
													                                 password,
																					 GetPosixTimeNow(),
																					 GetPosixTimeNow(),
																					 Dmoneys,
																					 num);
   DB_Update(tmp);
}

AddMoneyToDepozit(num, Dmoneys)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "UPDATE BankDepozits SET Moneys=Moneys+%d WHERE depozitNum=%d", Dmoneys, num);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "UPDATE BankDepozits SET LastActivityDate=%d WHERE depozitNum=%d", GetPosixTimeNow(), num);
   DB_Update(tmp);
}

TakeMoneyFromDepozit(num, Dmoneys)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "UPDATE BankDepozits SET Moneys=Moneys-%d WHERE depozitNum=%d", Dmoneys, num);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "UPDATE BankDepozits SET LastActivityDate=%d WHERE depozitNum=%d", GetPosixTimeNow(), num);
   DB_Update(tmp);
}

DestroyDepoz(num)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "UPDATE BankDepozits SET DepozitType=0 WHERE depozitNum=%d", num);
   DB_Update(tmp);
}

GetBankInfo(numDepozs[])
{
   new tmp[256];
   new DBResult:myresult;
   for(new i=0; i<numDepozitsTypes; i++)
   {
     format(tmp, sizeof(tmp), "SELECT count(*) FROM BankDepozits WHERE DepozitType=%d", i+1);
     if(SQlite_Select2(myresult, tmp) == 0) return false;
     db_get_field(myresult, 0, tmp, sizeof(tmp));
     numDepozs[i] = strval(tmp);
   }
   return true;
}

//------------------------------------------------------------------------------
//eracing
Eracing_AddRecordToDB(rTime, pNumDB)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "INSERT INTO eracingRecords VALUES (%d, '%s', %d, %d)", routNum, routName, rTime, pNumDB);
   DB_Update(tmp);
}

Eracing_UpdateRecordInDB(oldRTime, oldpNumDB, rTime, pNumDB)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "UPDATE eracingRecords SET time=%d, playerBdID=%d WHERE numRout=%d AND time=%d AND playerBdID=%d", rTime, pNumDB, routNum, oldRTime, oldpNumDB);
   DB_Update(tmp);
}

Eracing_LoadRecordFromDB(&DBResult:result)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "DELETE FROM eracingRecords WHERE numRout=%d AND NameRout!='%s'", routNum, routName);
   DB_Update(tmp);
   format(tmp, sizeof(tmp), "SELECT * FROM eracingRecords, mainParam WHERE eracingRecords.playerBdID=mainParam.id AND numRout=%d ORDER BY time ASC", routNum);
   SQlite_Select2(result, tmp);
}

DelAllRecordsFromDB(numRace)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "DELETE FROM eracingRecords WHERE numRout=%d", numRace);
   DB_Update(tmp);
}

//------------------------------------------------------------------------------
// 
Statistic_GetStartStatData(&year, &month, &day)
{
   new DBResult:result;
   if(SQlite_Select2(result, "SELECT * FROM visits ORDER BY year ASC, month ASC, day ASC, hour ASC, minute ASC LIMIT 0,1") == 0)
   {
		   printf("    ");
   }
   new t1[20];
   db_get_field(result, 0, t1, 20);
   year = strval(t1);
   db_get_field(result, 1, t1, 20);
   month = strval(t1);
   db_get_field(result, 2, t1, 20);
   day = strval(t1);
}

Statistic_PrintStatBetweenSates(startY, startM, startD, endY, endM, endD, FileName[])
{
   if(fexist(FileName)) fremove(FileName);
   new File:f = fopen(FileName);
   new cm[255];
   new Float:avgAll, Float:avgAdm, maxAll, maxAd, Float:avgPing;
   while((startY < endY) || (startM < endM) || (startD < endD))
   {
        new DBResult:result;
        //
        format(cm, sizeof(cm), "SELECT count(avgAll) FROM visits WHERE year=%d AND month=%d AND day=%d", startY, startM, startD);
        SQlite_Select2(result, cm);
        db_get_field(result, 0, cm, 255);
        //
        if(strval(cm) == 0)
		{
             format(cm, sizeof(cm), "%d-%d-%d: non \r\n", startY, startM, startD);
             fwrite(f, cm);
		}
        else
        {
             format(cm, sizeof(cm), "SELECT avg(avgAll), max(maxAll), avg(avgAdmins), max(maxAdmins), avg(avgPing) FROM visits WHERE year=%d AND month=%d AND day=%d", startY, startM, startD);
             SQlite_Select2(result, cm);
             db_get_field(result, 0, cm, 255);
             avgAll = floatstr(cm);
             db_get_field(result, 1, cm, 255);
             maxAll = strval(cm);
             db_get_field(result, 2, cm, 255);
             avgAdm = floatstr(cm);
             db_get_field(result, 3, cm, 255);
             maxAd = strval(cm);
             db_get_field(result, 4, cm, 255);
             avgPing = floatstr(cm);
             //printf("Y:%d; M:%d; D:%d; avgAll:%.2f; maxAll: %d; avgAdmins: %.2f; maxAdmins: %d; avgPing: %.2f", startY, startM, startD, avgAll, maxAll, avgAdm, maxAd, avgPing);
             format(cm, sizeof(cm), "Y:%d; M:%d; D:%d; avgAll:%.2f; maxAll: %d; avgAdmins: %.2f; maxAdmins: %d; avgPing: %.2f \r\n", startY, startM, startD, avgAll, maxAll, avgAdm, maxAd, avgPing);
             fwrite(f, cm);
        }
        startD++;
        if(startD > 31)
        {
             startD = 1;
             startM++;
             if(startM > 12)
             {
                 startM=1;
                 startY++;
             }
        }
        db_free_result(result);
   }
   fclose(f);
}

Statistic_PrintStatByHours(FileName[])
{
   if(fexist(FileName)) fremove(FileName);
   new File:f = fopen(FileName);
   new cm[255];
   new Float:avgAll, Float:avgAdm, maxAll, maxAd, Float:avgPing;
   for(new h=0; h<=23; h++)
   {
        new DBResult:result;
        //
        format(cm, sizeof(cm), "SELECT count(avgAll) FROM visits WHERE hour=%d", h);
        SQlite_Select2(result, cm);
        db_get_field(result, 0, cm, 255);
        //
        if(strval(cm) == 0)
		{
             format(cm, sizeof(cm), "%d: non \r\n", h);
             fwrite(f, cm);
		}
        else
        {
             format(cm, sizeof(cm), "SELECT avg(avgAll), max(maxAll), avg(avgAdmins), max(maxAdmins), avg(avgPing) FROM visits WHERE hour=%d", h);
             SQlite_Select2(result, cm);
             db_get_field(result, 0, cm, 255);
             avgAll = floatstr(cm);
             db_get_field(result, 1, cm, 255);
             maxAll = strval(cm);
             db_get_field(result, 2, cm, 255);
             avgAdm = floatstr(cm);
             db_get_field(result, 3, cm, 255);
             maxAd = strval(cm);
             db_get_field(result, 4, cm, 255);
             avgPing = floatstr(cm);
             //printf("Y:%d; M:%d; D:%d; avgAll:%.2f; maxAll: %d; avgAdmins: %.2f; maxAdmins: %d; avgPing: %.2f", startY, startM, startD, avgAll, maxAll, avgAdm, maxAd, avgPing);
             format(cm, sizeof(cm), "%2.2d: avgAll:%.2f; maxAll: %d; avgAdmins: %.2f; maxAdmins: %d; avgPing: %.2f \r\n", h, avgAll, maxAll, avgAdm, maxAd, avgPing);
             fwrite(f, cm);
        }
        db_free_result(result);
   }
   fclose(f);
}

banlist_BanPlayerSimply(playerid, bannerid, reason[], srok)//srok  
{
   if(!IsPlayerConnected(playerid)) return;
   new ip[30];
   GetPlayerIpMy(playerid, ip, sizeof(ip));
   playerid = PlayerParams[playerid][id_BD];
   if(!IsPlayerConnected(bannerid)) bannerid = -1;
   else bannerid = PlayerParams[bannerid][id_BD];
   banlist_BanPlayer(playerid, bannerid, ip, reason, srok);
}

banlist_BanPlayer(playerid_DB, bannerid_DB, ip[], reason[], srok)//srok  
{
   new unbanDate = srok*60 + GetPosixTimeNow();
   new tmp[256];
   new date[50];
   new dd, mmm, yy, hh, mm, ss;
   getdate(yy, mmm, dd);
   gettime(hh, mm, ss);
   format(date, sizeof(date), "%.2d : %.2d : %.4d - %.2d : %.2d : %.2d", dd, mmm, yy, hh, mm, ss);
   format(tmp, sizeof(tmp), "INSERT INTO banlist (idBanned, idWhoBanned, UnBanDate, ipB, reason, banDate) VALUES (%d, %d, %d, '%s', '%s', '%s')", playerid_DB, bannerid_DB, unbanDate, ip, reason, date);
   DB_Update(tmp);
}

banlist_UnBanPlayerEx(ip[])
{
	new tmp[256];
    format(tmp, sizeof(tmp), "DELETE FROM banlist WHERE ipB='%s'", ip);
    DB_Update(tmp);
}

banlist_AutoUnBan()
{
   new DBResult:result;
   new tmp[256];
   format(tmp, sizeof(tmp), "SELECT ipB FROM banlist WHERE UnBanDate<%d", GetPosixTimeNow());
   SQlite_Select2(result, tmp);
   new ip[30];
   for(new i=0; i<db_num_rows(result); i++)
   {
       db_get_field(result, 0, ip, sizeof(ip));
       banlist_UnBanPlayerEx(ip);
       format(tmp, sizeof(tmp), "   ip=%s,    ", ip);
	   SaveToLog(tmp, 3);
       db_next_row(result);
   }
}

banlist_PrintBanlist()
{
	if(fexist(ExBanlistPatch)) fremove(ExBanlistPatch);
	new File:f = fopen(ExBanlistPatch, io_write);
	new DBResult:result;
	new DBResult:result2;
	new tmp[256];
	new date[50];
    SQlite_Select2(result, "SELECT * FROM banlist");
    new nameBanner[50], bannerIp[20], unBanDate, ip[20], reason[256], nameBanned[50];
    new idBanned, idBanner;
	for(new i=0; i<db_num_rows(result); i++)
	{
//"CREATE TABLE banlist (idBanned, idWhoBanned, UnBanDate, ipB VARCHAR(20), reason VARCHAR(200))");
		//  
	    db_get_field_assoc(result, "idBanned", tmp, sizeof(tmp));
	    // 
	    db_get_field_assoc(result, "banDate", date, sizeof(date));
	    idBanned = strval(tmp);
	    if(idBanned==-1) format(nameBanned, sizeof(nameBanned), "%s", "not registered");
	    else
	    {
			format(tmp, sizeof(tmp), "SELECT name FROM mainParam WHERE id=%d", idBanned);
			if(!SQlite_Select2(result2, tmp))
                 format(nameBanned, sizeof(nameBanned), "%s", "not registered");
			else
                db_get_field(result2, 0, nameBanned, sizeof(nameBanned));
	    }
	    //     
	    db_get_field_assoc(result, "idWhoBanned", tmp, sizeof(tmp));
	    idBanner = strval(tmp);
	    if(idBanner==-1)
		{
		    format(nameBanner, sizeof(nameBanner), "%s", "not registered");
		    format(bannerIp, sizeof(bannerIp), "%s", "unknown");
		}
	    else
	    {
			format(tmp, sizeof(tmp), "SELECT name, ip FROM AllColumn WHERE id=%d", idBanner);
			if(!SQlite_Select2(result2, tmp))
			{
                 format(nameBanner, sizeof(nameBanner), "%s", "not registered");
                 format(bannerIp, sizeof(bannerIp), "%s", "unknown");
            }
			else
			{
                db_get_field(result2, 0, nameBanner, sizeof(nameBanner));
                db_get_field(result2, 1, bannerIp, sizeof(bannerIp));
            }
	    }
	    // 
	    db_get_field_assoc(result, "ipB", ip, sizeof(ip));
	    // 
	    db_get_field_assoc(result, "reason", reason, sizeof(reason));
		// 
	    db_get_field_assoc(result, "UnBanDate", tmp, sizeof(tmp));
	    unBanDate = strval(tmp);
	    format(tmp, sizeof(tmp), "%s (%s): %s( %d); : %s (%s); : %s\r\n", ip, nameBanned, reason, unBanDate, nameBanner, bannerIp, date);
	    fwrite(f, tmp);
  	    db_next_row(result);
	}
	fclose(f);
}

banlist_isIPBanned(ip[])
{
   new tmp[256];
   new DBResult:result;
   format(tmp, sizeof(tmp), "SELECT * FROM banlist WHERE ipB='%s'", ip);
   return (SQlite_Select2(result, tmp)!=0);
}

banlist_GetIPbanInfo(ip[], povod[], siz1, date[], siz2, &dd, &hh, &mm)
{
   new tmp[256];
   new DBResult:result;
   format(tmp, sizeof(tmp), "SELECT * FROM banlist WHERE ipB='%s'", ip);
   if(SQlite_Select2(result, tmp)==0)
   {
	  povod[0]=0;
	  dd=0;
	  hh=0;
   }
   db_get_field_assoc(result, "reason", povod, siz1);
   db_get_field_assoc(result, "banDate", date, siz2);
   db_get_field_assoc(result, "UnBanDate", tmp, sizeof(tmp));
   new time = int:((strval(tmp)-GetPosixTimeNow())/60);// 
   dd = int:(time/1440);
   hh = int:((time - dd*1440)/60);
   mm = time - dd*1440-hh*60;
}

//

PrintDBStruct_RCON()
{
   printf("mainParam");
   printf("id, name, password_hash, experience, money, kills, deaths, wlewel, band, bandStatus, house, gold");
   printf(" ");
   printf("secondParam");
   printf("id, SilentTime, JailTime, Race_Starts, Race_FirstPlaces, ip, TruckerMissStats, BusMissStats");
   printf("CarExportMissStats, TrainMissStats, TaxiMissStats, picUps, numPicUps, cashBoxStats");
   printf(" ");
   printf("times");
   printf("id, reg_Date, reg_DateNew, GameTime, GameTimeNew, LastActivityTime, LastActivityTimeNew");
   printf(" ");
   printf("profileParam");
   printf("id, weapList_0_ID, weapList_1_ID, weapList_2_ID, weapList_3_ID, weapList_4_ID");
   printf("weapList_0_ammo, weapList_1_ammo, weapList_2_ammo, weapList_3_ammo, weapList_4_ammo");
   printf("BodyArmour, BlockIP, autoLogin ,AdminStatus ,Skin, hitmanMoneys");
   printf("spawnType, iPanelType ,blocked");
   printf(" ");
   printf("bands");
   printf("id, enabled, name, mainID, color, moneys, sumKills, sumDeaths, Reputation, bExp, reg_Date");
   printf(" ");
   printf("bRelations");
   printf("band1ID, band2ID, rStatus, kills, rDateStart");
   printf(" ");
   printf("Houses");
   printf("HouseID, ownerID, ownerType, isForSale, saleValue");
   printf(" ");
   printf("HousesCars");
   printf("HouseID, NumberCar, CarModel, TuningType, LockDoor, Color1, Color2");
   printf(" ");
   printf("Zones");
   printf("zoneID, bandID");
   printf(" ");
   printf("BankDepozits");
   printf("depozitNum, password, CreateDate, LastActivityDate, Moneys, DepozitType");
   printf(" ");
   printf("eracingRecords");
   printf("numRout, NameRout, time, playerBdID");
   printf(" ");
   printf("banlist");
   printf("idBanned, idWhoBanned, UnBanDate, ipB, reason, banDate");
   printf(" ");
   printf("erpgParam");
   printf("max_players_count, max_players_Year, max_players_Mouth, max_players_Day, max_players_Hour, max_players_Min, max_players_Sec");
   printf("create_time_year, create_time_Mouth, create_time_Day, create_time_Hour, create_time_Min, create_time_Sec");
   printf(" ");
   printf("visits");
   printf("year, month, day, hour, minute, avgAll, maxAll, avgAdmins, maxAdmins, avgPing");
}

SetGOLD(id, srok)
{
   new tmp[256];
   format(tmp, sizeof(tmp), "UPDATE mainParam SET gold=gold+%d WHERE id=%d", srok, id);
   DB_Update(tmp);
   new playerid = GetPlayeridByBDID(id);
   if(playerid != -1)
   {
       PlayerParams[playerid][isGold] = true;
       format(tmp, sizeof(tmp), "       %d ", srok);
       SendPlayerModText(playerid, tmp);
   }
}

DecGolds()
{
   DB_Update("UPDATE mainParam SET gold=gold-1 WHERE gold>0");
}

GetLastEveryDayUpd(&yy, &mm, &dd)
{
     new DBResult:result;
     new tmp[256];
     SQlite_Select2(result, "SELECT lastUpd_year, lastUpd_Month, lastUpd_Day FROM erpgParam");
     db_get_field_assoc(result, "lastUpd_year", tmp, sizeof(tmp));
     yy = strval(tmp);
     db_get_field_assoc(result, "lastUpd_Month", tmp, sizeof(tmp));
     mm = strval(tmp);
     db_get_field_assoc(result, "lastUpd_Day", tmp, sizeof(tmp));
     dd = strval(tmp);
}

SetLastEveryDayUpd(yy, mm, dd)
{
     new tmp[256];
	 format(tmp, sizeof(tmp), "UPDATE erpgParam SET lastUpd_year=%d, lastUpd_Month=%d, lastUpd_Day=%d", yy, mm, dd);
	 DB_Update(tmp);
}

updatePlayersExpEveryDay()
{
    new tmp[256];
	format(tmp, sizeof(tmp), "UPDATE mainParam SET experience=round(experience*%.4f) WHERE experience>%d AND gold=0", EveryDayDecExpKoef, EveryDayDecExpMin);
    DB_Update(tmp);
}

//     
DB_missions_Load()
{
	new tmp[50];
	new DBResult:result;
    for(new i=0; i<numBases; i++)
    {
          format(tmp, sizeof(tmp), "SELECT * FROM TruckerBases WHERE baseNum=%d", i);
          SQlite_Select2(result, tmp);
          db_get_field_assoc(result, "Cargo0Coef", tmp, sizeof(tmp));
          TrBKoef[i][0] = floatstr(tmp);
          db_get_field_assoc(result, "Cargo1Coef", tmp, sizeof(tmp));
          TrBKoef[i][1] = floatstr(tmp);
          db_get_field_assoc(result, "Cargo2Coef", tmp, sizeof(tmp));
          TrBKoef[i][2] = floatstr(tmp);
          Bases[i][_ownerCoef] = 0;
          db_get_field_assoc(result, "ownerID", tmp, sizeof(tmp));
          Bases[i][_owner] = strval(tmp);
          if(Bases[i][_owner] != -1)
             if(!isBandReal(Bases[i][_owner]))
             {
			    Bases[i][_owner] = -1;
			    DB_missions_ChTrBaseOwner(i, -1);
			    Bases[i][_ownerCoef] = 0;
			 }
			 else
			 {
                db_get_field_assoc(result, "ownerCoef", tmp, sizeof(tmp));
                Bases[i][_ownerCoef] = strval(tmp);
                if(Bases[i][_ownerCoef] < 0 || Bases[i][_ownerCoef] > 100) Bases[i][_ownerCoef] = 0;
             }
    }
}

//   
DB_missions_ChTrBaseOwner(baseID, ownerID)
{
	new tmp[100];
	format(tmp, sizeof(tmp), "UPDATE TruckerBases SET ownerID=%d WHERE baseNum=%d", ownerID, baseID);
    DB_Update(tmp);
}

//    
DB_missions_ChTrBaseOwnCoef(baseID, ownerCoef)
{
	new tmp[100];
	format(tmp, sizeof(tmp), "UPDATE TruckerBases SET ownerCoef=%d WHERE baseNum=%d", ownerCoef, baseID);
    DB_Update(tmp);
}

// 
DB_missions_SaveTrCoef(cargoID)
{
    new tmp[100];
    for(new i=0; i<numBases; i++)
    {
		format(tmp, sizeof(tmp), "UPDATE TruckerBases SET Cargo%dCoef=%.3f WHERE baseNum=%d", cargoID, TrBKoef[i][cargoID], i);
		DB_Update(tmp);
    }
}

//  
PrintSelect(sel[])
{
   new DBResult:myresult;
   if(SQlite_Select2(myresult, sel)==0) print("Table is empty\n\n");
   for(new i=0; i<db_num_rows(myresult); i++)
   {
	  new t1[256];
	  new t2[256];
	  new rez[256];
	  for(new k=0; k<db_num_fields(myresult); k++)
	  {
          db_get_field(myresult, k, rez, 256);
		  format(t1, sizeof(t1), "%s %10.10s", t2, rez);
		  format(t2, sizeof(t2), "%s", t1);
	  }
	  print(t2);
	  if(i<db_num_rows(myresult)-1) db_next_row(myresult);
   }
}
