//       !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//   
const MaxNumDM = 10;
new NumDMs = 0;
const maxNumWeapInDM = 3;

const MaxCoordsInDM = 20;

const MaxDMnameLenght = 30;

enum pointCoordsEnum
{
	Float: _pcX,
	Float: _pcY,
	Float: _pcZ,
	Float: _pcAng
};

new DMsCoords[MaxNumDM][MaxCoordsInDM][pointCoordsEnum];

enum DMInfoEnum
{
	_DMinter,
	_DMCoordNum,
	_DMName[MaxDMnameLenght]
};

new DMs[MaxNumDM][DMInfoEnum];

new DMweaps[MaxNumDM][maxNumWeapInDM];

LoadDMs()
{
	new tmp[256];
	new fileName[256];
	new t[10][50];
	new File:f;
	for(new i=0; i<MaxNumDM; i++)
	{
		format(fileName, sizeof(fileName), DMsPatch, i);
		if(!fexist(fileName)) break;
		f = fopen(fileName);
		//
		if(!ReadConf(f, tmp, 256, 3))
		{
            fclose(f);
			break;
		}
		StripNewLine(tmp);
		split(tmp, t, ',');
		format(DMs[i][_DMName], MaxDMnameLenght, "%s", t[0]);
		//
		if(!ReadConf(f, tmp, 256, 3))
		{
            fclose(f);
			break;
		}
		StripNewLine(tmp);
		for(new k=0; k<maxNumWeapInDM; k++) t[k] = "0";// 
		split(tmp, t, ',');
		for(new k=0; k<maxNumWeapInDM; k++)
		{
		   DMweaps[i][k] = strval(t[k]);
		   if((DMweaps[i][k] != 0) && (!IsWeapIDCorrectly(DMweaps[i][k])))
		   {
              format(tmp, sizeof(tmp), " Uncorrect weap ID (%d) for DM number %d", DMweaps[i][k], i);
              printf(tmp);
              format(tmp, sizeof(tmp), "  ID  (%d)    %d", DMweaps[i][k], i);
              SaveToLog(tmp, 0);
			  DMweaps[i][k]=0;
		   }
		}
		//
		if(!ReadConf(f, tmp, 256, 3))
		{
            fclose(f);
			break;
		}
		StripNewLine(tmp);
		split(tmp, t, ',');
		DMs[i][_DMinter] = strval(t[0]);
		//
		DMs[i][_DMCoordNum] = 0;
		for(new k=0; k<MaxCoordsInDM; k++)
		{
			if(!ReadConf(f, tmp, 256, 3)) break;
            StripNewLine(tmp);
		    split(tmp, t, ',');
		    DMsCoords[i][k][_pcX] = floatstr(t[0]);
		    DMsCoords[i][k][_pcY] = floatstr(t[1]);
		    DMsCoords[i][k][_pcZ] = floatstr(t[2]);
		    DMsCoords[i][k][_pcAng] = floatstr(t[3]);
		    DMs[i][_DMCoordNum]++;
		}
		fclose(f);
		if(DMs[i][_DMCoordNum] == 0) break;
		NumDMs++;
	}
}

TeleportToDM(playerid)
{
    if(PlayerParams[playerid][isInDM] != -1)
	{
         new rand = minrandom(0, DMs[PlayerParams[playerid][isInDM]][_DMCoordNum]);
         TeleportPlayerEx(playerid, DMsCoords[PlayerParams[playerid][isInDM]][rand][_pcX],
								    DMsCoords[PlayerParams[playerid][isInDM]][rand][_pcY],
								    DMsCoords[PlayerParams[playerid][isInDM]][rand][_pcZ],
								    DMsCoords[PlayerParams[playerid][isInDM]][rand][_pcAng],
									DMs[PlayerParams[playerid][isInDM]][_DMinter]);
         ResetPlayerWeapons(playerid);
         for(new k=0; k<maxNumWeapInDM; k++)
             if(DMweaps[PlayerParams[playerid][isInDM]][k] != 0)
			   GivePlayerWeapon(playerid, DMweaps[PlayerParams[playerid][isInDM]][k], 10000);
         SendPlayerModText(playerid, "     ,  /dmExit", 0xF0F8FFAA);
         SetPlayerColorAlpha(playerid, 0x00);
	}
}

isPlayerInDM(playerid)
{
    if(!IsPlayerConnected(playerid)) return false;
    return (PlayerParams[playerid][isInDM] != -1);
}

ExitPlayerFromDM(playerid)
{
    new name[30];
	new tmp[256];
	GetPlayerName(playerid, name, sizeof(name));
	format(tmp, sizeof(tmp), "  %s (id=%d)   ", name, playerid);
	SendTextForAllInDM(tmp);
    PlayerParams[playerid][isInDM] = -1;
    SetPlayerColorAlpha(playerid, 0xFF);
    UpdatePlayerRandomSpawn(playerid);
}

SendTextForAllInDM(text[])
{
	for(new i=0; i<MAX_PLAYERS_MY; i++)
	   if(isPlayerInDM(i))
          SendPlayerModText(i, text, 0xF0F8FFAA);
}

OnPlayerDMCommandText(playerid, cmdtext[])
{
	if(!IsPlayerConnected(playerid)) return 1;
	new cmd[256];
	ExtractParametersFromString(cmdtext, 1, cmd);
    if(isPlayerInDM(playerid))
    {
        if((strcmp(cmd, "/dmExit", true) == 0) || (strcmp(cmd, "/", true) == 0))
		{
            ExitPlayerFromDM(playerid);
            SpawnPlayer(playerid);
            return 1;
        }
    }
	return 0;
}

GetNumPlayersInDM(dmNum)
{
	new num=0;
	for(new i=0; i<MAX_PLAYERS_MY; i++)
	   if(IsPlayerConnected(i) && (PlayerParams[i][isInDM] == dmNum)) num++;
	return num;
}

isWeapForDM(weapid, dmNum)
{
	if(dmNum < 0 || dmNum >= NumDMs) return true;
	for(new i=0; i<maxNumWeapInDM; i++)
	   if(weapid == DMweaps[dmNum][i]) return true;
	return false;
}
