const maxNumBands = 30;        //  
const MaxBandName = 20;        //   
const MinBandName = 4;         //   

const MoneysForFriednlyKill = 5000;   //     

const SimplyPlayerColor = 0xFFE4C4AA;          //  
const defaultBandColor = 16770244;             //  

enum bandDescr
{
	enabled,             //  
	isChanged,           //  (  )
	bName[MaxBandName],  // 
	bMainID,             //( ) 
	bColor,              // 
	bHouseID,            //  (-1,  )
	bMoneys,             // 
	bKills,              //  
	bDeaths,             //   
	bExp                 // 
}

new bands[maxNumBands][bandDescr];     //  

//------------------------------------------------------------------------------
//
const Max_Band_LVL = 10;                           //  
new Band_EXP_For_LVL[Max_Band_LVL];                // - 
new Band_Max_Players_LVL[Max_Band_LVL];            // -  
new Band_Max_Zones_LVL[Max_Band_LVL];              // -  
new Band_MinBanditsForCapZone_LVL[Max_Band_LVL];   // -     
new truckerBaseValue = 2000000;                    //  

//  
LoadBandExpLvls()
{
   if(!fexist(BandLvlExpConfPatch)) return false;
   if(dini_Isset(BandLvlExpConfPatch, "ZoneBandExpKoeff")) ZoneBandExpKoeff = dini_Float(BandLvlExpConfPatch,"ZoneBandExpKoeff");
   if(dini_Isset(BandLvlExpConfPatch, "KillBandExpKoeff")) KillBandExpKoeff = dini_Float(BandLvlExpConfPatch,"KillBandExpKoeff");
   if(dini_Isset(BandLvlExpConfPatch, "FriendlyBandExp")) FriendlyBandExp = dini_Int(BandLvlExpConfPatch,"FriendlyBandExp");
   if(dini_Isset(BandLvlExpConfPatch, "KillWithoutBandExpBand")) KillWithoutBandExpBand = dini_Int(BandLvlExpConfPatch,"KillWithoutBandExpBand");
   if(dini_Isset(BandLvlExpConfPatch, "DeadthBandExp")) DeadthBandExp = dini_Int(BandLvlExpConfPatch,"DeadthBandExp");
   if(dini_Isset(BandLvlExpConfPatch, "MoneysForAllZonesInDay")) MoneysForAllZonesInDay = dini_Float(BandLvlExpConfPatch, "MoneysForAllZonesInDay");
   if(dini_Isset(BandLvlExpConfPatch, "B_EveryDayDecExpKoef")) B_EveryDayDecExpKoef = dini_Float(BandLvlExpConfPatch, "B_EveryDayDecExpKoef");
   if(dini_Isset(BandLvlExpConfPatch, "B_EveryDayDecExpMin")) B_EveryDayDecExpMin = dini_Int(BandLvlExpConfPatch,"B_EveryDayDecExpMin");
   if(dini_Isset(BandLvlExpConfPatch, "truckerBaseValue")) truckerBaseValue = dini_Int(BandLvlExpConfPatch,"truckerBaseValue");
   new tmp[256];
   for(new i=0; i<Max_Band_LVL; i++)
   {
	  format(tmp, sizeof(tmp), "ExpLvl_%d", i+1);
	  if(!dini_Isset(BandLvlExpConfPatch, tmp))
	  {
		 format(tmp, sizeof(tmp), " :      %d  ", i+1);
		 SaveToLog(tmp, 0);
		 return false;
	  }
	  Band_EXP_For_LVL[i] = dini_Int(BandLvlExpConfPatch, tmp);
	  if(i>0)
		if(Band_EXP_For_LVL[i] <= Band_EXP_For_LVL[i-1])
		{
		  format(tmp, sizeof(tmp), " :       .  %d      %d", i+1, i);
		  SaveToLog(tmp, 0);
		  return false;
	    }
	  format(tmp, sizeof(tmp), "Max_Players_Lvl_%d", i);
	  if(!dini_Isset(BandLvlExpConfPatch, tmp))
	  {
		 format(tmp, sizeof(tmp), " :       %d  ", i);
		 SaveToLog(tmp, 0);
		 return false;
	  }
	  Band_Max_Players_LVL[i] = dini_Int(BandLvlExpConfPatch, tmp);
	  if(i>0)
		if(Band_Max_Players_LVL[i] < Band_Max_Players_LVL[i-1])
		{
		  format(tmp, sizeof(tmp), " :       .  %d     %d", i, i-1);
		  SaveToLog(tmp, 0);
		  return false;
	    }
	  format(tmp, sizeof(tmp), "Max_Zones_Lvl_%d", i);
	  if(!dini_Isset(BandLvlExpConfPatch, tmp))
	  {
		 format(tmp, sizeof(tmp), " :       %d  ", i);
		 SaveToLog(tmp, 0);
		 return false;
	  }
	  Band_Max_Zones_LVL[i] = dini_Int(BandLvlExpConfPatch, tmp);
	  if(i>0)
		if(Band_Max_Zones_LVL[i] < Band_Max_Zones_LVL[i-1])
		{
		  format(tmp, sizeof(tmp), " :       .  %d     %d", i, i-1);
		  SaveToLog(tmp, 0);
		  return false;
	    }
	    ///
	  format(tmp, sizeof(tmp), "MinBanditsForStartCaptZone_Lvl_%d", i);
	  if(!dini_Isset(BandLvlExpConfPatch, tmp))
	  {
		 format(tmp, sizeof(tmp), " :          %d  ", i);
		 SaveToLog(tmp, 0);
		 return false;
	  }
	  Band_MinBanditsForCapZone_LVL[i] = dini_Int(BandLvlExpConfPatch, tmp);
	  if(i>0)
		if(Band_MinBanditsForCapZone_LVL[i] > Band_MinBanditsForCapZone_LVL[i-1])
		{
		  format(tmp, sizeof(tmp), " :          .  %d     %d", i, i-1);
		  SaveToLog(tmp, 0);
		  return false;
	    }
   }
   return true;
}

//,    
GetBandLastExpForNextLvl(bandID)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return 0;
   if(bands[bandID][enabled] == 0) return 0;
   if(GetBandExpLvl(bandID) >= Max_Band_LVL) return 0;
   return Band_EXP_For_LVL[GetBandExpLvl(bandID)] - bands[bandID][bExp];
}

//  
GetBandExpLvl(bandID)
{//bReputation
   if((bandID < 0) || (bandID >= maxNumBands)) return 0;
   if(bands[bandID][enabled] == 0) return 0;
   for(new i=0; i<Max_Band_LVL; i++)
	  if(bands[bandID][bExp] < Band_EXP_For_LVL[i]) return i;
   return Max_Band_LVL;
}

//    
GetBandMaxPlayers(bandID)
{
   new bLVL = GetBandExpLvl(bandID);
   if(bLVL >= Max_Band_LVL) return Band_Max_Players_LVL[Max_Band_LVL - 1];
   return Band_Max_Players_LVL[bLVL];
}

//     
GetBandMaxZones(bandID)
{
   new bLVL = GetBandExpLvl(bandID);
   if(bLVL >= Max_Band_LVL) return Band_Max_Zones_LVL[Max_Band_LVL - 1];
   return Band_Max_Zones_LVL[bLVL];
}

//     
GetMinBanditsForStartCaptZone(bandID)
{
   new bLVL = GetBandExpLvl(bandID);
   if(bLVL >= Max_Band_LVL) return Band_MinBanditsForCapZone_LVL[Max_Band_LVL - 1];
   return Band_MinBanditsForCapZone_LVL[bLVL];
}

// (     )
enum _colors
{
   clr,
   cname[20]
}

// (  )
const ColorType0Value = 1000000;
const ColorType1Value = 1200000;
const ColorType2Value = 1500000;
const ColorType3Value = 2000000;

new ColorsType0[][_colors] = {{0x00FFFF, "aqua"},
                              {0x00CED1, "darkturquoise"},
                              {0x00BFFF, "deepskyblue"},
                              {0xDCDCDC, "gainsboro"},
                              {0xDAA520, "goldenrod"},
                              {0xF0FFF0, "honeydew"},
                              {0xF0E68C, "khaki"},
                              {0xE6E6FA, "lavender"},
                              {0xFFF0F5, "lavenderblush"},
                              {0xFFFACD, "lemonchiffon"}
};

new ColorsType1[][_colors] = {{0xADD8E6, "ligtblue"},
                              {0x90EE90, "lightgreen"},
                              {0xD3D3D3, "lightgrey"},
                              {0xFFA07A, "lightsalmon"},
                              {0x20B2AA, "lightseagreen"},
                              {0x778899, "lightslategray"},
                              {0x66CDAA, "mediumaquamarine"},
                              {0x9270DB, "mediumpurple"},
                              {0x48D1CC, "mediumturquoise"},
                              {0xFFE4B5, "moccasin"}
};

new ColorsType2[][_colors] = {{0x9ACD32, "yellowgreen"},
                              {0xD8BFD8, "thistle"},
                              {0x008080, "teal"},
                              {0x6495ED, "cornflowerblue"},
                              {0x008B8B, "darkcyan"},
                              {0x9400D3, "darkviolet"},
                              {0x4B0082, "indigo"},
                              {0x778899, "lightslategray"},
                              {0x00FF00, "lime"},
                              {0x808000, "olive"}
};

new ColorsType3[][_colors] = {{0xFFFFFF, "white"},
                              {0xFFFF00, "yellown"},
                              {0x0000FF, "blue"},
                              {0xFF8C00, "darkorange"},
                              {0x808080, "gray"},
                              {0x008000, "green"},
                              {0xFF00FF, "magenta"},
                              {0x0000CD, "mediumblue"},
                              {0xFFA500, "orange"}
};
//------------------------------------------------------------------------------
// 
const Max_Date_Len = 20;            //   
enum RelationsDescr
{
   _status,                         // . 0 - ; 1-; -1 - 
   dateUpdateStatus[Max_Date_Len],  //   
   _kills,                          //   1   2
   _oldKills                        //    
}

new bandsRelations[maxNumBands][maxNumBands][RelationsDescr];   // 

//-----------------------

enum updateRqueryDescr
{
   _NewStatus,       // 
   _QueryStartTime   //  
}

//    
new rUpdateQuery[maxNumBands][maxNumBands][updateRqueryDescr];

//-----------------------

//   
isFriendlyBand(band1, band2)
{
   if((band1<0) || (band1>=maxNumBands)) return false;
   if((band2<0) || (band2>=maxNumBands)) return false;
   if((bands[band1][enabled] == 0) || (bands[band2][enabled] == 0)) return false;
   if(band2 == band1) return false;
   return (bandsRelations[band1][band2][_status] == 1);
}

//   
isHostBand(band1, band2)
{
   if((band1<0) || (band1>=maxNumBands)) return false;
   if((band2<0) || (band2>=maxNumBands)) return false;
   if((bands[band1][enabled] == 0) || (bands[band2][enabled] == 0)) return false;
   if(band2 == band1) return false;
   return (bandsRelations[band1][band2][_status] == -1);
}

//   
SetBandsRelations(band1, band2, st)
{
   if(band1 == band2) return;
   if((band1<0) || (band1>=maxNumBands)) return;
   if((band2<0) || (band2>=maxNumBands)) return;
   if((bands[band1][enabled] == 0) || (bands[band2][enabled] == 0)) return;
   if(bandsRelations[band1][band2][_status] == st) return;
   if((st != -1) && (st != 0) && (st != 1)) return;
   bandsRelations[band1][band2][_status] = st;
   bandsRelations[band2][band1][_status] = st;
   UpdateBandRelations(band1, band2);
   new tmp[255];
   switch(st)
   {
      case -1: format(tmp, sizeof(tmp), "  %s  %s  ", bands[band1][bName], bands[band2][bName]);
      case 0: format(tmp, sizeof(tmp), "  %s  %s    ", bands[band1][bName], bands[band2][bName]);
      case 1: format(tmp, sizeof(tmp), "  %s  %s   ", bands[band1][bName], bands[band2][bName]);
   }
   SendAllBandsText(tmp);
   SaveToLog(tmp, 7, band1, band2);
}

//------------------------------------------------------------------------------

//     
isPlayerInAnyBand(playerid)
{
   if(!IsPlayerConnected(playerid)) return false;
   if(PlayerParams[playerid][IsPlayerLogined] == 0) return false;
   if((PlayerParams[playerid][playerBand] < 0) ||
	  (PlayerParams[playerid][playerBand] >= maxNumBands)) return false;
   if(bands[PlayerParams[playerid][playerBand]][enabled] == 0)
   {
      if(TypeRegBase == 1) setPlayerBandStatus(playerid, -1, 0, TypeRegBase);
	  return false;
   }
   return true;
}

//      
GetPlayerStatusInBandTxt(playerid)
{
   new tmp[256];
   if(!isPlayerInAnyBand(playerid))
	  format(tmp, sizeof(tmp), "%s", " ");
   else
	 if(PlayerParams[playerid][statusBand] == 0)
        format(tmp, sizeof(tmp), "%s", " ");
     else
       if(PlayerParams[playerid][statusBand] == 1)
        format(tmp, sizeof(tmp), "%s", " ");
       else
         format(tmp, sizeof(tmp), "%d", PlayerParams[playerid][statusBand]);
   return tmp;
}

//     
isBandReal(bandID)
{
   if((bandID<0) || (bandID>=maxNumBands)) return false;
   if(bands[bandID][enabled] == 0) return false;
   return true;
}

//    
isPlayerInBand(playerid, bandID)
{
   if(!isPlayerInAnyBand(playerid)) return false;
   if(PlayerParams[playerid][playerBand] != bandID)return false;
   return true;
}

//  
SetPlayerBandColor(playerid)
{
	if(!IsPlayerConnected(playerid)) return;
	if(PlayerParams[playerid][ETDMTeam] == FIRST_TEAM_ID)
	{
         SetPlayerColor(playerid, FIRST_TEAM_COLOR);
         return;
	}
	if(PlayerParams[playerid][ETDMTeam] == SECOND_TEAM_ID)
	{
         SetPlayerColor(playerid, SECOND_TEAM_COLOR);
         return;
	}
	if(PlayerParams[playerid][IsPlayerLogined] == 0)
	{
       SetPlayerColor(playerid, SimplyPlayerColor);
	   return;
	}
	if((PlayerParams[playerid][playerBand] <= -1) ||
	   (PlayerParams[playerid][playerBand] >= maxNumBands)) SetPlayerColor(playerid, SimplyPlayerColor);
	    else
		  if(bands[PlayerParams[playerid][playerBand]][enabled] == 0) SetPlayerColor(playerid, SimplyPlayerColor);
		  else SetPlayerColorEx(playerid, bands[PlayerParams[playerid][playerBand]][bColor]);
}

//  
numBands()
{
   new t=0;
   for(new i=0; i<maxNumBands; i++)
	  if(bands[i][enabled] != 0) t++;
   return t;
}

//   
isBandNameCorrectly(name[])
{
   if((strlen(name) < MinBandName) || (strlen(name) > MaxBandName)) return false;
   for(new i=0; i<strlen(name); i++)
      if((name[i] != 91) &&
         (name[i] != 93) &&
         (name[i] != 95) &&
         !isIntBetween(name[i], 65, 90) &&
         !isIntBetween(name[i], 97, 122) &&
		 !isIntBetween(name[i], 48, 57)) return false;
   return true;
}

//      -1
GetFreeBand()
{
   for(new i=0; i<maxNumBands; i++) if(bands[i][enabled] == 0) return i;
   return -1;
}

//   
IncBandMoneys(bandID, mon)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return;
   if(bands[bandID][enabled] == 0) return;
   bands[bandID][bMoneys] += mon;
   bands[bandID][isChanged] = 1;
}

//  
IncBandKills(bandID, inc)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return;
   if(bands[bandID][enabled] == 0) return;
   bands[bandID][bKills] += inc;
   bands[bandID][isChanged] = 1;
}

//  
IncBandDeaths(bandID, inc)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return;
   if(bands[bandID][enabled] == 0) return;
   bands[bandID][bDeaths] += inc;
   bands[bandID][isChanged] = 1;
}

//  
IncBandExp(bandID, inc)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return;
   if(bands[bandID][enabled] == 0) return;
   bands[bandID][bExp] += inc;
   if(bands[bandID][bExp] < 0) bands[bandID][bExp] = 0;
   bands[bandID][isChanged] = 1;
}

//  
updateBandsExpEveryDay()
{
   for(new i=0; i<maxNumBands; i++)
	  if(bands[i][enabled] != 0)
		if(bands[i][bExp] > B_EveryDayDecExpMin)
		{
             bands[i][bExp] = floatround(B_EveryDayDecExpKoef*float(bands[i][bExp]));
             bands[i][isChanged] = 1;
        }
}

//  
SetBandColor(bandID, color)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return;
   if(bands[bandID][enabled] == 0) return;
   bands[bandID][bColor] = color;
   UpdateBand(bandID);
   for(new i = 0; i <= MaxPlayerID; i++)
	   if(IsPlayerConnected(i))
		 if(PlayerParams[i][IsPlayerLogined] != 0)
	       if(PlayerParams[i][playerBand] == bandID)
              SetPlayerColor(i, GetColorMy(color));
}

//  
SetBandNewMain(bandID, mID)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return;
   if(bands[bandID][enabled] == 0) return;
   bands[bandID][bMainID] = mID;
   UpdateBand(bandID);
}

//    
SendBandsText(bandID, text[])
{
   if((bandID < 0) || (bandID >= maxNumBands)) return;
   if(bands[bandID][enabled] == 0) return;
   for(new i = 0; i <= MaxPlayerID; i++)
	   if(IsPlayerConnected(i))
		 if(PlayerParams[i][IsPlayerLogined] != 0)
	       if(PlayerParams[i][playerBand] == bandID)
              SendPlayerModText(i, text, 0xAA3333AA);
}

//    
SendAllBandsText(text[], _bID=-1)//  ,  _bID
{
   for(new i = 0; i <= MaxPlayerID; i++)
	   if(IsPlayerConnected(i))
		 if(PlayerParams[i][IsPlayerLogined] != 0)
	       if((PlayerParams[i][playerBand] != -1) && (PlayerParams[i][playerBand] != _bID))
              SendPlayerModText(i, text, 0xAA3333AA);
}

//   - 
isBandColorOccup(color)
{
   for(new i=0; i<maxNumBands; i++)
       if(bands[i][enabled] != 0)
	       if(bands[i][bColor] == color) return true;
   return false;
}

//    
UpdateBandResp(bandID)
{
   for(new i = 0; i <= MaxPlayerID; i++)
      if(isPlayerInBand(i, bandID))
         UpdatePlayerRandomSpawn(i);
}

//     ,      
GetNumWarBanditsForBandOnServ(bandID)
{
   new num=0;
   if((bandID < 0) || (bandID >= maxNumBands)) return 0;
   for(new i=0; i<MAX_PLAYERS_MY; i++)
	 if(IsPlayerConnected(i) && isPlayerInAnyBand(i))
		if(isHostBand(bandID, PlayerParams[i][playerBand])) num++;
   return num;
}

//    
GetBandDBVBase(bandID)
{
   for(new i=0; i<numBases; i++)
	 if(Bases[i][_owner] == bandID)
		 return i;
   return -1;
}
