const numCrashBoxPoints = 20;
new Float:CrashBoxPoints[numCrashBoxPoints][3];

const crashBoxPicUP_model = 1224;
const CrashBoxStartIconModel = 37;
const CrashBoxFinishIconModel = 43;

new Float:avgDistanceCrashBoxPts = 0.0;   //   (   )
new CrashBox_status = 0;                  // : 0-; 1-  ; 2-  

new crashBoxPlayerID = -1;                //  
new crashBoxPicUP_ID = -1;                //  
new crashBoxFinishCP = -1;                //  -  
const crashBoxIconStartID = 25;           // -
const crashBoxIconFinishID = 26;          // -
new crashBoxStartPoint = -1;              // -
new crashBoxFinishPoint = -1;             // -
new crashBoxPremium = 0;                  //  

InitCrashBoxPoints()
{
	if(!fexist(CrashBoxPointsPatch))
	{
        SaveToLog("      CrashBox", 0);
		return false;
	}
	new File:f = fopen(CrashBoxPointsPatch, io_read);
	new tmp[255];
	new t[10][50];
	
	for(new i=0; i<numCrashBoxPoints; i++)
	{
		if(!fread(f, tmp))
		{
		   fclose(f);
		   SaveToLog("       CrashBox", 0);
	       return false;
		}
		StripNewLine(tmp);
		if((strlen(tmp) < 20) || ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*"))
		{
		   i--;
		   continue;
		}
		split(tmp, t, ',');
		CrashBoxPoints[i][0] = floatstr(t[0]);
		CrashBoxPoints[i][1] = floatstr(t[1]);
		CrashBoxPoints[i][2] = floatstr(t[2]);
	}
	fclose(f);
	avgDistanceCrashBoxPts = 0.0;
	new num = 0;
	new Float:d;
	for(new i=0; i<numCrashBoxPoints-1; i++)
	  for(new k=i+1; k<numCrashBoxPoints; k++)
	  {
		  d = GetDistanceBetweenPoints(CrashBoxPoints[i][0],
		                               CrashBoxPoints[i][1],
									   CrashBoxPoints[i][2],
									   CrashBoxPoints[k][0],
									   CrashBoxPoints[k][1],
									   CrashBoxPoints[k][2]);
          avgDistanceCrashBoxPts += d;
          num++;
	  }
	//printf("SumDis: %f; num= %d", avgDistanceCrashBoxPts, num);
	avgDistanceCrashBoxPts = floatdiv(avgDistanceCrashBoxPts, float(num));
	if(avgDistanceCrashBoxPts <= 0)
	{
         SaveToLog("      .    ", 0);
	     return false;
	}
	return true;
}

public Timer_CashBoxInit()
{
	if(CrashBox_status == 1)
	{
        DelPic(crashBoxPicUP_ID);
        crashBoxPicUP_ID = -1;
        DestroyGlobalIcon(crashBoxIconStartID);
        DestroyGlobalIcon(crashBoxIconFinishID);
        DeleteCP(crashBoxFinishCP);
        CrashBox_status = 0;
        SendModTextToAll("       ", 0x33AA33AA);
        return;
	}
	if(CrashBox_status == 2)
	{
        crashBoxPicUP_ID = -1;
        DestroyGlobalIcon(crashBoxIconStartID);
        DestroyGlobalIcon(crashBoxIconFinishID);
        DeleteCP(crashBoxFinishCP);
        CrashBox_status = 0;
        SendModTextToAll("       ", 0x33AA33AA);
        SendPlayerModText(crashBoxPlayerID, "  , ");
        crashBoxPlayerID = -1;
        return;
	}
	crashBoxStartMission();
}

public Timer_CashBoxCheck()
{
	if(CrashBox_status == 2)
	{
		if(!IsPlayerConnected(crashBoxPlayerID))
		{
            new Float:x, Float:y, Float:z;
	        x = CrashBoxPoints[crashBoxStartPoint][0];
	        y = CrashBoxPoints[crashBoxStartPoint][1];
	        z = CrashBoxPoints[crashBoxStartPoint][2];
	        crashBoxPicUP_ID = CrPic(crashBoxPicUP_model,x,y,z,-1,1,0,PicType_CrashBox);
            if(crashBoxPicUP_ID == -1)
            {
	             SaveToLog(" :        CrashBox", 0);
	             SendModTextToAll("    ", 0x33AA33AA);
	             DestroyGlobalIcon(crashBoxIconStartID);
	             DestroyGlobalIcon(crashBoxIconFinishID);
	             DeleteCP(crashBoxFinishCP);
	             CrashBox_status = 0;
	             return;
	        }
	        DestroyGlobalIcon(crashBoxIconStartID);
	        CreateGlobalIcon(CrashBoxStartIconModel, x, y, z, 0xFFFFFFAA, crashBoxIconStartID);
	        HidePlayerCP(crashBoxPlayerID, crashBoxFinishCP);
	        new tmp[255];
	        format(tmp, sizeof(tmp), "     .     %d$", crashBoxPremium);
            SendModTextToAll(tmp, 0x33AA33AA);
            SaveToLog(" :    CrashBox.   - 2,   . ", 0);
            crashBoxPlayerID = -1;
            CrashBox_status=1;
		}
		else
		{/*
			if(GetPlayerState(crashBoxPlayerID) == PLAYER_STATE_ONFOOT)
               GivePlayerWeapon(crashBoxPlayerID, 0, 1);
            else*/
			  if(GetPlayerState(crashBoxPlayerID) == PLAYER_STATE_PASSENGER)
			  {
                 SendPlayerModText(crashBoxPlayerID, "       ");
                 RemovePlayerFromVehicle(crashBoxPlayerID);
			  }
			  else
				 if(GetPlayerState(crashBoxPlayerID) == PLAYER_STATE_DRIVER)
					if(IsPlayerInHelicopter(crashBoxPlayerID) ||
					   IsPlayerInPlane(crashBoxPlayerID) ||
					   IsPlayerInTrain(crashBoxPlayerID))
					{
                        SendPlayerModText(crashBoxPlayerID, "         ");
                        RemovePlayerFromVehicle(crashBoxPlayerID);
					}
		}
	}
}

crashBoxStartMission()
{
    crashBoxStartPoint = minrandom(0, numCrashBoxPoints);
    new i=0;
    crashBoxFinishPoint = crashBoxStartPoint;
    while(avgDistanceCrashBoxPts > GetDistanceBetweenPoints(CrashBoxPoints[crashBoxFinishPoint][0],
			                                                CrashBoxPoints[crashBoxFinishPoint][1],
			                                                CrashBoxPoints[crashBoxFinishPoint][2],
			                                                CrashBoxPoints[crashBoxStartPoint][0],
			                                                CrashBoxPoints[crashBoxStartPoint][1],
			                                                CrashBoxPoints[crashBoxStartPoint][2]))
	{
		  if(i>50)
		  {
             SaveToLog(" :         CrashBox", 0);
		     return false;
		  }
		  i++;
		  crashBoxFinishPoint = minrandom(0, numCrashBoxPoints);
	}
	crashBoxPlayerID = -1;
	crashBoxPicUP_ID = CrPic(crashBoxPicUP_model,
	                         CrashBoxPoints[crashBoxStartPoint][0],
							 CrashBoxPoints[crashBoxStartPoint][1],
			                 CrashBoxPoints[crashBoxStartPoint][2],
							 -1,
							 1,
							 0,
							 PicType_CrashBox);
	if(crashBoxPicUP_ID == -1)
	{
	   SaveToLog(" :        CrashBox", 0);
	   return false;
	}
	CreateGlobalIcon(CrashBoxStartIconModel,
	                 CrashBoxPoints[crashBoxStartPoint][0],
					 CrashBoxPoints[crashBoxStartPoint][1],
			         CrashBoxPoints[crashBoxStartPoint][2],
					 0xFFFFFFAA,
					 crashBoxIconStartID);
    CreateGlobalIcon(CrashBoxFinishIconModel,
	                 CrashBoxPoints[crashBoxFinishPoint][0],
					 CrashBoxPoints[crashBoxFinishPoint][1],
			         CrashBoxPoints[crashBoxFinishPoint][2],
					 0xAA3333AA,
					 crashBoxIconFinishID);
	CrashBox_status = 1;
	new Float:dis = GetDistanceBetweenPoints(CrashBoxPoints[crashBoxFinishPoint][0],
			                                 CrashBoxPoints[crashBoxFinishPoint][1],
			                                 CrashBoxPoints[crashBoxFinishPoint][2],
			                                 CrashBoxPoints[crashBoxStartPoint][0],
			                                 CrashBoxPoints[crashBoxStartPoint][1],
			                                 CrashBoxPoints[crashBoxStartPoint][2]);
	crashBoxPremium = floatround(floatmul(10.0, dis));
	crashBoxFinishCP = CreateCP(CrashBoxPoints[crashBoxFinishPoint][0], CrashBoxPoints[crashBoxFinishPoint][1], CrashBoxPoints[crashBoxFinishPoint][2], 10.0, 100.0, 0, 1);
	new tmp[255];
	format(tmp, sizeof(tmp), " : -    .         %d$.", crashBoxPremium);
	SendModTextToAll(tmp, 0x33AA33AA);
	SendModTextToAll(" ,    ", 0x33AA33AA);
	return true;
}

crashBoxPlayerDieOrDisconnect()
{
	new Float:x, Float:y, Float:z;
	GetPlayerPos(crashBoxPlayerID, x, y, z);
	crashBoxPicUP_ID = CrPic(crashBoxPicUP_model,x,y,z,-1,1,0,PicType_CrashBox);
    if(crashBoxPicUP_ID == -1)
    {
	   SaveToLog(" :        CrashBox", 0);
	   SendModTextToAll("    ", 0x33AA33AA);
	   DestroyGlobalIcon(crashBoxIconStartID);
	   DestroyGlobalIcon(crashBoxIconFinishID);
	   DeleteCP(crashBoxFinishCP);
	   CrashBox_status = 0;
	   return;
	}
	DestroyGlobalIcon(crashBoxIconStartID);
	CreateGlobalIcon(CrashBoxStartIconModel, x, y, z, 0xFFFFFFAA, crashBoxIconStartID);
	HidePlayerCP(crashBoxPlayerID, crashBoxFinishCP);
	new tmp[255];
	format(tmp, sizeof(tmp), "   .     %d$", crashBoxPremium);
    SendModTextToAll(tmp, 0x33AA33AA);
    crashBoxPlayerID = -1;
    CrashBox_status=1;
}

crashBoxBoxUpped(playerid)
{
   SendPlayerModText(playerid, " !!   .   ");
   ShowPlayerCP(playerid, crashBoxFinishCP);
   DelPic(crashBoxPicUP_ID);
   crashBoxPicUP_ID = -1;
   crashBoxPlayerID = playerid;
   CrashBox_status = 2;
   new name[50];
   GetPlayerName(playerid, name, sizeof(name));
   new tmp[255];
   format(tmp, sizeof(tmp), " %s       .  ,    %d$", name, crashBoxPremium);
   SendModTextToAll(tmp, 0x33AA33AA);
}

crashBoxPlayerFinish()
{
   new name[50];
   GetPlayerName(crashBoxPlayerID, name, sizeof(name));
   new tmp[255];
   format(tmp, sizeof(tmp), " %s        %d$", name, crashBoxPremium);
   SendModTextToAll(tmp, 0x33AA33AA);
   format(tmp, sizeof(tmp), " CrashBox:     . : %d$", name, crashBoxPremium);
   SaveToLog(tmp, 15, crashBoxPlayerID);
   missions(crashBoxPlayerID, 3, crashBoxPremium, 0.0);
   DestroyGlobalIcon(crashBoxIconStartID);
   DestroyGlobalIcon(crashBoxIconFinishID);
   DeleteCP(crashBoxFinishCP);
   CrashBox_status = 0;
   crashBoxPlayerID=-1;
}
