
enum _DepTypeDescr
{
   _DepozitName[50],        // 
   _MinimumMoneys,          //   
   Float:_DepIncrease,      //
   Float:_bankCrash,        // 
   _DepTimeNextTick         //  
}

const numDepozitsTypes=4;   //  

new DepozitTypes[numDepozitsTypes][_DepTypeDescr];

const NumDepozitsInBank=1000;

const numMaxErrorTranzact = 5;

const NumBanks = 4;

const Float:BankComission = 0.03;  // 
const BankMinMoney = 1000;          // ,    
const BankMinComission = 100;       // 

const Float:BankHBuyComission = 0.01;  //    

// .  . .    
new Float:BanksCoords[NumBanks][8];

new BankCPs[NumBanks];

// 
DepozitsInit()
{
	new oneHour = 3600000;
	new FiveMinute = 300000;
	new TmpTime = GTick()+oneHour;
	for(new i=0; i<numDepozitsTypes; i++)
	{
	   DepozitTypes[i][_DepTimeNextTick] = TmpTime;
	   TmpTime+= FiveMinute;
	}
}

LoadBankConfig()
{
   new tmp[256];
   new t[20];
   new t2[10][50];
   if(!fexist(BankPatch)) return false;
   for(new i=0; i<NumBanks; i++)
   {
	   format(t, sizeof(t), "BankCP_%d", i);
       if(dini_Isset(BankPatch, t))
	   {
	       tmp = dini_Get(BankPatch,t);
	       split(tmp, t2, ',');
	       for(new k=0; k<8; k++)
              BanksCoords[i][k] = floatstr(t2[k]);
	   }
	   else
	   {
	       printf("Unable to load %d bank coords", i);
	       return false;
	   }
   }
   for(new i=1; i<=numDepozitsTypes; i++)
   {
       format(t, sizeof(t), "DepozType_%d", i);
       if(dini_Isset(BankPatch, t))
	   {
	       tmp = dini_Get(BankPatch,t);
	       split(tmp, t2, ',');
	       DepozitTypes[i-1][_MinimumMoneys] = strval(t2[0]);
	       DepozitTypes[i-1][_DepIncrease] = floatstr(t2[1]);
	       DepozitTypes[i-1][_bankCrash] = floatstr(t2[2]);
	       format(DepozitTypes[i-1][_DepozitName], 50, "%s", t2[3]);
	   }
	   else
	   {
	       printf("Unable to load %d depozit type", i);
	       return false;
	   }
   }
   return true;
}

UpdateDepozit(i)
{
    new tmp[150];
    DepozitTypes[i][_DepTimeNextTick] = GTick() + 3600000;
    if(GetRandom(floatdiv(DepozitTypes[i][_bankCrash], 100)))
    {
        UpdateDepozitsCrash(i+1);
        format(tmp, sizeof(tmp), " :  '%s'   .", DepozitTypes[i][_DepozitName]);
        SendModTextToAll(tmp, 0x4B00B0AA);
        SaveToLog(tmp, 12);
    }
    else
        UpdateDepozitsIncrease(i+1, DepozitTypes[i][_DepIncrease]);
}

public Timer_DepozitsTick()
{
	for(new i=0; i<numDepozitsTypes; i++)
		if(GTick() > DepozitTypes[i][_DepTimeNextTick])
           UpdateDepozit(i);
}

GetTypeDepozitName(numType)
{
	new tmp[256];
	format(tmp, sizeof(tmp), "%s", " ");
	if((numType<1) || (numType>numDepozitsTypes)) return tmp;
	format(tmp, sizeof(tmp), "%s", DepozitTypes[numType-1][_DepozitName]);
	return tmp;
}

GetTypeDepozitMinMoneys(numType)
{
	if((numType<1) || (numType>numDepozitsTypes)) return 0;
	return DepozitTypes[numType-1][_MinimumMoneys];
}

Float:GetTypeDepozitIncrease(numType)
{
	if((numType<1) || (numType>numDepozitsTypes)) return 0.0;
	return DepozitTypes[numType-1][_DepIncrease];
}

Float:GetTypeDepozitCrash(numType)
{
	if((numType<1) || (numType>numDepozitsTypes)) return 0.0;
	return DepozitTypes[numType-1][_bankCrash];
}

ErrorBankTranzact(playerid)
{
    PlayerParams[playerid][_NumErrorsInBank]++;
    new tmp[256];
    if(PlayerParams[playerid][_NumErrorsInBank] >= numMaxErrorTranzact)
    {
		new name[50];
		GetPlayerName(playerid, name, sizeof(name));
		format(tmp, sizeof(tmp), "  %s(id=%d)        %d ", name, playerid, PlayerParams[playerid][_NumErrorsInBank]);
		SendModTextToAll(tmp, 0xFFFFFFAA);
		SaveToLog(tmp, 12, playerid);
		PlayerParams[playerid][noShowDisconnectMsg] = 1;
		Kick(playerid);
    }
    else
    {
        format(tmp, sizeof(tmp), " ,   %d ,     .( %d)", numMaxErrorTranzact, PlayerParams[playerid][_NumErrorsInBank]);
        SendPlayerModText(playerid, tmp, 0x4B00B0AA);
	}
}

isPlayerInBank(playerid)
{
	for(new i=0; i<NumBanks; i++)
	   if(IsPlayerNearPoint(playerid, BanksCoords[i][0], BanksCoords[i][1], BanksCoords[i][2], BanksCoords[i][3])) return true;
	return false;
}

ShowPlayerBankDialog(playerid)
{
    ShowPlayerDialog(playerid,50,DIALOG_STYLE_LIST,""," \n  \n \n ","OK","");
}

ShowPlayerBankCreateDialog(playerid)
{
    ShowPlayerDialog(playerid,51,DIALOG_STYLE_INPUT,"", " :\n[] [ ] [ ] []","OK","");
}

ShowPlayerBankInfoDialog(playerid)
{
	ShowPlayerDialog(playerid,52,DIALOG_STYLE_INPUT,"", " :\n[] []","OK","");
}

ShowPlayerBankTakeDialog(playerid)
{
	ShowPlayerDialog(playerid,53,DIALOG_STYLE_INPUT,"", " :\n[] [] []","OK","");
}

ShowPlayerBankAddDialog(playerid)
{
	ShowPlayerDialog(playerid,54,DIALOG_STYLE_INPUT,"", " :\n[] [] []","OK","");
}

