const NumHouses = 500;
const MaxVechsToHous = 5;

const housePicUpType = 2;
const FreeHousePicUpID = 1273;
const OwnedHousePicUpID = 1239;

const PersonalHouseMapIconID = 35;
const PersonalHouseIndNum = 999;
const BandHouseMapIconID = 35;
const BandHouseIndNum = 998;
const GatesViewDis=300;

new InsideHousePickup = false;
new hidedialogtimer[MAX_PLAYERS];
#pragma unused InsideHousePickup

new DefaultCode[255] = "3valenka";

#define MAX_HOUSE_WEAPONS 6
forward UpdateHouseWeaponBox();

enum _houses
{
	_isLoaded,                 // 
	_owner,                    //  
	ownerName[MAX_PLAYER_NAME],// 
	_spawnMoney,               //   
	_ownerType,                //0 - ; 1 - ; 2 - 
	_picUD_ID,                 //  
	Float:_picUpCoordX,        // 
	Float:_picUpCoordY,        // 
	Float:_picUpCoordZ,        // 
	Float:_SpawnCoordX,        // 
	Float:_SpawnCoordY,        // 
	Float:_SpawnCoordZ,        // 
	Float:_SpawnCoordAng,      // 
	_SpawnCoordInterior,       // 
	_baseValue,                // 
	_ownerValue,               //,  
	_isForSale,                //    
	_Gate,                     // -1,  
    _maxHouseVechs,            //   
    _weapons[MAX_HOUSE_WEAPONS],//   . 0 - TEC9, 1 - UZI, 2 - AK47, 3 - M4, 4 - Sawn-off Shotgun, 5 - RPG.
    _codelock[255],             // 
    _vault                      //  
}

new Houses[NumHouses][_houses];

enum _houseVechs
{
    _HouseVechs_ID,        //   vhls
    _HousesVechs_Model,    // 
    _HouseVechs_Tuning,    //0 - 1 - 2
    _HouseVechs_Lock,      //  
    Float:_HouseVechs_X,   // 
    Float:_HouseVechs_Y,   // 
    Float:_HouseVechs_Z,   // 
    Float:_HouseVechs_ang, // 
    _color1,               //  
    _color2                //  
}

new HouseVechs[NumHouses][MaxVechsToHous][_houseVechs];

//------------------------------------------------------------------------------
enum HousesCarsColorsEnum
{
   _colorName[20],// 
   _clr,          //
   _value         //
}

new HousesCarsColors[][HousesCarsColorsEnum] = {{"WHITE", 1, 10000},
												{"GREY", 11, 10000},
												{"GREEN", 16, 10000},
												{"RED", 3, 10000},
												{"YELLOW", 46, 10000},
												{"BLUE", 7, 10000},
												{"BLACK", 0, 10000},
												{"GOLD", 65, 10000},
												{"PINK", 126, 10000}
};

const TuningType1_moneys = 200000;
const TuningType2_moneys = 500000;
const HouseCar_CarDoormoney = 200000;

//------------------------------------------------------------------------------
const MaxGates = 255;
enum GatesDescriptor
{
   _isLoad,
   _part1_state,//0-: 1- 
   _part1_house,
   _part1_model, // 
   _part1_objectID,
   Float:_part1_x,
   Float:_part1_y,
   Float:_part1_z,
   Float:_part1_xr,
   Float:_part1_yr,
   Float:_part1_zr,
   Float:_part1_x_open,
   Float:_part1_y_open,
   Float:_part1_z_open,
   Float:_part1_speed
}

new gates[MaxGates][GatesDescriptor];

GatesLoad()
{
//GatesPatch
    if(!fexist(GatesPatch))
	{
        SaveToLog("     ", 0);
	    return false;
	}
    for(new i=0; i<sizeof(gates); i++)
    {
        gates[i][_isLoad] = 0;
        gates[i][_part1_state] = 0;
        gates[i][_part1_house] = -1;
        gates[i][_part1_objectID] = INVALID_OBJECT_ID;
        //
    }
	new File:f = fopen(GatesPatch, io_read);
	new tmp[255];
	new t[20][50];
	//
	for(new i=0; i<MaxGates; i++)
	{
		if(!fread(f, tmp)) break;
        StripNewLine(tmp);
        if((strlen(tmp) < 20) || ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*"))
		{
		   i--;
		   continue;
		}
		split(tmp, t, ',');
		gates[i][_part1_model] = strval(t[0]);
		gates[i][_part1_x] = floatstr(t[1]);
		gates[i][_part1_y] = floatstr(t[2]);
		gates[i][_part1_z] = floatstr(t[3]);
		gates[i][_part1_xr] = floatstr(t[4]);
		gates[i][_part1_yr] = floatstr(t[5]);
		gates[i][_part1_zr] = floatstr(t[6]);
		gates[i][_part1_x_open] = floatstr(t[7]);
		gates[i][_part1_y_open] = floatstr(t[8]);
		gates[i][_part1_z_open] = floatstr(t[9]);
		gates[i][_part1_speed] = floatstr(t[10]);
		gates[i][_isLoad] = 1;
	}
	fclose(f);
	return true;
}

GatesInit()
{
	for(new i=0; i<MaxGates; i++)
	   if(gates[i][_isLoad] == 1)
		   if(gates[i][_part1_house] == -1) gates[i][_part1_objectID] = AddObjectToList(GatesViewDis,
		                                                                        gates[i][_part1_model],
		                                                                        gates[i][_part1_x_open],
													                            gates[i][_part1_y_open],
												 	                            gates[i][_part1_z_open],
													                            gates[i][_part1_xr],
												 	                            gates[i][_part1_yr],
													                            gates[i][_part1_zr]);
		   else if(Houses[gates[i][_part1_house]][_ownerType] == 0) gates[i][_part1_objectID] = AddObjectToList(GatesViewDis,
		                                                                                                gates[i][_part1_model],
		                                                                                                gates[i][_part1_x_open],
													                                                    gates[i][_part1_y_open],
												 	                                                    gates[i][_part1_z_open],
													                                                    gates[i][_part1_xr],
												 	                                                    gates[i][_part1_yr],
													                                                    gates[i][_part1_zr]);
				else
				{
                     gates[i][_part1_state] = 1;
				     gates[i][_part1_objectID] = AddObjectToList(GatesViewDis,
					                                     gates[i][_part1_model],
		                                                 gates[i][_part1_x],
													     gates[i][_part1_y],
												 	     gates[i][_part1_z],
													     gates[i][_part1_xr],
												 	     gates[i][_part1_yr],
													     gates[i][_part1_zr]);
				}
}

OpenGate(gateID)
{
	if((gateID < 0) || (gateID >=MaxGates)) return;
	if(gates[gateID][_isLoad] != 1) return;
	if(gates[gateID][_part1_state] == 0) return;
	gates[gateID][_part1_state] = 0;
	MoveObjectMy(gates[gateID][_part1_objectID], gates[gateID][_part1_x_open], gates[gateID][_part1_y_open], gates[gateID][_part1_z_open], gates[gateID][_part1_speed]);
}

public CloseGate(gateID)
{
	if((gateID < 0) || (gateID >=MaxGates)) return;
	if(gates[gateID][_isLoad] != 1) return;
	if(gates[gateID][_part1_state] == 1) return;
	gates[gateID][_part1_state] = 1;
	MoveObjectMy(gates[gateID][_part1_objectID], gates[gateID][_part1_x], gates[gateID][_part1_y], gates[gateID][_part1_z], gates[gateID][_part1_speed]);
}

NumLoadedGates()
{
	new num = 0;
	for(new i=0; i<MaxGates; i++)
	   if(gates[i][_isLoad] != 0) num++;
	return num;
}

GetClosestGate(playerid)
{
	for(new i=0; i<MaxGates; i++)
	   if(gates[i][_isLoad] == 1)
          if(IsPlayerNearPoint(playerid, gates[i][_part1_x],
		                                 gates[i][_part1_y],
										 gates[i][_part1_z],
									 	 50.0)) return i;
	return -1;
}

//------------------------------------------------------------------------------

LoadHouses()
{
	if(!fexist(housesPatch))
	{
        SaveToLog("     ", 0);
	    return false;
	}
	new File:f = fopen(housesPatch, io_read);
	new tmp[255];
	new t[20][50];
	new numLoadedHouses = -1;
	//
	for(new i=0; i<NumHouses; i++)
	{
		if(!fread(f, tmp)) break;
		StripNewLine(tmp);
		if((strlen(tmp) < 20) || ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*"))
		{
		   i--;
		   continue;
		}
		split(tmp, t, ',');
		Houses[i][_spawnMoney] = strval(t[0]);
		Houses[i][_picUpCoordX] = floatstr(t[1]);
		Houses[i][_picUpCoordY] = floatstr(t[2]);
		Houses[i][_picUpCoordZ] = floatstr(t[3]);
		Houses[i][_SpawnCoordX] = floatstr(t[4]);
		Houses[i][_SpawnCoordY] = floatstr(t[5]);
		Houses[i][_SpawnCoordZ] = floatstr(t[6]);
		Houses[i][_SpawnCoordAng] = floatstr(t[7]);
		Houses[i][_SpawnCoordInterior] = strval(t[8]);
		Houses[i][_baseValue] = strval(t[9]);
		Houses[i][_Gate] = strval(t[10]);
		if((Houses[i][_Gate] < 0) || (Houses[i][_Gate] >= MaxGates)) Houses[i][_Gate] = -1;
		if(Houses[i][_Gate] != -1)
			if(gates[Houses[i][_Gate]][_isLoad] == 0) Houses[i][_Gate] = -1;
			else gates[Houses[i][_Gate]][_part1_house] = i;
		Houses[i][_maxHouseVechs] = strval(t[11]);
		Houses[i][_isLoaded] = 1;
		set(Houses[i][_codelock], DefaultCode);
		numLoadedHouses = i;
	}
	fclose(f);
	for(new i=numLoadedHouses+1; i<NumHouses; i++)
         Houses[i][_isLoaded] = 0;
	if(!fexist(housesVechPatch)) 
	{
        SaveToLog("       ", 0);
	    return false;
	}
	f = fopen(housesVechPatch, io_read);
	//
	for(new i=0; i<=numLoadedHouses; i++)
	{
		if(!fread(f, tmp))
		{
            fclose(f);
            SaveToLog("       ", 0);
            return false;
		}
		StripNewLine(tmp);
		if(ifStrStartedFromStr(tmp, "*"))
		{
		   i--;
		   continue;
		}
		split(tmp, t, ',');
		for(new k=0; k<MaxVechsToHous; k++)
		{
		   if(k<Houses[i][_maxHouseVechs])
		   {
		     HouseVechs[i][k][_HouseVechs_X] = floatstr(t[4*k]);
		     HouseVechs[i][k][_HouseVechs_Y] = floatstr(t[4*k+1]);
		     HouseVechs[i][k][_HouseVechs_Z] = floatstr(t[4*k+2]);
		     HouseVechs[i][k][_HouseVechs_ang] = floatstr(t[4*k+3]);
		     HouseVechs[i][k][_HouseVechs_ID] = -1;
		     HouseVechs[i][k][_HousesVechs_Model] = 0;
		     //
		     HouseVechs[i][k][_color1] = -1;
		     HouseVechs[i][k][_color2] = -1;
		   }
		}

	}
	fclose(f);
	//     
	//   
	if(!LoadHousesInfoFromBD())
	{
       SaveToLog("         ", 0);
	   return false;
	}
	UpdateHouseWeaponBox(); //  
    return true;
}

NumLoadedHouses()
{
   new num=0;
   for(new i=0; i<NumHouses; i++)
	  if(Houses[i][_isLoaded] == 1)
		 num++;
   return num;
}

GetPlayerClosestHouse(playerid)
{
   for(new i=0; i<sizeof(Houses); i++)
	  if(Houses[i][_isLoaded] == 1)
		 if(IsPlayerNearPoint(playerid, Houses[i][_picUpCoordX],
									    Houses[i][_picUpCoordY],
									    Houses[i][_picUpCoordZ],
										5.0)) return i;
   return -1;
}

InitHouses()
{
   for(new i=0; i<NumLoadedHouses(); i++)
   {
	   if(Houses[i][_ownerType] == 0)
          Houses[i][_picUD_ID] = CrPic(FreeHousePicUpID,
		                               Houses[i][_picUpCoordX],
									   Houses[i][_picUpCoordY],
									   Houses[i][_picUpCoordZ], -1, 1, 0, PicType_Houses);
	   else Houses[i][_picUD_ID] = CrPic(OwnedHousePicUpID,
		                                 Houses[i][_picUpCoordX],
									     Houses[i][_picUpCoordY],
									     Houses[i][_picUpCoordZ], -1, 1, 0, PicType_Houses);
   }
   
   InsideHousePickup = CrPic(FreeHousePicUpID, 234.2826, 1065.229, 1084.2101, -1, -1, 0, PicType_InsideHouses);
}

UpdateHousePicUp(houseID)
{
   DelPic(Houses[houseID][_picUD_ID]);
   if(Houses[houseID][_ownerType] == 0)
          Houses[houseID][_picUD_ID] = CrPic(FreeHousePicUpID,
		                                     Houses[houseID][_picUpCoordX],
									         Houses[houseID][_picUpCoordY],
									         Houses[houseID][_picUpCoordZ], -1, 1, 0, PicType_Houses);
   else Houses[houseID][_picUD_ID] = CrPic(OwnedHousePicUpID,
		                                   Houses[houseID][_picUpCoordX],
									       Houses[houseID][_picUpCoordY],
									       Houses[houseID][_picUpCoordZ], -1, 1, 0, PicType_Houses);
}

GetHousesFreeSlot(houseID)
{
   for(new i=0; i<Houses[houseID][_maxHouseVechs]; i++)
	  if(HouseVechs[houseID][i][_HouseVechs_ID] == -1)
		  return i;
   return -1;
}

isPlayerHaveHouseVehicle(playerid, slotID)
{
   if(PlayerParams[playerid][IsPlayerLogined] == 0) return false;
   if(PlayerParams[playerid][hID] == -1) return false;
   if((slotID < 0) || (slotID >= MaxVechsToHous)) return false;
   if(slotID >= Houses[PlayerParams[playerid][hID]][_maxHouseVechs]) return false;
   if(HouseVechs[PlayerParams[playerid][hID]][slotID][_HouseVechs_ID] == -1) return false;
   return true;
}

isBandHaveHouseVehicle(bandID, slotID)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return false;
   if((bands[bandID][enabled] == 0) || (bands[bandID][bHouseID] == -1)) return false;
   if((slotID < 0) || (slotID >= MaxVechsToHous)) return false;
   if(slotID >= Houses[bands[bandID][bHouseID]][_maxHouseVechs]) return false;
   if(HouseVechs[bands[bandID][bHouseID]][slotID][_HouseVechs_ID] == -1) return false;
   return true;
}

isBandHaveHouse(bandID)
{
   if((bandID < 0) || (bandID >= maxNumBands)) return false;
   if(bands[bandID][enabled] == 0) return false;
   if(bands[bandID][bHouseID] == -1) return false;
   return true;
}

HouseSell(numH)
{
   Houses[numH][_ownerType] = 0;
   Houses[numH][_owner] = -1;
   Houses[numH][_isForSale] = 0;
   format(Houses[numH][ownerName], MAX_PLAYER_NAME, "%s", "none");
   UpdateHouse(numH);
   UpdateHousePicUp(numH);
   for(new i=0; i<Houses[numH][_maxHouseVechs]; i++)
	if(HouseVechs[numH][i][_HouseVechs_ID] != -1)
	   UpdateCarDoorsForVehicle(HouseVechs[numH][i][_HouseVechs_ID]);
}

isPlayerHaveHouse(playerid, houseNum)
{
   if((houseNum<0) || (houseNum>=NumHouses)) return false;
   if(Houses[houseNum][_isLoaded] == 0) return false;
   if(Houses[houseNum][_ownerType] == 1)
	  if(PlayerParams[playerid][hID] == houseNum) return true;
	  else return false;
   if(Houses[houseNum][_ownerType] == 2)
	  if(isPlayerInBand(playerid, Houses[houseNum][_owner])) return true;
	  else return false;
   return false;
}

//     
isPlayerNearBandHouse(playerid)
{
    if(!isPlayerInAnyBand(playerid)) return false;
    new nhID = GetPlayerClosestHouse(playerid);
    if(nhID==-1) return false;
    if(Houses[nhID][_ownerType] != 2) return false;
    if(bands[PlayerParams[playerid][playerBand]][bHouseID] != nhID) return false;
    return true;
}

UpdatePlayerHouseMapIcon(playerid)
{
   DestroyPlayerIcon(playerid, PersonalHouseIndNum);
   DestroyPlayerIcon(playerid, BandHouseIndNum);
   if(PlayerParams[playerid][IsPlayerLogined] == 0) return;
   if(PlayerParams[playerid][hID] != -1)
       CreatePlayerPersonalIcon(playerid, PersonalHouseMapIconID, Houses[PlayerParams[playerid][hID]][_SpawnCoordX], Houses[PlayerParams[playerid][hID]][_SpawnCoordY], Houses[PlayerParams[playerid][hID]][_SpawnCoordZ], 0xAA3333AA, PersonalHouseIndNum);
   //
   if(isPlayerInAnyBand(playerid))
	   if(bands[PlayerParams[playerid][playerBand]][bHouseID] != -1)
           CreatePlayerPersonalIcon(playerid, BandHouseMapIconID, Houses[bands[PlayerParams[playerid][playerBand]][bHouseID]][_SpawnCoordX], Houses[bands[PlayerParams[playerid][playerBand]][bHouseID]][_SpawnCoordY], Houses[bands[PlayerParams[playerid][playerBand]][bHouseID]][_SpawnCoordZ], 0xAA3333AA, BandHouseIndNum);
}

isPlayerInHouse(playerid, houseid)
{
	if(GetPlayerVirtualWorld(playerid) == houseid+5) return true;
	return false;
}

TeleportPlayerToHouse(playerid, houseid)
{
	if(isPlayerInHouse(playerid, houseid)) return false;
    PlayerParams[playerid][isInHouse] = houseid;
    return SetPlayerPosEx(playerid, 234.2826, 1065.229, 1084.2101, 0.0, 6, houseid+5);
}

TeleportPlayerOutOfHouse(playerid, houseid)
{
	if(!isPlayerInHouse(playerid, houseid)) return false;
	SetPlayerVirtualWorld(playerid, 0);
	SetPlayerPosEx(playerid, Houses[PlayerParams[playerid][isInHouse]][_SpawnCoordX], Houses[PlayerParams[playerid][isInHouse]][_SpawnCoordY], Houses[PlayerParams[playerid][isInHouse]][_SpawnCoordZ], Houses[PlayerParams[playerid][isInHouse]][_SpawnCoordAng], Houses[PlayerParams[playerid][isInHouse]][_SpawnCoordInterior], 0);
	PlayerParams[playerid][isInHouse] = -1;
	return true;
}

HouseSafeBoxAddMoney(playerid, houseid, money)
{
	if(money < 0) return false;
    if(money > 500000) return false;
	if(GetPlayerMoneyEx(playerid) < money) return false;
	Houses[houseid][_vault] = Houses[houseid][_vault] + money;
	AddPlayerMoneyEx(playerid, -money);
	UpdateHouse(houseid);
	return true;
}

HouseSafeBoxTakeMoney(playerid, houseid, money)
{
    if(money < 0) return false;
	if(money > 500000) return false;
	if(Houses[houseid][_vault] < money) return false;
	Houses[houseid][_vault] = Houses[houseid][_vault] - money;
	AddPlayerMoneyEx(playerid, money);
	UpdateHouse(houseid);
	return true;
}

ShowPlayerHouseDialog(playerid)
{
    PlayerParams[playerid][isInHouseDialog] = true;
    ShowPlayerDialog(playerid,11,DIALOG_STYLE_LIST," ","\n  ","","");
}

ShowPlayerBandHouseDialog(playerid)
{
    PlayerParams[playerid][isInHouseDialog] = true;
    ShowPlayerDialog(playerid,12,DIALOG_STYLE_LIST,"  ","\n  ","","");
}

ShowPlayerHouseDialogInside(playerid)
{
    PlayerParams[playerid][isInHouseDialog] = true;
    ShowPlayerDialog(playerid,13,DIALOG_STYLE_LIST," ","\n\n\n\n  \n","","");
}

ShowPlayerHouseWeaponDialog(playerid)
{
    KillTimer(hidedialogtimer[playerid]);
    PlayerParams[playerid][isInHouseDialog] = true;
	new tmp[255];
	new house = PlayerParams[playerid][isInHouse];
	new tec9, uzi, ak, m4, sgun, rpg;
	tec9 = Houses[house][_weapons][0]*30;
	uzi = Houses[house][_weapons][1]*30;
	ak = Houses[house][_weapons][2]*9;
	m4 = Houses[house][_weapons][3]*9;
	sgun = Houses[house][_weapons][4]*1;
	rpg = (Houses[house][_weapons][5]*1)/5;
	format(tmp, sizeof(tmp), "TEC9 - %d\nUZI - %d\nAK47 - %d\nM4 - %d\nSawn-off Shotgun - %d\nRPG - %d", tec9, uzi, ak, m4, sgun, rpg);
    ShowPlayerDialog(playerid,14,DIALOG_STYLE_LIST,"",tmp,"","");
}

ShowHouseCodeLockChangeDialog(playerid)
{
    KillTimer(hidedialogtimer[playerid]);
    PlayerParams[playerid][isInHouseDialog] = true;
    ShowPlayerDialog(playerid,15,DIALOG_STYLE_INPUT,"  ","   ","","");
}

ShowHouseCodeLockEnterDialog(playerid)
{
    KillTimer(hidedialogtimer[playerid]);
    PlayerParams[playerid][isInHouseDialog] = true;
    ShowPlayerDialog(playerid,16,DIALOG_STYLE_INPUT,"  ","  ","","");
}

ShowHouseSafeBoxDialog(playerid)
{
    KillTimer(hidedialogtimer[playerid]);
    PlayerParams[playerid][isInHouseDialog] = true;
	new tmp[255];
	new house = PlayerParams[playerid][isInHouse];
	format(tmp, sizeof(tmp), ": %d\n  \n  ", Houses[house][_vault]);
    ShowPlayerDialog(playerid,17,DIALOG_STYLE_LIST," ",tmp,"OK","");
}

ShowHouseSafeBoxAddDialog(playerid)
{
    KillTimer(hidedialogtimer[playerid]);
    PlayerParams[playerid][isInHouseDialog] = true;
    ShowPlayerDialog(playerid,18,DIALOG_STYLE_INPUT," ","  ","","");
}

ShowHouseSafeBoxTakeDialog(playerid)
{
    KillTimer(hidedialogtimer[playerid]);
    PlayerParams[playerid][isInHouseDialog] = true;
    ShowPlayerDialog(playerid,19,DIALOG_STYLE_INPUT," ","  ","","");
}

stock UpdateHouseWeaponBox()
{
   for(new i=0; i<sizeof(Houses); i++)
   {
        Houses[i][_weapons][0] = Houses[i][_weapons][0]+15;//TEC9
        Houses[i][_weapons][1] = Houses[i][_weapons][1]+15;//UZI
        Houses[i][_weapons][2] = Houses[i][_weapons][2]+15;//AK47
        Houses[i][_weapons][3] = Houses[i][_weapons][3]+15;//M4
        Houses[i][_weapons][4] = Houses[i][_weapons][4]+15;//Sawn-off shotgun
        Houses[i][_weapons][5] = Houses[i][_weapons][5]+5;//RPG
        if(Houses[i][_weapons][5] > 25) Houses[i][_weapons][5] = 25;
   }
   SendModTextToAll("      .");
}

forward HideHouseDialog(playerid);
public HideHouseDialog(playerid)
{
    PlayerParams[playerid][isInHouseDialog] = false;
}

