/* mapIcons.pwn
 *
 *   ereg.pwn
 *      .
 *    CreatePlayerPersonalIcon  CreateGlobalIcon
 */

const MaxMapIcons = 32; //   .  .

#define typeMapIcon_none 0
#define typeMapIcon_Global 1
#define typeMapIcon_Personal 2

enum _playersMapIcons    // 
{
   _typeIcon,            // (, , )
   _IconModelId,         //  
   Float:_iconCoord_X,   //
   Float:_iconCoord_Y,   //
   Float:_iconCoord_Z,   //
   _iconColor,           // 
   _iconNum              //  (  )
}

new playersIcons[MAX_PLAYERS_MY][MaxMapIcons][_playersMapIcons];

// 
updatePlayerIcons(playerid, delPersonal=0)
{
   if(!IsPlayerConnected(playerid)) return;
   for(new i=0; i<MaxMapIcons; i++)
	   if(playersIcons[playerid][i][_typeIcon] != typeMapIcon_none)
	   {
		  if((delPersonal!=0) && (playersIcons[playerid][i][_typeIcon] == typeMapIcon_Personal))
             playersIcons[playerid][i][_typeIcon] = typeMapIcon_none;
          else
            SetPlayerMapIcon(playerid,
		                     i,
						     playersIcons[playerid][i][_iconCoord_X],
						     playersIcons[playerid][i][_iconCoord_Y],
						     playersIcons[playerid][i][_iconCoord_Z],
						     playersIcons[playerid][i][_IconModelId],
						     playersIcons[playerid][i][_iconColor]
            );
	   }
}

//   
GetPlayerFreeIconSlot(playerid)
{
   if((playerid<0) || (playerid>=MAX_PLAYERS_MY)) return -1;
   for(new i=0; i<MaxMapIcons; i++)
	  if(playersIcons[playerid][i][_typeIcon] == typeMapIcon_none) return i;
   return -1;
}

//     
GetPlayerIconSlotByNum(playerid, individualNum)
{
   if((playerid<0) || (playerid>=MAX_PLAYERS_MY)) return -1;
   for(new i=0; i<MaxMapIcons; i++)
	  if(playersIcons[playerid][i][_typeIcon] != typeMapIcon_none) 
		 if(playersIcons[playerid][i][_iconNum] == individualNum) return i;
   return -1;
}

// .   .  !!!
CreatePlayerIcon(playerid, iconModel, Float:x, Float:y, Float:z, color, individualNum, typeIcon)
{
    if((playerid<0) || (playerid>=MAX_PLAYERS_MY)) return false;
    if(GetPlayerIconSlotByNum(playerid, individualNum) != -1)
	{
	 printr("   ");
	 return false;
	}
    new freeSlot = GetPlayerFreeIconSlot(playerid);
    if(freeSlot == -1) 
    {
	 printr("   ");
	 return false;
	}
    playersIcons[playerid][freeSlot][_typeIcon] = typeIcon;
    playersIcons[playerid][freeSlot][_IconModelId] = iconModel;
    playersIcons[playerid][freeSlot][_iconCoord_X] = x;
    playersIcons[playerid][freeSlot][_iconCoord_Y] = y;
    playersIcons[playerid][freeSlot][_iconCoord_Z] = z;
    playersIcons[playerid][freeSlot][_iconColor] = color;
    playersIcons[playerid][freeSlot][_iconNum] = individualNum;
    if(IsPlayerConnected(playerid))
       SetPlayerMapIcon(playerid,
	 	                freeSlot,
					    playersIcons[playerid][freeSlot][_iconCoord_X],
					    playersIcons[playerid][freeSlot][_iconCoord_Y],
					    playersIcons[playerid][freeSlot][_iconCoord_Z],
					    playersIcons[playerid][freeSlot][_IconModelId],
					    playersIcons[playerid][freeSlot][_iconColor]
    );
    return true;
}

// .
DestroyPlayerIcon(playerid, individualNum)
{
    if((playerid<0) || (playerid>=MAX_PLAYERS_MY)) return false;
    new numSlot = GetPlayerIconSlotByNum(playerid, individualNum);
    if(numSlot == -1) return false;
    if(IsPlayerConnected(playerid)) RemovePlayerMapIcon(playerid, numSlot);
    playersIcons[playerid][numSlot][_typeIcon] = typeMapIcon_none;
    return true;
}

//  
DestroyGlobalIcon(individualNum)
{
	for(new i=0; i<MAX_PLAYERS_MY; i++)
       DestroyPlayerIcon(i, individualNum);
}

// ,    
CreatePlayerPersonalIcon(playerid, iconModel, Float:x, Float:y, Float:z, color, individualNum)
{
    return CreatePlayerIcon(playerid, iconModel, x, y, z, color, individualNum, typeMapIcon_Personal);
}

// ,   
CreateGlobalIcon(iconModel, Float:x, Float:y, Float:z, color, individualNum)
{
   for(new i=0; i<MAX_PLAYERS_MY; i++)
      if(!CreatePlayerIcon(i, iconModel, x, y, z, color, individualNum, typeMapIcon_Global)) printf("Player %d non create icon num %d", i, individualNum);
}
