/* missionsTaxi.pwn
 *
 *   ereg.pwn
 *
 *   ,    
 *
 */


isTaxiSubMenuEmpty(num)
{
   if((num<0) || (num >=max_SubMenu)) return true;
   for(new i=0; i<max_Row_In_SubMenu; i++)
	 if(taxiMenuDescr[num][i] != -1) return false;
   return true;
}

GetTaxiPremium(Float:dist)
{
	return floatround(floatdiv(dist, 4.0));
}

Float:TaxiGetDistanceToFinishPoint(taxistID, pointNum)
{
   return GetDistancePlayerToPoint(taxistID, TaxiPoints[pointNum][_TaxiPointX], TaxiPoints[pointNum][_TaxiPointY], TaxiPoints[pointNum][_TaxiPointZ]);
}

SendToPlayerTaxiPassengersList(playerid, idStart, num)
{
   new tmp[256];
   new name[50];
   new k=0;
   new t;
   //taxiPassengersListClr
   SendPlayerModText(playerid, "  ,  :", taxiPassengersListClr);
   for(new i=idStart; i<MAX_PLAYERS_MY; i++)
	  if(IsPlayerConnected(i) && (PlayerParams[i][isNeedTaxi] == 1))
	  {
		 t = GTick() - PlayerParams[i][timeStartNeedTaxi];
		 GetPlayerName(i, name, sizeof(name));
		 format(tmp, sizeof(tmp), " %2.2d : %24.24s : %s", i, name, TimeToTexts(t));
		 SendPlayerModText(playerid, tmp, taxiPassengersListClr);
		 k++;
		 if(k>=num) break;
	  }
   if(k==0) SendPlayerModText(playerid, "   .", taxiPassengersListClr);
}

SendToPlayerTaxistList(playerid, idStart, num)
{
   new tmp[256];
   new name[50];
   new k=0;
   //taxiPassengersListClr
   SendPlayerModText(playerid, "  :", taxiPassengersListClr);
   for(new i=idStart; i<MAX_PLAYERS_MY; i++)
	  if(IsPlayerConnected(i) && (PlayerParams[i][NumMission] == mission_Taxi))
	  {
		 GetPlayerName(i, name, sizeof(name));
         if(MissionDescr[i][Status] == taxi_st_freeDriver)
		    format(tmp, sizeof(tmp), " %2.2d : %24.24s : ", i, name);
         else format(tmp, sizeof(tmp), " %2.2d : %24.24s : ", i, name);
		 SendPlayerModText(playerid, tmp, taxiPassengersListClr);
		 k++;
		 if(k>=num) break;
	  }
   if(k==0) SendPlayerModText(playerid, "   .", taxiPassengersListClr);
}

isPlayerPassenger(playerid)
{
   if(IsPlayerConnected(playerid) && (PlayerParams[playerid][isNeedTaxi] != 0)) return true;
   return false;
}

isPlayerFreeTaxist(playerid)
{
   if(!IsPlayerInAnyVehicle(playerid)) return false;
   if(GetPlayerState(playerid) != PLAYER_STATE_DRIVER) return false;
   if(!isPlayerInMissionCar(playerid, mission_Taxi)) return false;
   if(PlayerParams[playerid][NumMission] != mission_Taxi) return false;
   if(MissionDescr[playerid][Status] != taxi_st_freeDriver) return false;
   return true;
}

IsPlayerInFreeTaxiPass(playerid)
{
   if(!IsPlayerInAnyVehicle(playerid)) return false;
   if(GetPlayerState(playerid) != PLAYER_STATE_PASSENGER) return false;
   new vID = VehicleDriverID(GetPlayerVehicleID(playerid));
   return isPlayerFreeTaxist(vID);
}

onPassengerClearMiss(playerid, result)
{
   new name[50];
   new tmp[256];
   new rslt[50];
   switch(result)
   {
	  case 0:
	    {
		   format(rslt, sizeof(rslt), "%s", "; : ");
		   SendPlayerModText(playerid, "   ,      ", taxiPassengersListClr);
		}
	  case 1: format(rslt, sizeof(rslt), "%s", "; :   ");
	  case 2: format(rslt, sizeof(rslt), "%s", "; :    ");
	  case 3: format(rslt, sizeof(rslt), "%s", "; : ");
	  case 4:
	    {
		   format(rslt, sizeof(rslt), "%s", " ");
           SendPlayerModText(playerid, "    ,      ", taxiPassengersListClr);
		}
      case 5: format(rslt, sizeof(rslt), "%s", "; :   ");
	  default: format(rslt, sizeof(rslt), "%s", " ");
   }
   if(IsPlayerConnected(playerid))
   {
     GetPlayerName(playerid, name, sizeof(name));
     if((PlayerParams[playerid][isNeedTaxi] == 1) || (PlayerParams[playerid][isNeedTaxi] == 2))
     {
	   format(tmp, sizeof(tmp), "  %s     %s", name, rslt);
       for(new i=0; i<MAX_PLAYERS_MY; i++)
		  if(IsPlayerConnected(i) && (PlayerParams[i][NumMission] == mission_Taxi))
		  {
             SendPlayerModText(i, tmp, taxiPassengersListClr);
          }

     }
   }
   if(PlayerParams[playerid][isNeedTaxi] == 3)//
   {
	  new taxistID = GetTaxistForClient(playerid);
	  if(!IsPlayerConnected(taxistID))
	  {
         if(IsPlayerConnected(playerid)) SendPlayerModText(playerid, "      ", taxiPassengersListClr);
	  }
	  else
	  {
	     new mon = GetClientPenalty(taxistID);
	     if(mon>0)
	     {
	       AddPlayerMoneyEx(playerid, -mon);
	       AddPlayerMoneyEx(taxistID, mon);
	       format(tmp, sizeof(tmp), "     .      %d$", mon);
           if(IsPlayerConnected(taxistID)) SendPlayerModText(taxistID, tmp, taxiPassengersListClr);
           format(tmp, sizeof(tmp), "     .      %d$", mon);
           if(IsPlayerConnected(playerid)) SendPlayerModText(playerid, tmp, taxiPassengersListClr);
         }
         else
         {
           if(IsPlayerConnected(taxistID)) SendPlayerModText(taxistID, "     .    , ..      ", taxiPassengersListClr);
           if(IsPlayerConnected(playerid)) SendPlayerModText(playerid, "     .     ", taxiPassengersListClr);
         }
         ReInitTaxiMiss(taxistID);
	  }
   }
   PlayerParams[playerid][isNeedTaxi] = 0;
   UpdateAllTaxistColorForClient(playerid);
   UpdateClientMarkerForTaxists(playerid);
}

ReInitTaxiMiss(playerid)
{
        DeleteFinBaseCP(playerid);
        PlayerParams[playerid][NumMission] = mission_Taxi;
        MissionDescr[playerid][StartTime] = GTick();
		MissionDescr[playerid][vech] = GetPlayerVehicleID(playerid);
		MissionDescr[playerid][TypeCargo] = -1;
		MissionDescr[playerid][Status] = taxi_st_freeDriver;
		MissionDescr[playerid][NumEndBase] = -1;
		SetTDForPlayer(playerid);
		new tmp[256];
		format(tmp, sizeof(tmp), "   : %d", MissionDescr[playerid][wages]);
		SendPlayerModText(playerid, tmp);
		SendPlayerModText(playerid, "     ;  '/taxiP'  ;");
}

onPassengerStartMiss(playerid)
{
   new name[50];
   new tmp[256];
   GetPlayerName(playerid, name, sizeof(name));
   format(tmp, sizeof(tmp), "  %s  .       ", name);
   for(new i=0; i<MAX_PLAYERS_MY; i++)
 	  if(IsPlayerConnected(i) && (PlayerParams[i][NumMission] == mission_Taxi))
	  {
             SendPlayerModText(i, tmp, taxiPassengersListClr);
      }
   PlayerParams[playerid][isNeedTaxi] = 1;
   PlayerParams[playerid][timeStartNeedTaxi] = GTick();
   UpdateAllTaxistColorForClient(playerid);
   UpdateClientMarkerForTaxists(playerid);
   if(IsPlayerInFreeTaxiPass(playerid))
             OnPlassengerEnterTaxistCar(playerid);
}

//     
UpdateClientMarkerForTaxists(playerid)
{
   new clr;
   if((PlayerParams[playerid][isNeedTaxi]!=1) && (PlayerParams[playerid][isNeedTaxi]!=2)) clr = GetPlayerColor(playerid);
   else clr = 0xAA3333AA;
   for(new i=0; i<MAX_PLAYERS_MY; i++)
	  if(IsPlayerConnected(i) && (PlayerParams[i][NumMission] == mission_Taxi) && (i != playerid))
          //    
          SetPlayerMarkerForPlayer(i, playerid, clr);
}

//     
UpdateAllPlayersColorForTaxist(taxistid)
{
   for(new i=0; i<MAX_PLAYERS_MY; i++)
	  if(IsPlayerConnected(i) && (i != taxistid))
         if((PlayerParams[i][isNeedTaxi]!=0) && (PlayerParams[i][isNeedTaxi]!=3) && (PlayerParams[taxistid][NumMission] == mission_Taxi))
           //
           SetPlayerMarkerForPlayer(taxistid, i, 0xAA3333AA);
         else
           // 
           SetPlayerMarkerForPlayer(taxistid, i, GetPlayerColor(i));
}

//     
UpdateTaxistMarkerForClients(taxistid)
{
   new clr;
   if(PlayerParams[taxistid][NumMission] != mission_Taxi) clr = GetPlayerColor(taxistid);
   else clr = 0xAA3333AA;
   for(new i=0; i<MAX_PLAYERS_MY; i++)
	  if(IsPlayerConnected(i) && (PlayerParams[i][isNeedTaxi] != 0) && (i != taxistid))
          //    
          SetPlayerMarkerForPlayer(i, taxistid, clr);
}

//     
UpdateAllTaxistColorForClient(playerid)
{
   for(new i=0; i<MAX_PLAYERS_MY; i++)
	  if(IsPlayerConnected(i) && (i != playerid))
         if((PlayerParams[i][NumMission] == mission_Taxi) && (PlayerParams[playerid][isNeedTaxi] != 0))
             SetPlayerMarkerForPlayer(playerid, i, 0xAA3333AA);
         else
           SetPlayerMarkerForPlayer(playerid, i, GetPlayerColor(i));

}

OnPlassengerEnterTaxistCar(playerid)
{
	new taxistID = GetTaxistForClient(playerid);
	if(IsPlayerConnected(taxistID))
	{
       SendPlayerModText(taxistID, "     .     ", taxiPassengersListClr);
       SendPlayerModText(playerid, "      ,  ", taxiPassengersListClr);
       PlayerParams[playerid][isNeedTaxi] = 2;
       ShowMenuForPlayerEx(Taxi_MainMenu, playerid);
	}
	else
	{
       onPassengerClearMiss(playerid, 4);
	}
}

OnTaxiClientSelectRow(playerid, num)
{
   new tmp[256];
   if((num<0) || (num>=TaxiPointsNum))
   {
       SendPlayerModText(playerid, "    ,  ", taxiPassengersListClr);
       OnPlassengerEnterTaxistCar(playerid);
	   return;
   }
   new taxistID = GetTaxistForClient(playerid);
   if(!IsPlayerConnected(taxistID))
   {
       SendPlayerModText(playerid, "  .  ", taxiPassengersListClr);
       PlayerParams[playerid][isNeedTaxi] = 1;
       return;
   }
   MissionDescr[taxistID][_MDistance] = TaxiGetDistanceToFinishPoint(taxistID, num);
   new mon = GetTaxiPremium(MissionDescr[taxistID][_MDistance]);
   if(GetPlayerMoneyEx(playerid) < mon)
   {
	   format(tmp, sizeof(tmp), "    . : %d$;  : %d$", mon, GetPlayerMoneyEx(playerid));
	   SendPlayerModText(playerid, tmp, taxiPassengersListClr);
	   OnPlassengerEnterTaxistCar(playerid);
	   return;
   }

   format(tmp, sizeof(tmp), "    : %s.  ", TaxiPoints[num][_TaxiPointName]);
   SendPlayerModText(taxistID, tmp, taxiPassengersListClr);

   MissionDescr[taxistID][TypeCargo] = playerid;
   MissionDescr[taxistID][NumEndBase] = num;
   MissionDescr[taxistID][StartTime] = GTick();
   MissionDescr[taxistID][NormalTime] = TaxiGetNormalTime(taxistID, num);

   if(!CreateFinBaseCP(taxistID))
   {
       SendPlayerModText(taxistID, "    ,  ", taxiPassengersListClr);
       MissionDisabled(taxistID);
       return;
   }
   ShowFinBaseCP(taxistID);
   MissionDescr[taxistID][Status] = taxi_st_withPassenger;
   PlayerParams[playerid][isNeedTaxi] = 3;
   format(tmp, sizeof(tmp), "    : %s.  : %d$", TaxiPoints[num][_TaxiPointName], Premium2(taxistID));
   SendPlayerModText(playerid, tmp, taxiPassengersListClr);
}

//   
GetTaxistForClient(playerid)
{
   if(!IsPlayerConnected(playerid))
   {
      if(playerid == -1) return -1;
      for(new i=0; i<MAX_PLAYERS_MY; i++)
		 if(IsPlayerConnected(i) &&
		    (PlayerParams[i][NumMission] == mission_Taxi) &&
			(MissionDescr[i][Status] != taxi_st_freeDriver) &&
			(MissionDescr[i][TypeCargo] == playerid)) return i;
   }
   if(PlayerParams[playerid][isNeedTaxi] == 1)
   {
	  if(!IsPlayerInAnyVehicle(playerid)) return -1;
	  if(!IsPlayerInFreeTaxiPass(playerid)) return -1;
	  return VehicleDriverID(GetPlayerVehicleID(playerid));
   }

   for(new i=0; i<MAX_PLAYERS_MY; i++)
	 if(IsPlayerConnected(i) && (PlayerParams[i][NumMission] == mission_Taxi))
		if(MissionDescr[i][Status] != taxi_st_freeDriver)//  -
		{
		   if(MissionDescr[i][TypeCargo] == playerid) return i;
		}
		else//   ,      
		  if(IsPlayerInAnyVehicle(i) &&
		     (GetPlayerVehicleID(i) == GetPlayerVehicleID(playerid)) &&
			 (PlayerParams[playerid][isNeedTaxi] == 2)) return i;
   return -1;
}

//     
isClientInTaxistCar(taxistID)
{
   if(!IsPlayerConnected(MissionDescr[taxistID][TypeCargo])) return false;
   if(!IsPlayerInAnyVehicle(taxistID) || !IsPlayerInAnyVehicle(MissionDescr[taxistID][TypeCargo])) return false;
   if(GetPlayerVehicleID(taxistID) == GetPlayerVehicleID(MissionDescr[taxistID][TypeCargo])) return true;
   return false;
}

//      
TaxiGetNormalTime(playerid, numPoint)
{//return floatround(floatdiv(dist, 4.0));
   new Float:dis = TaxiGetDistanceToFinishPoint(playerid, numPoint);
   return floatround(floatdiv(dis, 15.0))*1000;
}

//       
GetClientPenalty(taxistid)//
{
   if(!IsPlayerConnected(MissionDescr[taxistid][TypeCargo])) return 0;
   new Float:dis = TaxiGetDistanceToFinishPoint(MissionDescr[taxistid][TypeCargo], MissionDescr[taxistid][NumEndBase]);
   new Float:deltaDis = floatsub(MissionDescr[taxistid][_MDistance], dis);
   if(deltaDis <= 0.0) return 0;
   return GetTaxiPremium(dis);
}

//       
GetTaxistPenalty(taxistid)//
{
   if(!IsPlayerConnected(MissionDescr[taxistid][TypeCargo])) return 0;
   new mon = GetTaxiPremium(MissionDescr[taxistid][_MDistance]);
   new time = GTick() - MissionDescr[taxistid][StartTime];
   if(time > MissionDescr[taxistid][NormalTime])
       mon = mon * (1 + floatround(floatdiv(time-MissionDescr[taxistid][NormalTime], MissionDescr[taxistid][NormalTime])));
   return mon;
}

public Timer_CheckTaxiPassengers()
{
   new name[50];
   new tmp[256];
   for(new i=0; i<MAX_PLAYERS_MY; i++)
   {
	   if(IsPlayerConnected(i) && (PlayerParams[i][isNeedTaxi] == 1))
	   {
           GetPlayerName(i, name, sizeof(name));
		   if((GTick() - PlayerParams[i][timeStartNeedTaxi]) >= timeWaitPassengers)
		   {
			   format(tmp, sizeof(tmp), "      %s    %d $", name, MoneyForLimitWaitTaxi);
               new mon=0;
			   for(new k=0; k<MAX_PLAYERS_MY; k++)
				 if(IsPlayerConnected(k) &&
				   (PlayerParams[k][NumMission] == mission_Taxi) &&
				   (MissionDescr[k][Status] == taxi_st_freeDriver) &&
				   ((GTick() - MissionDescr[k][StartTime]) > TaxiMinTimeForWaitingPenalty))
				 {
					 mon+=MoneyForLimitWaitTaxi;
					 AddPlayerMoneyEx(k, -MoneyForLimitWaitTaxi);
					 SendPlayerModText(k, tmp, taxiPassengersListClr);
				 }
			   if(mon>0)
			   {
				  format(tmp, sizeof(tmp), "       .   : %d$", mon);
				  SendPlayerModText(i, tmp, taxiPassengersListClr);
                  AddPlayerMoneyEx(i, mon);
			   }
			   PlayerParams[i][timeStartNeedTaxi] = GTick();
               //onPassengerClearMiss(i, 2);
		   }
		   else
		   {
			   format(tmp, sizeof(tmp), " %s   ", name);
			   for(new k=0; k<MAX_PLAYERS_MY; k++)
				 if(IsPlayerConnected(k) && (PlayerParams[k][NumMission] == mission_Taxi) && (MissionDescr[k][Status] == taxi_st_freeDriver))
					 SendPlayerModText(k, tmp, taxiPassengersListClr);
		   }
	   }
   }
}

OnTaxistFinish(playerid)
{
   new passID = MissionDescr[playerid][TypeCargo];
   if(!IsPlayerConnected(passID))
   {
       SendPlayerModText(playerid, "     0_.  ", taxiPassengersListClr);
       ReInitTaxiMiss(playerid);
   }
   RemovePlayerFromVehicle(passID);
   new mon = Premium2(playerid);
   MissionDescr[playerid][wages]++;
   missions(playerid, 6, mon, 0.0);
   AddPlayerMoneyEx(passID, -mon);
   new tmp[256];
   format(tmp, sizeof(tmp), "   %.1f;  %s;  %d$", MissionDescr[playerid][_MDistance], TimeToTextsEx(GTick() - MissionDescr[playerid][StartTime]), mon);
   SendPlayerModText(playerid, tmp, taxiPassengersListClr);
   format(tmp, sizeof(tmp), "   %d$  ", mon);
   SendPlayerModText(passID, tmp, taxiPassengersListClr);
   format(tmp, sizeof(tmp), " : : %d$", mon);
   SaveToLog(tmp, 15, playerid);
   ReInitTaxiMiss(playerid);
   PlayerParams[passID][isNeedTaxi] = 0;
   UpdateClientMarkerForTaxists(passID);
   UpdateAllTaxistColorForClient(passID);
}
