/* object.pwn
 *   ereg.pwn
 *
 *     .     .
 *      .
 *          AddObjectToList
 */

new MaxObjectID = 0;             //  
new numStaticObjects=0;          //   ( )
new StuntObjects[MAX_OBJECTS];   //  -  ; : 1 - . 0 - .

enum objDescriptor               // 
{
	isExist,                     ///
	_oID,                        // ,  
	_model,                      //
	_isDynamic,                  //1 - , 0 - 
	_oDis,                       // ,  
	Float:_oX,                   //
	Float:_oY,
	Float:_oZ,
	Float:_oXr,                  //
	Float:_oYr,
	Float:_oZr
}

new Objects[MaxObjects][objDescriptor]; //   

/*
 *           .   (  
 *  )   !!!     .
 */
AddObjectToList(dynamic, modelid, Float:X, Float:Y, Float:Z, Float:rX, Float:rY, Float:rZ)
{
	if(dynamic==0)
	  if(numStaticObjects>=MAX_OBJECTS)
	  {
		  print("[WARNING]: Static object not loaded because created maximum objects");
		  return -1;
	  }
	for(new i=0; i<MaxObjects; i++)
	   if(Objects[i][isExist] == 0)
	   {
           Objects[i][isExist] = 1;
           if(dynamic == 0)
           {
              Objects[i][_isDynamic] = 0;
              Objects[i][_oDis] = 0;
           }
           else
           {
              Objects[i][_isDynamic] = 1;
              Objects[i][_oDis] = dynamic;
           }
           //_oDis
		   Objects[i][_model] = modelid;
		   Objects[i][_oX] = X;
		   Objects[i][_oY] = Y;
		   Objects[i][_oZ] = Z;
		   Objects[i][_oXr] = rX;
		   Objects[i][_oYr] = rY;
		   Objects[i][_oZr] = rZ;
		   if(i > MaxObjectID) MaxObjectID = i;
		   if(dynamic==0)
		   {
		       cObject(i); // ,  
		       numStaticObjects++;
		   }
		   return i;
	   }
	printf("[WARNING] Object is not created, because the limit(%d) is settled", MaxObjects);
	return -1;
}

//     .
LoadObjects()
{
    for(new i=0; i<MAX_OBJECTS; i++) StuntObjects[i] = 0;
    if(!fexist(ObjectsPatch)) return;
	new File:f = fopen(ObjectsPatch, io_read);
	new tmp[255];
	new t[10][50];
	while(fread(f, tmp))
	{
		StripNewLine(tmp);
		if(strlen(tmp) < 20) continue;
		if(ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*")) continue;
		split(tmp, t, ',');
		AddObjectToList(strval(t[0]), strval(t[1]),
		                floatstr(t[2]), floatstr(t[3]), floatstr(t[4]),
						floatstr(t[5]), floatstr(t[6]), floatstr(t[7]));
	}
	fclose(f);
	return;
}

//  !!!
//   1    (  ).
//      
cObject(id, playerid=-1)
{
	if(id < 0 || id >= MaxObjects) return;
	if(Objects[id][isExist] == 0) return;
	if(Objects[id][_isDynamic] == 0)//
	{
       new objectid = CreateObject(Objects[id][_model],
	                               Objects[id][_oX],
								   Objects[id][_oY],
								   Objects[id][_oZ],
								   Objects[id][_oXr],
								   Objects[id][_oYr],
								   Objects[id][_oZr]);
	   if(objectid == INVALID_OBJECT_ID) printf("Object not created");
	   else
	   {
	      StuntObjects[objectid] = 1;
	      Objects[id][_oID] = objectid;
	   }
	}
	else//
	{
		if(PlayerParams[playerid][view][id])
			return;
		//   
		if((numStaticObjects + PlayerParams[playerid][numViewDinamicObjects]) >= MAX_OBJECTS) return;
        PlayerParams[playerid][view][id] = true;
        PlayerParams[playerid][objid][id] = CreatePlayerObject(playerid, Objects[id][_model],
	                                                                   Objects[id][_oX],
	                                                                   Objects[id][_oY],
	                                                                   Objects[id][_oZ],
	                                                                   Objects[id][_oXr],
	                                                                   Objects[id][_oYr],
	                                                                   Objects[id][_oZr]);
        PlayerParams[playerid][numViewDinamicObjects]++;
	}
}

//       
destroyPlayerObjects(playerid)
{
	for(new i=0; i<MaxObjectID; i++)
       if(PlayerParams[playerid][view][i])
       {
          dObject(i, playerid);
       }
}

// 
dObject(id, playerid=-1)
{
	if(id < 0 || id >= MaxObjects) return;
	if(Objects[id][isExist] == 0) return;
	if(Objects[id][_isDynamic] == 0)//
	{
       DestroyObject(Objects[id][_oID]);
       StuntObjects[Objects[id][_oID]] = 1;
       Objects[id][_oID] = INVALID_OBJECT_ID;
	}
	else//
	{
	   if(playerid < 0) return;
       if(!PlayerParams[playerid][view][id])
			return;
       DestroyPlayerObject(playerid, PlayerParams[playerid][objid][id]);
       PlayerParams[playerid][view][id] = false;
       PlayerParams[playerid][numViewDinamicObjects]--;
	}
}

// 
MoveObjectMy(oID, Float:x, Float:y, Float:z, Float:spd)
{
    if(oID < 0 || oID >= MaxObjects) return;
	if(Objects[oID][isExist] == 0) return;
	if(Objects[oID][_isDynamic] == 0)//
	{
       MoveObject(Objects[oID][_oID], x, y, z, spd);
	}
	else//
	{
	   Objects[oID][_oX] = x;
	   Objects[oID][_oY] = y;
	   Objects[oID][_oZ] = z;
	   for(new i=0; i<MAX_PLAYERS; i++)
		  if(IsPlayerConnected(i))
           if(PlayerParams[i][view][oID])
               MovePlayerObject(i, PlayerParams[i][objid][oID], x, y, z, spd);
	}
}

//  
DestroyAllObjects()
{
	for(new i = 0; i < MAX_OBJECTS; i++)
	{
		if(StuntObjects[i])
		{
			DestroyObject(i);
			StuntObjects[i] = 0;
		}
	}
}

// .    .
UpdatePlayerObjects(playerid)
{
	if(!IsPlayerConnected(playerid)) return;
	if(PlayerParams[playerid][IsPlayerDieAndNoSpawn] == 1) return;
	new Float:pX, Float:pY, Float:pZ;
	GetPlayerPos(playerid, pX, pY, pZ);
	for(new i=0; i<MaxObjectID; i++)
	   if(Objects[i][isExist] && Objects[i][_isDynamic] != 0)
		 if(IsPointNearPoint(pX, pY, pZ, Objects[i][_oX], Objects[i][_oY], Objects[i][_oZ], Objects[i][_oDis]))
		 {
			 if(!PlayerParams[playerid][view][i])
			 {
                //SendPlayerModText(playerid, "  1");
                cObject(i, playerid);
             }
		 }
		 else
		 {
            if(PlayerParams[playerid][view][i])
            {
                //SendPlayerModText(playerid, "  1");
                dObject(i, playerid);
            }
		 }
}

//  .      ,
//  .
// ,     ,   .
stock TeleportPlayerToPosWithObj(playerid, Float:pX, Float:pY, Float:pZ)
{
    if(!IsPlayerConnected(playerid)) return;
	for(new i=0; i<MaxObjectID; i++)
	   if(Objects[i][isExist] && Objects[i][_isDynamic] != 0)
		 if(IsPointNearPoint(pX, pY, pZ, Objects[i][_oX], Objects[i][_oY], Objects[i][_oZ], Objects[i][_oDis]))
		 {
			 if(!PlayerParams[playerid][view][i])
                cObject(i, playerid);
		 }
		 else
		 {
            if(PlayerParams[playerid][view][i])
                dObject(i, playerid);
		 }
	SetPlayerPos(playerid, pX, pY, pZ);
}
