const Max_Petrols_Stations = 50;
enum _PetrolStationDescr
{
	enabled,
	Float:_petrolMaxX,
	Float:_petrolMinX,
	Float:_petrolMaxY,
	Float:_petrolMinY,
	Float:_petrolMaxZ,
	Float:_petrolMinZ,
}

new petrolsStations[Max_Petrols_Stations][_PetrolStationDescr];

LoadPetrolsStations()
{
	for(new i=0; i<Max_Petrols_Stations; i++) petrolsStations[i][enabled] = 0;
	if(!fexist(PetrolStationsPatch)) return;
	new File:f = fopen(PetrolStationsPatch, io_read);
	new tmp[255];
	new t[10][50];
	new i=0;
	while(fread(f, tmp) && (i<Max_Petrols_Stations))
	{
        StripNewLine(tmp);
		if((strlen(tmp) < 10) || ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*"))
		{
		   continue;
		}
		split(tmp, t, ',');
		petrolsStations[i][_petrolMinX]=floatstr(t[0]);
		petrolsStations[i][_petrolMaxX]=floatstr(t[1]);
		petrolsStations[i][_petrolMinY]=floatstr(t[2]);
		petrolsStations[i][_petrolMaxY]=floatstr(t[3]);
		petrolsStations[i][_petrolMinZ]=floatstr(t[4]);
		petrolsStations[i][_petrolMaxZ]=floatstr(t[5]);
		petrolsStations[i][enabled]=1;
		i++;
	}
	fclose(f);
}

numPetrolStations()
{
	new num = 0;
	for(new i=0; i<Max_Petrols_Stations; i++)
	   if(petrolsStations[i][enabled] != 0) num++;
	return num;
}

isPointInPetrol(Float:x, Float:y, Float:z, petrolStNum)
{
	return IsPointInAreaMy(x, y, z, petrolsStations[petrolStNum][_petrolMinX],
	                                petrolsStations[petrolStNum][_petrolMaxX],
									petrolsStations[petrolStNum][_petrolMinY],
									petrolsStations[petrolStNum][_petrolMaxY],
									petrolsStations[petrolStNum][_petrolMinZ],
									petrolsStations[petrolStNum][_petrolMaxZ]);
}

GetPlayerPetrol(playerid)
{
	new Float:x, Float:y, Float:z;
	GetPlayerPos(playerid, x, y, z);
	for(new i=0; i<Max_Petrols_Stations; i++)
	   if(petrolsStations[i][enabled] != 0)
		  if(isPointInPetrol(x, y, z, i)) return i;
	return -1;
}

public Timer_petrolStations()
{
	if(isPetrolEnabled == 0) return;
	for(new i=0; i<=MaxPlayerID; i++)
	 if(IsPlayerConnected(i))
	  if((GetPlayerState(i) == PLAYER_STATE_DRIVER) && (PlayerParams[i][isMenuShowed] == 0) && (PlayerParams[i][speed] == 0))
	   if(GetModelMaxPetrol(GetVehicleModel(GetPlayerVehicleID(i))) > 0.0)
	   {
		  new numPetrolSt = GetPlayerPetrol(i);
		  if(numPetrolSt != -1)
		  {
			  new tmp[256];
			  format(tmp, sizeof(tmp), "     %d", numPetrolSt);
			  SendPlayerModText(i, tmp);
			  ShowMenuForPlayerEx(PetrolStationMenu, i);
			  FreezePlayer(i);
		  }
	   }
}
