/* picUps.pwn
 *   ereg.pwn
 *
 *     .    .
 */
 
// 
#define PicType_none 0
#define PicType_Dropped_Weap 1
#define PicType_Dropped_Money 2
#define PicType_Dropped_Health 3
#define PicType_Bags 4
#define PicType_Houses 5
#define PicType_CrashBox 6
#define PicType_Miss_9_11 7
#define PicType_InsideHouses 8
#define PicType_Bussinesses 9

// 
enum _PicUpDescr
{
   PicType,                            //
   _weapID,                            //id 
   timeStartPic,                       //  
   timePicLife,                        //  
   picAmmo,                            // ( )
   Float:_PicUpCoord_X,                // 
   Float:_PicUpCoord_Y,                // 
   Float:_PicUpCoord_Z                 // 
}
const MAX_PICS = MAX_PICKUPS;          //   
const Max_Drop_Pics = 1024;            //   
new numCreatedPics = 0;                //  
new DefaultTimePicLife = 30000;        //   
new timerInterval = 5000;              //  

new PicUPs[MAX_PICS][_PicUpDescr];

//
InitPicUps()
{
    numCreatedPics = 0;
	for(new i=0; i<sizeof(PicUPs); i++)
       PicUPs[i][PicType] = PicType_none;
}

//      !!!!!!!
//tlife -  ( ).  0 -  .
//ammo -  ( )
//wID -  ( )
CrPic(picModel, Float:X, Float:Y, Float:Z, tlife, ammo, wID, Type)
{
    if(numCreatedPics >= Max_Drop_Pics) return -1;
    new picID = CreatePickup(picModel, 23, X, Y, Z, -1);
    if(picID != -1)
	{
	   if(PicUPs[picID][PicType] != PicType_none)
	   {
		  printr("    ");
          DestroyPickup(picID);
	      return -1;
	   }
	   numCreatedPics++;
	   PicUPs[picID][PicType] = Type;
	   PicUPs[picID][timeStartPic] = GTick();
	   PicUPs[picID][timePicLife] = tlife;
	   PicUPs[picID][picAmmo] = ammo;
	   PicUPs[picID][_weapID] = wID;
	   PicUPs[picID][_PicUpCoord_X] = X;
	   PicUPs[picID][_PicUpCoord_Y] = Y;
	   PicUPs[picID][_PicUpCoord_Z] = Z;
	}
	return picID;
}

// 
DelPic(pickupid)
{
    DestroyPickup(pickupid);
    PicUPs[pickupid][PicType] = PicType_none;
    PicUPs[pickupid][_weapID] = -1;
    PicUPs[pickupid][timeStartPic] = 0;
    numCreatedPics--;
    return 1;
}

//    .      .
GetOptimalTimePicLife()
{
	new Float:proc = float(Max_Drop_Pics - numCreatedPics)/float(Max_Drop_Pics);
	return floatround(proc*DefaultTimePicLife);
}

//    .
FindNearestPicUp(Float:CoordX, Float:CoordY, Float:CoordZ, numClosest=-1)
{
	// ,      
	if(numClosest != -1)
	  if(IsPointNearPoint(CoordX, CoordY, CoordZ, PicUPs[numClosest][_PicUpCoord_X], PicUPs[numClosest][_PicUpCoord_Y], PicUPs[numClosest][_PicUpCoord_Z], 2.0))
		  return numClosest;
	//  .
	for(new i=0; i<MAX_PICS; i++)
	   if(PicUPs[i][PicType] != PicType_none)
		  if(IsPointNearPoint(CoordX, CoordY, CoordZ, PicUPs[i][_PicUpCoord_X], PicUPs[i][_PicUpCoord_Y], PicUPs[i][_PicUpCoord_Z], 2.0))
		  {
			 if(numClosest == -1) numClosest = i;
			 else
			 {
				new Float:Dist1 = GetDistanceBetweenPoints(CoordX, CoordY, CoordZ, PicUPs[i][_PicUpCoord_X], PicUPs[i][_PicUpCoord_Y], PicUPs[i][_PicUpCoord_Z]);
				new Float:Dist2 = GetDistanceBetweenPoints(CoordX, CoordY, CoordZ, PicUPs[numClosest][_PicUpCoord_X], PicUPs[numClosest][_PicUpCoord_Y], PicUPs[numClosest][_PicUpCoord_Z]);
				if(Dist1 < Dist2) numClosest = i;
			 }
		  }
	return numClosest;
}

// //   
DropOnDie(playerid)
{
   new Float:X, Float:Y, Float:Z;
   GetPlayerPos(playerid, X, Y, Z);
   // 
   new temp;
   new s[256];
   new PX;
   new PY;
   for(new i=0;i<15;i++)
   {
 	    //    
	    format(s, 256 ,"%.0f", X);
		temp = strval(s);
		PX = random((temp+2)-(temp-2))+(temp-2);
		format(s, 256 ,"%.0f", Y);
		temp = strval(s);
		PY = random((temp+2)-(temp-2))+(temp-2);
	   //  
		if((i<12) && (DropWeapEnabled != 0))//
            DropWeapOnDie(playerid, i, PX, PY, Z);
	 	if((i==13) && (DropHealth != 0))//
		{
		    CrPic(1240, PX, PY, Z, GetOptimalTimePicLife(), 1, -1, PicType_Dropped_Health);
		}
 		if((i==14) & (DropMoneyEnabled != 0))//
		{
		   // DroppedMoneyPercent%  ,    DroppedMoneyMin
           if(GetPlayerExpLevel(playerid) > 0 && PlayerParams[playerid][isGold] != true)
           {
	         new pMoney = int:(GetPlayerMoneyEx(playerid)*DroppedMoneyPercent/100);
	         if(pMoney > DroppedMoneyMin)
	         {
		       CrPic(1212, PX, PY, Z, GetOptimalTimePicLife(), pMoney, -1, PicType_Dropped_Money);
		       AddPlayerMoneyEx(playerid, -pMoney);
		     }
		   }
		}
   }
}

//------------------------------------------------------------------------------
//
const Max_Num_Bags = 30;         //
new num_bags;                    // 
new Float:Bags[Max_Num_Bags][3]; //

new bags_IDS[Max_Num_Bags];      // 

const bags_model = 1210;
const bags_type = 23;

//     
GetBagNum(id)
{
   for(new i = 0; i<num_bags; i++)
	  if(bags_IDS[i] == id) return i;
   return -1;
}

// -   
picUpFounded(playerid, numP)
{
   SetBit(PlayerParams[playerid][picUps], numP, 1);
   new tmp[256];
   format(tmp, sizeof(tmp), "   %d-    %d", numFoundedPicUps(playerid), num_bags);
   SendPlayerModText(playerid, tmp);
   IncPlayerExp(playerid, 100);
   if(numFoundedPicUps(playerid) < num_bags) SendPlayerModText(playerid, "      ");
   else
   {
       SendPlayerModText(playerid, " !!!        5000 ");
       IncPlayerExp(playerid, 5000);
   }
}

//    
numFoundedPicUps(playerid)
{
	new out = 0;
	for(new i=0; i<num_bags; i++)
	   if(GetBit(PlayerParams[playerid][picUps], i)) out ++;
	return out;
}

//   
LoadBugs()
{
    num_bags = 0;
    for(new i=0; i<Max_Num_Bags; i++) bags_IDS[i] = 0;
    if(!fexist(BugsPatch)) return;
	new File:f = fopen(BugsPatch, io_read);
	new tmp[255];
	new t[10][50];
	while(fread(f, tmp))
	{
		StripNewLine(tmp);
		if(strlen(tmp) < 20) continue;
		if(ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*")) continue;
		split(tmp, t, ',');
		Bags[num_bags][0] = floatstr(t[0]);
		Bags[num_bags][1] = floatstr(t[1]);
		Bags[num_bags][2] = floatstr(t[2]);
		num_bags++;
		if(num_bags >= Max_Num_Bags) break;
	}
	fclose(f);
	return;
}
