const vechSpawnDelay = 600;
const HouseVechSpawnDelay = 600;

//
new Vechs[MAX_VEHICLES];    //id  -      

enum _CarsDescriptor
{
   _CarID,
   _ModelID,
   Float:_x,       // 
   Float:_y,       // 
   Float:_z,       // 
   Float:_angl,    // 
   colour1,
   colour2,
   respawndelay,
   _interior,      // 
   _isMagazine,    //
   _spawned,       //,   
   _InRace,        //      
   _IsForRent,     //(   ,   )
   _ForMining,     //
   _MiningRun,     // 
   _ForLock,       // 
   _Locked,        // 
   _houseID,       //  ( ,  -1)
   _IDCarInHouse,  //    ( )
   _isAutoShop,    //   
   Float:_fuel     //
}

new vhls[MAX_VEHICLES][_CarsDescriptor];

//******************************************************************************

enum _ModelsDescriptor
{
   _PlayersMinLevel,           // ,      
   _isClosedWithVehBan,        //    weapBan
   _moneysForMagazine,         //   
   Float:_MaxPetrol,           //   
   Float:_PetrolConsumption    // (/)
}

new vModels[212][_ModelsDescriptor];

LoadVModels()
{
   new tmp[256];
   new t[10];
   new t2[10][50];
   for(new i=0; i<sizeof(vModels); i++)
   {
	   format(t, sizeof(t), "%d", i+400);
       if(dini_Isset(vModelsPatch, t))
	   {
	       tmp = dini_Get(vModelsPatch,t);
	       split(tmp, t2, ',');
	       vModels[i][_MaxPetrol] = floatstr(t2[0]);
	       vModels[i][_PetrolConsumption] = floatmul(floatdiv(floatstr(t2[1]), 360000.0), petrol_Consumption_factor);
	       vModels[i][_moneysForMagazine] = strval(t2[2]);
	       vModels[i][_isClosedWithVehBan] = strval(t2[3]);
	       vModels[i][_PlayersMinLevel] = strval(t2[4]);
	   }
	   else
	   {
	       vModels[i][_MaxPetrol] = 0.0;
	       vModels[i][_PetrolConsumption] = 0.0;
	       vModels[i][_moneysForMagazine] = 1000000;
	       vModels[i][_isClosedWithVehBan] = 0;
	       vModels[i][_PlayersMinLevel] = 0;
	   }
   }
}

//******************************************************************************

Float:GetModelPetrolConsumption(modelID)
{
   new num = modelID-400;
   if((num<0) || (num >= sizeof(vModels))) return 0.0;
   return vModels[num][_PetrolConsumption];
}

Float:GetModelMaxPetrol(modelID)
{
   new num = modelID-400;
   if((num<0) || (num >= sizeof(vModels))) return 0.0;
   return vModels[num][_MaxPetrol];
}

GetModelMoneysForMagazine(modelID)
{
   new num = modelID-400;
   if((num<0) || (num >= sizeof(vModels))) return 1000000;
   return vModels[num][_moneysForMagazine];
}

GetModelClosedWithVehBan(modelID)
{
   new num = modelID-400;
   if((num<0) || (num >= sizeof(vModels))) return 0;
   return vModels[num][_isClosedWithVehBan];
}

GetModelPlayersMinLevel(modelID)
{
   new num = modelID-400;
   if((num<0) || (num >= sizeof(vModels))) return 0;
   return vModels[num][_PlayersMinLevel];
}

incVehFuel(vID, Float:value)
{
   vhls[Vechs[vID]][_fuel] += value;
   if(vhls[Vechs[vID]][_fuel] > GetModelMaxPetrol(vhls[Vechs[vID]][_ModelID])) vhls[Vechs[vID]][_fuel] = GetModelMaxPetrol(vhls[Vechs[vID]][_ModelID]);
   if(vhls[Vechs[vID]][_fuel] < 0.0) vhls[Vechs[vID]][_fuel] = 0.0;
}

LoadVehicles()
{
    if(!fexist(VehFileName)) return false;
	new File:f = fopen(VehFileName, io_read);
	new tmp[255];
	new t[10][50];
	for(new i=0; i<sizeof(vhls); i++)
	{
  	    vhls[i][_ModelID] = -1;
  	    vhls[i][_CarID] = INVALID_VEHICLE_ID;
  	}
	for(new i=0; i<sizeof(vhls); i++)
	{
		if(!ReadConf(f, tmp, sizeof(tmp), 20)) break;
		StripNewLine(tmp);
		split(tmp, t, ',');
		vhls[i][_ModelID] = strval(t[0]);
		if(!isVehModelCorrectly(vhls[i][_ModelID]))
		{
		   format(tmp, sizeof(tmp), "     .    (%d)", vhls[i][_ModelID]);
		   SaveToLog(tmp, 0);
		   printr("       .   .");
		   fclose(f);
		   return false;
		}
		vhls[i][_x] = floatstr(t[1]);
		vhls[i][_y] = floatstr(t[2]);
		vhls[i][_z] = floatstr(t[3]);
		vhls[i][_angl] = floatstr(t[4]);
		vhls[i][_interior] = strval(t[5]);
		vhls[i][_isMagazine] = 0;
		vhls[i][_IsForRent] = strval(t[7]);
		vhls[i][_houseID] = -1;
		vhls[i][_fuel] = 0;
		//
	}
	fclose(f);
	return true;
}

GetFreeSlotInVhls()//      (  )
{
    for(new i=0; i<sizeof(vhls); i++)
	   if(vhls[i][_ModelID] == -1) return i;
	return -1;
}

LoadMagVech(model, houseID, slotID)
{
	new num = GetFreeSlotInVhls();
	if(num == -1)
	{
		printf("Unable to set magVehs for house %d in slot %d (model - %d). Verdict: vehicles array is full", houseID, slotID, model);
		new tmp[256];
		format(tmp, sizeof(tmp), "       %d ( %d; : %d). :   ", houseID, slotID, model);
		SaveToLog(tmp, 0);
		return 0;
	}
	HouseVechs[houseID][slotID][_HousesVechs_Model] = model;
	HouseVechs[houseID][slotID][_HouseVechs_ID] = num;
	vhls[num][_houseID] = houseID;
    vhls[num][_IDCarInHouse] = slotID;
    vhls[num][_ModelID] = HouseVechs[houseID][slotID][_HousesVechs_Model];
    vhls[num][_x] = HouseVechs[houseID][slotID][_HouseVechs_X];
	vhls[num][_y] = HouseVechs[houseID][slotID][_HouseVechs_Y];
	vhls[num][_z] = HouseVechs[houseID][slotID][_HouseVechs_Z];
	vhls[num][_angl] = HouseVechs[houseID][slotID][_HouseVechs_ang];
	vhls[num][_interior] = 0;
	vhls[num][_isMagazine] = 1;
	return 1;
}

AddModVehicle(model, Float:X, Float:Y, Float:Z, Float:A, color1, color2, delay, autoshop = false)
{
        new num = GetFreeSlotInVhls();
        vhls[num][_ModelID] = model;
		vhls[num][_x] = X;
		vhls[num][_y] = Y;
		vhls[num][_z] = Z;
		vhls[num][_angl] = A;
		vhls[num][_interior] = 0;
		vhls[num][_isMagazine] = 0;
		vhls[num][_IsForRent] = 0;
		vhls[num][_houseID] = -1;
		vhls[num][_fuel] = 0;
		vhls[num][colour1] = color1;
		vhls[num][colour2] = color2;
		vhls[num][respawndelay] = delay;
		if(autoshop)
		    vhls[num][_isAutoShop] = 1;
		return CreateVeh(num);
}

GetVehID(vNum)
{
    return vhls[vNum][_CarID];
}

InitVehicles()
{
	for(new i=0; i<sizeof(vhls); i++)
        vhls[i][_CarID] = INVALID_VEHICLE_ID;
    for(new i=0; i<sizeof(Vechs); i++)
        Vechs[i] = -1;
    for(new i=0; i<sizeof(vhls); i++)
	   if(CreateVeh(i) == -1)
	   {
               new tmp[255];
			   format(tmp, sizeof(tmp), " Unable creating vehicle. Number - %d.", i);
			   printr(tmp);
		       return false;
	   }
	for(new i=0; i<sizeof(vhls); i++)
	   if((vhls[i][_ModelID] != -1) && (vhls[i][_isMagazine] != 0) && (vhls[i][_houseID] != -1))
		  if((HouseVechs[vhls[i][_houseID]][vhls[i][_IDCarInHouse]][_HouseVechs_Lock] != 0) || (vhls[i][_isAutoShop] == 1))
		  {
               vhls[i][_ForLock] = 1;
               vhls[i][_Locked] = 1;
		  }
	printf("Vehicles: %d; Static vehicles: %d; Houses vehicles: %d", NumVechs(), GetNumStaticVeh(), GetNumShopVeh());
	return true;
}

UpdateCarDoorsForPlayer(playerid)
{
	if(IsPlayerConnected(playerid))
	{
		for(new i=0; i<sizeof(vhls); i++)
		   if(vhls[i][_ModelID] != -1)
             if(IsVehicleStreamedIn(vhls[i][_CarID], playerid))
              if(isCarDoorUnlockedForPlayer(playerid, i))
                SetVehicleParamsForPlayer(vhls[i][_CarID], playerid, 0, 0);
              else SetVehicleParamsForPlayer(vhls[i][_CarID], playerid, 0, 1);
			   
	}
}

//   ,    
UpdateCarDoorsForPlayer2(playerid)
{
	if(IsPlayerConnected(playerid))
	{
		for(new i=0; i<sizeof(vhls); i++)
		   if(vhls[i][_ModelID] != -1)
             if(IsVehicleStreamedIn(vhls[i][_CarID], playerid))
              if(!isCarDoorUnlockedForPlayer(playerid, i))
                 SetVehicleParamsForPlayer(vhls[i][_CarID], playerid, 0, 1);

	}
}

UpdateCarDoorsForVehicle(vNum)
{
    for(new i=0; i<=MaxPlayerID; i++)
		if(IsPlayerConnected(i))
	     if(IsVehicleStreamedIn(vhls[vNum][_CarID], i))
		 {
			//      
			if(isCarDoorUnlockedForPlayer(i, vNum))
                SetVehicleParamsForPlayer(vhls[vNum][_CarID], i, 0, 0);
            else SetVehicleParamsForPlayer(vhls[vNum][_CarID], i, 0, 1);
		 }
}

isCarDoorUnlockedForPlayer(playerid, carNum)
{
	if(GetPlayerVehicleID(playerid) == vhls[carNum][_CarID]) return true;
	if(PlayerParams[playerid][isGold] == true) return true;
	//    
	// 
	if(vhls[carNum][_Locked] == 0) return true;
	if(vhls[carNum][_isAutoShop] == 1)
	{
		return IsPlayerOwnerOfCar(playerid, vhls[carNum][_CarID]);
	}
	//   
	// 
	if(vhls[carNum][_isMagazine] == 0) return false;
	//  
	//
	if(vhls[carNum][_houseID] == -1) return true;
	//  
	// 
	if(Houses[vhls[carNum][_houseID]][_ownerType] == 0) return false;
	// 
	if(Houses[vhls[carNum][_houseID]][_ownerType] == 1)
	  if(PlayerParams[playerid][hID] == vhls[carNum][_houseID]) return true;
	  else return false;
	// 
	if(Houses[vhls[carNum][_houseID]][_ownerType] == 2)
	  if(isPlayerInBand(playerid, Houses[vhls[carNum][_houseID]][_owner])) return true;
	  else return false;
	return true;
}

CreateVeh(vNum)
{
   if(vhls[vNum][_ModelID] == -1) return 0;
   if(vhls[vNum][_CarID] != INVALID_VEHICLE_ID) return -1;
   new vID;
   new color1, color2, delay;
   if((vhls[vNum][_isMagazine] != 0) && (vhls[vNum][_houseID] != -1))
   {
        delay = HouseVechSpawnDelay;
        color1 = HouseVechs[vhls[vNum][_houseID]][vhls[vNum][_IDCarInHouse]][_color1];
        color2 = HouseVechs[vhls[vNum][_houseID]][vhls[vNum][_IDCarInHouse]][_color2];
   }
   else
   {
        delay = vechSpawnDelay;
        color1 = -1;
        color2 = -1;
   }
   if(vhls[vNum][_isAutoShop] == 1)
   {
        color1 = vhls[vNum][colour1];
        color2 = vhls[vNum][colour2];
        delay = vhls[vNum][respawndelay];
   }
   vID = CreateVehicle(vhls[vNum][_ModelID],
				           vhls[vNum][_x],
						   vhls[vNum][_y],
						   vhls[vNum][_z],
						   vhls[vNum][_angl],
						   color1, color2, delay);
   if(vID == INVALID_VEHICLE_ID) return -1;
   
   if(vhls[vNum][_isMagazine] == 0)
   {
      if(GetModelMaxPetrol(vhls[vNum][_ModelID]) > 0.0)
      {
		new mn = floatround(floatmul(GetModelMaxPetrol(vhls[vNum][_ModelID]), 0.4));
		new mx = floatround(floatmul(GetModelMaxPetrol(vhls[vNum][_ModelID]), 0.8));
        vhls[vNum][_fuel] = float(minrandom(mn, mx));
      }
      else vhls[vNum][_fuel] = 0.0;
   }
   else
      vhls[vNum][_fuel] = GetModelMaxPetrol(vhls[vNum][_ModelID]);
   Vechs[vID] = vNum;
   vhls[vNum][_CarID] = vID;
   vhls[vNum][_InRace] = 0;
   vhls[vNum][_ForMining] = 0;
   vhls[vNum][_MiningRun] = 0;
   vhls[vNum][_spawned] = 1;
   vhls[vNum][_Locked] = 0;
   if(vhls[vNum][_isAutoShop] == 1)
   {
		InitPlayerCarPosByVehID(vID);
		InitPlayerCarModsByVehID(vID);
   }
   return vNum;
}

DestroyVeh(vNum)
{
    new vID = vhls[vNum][_CarID];
    removeAllFromVehicleEx(vID);
    DestroyVehicle(vID);
    vhls[vNum][_CarID] = INVALID_VEHICLE_ID;
    Vechs[vID] = -1;
}

stock SetVehiclePosEx(vehicleid, Float:VX,Float:VY,Float:VZ,Float:VA)
{
        SetVehiclePos(vehicleid,VX,VY,VZ);
        SetVehicleZAngle(vehicleid,VA);
}

BuyVehForHouse(vModel, houseID, slotID)
{
   LoadMagVech(vModel, houseID, slotID);
   HouseVechs[houseID][slotID][_HouseVechs_Tuning] = 0;
   HouseVechs[houseID][slotID][_HouseVechs_Lock] = 0;
   HouseVechs[houseID][slotID][_color1] = -1;
   HouseVechs[houseID][slotID][_color2] = -1;
   CreateVeh(HouseVechs[houseID][slotID][_HouseVechs_ID]);
   BuyHouseCarBD(houseID, slotID, vModel);
}

SellVehForHouse(houseID, slotID)
{
   new vNum = HouseVechs[houseID][slotID][_HouseVechs_ID];
   DestroyVeh(vNum);
   vhls[vNum][_houseID] = -1;
   vhls[vNum][_IDCarInHouse] = -1;
   HouseVechs[houseID][slotID][_HouseVechs_ID] = -1;
   HouseVechs[houseID][slotID][_HouseVechs_Tuning] = 0;
   HouseVechs[houseID][slotID][_HouseVechs_Lock] = 0;
   HouseVechs[houseID][slotID][_color1] = -1;
   HouseVechs[houseID][slotID][_color2] = -1;
   vhls[vNum][_ModelID] = -1;
   SellHouseCarBD(houseID, slotID);
}

RepliceVechsInHouse(houseID, slot1, slot2)
{
   new carNum1, carNum2, carMod1, carMod2, tun, Lock, c1, c2;
   carNum1 = HouseVechs[houseID][slot1][_HouseVechs_ID];
   carNum2 = HouseVechs[houseID][slot2][_HouseVechs_ID];
   carMod1 = HouseVechs[houseID][slot1][_HousesVechs_Model];
   carMod2 = HouseVechs[houseID][slot2][_HousesVechs_Model];
   if((carNum1 == -1) && (carNum2 == -1)) return;
   if(slot1 == slot2) return;
   tun = HouseVechs[houseID][slot1][_HouseVechs_Tuning];
   Lock = HouseVechs[houseID][slot1][_HouseVechs_Lock];
   c1 = HouseVechs[houseID][slot1][_color1];
   c2 = HouseVechs[houseID][slot1][_color2];
   if(carNum1 != -1) DestroyVeh(carNum1);
   if(carNum2 != -1) DestroyVeh(carNum2);
   if(carNum1 != -1) vhls[carNum1][_IDCarInHouse] = slot2;
   if(carNum2 != -1) vhls[carNum2][_IDCarInHouse] = slot1;
   HouseVechs[houseID][slot1][_HouseVechs_ID] = HouseVechs[houseID][slot2][_HouseVechs_ID];
   HouseVechs[houseID][slot2][_HouseVechs_ID] = carNum1;
   HouseVechs[houseID][slot1][_HousesVechs_Model] = HouseVechs[houseID][slot2][_HousesVechs_Model];
   HouseVechs[houseID][slot2][_HousesVechs_Model] = carMod1;
   HouseVechs[houseID][slot1][_HouseVechs_Tuning] = HouseVechs[houseID][slot2][_HouseVechs_Tuning];
   HouseVechs[houseID][slot2][_HouseVechs_Tuning] = tun;
   HouseVechs[houseID][slot1][_HouseVechs_Lock] = HouseVechs[houseID][slot2][_HouseVechs_Lock];
   HouseVechs[houseID][slot2][_HouseVechs_Lock] = Lock;
   HouseVechs[houseID][slot1][_color1] = HouseVechs[houseID][slot2][_color1];
   HouseVechs[houseID][slot2][_color1] = c1;
   HouseVechs[houseID][slot1][_color2] = HouseVechs[houseID][slot2][_color2];
   HouseVechs[houseID][slot2][_color2] = c2;
   if(carNum1 != -1)
   {
       vhls[carNum1][_x] = HouseVechs[houseID][slot2][_HouseVechs_X];
       vhls[carNum1][_y] = HouseVechs[houseID][slot2][_HouseVechs_Y];
       vhls[carNum1][_z] = HouseVechs[houseID][slot2][_HouseVechs_Z];
       vhls[carNum1][_angl] = HouseVechs[houseID][slot2][_HouseVechs_ang];
   }
   if(carNum2 != -1)
   {
       vhls[carNum2][_x] = HouseVechs[houseID][slot1][_HouseVechs_X];
       vhls[carNum2][_y] = HouseVechs[houseID][slot1][_HouseVechs_Y];
       vhls[carNum2][_z] = HouseVechs[houseID][slot1][_HouseVechs_Z];
       vhls[carNum2][_angl] = HouseVechs[houseID][slot1][_HouseVechs_ang];
   }
   if(carNum1 == -1)//   ,   
   {
       BuyHouseCarBD(houseID, slot1, carMod2);
       SellHouseCarBD(houseID, slot2);
   }
   else
     if(carNum2 == -1)//   ,   
     {
       BuyHouseCarBD(houseID, slot2, carMod1);
       SellHouseCarBD(houseID, slot1);
     }
	 else //    
	 {
         UpdateHouseCarId_BD(houseID, slot1, carMod2);
         UpdateHouseCarId_BD(houseID, slot2, carMod1);
	 }
   UpdateHouseCarBD(houseID, slot1);
   UpdateHouseCarBD(houseID, slot2);
   if(carNum1 != -1) CreateVeh(carNum1);
   if(carNum2 != -1) CreateVeh(carNum2);
   if(carNum1 != -1) SetVehicleToRespawn(vhls[carNum1][_CarID]);
   if(carNum2 != -1) SetVehicleToRespawn(vhls[carNum2][_CarID]);
}

public OnVehicleSpawn(vehicleid)
{
   if(Vechs[vehicleid] == -1) return 1;
   /*
   new hh, mm, ss;
   gettime(hh, mm, ss);
   new tmp[256];
   format(tmp, sizeof(tmp), "Vehicle %d spawned in %dh-%dm-%ds", vehicleid, hh, mm, ss);
   printf(tmp);
   SaveToLog(tmp, 0);
   */
   SetVehicleVirtualWorld(vehicleid, 0);
   vhls[Vechs[vehicleid]][_ForLock] = 0;
   vhls[Vechs[vehicleid]][_Locked] = 0;
   if(vhls[Vechs[vehicleid]][_isMagazine] == 0)
   {
      LinkVehicleToInterior(vehicleid, vhls[Vechs[vehicleid]][_interior]);
      if(GetModelMaxPetrol(vhls[Vechs[vehicleid]][_ModelID]) > 0.0)
      {
		new mn = floatround(floatmul(GetModelMaxPetrol(vhls[Vechs[vehicleid]][_ModelID]), 0.4));
		new mx = floatround(floatmul(GetModelMaxPetrol(vhls[Vechs[vehicleid]][_ModelID]), 0.8));
        vhls[Vechs[vehicleid]][_fuel] = float(minrandom(mn, mx));
      }
      else vhls[Vechs[vehicleid]][_fuel] = 0.0;
   }
   else
   {
      vhls[Vechs[vehicleid]][_fuel] = GetModelMaxPetrol(vhls[Vechs[vehicleid]][_ModelID]);
	  new _hID = vhls[Vechs[vehicleid]][_houseID];
	  LinkVehicleToInterior(vehicleid, 0);
	  if(_hID != -1)
	  {
	     new idInHouse = vhls[Vechs[vehicleid]][_IDCarInHouse];
         if(HouseVechs[_hID][idInHouse][_HouseVechs_Lock] != 0)
         {
           vhls[Vechs[vehicleid]][_ForLock] = 1;
		   vhls[Vechs[vehicleid]][_Locked] = 1;
         }
         //---------------------------------------------------------------------
         /*
         if((HouseVechs[vhls[Vechs[vehicleid]][_houseID]][vhls[Vechs[vehicleid]][_IDCarInHouse]][_HouseVechs_Tuning] == 1) ||
            (HouseVechs[vhls[Vechs[vehicleid]][_houseID]][vhls[Vechs[vehicleid]][_IDCarInHouse]][_HouseVechs_Tuning] == 2))
             SetTimerEx("Timer_SetCarTuning", 2000, 0, "dd", vehicleid, HouseVechs[vhls[Vechs[vehicleid]][_houseID]][vhls[Vechs[vehicleid]][_IDCarInHouse]][_HouseVechs_Tuning]);
		 */
		 //---------------------------------------------------------------------
      }
   }
   if(vhls[Vechs[vehicleid]][_isAutoShop] == 1)
   {
           vhls[Vechs[vehicleid]][_ForLock] = 1;
		   vhls[Vechs[vehicleid]][_Locked] = 1;
   }
   UpdateCarDoorsForVehicle(Vechs[vehicleid]);
   vhls[Vechs[vehicleid]][_InRace] = 0;
   vhls[Vechs[vehicleid]][_ForMining] = 0;
   vhls[Vechs[vehicleid]][_MiningRun] = 0;
   vhls[Vechs[vehicleid]][_spawned] = 1;
   if(vhls[Vechs[vehicleid]][_isAutoShop] == 1)
   {
        InitPlayerCarModsByVehID(vehicleid);
   		InitPlayerCarPosByVehID(vehicleid);
   }
   return 1;
}

isVehModelOnServ(vModelID)
{
   for(new i=0; i<MAX_VEHICLES; i++)
	 if(vhls[i][_ModelID] == vModelID) return true;
   return false;
}

NumVechs()
{
	return GetNumStaticVeh() + GetNumShopVeh();
}

GetNumStaticVeh()
{
    new num = 0;
	for(new i=0; i<sizeof(vhls); i++)
	   if((vhls[i][_ModelID] != -1) && (vhls[i][_isMagazine] == 0))
		  num++;
	return num;
}

GetNumShopVeh()
{
   new num = 0;
   for(new i=0; i<sizeof(vhls); i++)
	   if((vhls[i][_ModelID] != -1) && (vhls[i][_isMagazine] != 0))
		  num++;
   return num;
}

#if defined _debug_mode
public OnVehicleMod(playerid, vehicleid, componentid)
{
   new tmp[255];
   format(tmp, sizeof(tmp), "  - %d; : %d", vehicleid, componentid);
   SendPlayerModText(playerid, tmp);
   return 1;
}
#endif

public OnVehicleStreamIn(vehicleid, forplayerid)
{
   if(!isCarDoorUnlockedForPlayer(forplayerid, Vechs[vehicleid]))
        SetVehicleParamsForPlayer(vehicleid, forplayerid, 0, 1);
   return 1;
}
