const MaxSlots=10;        //  
const MaxWeapInSlot=10;   //    

const WMagMaxSlotName = 50; //   

enum _WeapMagEnum
{
	_SlotEnabled,
	_weaponID,
	_weaponAmmo,
	_wMoneys
}

//    (  )
new WeapMagConfig[MaxSlots][MaxWeapInSlot][_WeapMagEnum];

new WeapMagSlotsNames[MaxSlots][WMagMaxSlotName];//   ( )

new Menu:WeapMainMenu;          // 
new Menu:weapMenues[MaxSlots];  //

const WeapMagMaxNumCPs=20;         //   
new WeapMagnumCPs=0;               //  
new WeapMagCPs[WeapMagMaxNumCPs];  // 

//  .(       ,   )
isSlotEmpty(slotNum)
{
	if((slotNum<0)||(slotNum>=MaxSlots)) return true;
	for(new i=0; i<MaxWeapInSlot; i++)
	   if(WeapMagConfig[slotNum][i][_SlotEnabled] != 0) return false;
	return true;
}

//         (..       )
GetNumWeapByNumRow(slot, row)
{
	if(isSlotEmpty(slot)) return -1;
	new num=-1;
	for(new i=0; i<MaxWeapInSlot; i++)
	   if(WeapMagConfig[slot][i][_SlotEnabled] != 0)
	   {
		  num++;
		  if(num == row) return i;
	   }
	return -1;
}

//       
GetNumSlotByNumRow(row)
{
   new num = -1;
   for(new i=0; i<MaxSlots; i++)
	 if(!isSlotEmpty(i))
	 {
		num++;
		if(num == row) return i;
	 }
   return -1;
}

loadWeapMagParams()
{
//weapMagPatch
   new tmp[256], tmp2[256];
   new t2[10][50];
   if(!fexist(weapMagPatch)) return false;
   for(new i=0; i<MaxSlots; i++)
   {
	  for(new k=0; k<MaxWeapInSlot; k++)
	  {
		 format(tmp, sizeof(tmp), "weapSlot_%d_Row_%d", i, k);
		 if(dini_Isset(weapMagPatch, tmp))
		 {
            tmp2 = dini_Get(weapMagPatch,tmp);
            split(tmp2, t2, ',');
            WeapMagConfig[i][k][_SlotEnabled]=1;
            WeapMagConfig[i][k][_weaponID]=strval(t2[0]);
            WeapMagConfig[i][k][_weaponAmmo]=strval(t2[1]);
            WeapMagConfig[i][k][_wMoneys]=strval(t2[2]);
		 }
		 else WeapMagConfig[i][k][_SlotEnabled]=0;
	  }
	  if(!isSlotEmpty(i))
	  {
         format(tmp, sizeof(tmp), "weapSlot_%d_name", i);
         if(dini_Isset(weapMagPatch, tmp))
			format(WeapMagSlotsNames[i], WMagMaxSlotName, "%s", dini_Get(weapMagPatch,tmp));
		 else
		 {
            format(tmp, sizeof(tmp), " WeapMag Load ERROR: Not load name for %d slot", i);
            printf(tmp);
            return false;
		 }
	  }
   }
   return true;
}

// 
WeapMagInitMenues()
{
    new tmp[256];
    WeapMainMenu = CreateMenu("Weapon Magazine", 1, 50.0, 200.0, 150.0);
	if (IsValidMenu(WeapMainMenu))
    {
         SetMenuColumnHeader(WeapMainMenu, 0, "Type");
		 for(new i=0; i<MaxSlots; i++)
         {
			if(!isSlotEmpty(i))
			{
                AddMenuItem(WeapMainMenu, 0, WeapMagSlotsNames[i]);
                weapMenues[i] = CreateMenu(WeapMagSlotsNames[i], 2, 50.0, 200.0, 150.0, 150.0);
	            if (IsValidMenu(weapMenues[i]))
                {
                   SetMenuColumnHeader(weapMenues[i], 0, "Name");
                   SetMenuColumnHeader(weapMenues[i], 1, "Value");
                   for(new k=0; k<MaxWeapInSlot; k++)
					 if(WeapMagConfig[i][k][_SlotEnabled] != 0)
					 {
	                    // ( )
	                    GetWeaponNameMy(WeapMagConfig[i][k][_weaponID], tmp, sizeof(tmp));
	                    AddMenuItem(weapMenues[i], 0, tmp);
	                    //  ( )
	                    valstr(tmp, WeapMagConfig[i][k][_wMoneys]);
	                    AddMenuItem(weapMenues[i], 1, tmp);
					 }
                   AddMenuItem(weapMenues[i], 0, "Back");
                }
            }
		 }
    }
}

WeapMagBW(playerid, weapID, ammo, moneys)//  
{
	if(isWeapDisabled(weapID))
	{
        SendPlayerModText(playerid, "      .   .", 0x10F441AA);
        return 0;
	}
	if(GetPlayerMoneyEx(playerid) < moneys)
	{
		SendPlayerModText(playerid, "  .", 0x10F441AA);
		return 0;
	}
	AddPlayerMoneyEx(playerid, -moneys);
	if(weapID != 47) GivePlayerWeaponMy(playerid, weapID, ammo);
	else SetPlayerArmour(playerid, 100.0);
	return 1;
}
