/* weaponts.pwn
 *
 *   ereg.pwn
 *
 *     .
 *
 */

const NUM_WEAPS = 47;
enum WeapDescr
{
   _WeapModelID,                       // 
   _maxAmmo,                           //  (0 -  )
   _numDefaultAmmo,                    // ,   (  )()
   _IsDisabled,                        //   
   _isWBanDisabled                     //    weapBan
}

new weapsInfo[NUM_WEAPS][WeapDescr];

//     
LoadWeapsInfo()
{
    if(!fexist(WeapInfoPatch))
	{
       SaveToLog("     ", 0);
	   return false;
	}
	new File:f = fopen(WeapInfoPatch, io_read);
	new tmp[255];
	new t[15][50];
	new i=0;
	while(i<NUM_WEAPS)
	{
		if(!fread(f, tmp))
		{
           fclose(f);
		   SaveToLog("      ", 0);
	       return false;
		}
        StripNewLine(tmp);
        if((strlen(tmp) < 10) || ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*"))
		   continue;
        split(tmp, t, ',');
        weapsInfo[i][_WeapModelID] = strval(t[0]);
        weapsInfo[i][_maxAmmo] = strval(t[1]);
        if(weapsInfo[i][_maxAmmo] < 0) weapsInfo[i][_maxAmmo] = 0;
        weapsInfo[i][_numDefaultAmmo] = strval(t[2]);
        if(weapsInfo[i][_numDefaultAmmo] < 0) weapsInfo[i][_numDefaultAmmo] = 0;
        weapsInfo[i][_IsDisabled] = strval(t[3]);
        if((weapsInfo[i][_IsDisabled] != 0) && (weapsInfo[i][_IsDisabled] != 1)) weapsInfo[i][_IsDisabled] = 0;
        weapsInfo[i][_isWBanDisabled] = strval(t[4]);
        if((weapsInfo[i][_isWBanDisabled] != 0) && (weapsInfo[i][_isWBanDisabled] != 1)) weapsInfo[i][_isWBanDisabled] = 0;
        i++;
	}
	fclose(f);
	return true;
}

//   
isWIDCorrectly(wID)
{
	if((wID < 0) || (wID >=NUM_WEAPS)) return false;
	return true;
}

//  ( ,    )
isWeapDisabled(wID, playerid=-1)
{
   if(playerid != -1)
   {
	   if(IsPlayerConnected(playerid))
		  if(isPlayerInDM(playerid))
			  if(isWeapForDM(wID, PlayerParams[playerid][isInDM])) return false;
			  else return true;
   }
   if(wID==47) return false;//
   if(!isWIDCorrectly(wID)) return true;
   if(wID == 0) return true;
   if(weapsInfo[wID][_IsDisabled] != 0) return true;
   if((IsWeapontBanEnabled != 0) && (weapsInfo[wID][_isWBanDisabled] != 0)) return true;
   return false;
}

//  ,   
GivePlayerWeaponMy(playerid, wID, wAmmo)
{
   if(PlayerParams[playerid][AdminLvl] < ALvlForNonWeapVerify)
	  if(isWeapDisabled(wID)) return;
   GivePlayerWeapon(playerid, wID, wAmmo);
}

//       ,   
DropWeapOnDie(playerid, slot, Float:x, Float:y, Float:z)
{
   new weapid, ammo;
   GetPlayerWeaponData(playerid, slot, weapid, ammo);
   if(isWeapDisabled(weapid)) return;
   if((!isWeapDisabled(weapid)) && (ammo > 0))
   {
        if(ammo > weapsInfo[weapid][_maxAmmo]) ammo = weapsInfo[weapid][_maxAmmo];
		if(ammo<0) ammo = 0;
		if(ammo == 0) return;
		CrPic(weapsInfo[weapid][_WeapModelID], x, y, z, GetOptimalTimePicLife(), ammo, weapid, PicType_Dropped_Weap);
   }
}

//    
onPlayerPicUpWeapont(playerid, pickupid)
{
   if(isWIDCorrectly(PicUPs[pickupid][_weapID]))
   {
	  new numSlot = GetWeapSlot(PicUPs[pickupid][_weapID]);
	  if(!isWeapForPlayer(PicUPs[pickupid][_weapID], playerid)) return false;
	  new w, a;
	  GetPlayerWeaponData(playerid, numSlot, w, a);
	  if((w != PicUPs[pickupid][_weapID]) && IsWeapIDCorrectly(w) && (a > 0)) return false;
	  GivePlayerWeaponMy( playerid, PicUPs[pickupid][_weapID], PicUPs[pickupid][picAmmo]);
   }
   return true;
}

//     .        
isWeapForPlayer(wID, playerid)
{
   new ts = GetTypeSkinForPlayer(playerid);
   if(ts == Skin_Type_Medic)
	  if(wID!=24 && wID!=46 && wID!=16) return false;
   if(isWeapForKick(wID)) return false;
   if(isWeapDisabled(wID)) return false;
   return true;
}
