#define _Zones_Included

const MaxNumZones = 100;
new numZones;

const defaultZonesColorOptically = 100;

const MinimumPlayersForCapture = 2;
const emptyZoneCaptureTime = 120;//2 
const fullZoneCaptureTime = 300;//5 
const MinPlayersOnServerForStartCap = 5;

const TimeAfterCaptureForMoney = 5;             //  ,      

const TimePauseWhileZoneCaptured = 3;  //  ,         

enum zoneDescr
{
   Float:_minX,
   Float:_maxX,
   Float:_minY,
   Float:_maxY,
   Float:_minZ,
   Float:_maxZ,
   Float:area,           //
   numBand,              //  
   isCapture,            //  -(  , )
   zoneID,
   timeStartCapture,     //  
   timeLastCapture,      //  
   timeEndCapture        //  
}

new Float: MoneysForAreaInTenMinute;

new Zones[MaxNumZones][zoneDescr];

LoadZones()
{
    if(!fexist(zonesPatch)) return false;
	new File:f = fopen(zonesPatch, io_read);
	new tmp[255];
	new t[15][50];
	numZones = 0;
	
	while(fread(f, tmp) && (numZones<MaxNumZones))
	{
        if((strlen(tmp) < 20) || ifStrStartedFromStr(tmp, "//") || ifStrStartedFromStr(tmp, "*"))
		   continue;
        split(tmp, t, ',');
        Zones[numZones][_minX] = floatstr(t[0]);
        Zones[numZones][_minY] = floatstr(t[1]);
        Zones[numZones][_maxX] = floatstr(t[2]);
        Zones[numZones][_maxY] = floatstr(t[3]);
        Zones[numZones][_minZ] = floatstr(t[4]);
        Zones[numZones][_maxZ] = floatstr(t[5]);
        numZones++;
	}
	fclose(f);
	return LoadZonesFromBD();
}


fullZones()
{
    new Float:sumArea;
    for(new z=0; z<numZones; z++)
    {
        Zones[z][area] = floatmul(floatMod(Zones[z][_minX], Zones[z][_maxX]), floatMod(Zones[z][_minY], Zones[z][_maxY]));
        sumArea+=Zones[z][area];
        new zID = GangZoneCreate(Zones[z][_minX], Zones[z][_minY], Zones[z][_maxX], Zones[z][_maxY]);
        Zones[z][zoneID] = zID;
        Zones[z][isCapture] = -1;
        Zones[z][timeStartCapture] = 0;
        Zones[z][timeStartCapture] = 0;
    }
    MoneysForAreaInTenMinute = floatdiv(floatdiv(MoneysForAllZonesInDay, 144.0), sumArea);
    new tmp[255];
    format(tmp, sizeof(tmp), " Total area: %.2f; bonus for units area in 10 minutes: %f;", sumArea, MoneysForAreaInTenMinute);
    printr(tmp);
}

showZonesForPlayer(playerid)
{
	if(!isPlayerInAnyBand(playerid)) return;
	for(new i=0; i<numZones; i++)
	{
		//:      
		if(Zones[i][numBand] != -1)
          if(!isBandReal(Zones[i][numBand]))
		  {
		    Zones[i][numBand] = -1;
		    updateZoneForAllPlayers(i);
	        continue;
		  }
		if(Zones[i][isCapture] != -1)
		  if(!isBandReal(Zones[i][isCapture]))
		  {
		    Zones[i][isCapture] = -1;
		    updateZoneForAllPlayers(i);
		    continue;
		  }
		if((Zones[i][numBand] == -1) && (Zones[i][isCapture] == -1))
            GangZoneShowForPlayer(playerid, Zones[i][zoneID], GetColorMy(defaultBandColor, defaultZonesColorOptically));
        if((Zones[i][numBand] == -1) && (Zones[i][isCapture] != -1))
        {
            GangZoneShowForPlayer(playerid, Zones[i][zoneID], GetColorMy(defaultBandColor, defaultZonesColorOptically));
            new FlashColor = bands[Zones[i][isCapture]][bColor];
            if(FlashColor == defaultBandColor) FlashColor = 0xAA3333AA;
            GangZoneFlashForPlayer(playerid, Zones[i][zoneID], GetColorMy(FlashColor, defaultZonesColorOptically));
        }
        if((Zones[i][numBand] != -1) && (Zones[i][isCapture] == -1))
            GangZoneShowForPlayer(playerid, Zones[i][zoneID], GetColorMy(bands[Zones[i][numBand]][bColor], defaultZonesColorOptically));
        if((Zones[i][numBand] != -1) && (Zones[i][isCapture] != -1))
        {
            GangZoneShowForPlayer(playerid, Zones[i][zoneID], GetColorMy(bands[Zones[i][numBand]][bColor], defaultZonesColorOptically));
            new FlashColor = bands[Zones[i][isCapture]][bColor];
            if((FlashColor == defaultBandColor) && (bands[Zones[i][numBand]][bColor] == defaultBandColor)) FlashColor = 0xAA3333AA;
            GangZoneFlashForPlayer(playerid, Zones[i][zoneID], GetColorMy(FlashColor, defaultZonesColorOptically));
        }
	}
}

hideZonesForPlayer(playerid)
{
	if(!isPlayerInAnyBand(playerid)) return;
	for(new i=0; i<numZones; i++)
	{
		GangZoneHideForPlayer(playerid, i);
	}
}

updateZoneForAllPlayers(numZone)
{
	if(numZone<0 || numZone>=numZones) return;
    if(Zones[numZone][numBand] != -1)
          if(!isBandReal(Zones[numZone][numBand]))
		    Zones[numZone][numBand] = -1;
	if(Zones[numZone][isCapture] != -1)
		  if(!isBandReal(Zones[numZone][isCapture]))
		    Zones[numZone][isCapture] = -1;
    GangZoneHideForAll(Zones[numZone][zoneID]);
	for(new i=0; i<=MaxPlayerID; i++)
	{
	   if(isPlayerInAnyBand(i))
	   {
            if((Zones[numZone][numBand] == -1) && (Zones[numZone][isCapture] == -1))
               GangZoneShowForPlayer(i, Zones[numZone][zoneID], GetColorMy(defaultBandColor, defaultZonesColorOptically));
            if((Zones[numZone][numBand] == -1) && (Zones[numZone][isCapture] != -1))
            {
              GangZoneShowForPlayer(i, Zones[numZone][zoneID], GetColorMy(defaultBandColor, defaultZonesColorOptically));
              new FlashColor = bands[Zones[numZone][isCapture]][bColor];
              if(FlashColor == defaultBandColor) FlashColor = 0xAA3333AA;
              GangZoneFlashForPlayer(i, Zones[numZone][zoneID], GetColorMy(FlashColor, defaultZonesColorOptically));
            }
            if((Zones[numZone][numBand] != -1) && (Zones[numZone][isCapture] == -1))
              GangZoneShowForPlayer(i, Zones[numZone][zoneID], GetColorMy(bands[Zones[numZone][numBand]][bColor], defaultZonesColorOptically));
            if((Zones[numZone][numBand] != -1) && (Zones[numZone][isCapture] != -1))
            {
              GangZoneShowForPlayer(i, Zones[numZone][zoneID], GetColorMy(bands[Zones[numZone][numBand]][bColor], defaultZonesColorOptically));
              new FlashColor = bands[Zones[numZone][isCapture]][bColor];
              if((FlashColor == defaultBandColor) && (bands[Zones[numZone][numBand]][bColor] == defaultBandColor)) FlashColor = 0xAA3333AA;
              GangZoneFlashForPlayer(i, Zones[numZone][zoneID], GetColorMy(FlashColor, defaultZonesColorOptically));
            }
	   }
	}
}

isPlayerInZoneMy(playerid, numZone)
{
	if(!IsPlayerConnected(playerid)) return false;
	if((numZone < 0) || (numZone >= numZones)) return false;
	if(IsPlayerInAreaMy(playerid, 0, Zones[numZone][_minX], Zones[numZone][_maxX], Zones[numZone][_minY], Zones[numZone][_maxY], Zones[numZone][_minZ], Zones[numZone][_maxZ])) return true;
	return false;
}

isPlayerInZone(playerid, numZone)
{
	if(isPlayerInWarVechs(playerid)) return false;
	if(PlayerParams[playerid][isFreezed]) return false;
	if(PlayerParams[playerid][isMenuShowed]) return false;
	if(IsPlayerInAnyVehicle(playerid))
	   if(GetPlayerVehicleID(playerid) == 449) return false;
	return (PlayerParams[playerid][playerZone] == numZone);
}

GetPlayerNumZone(playerid)
{
    return PlayerParams[playerid][playerZone];
}

GetNumBanditsInZone(numZone, bandID)
{
    if((numZone < 0) || (numZone >= numZones)) return 0;
    if((bandID < 0) || (bandID >= maxNumBands)) return 0;
    new num = 0;
    for(new i=0; i<=MaxPlayerID; i++)
	   if(IsPlayerConnected(i))
		  if(PlayerParams[i][IsPlayerLogined] != 0)
	        if(PlayerParams[i][playerBand] == bandID)
			   if(isPlayerInZone(i, numZone))
			      num ++;
	return num;
}
/*
GetNumFriendlyBanditsInZone(numZone, bandID)
{
    if((numZone < 0) || (numZone >= numZones)) return 0;
    if((bandID < 0) || (bandID >= maxNumBands)) return 0;
    new num = 0;
    for(new i=0; i<=MaxPlayerID; i++)
	   if(isPlayerInAnyBand(i) && !isPlayerInDM(i))
	      if((PlayerParams[i][playerBand] == bandID) || isFriendlyBand(PlayerParams[i][playerBand], bandID))
			   if(isPlayerInZone(i, numZone))
			      num ++;
	return num;
}*/

//  
isZoneNearZone(zone1, zone2)
{
	if((zone1 >= numZones) || (zone1 < 0) || (zone2 >= numZones) || (zone2 < 0)) return false;
	new Float:x1Min = Zones[zone1][_minX];
	new Float:x1Max = Zones[zone1][_maxX];
	new Float:x2Min = Zones[zone2][_minX];
	new Float:x2Max = Zones[zone2][_maxX];
	new Float:y1Min = Zones[zone1][_minY];
	new Float:y1Max = Zones[zone1][_maxY];
	new Float:y2Min = Zones[zone2][_minY];
	new Float:y2Max = Zones[zone2][_maxY];
    if(isFloatBetween(x2Max, x1Min, x1Max) || isFloatBetween(x2Min, x1Min, x1Max))
	   if(isFloatBetween(y2Min, y1Min, y1Max) ||
	      isFloatBetween(y2Max, y1Min, y1Max) ||
		  ((y2Min < y1Min) && (y2Max > y1Max))) return true;
	if(isFloatBetween(y2Max, y1Min, y1Max) || isFloatBetween(y2Min, y1Min, y1Max))//(y1Max == y2Min) || (y1Min == y2Max))
	   if(isFloatBetween(x2Min, x1Min, x1Max) ||
	      isFloatBetween(x2Max, x1Min, x1Max) ||
		  ((x2Min < x1Min) && (x2Max > x1Max))) return true;
	return false;
}

// ,  
numZonesForBand(bandID)
{
   new num = 0;
   for(new i = 0; i < numZones; i++)
	   if(Zones[i][numBand] == bandID) num++;
   return num;
}
/*
for(new i = 0; i < numZones; i++)
	{
		//   
        if((Zones[i][isCapture] == -1) && (Zones[i][numBand] != -1))
        {
            //:      
             if(!isBandReal(Zones[i][numBand]))
		     {
		        Zones[i][numBand] = -1;
		        updateZoneForAllPlayers(i);
	            continue;
		     }
			 if((GTick() - Zones[i][timeEndCapture]) > TimeAfterCaptureForMoney*60000)
			 {
			    IncBandMoneys(Zones[i][numBand], floatround(floatmul(Zones[i][area], MoneysForAreaInTenMinute)));
				//IncBandExp(Zones[i][numBand], floatround(floatmul(float(GetNumWarBanditsForBandOnServ(Zones[i][numBand])), ZoneBandExpKoeff)));
			 }
		}
	}
	//    
	new numZ;
	for(new i=0; i<maxNumBands; i++)
	{
		if(bands[i][enabled] != 0)
		{
			numZ = numZonesForBandForAddExp(i);
			if(numZ > 0)
			  IncBandExp(i, floatround(floatmul(float(GetNumWarBanditsForBandOnServ(i)*numZ), ZoneBandExpKoeff)));
		}
	}
*/

moneysAndExpForBandZones(bID, &exp, &expMax, &moneyesMax, &moneys)
{
	moneyesMax=0; moneys=0;
	for(new i = 0; i < numZones; i++)
		if(Zones[i][numBand] == bID)
		{
            moneyesMax += floatround(floatmul(Zones[i][area], MoneysForAreaInTenMinute));
            if((Zones[i][isCapture] == -1) && ((GTick() - Zones[i][timeEndCapture]) > TimeAfterCaptureForMoney*60000))
                moneys += floatround(floatmul(Zones[i][area], MoneysForAreaInTenMinute));
	    }
	new numZ = numZonesForBandForAddExp(bID);
	exp=floatround(floatmul(float(GetNumWarBanditsForBandOnServ(bID)*numZ), ZoneBandExpKoeff));
	numZ = numZonesForBand(bID);
	expMax=floatround(floatmul(float(GetNumWarBanditsForBandOnServ(bID)*numZ), ZoneBandExpKoeff));
}

numZonesForBandForAddExp(bandID)
{
   new num = 0;
   for(new i = 0; i < numZones; i++)
	   if(Zones[i][numBand] == bandID)
	     if((GTick() - Zones[i][timeEndCapture]) > TimeAfterCaptureForMoney*60000) num++;
   return num;
}

//    
isBandMayCaptureZone(bandID, zone)
{
    if((zone < 0) || (zone >= numZones)) return false;
    if((bandID < 0) || (bandID >= maxNumBands)) return false;
	if(numZonesForBand(bandID) == 0) return true;
    
    for(new i = 0; i < numZones; i++)
	   if(i != zone)
          if(Zones[i][numBand] == bandID)
			 if(isZoneNearZone(i, zone)) return true;
	return false;
}

public updatesZoneStatusInTimer()
{
    new tmp[255];
	for(new i = 0; i < numZones; i++)
	{
		// 
        if(Zones[i][isCapture] != -1)
        {
		   //,     
	       if(!isBandReal(Zones[i][isCapture]))
	       {
		      Zones[i][isCapture] = -1;
		      updateZoneForAllPlayers(i);
		      continue;
		   }
		   //    
		   new lastTimeSec = Zones[i][timeLastCapture];
		   //,      
		   new numBandits = 0;//
		   new numSecur = 0;//
		   for(new id=0; id<=MaxPlayerID; id++)
	          if(IsPlayerConnected(id))
		         if(PlayerParams[id][IsPlayerLogined] != 0)
	                 if(isFriendlyBand(PlayerParams[id][playerBand], Zones[i][isCapture]) || isPlayerInBand(id, Zones[i][isCapture]))
	                 {
			             if(isPlayerInZone(id, i))
			             {
                              if(GetPlayerPauseTime(id) >= 1000*TimePauseWhileZoneCaptured)
                              {
                                 format(tmp, sizeof(tmp), "          %d .   ", TimePauseWhileZoneCaptured);
								 SendPlayerModText(id, tmp);
                              }
                              else
							  {
                                   numBandits++;
							  }
			             }
			         }
			         else if(isPlayerInBand(id, Zones[i][numBand]))
                            if(isPlayerInZone(id, i))
			                {
                                 numSecur++;
			                }
		   
		   
		   if(numBandits < MinimumPlayersForCapture)
		   {
			  format(tmp, sizeof(tmp), "          %d .  ", MinimumPlayersForCapture);
              SendBandsText(Zones[i][isCapture], tmp);
              if(Zones[i][numBand] != -1) SendBandsText(Zones[i][numBand], "  , ");
              Zones[i][isCapture] = -1;
              updateZoneForAllPlayers(i);
		      continue;
		   }
		   //,      .
		   if(lastTimeSec <= 0)
		   {
                if(Zones[i][numBand] == -1)
                {
                     SendBandsText(Zones[i][isCapture], "    .   .     .");
				     format(tmp, sizeof(tmp), "    - %.0f $  10 ", floatmul(Zones[i][area], MoneysForAreaInTenMinute));
				     SendBandsText(Zones[i][isCapture], tmp);
				     format(tmp, sizeof(tmp), "  %s    %d", bands[Zones[i][isCapture]][bName], i);
				     SendAllBandsText(tmp, Zones[i][isCapture]);
				     SaveToLog(tmp, 7, Zones[i][isCapture]);
                }
                else
                {
                     format(tmp, sizeof(tmp), "  .     %s.", bands[Zones[i][isCapture]][bName]);
				     SendBandsText(Zones[i][numBand], tmp);
				     format(tmp, sizeof(tmp), "     %s.    - %.0f $  10 ", bands[Zones[i][numBand]][bName], floatmul(Zones[i][area], MoneysForAreaInTenMinute));
				     SendBandsText(Zones[i][isCapture], tmp);
				     format(tmp, sizeof(tmp), "  %s   %d   %s", bands[Zones[i][isCapture]][bName], i, bands[Zones[i][numBand]][bName]);
				     SendAllBandsText(tmp, Zones[i][isCapture]);
				     SaveToLog(tmp, 7, Zones[i][isCapture]);
                }
                Zones[i][numBand] = Zones[i][isCapture];
                CaptureZoneBD(i, Zones[i][numBand]);
                Zones[i][isCapture] = -1;
                Zones[i][timeEndCapture] = GTick();
                updateZoneForAllPlayers(i);
                continue;
		   }
		   Zones[i][timeLastCapture]--;
        }
	}
}

public AddBandMoneyForZonesInTimer()
{
    for(new i = 0; i < numZones; i++)
	{
		//   
        if((Zones[i][isCapture] == -1) && (Zones[i][numBand] != -1))
        {
            //:      
             if(!isBandReal(Zones[i][numBand]))
		     {
		        Zones[i][numBand] = -1;
		        updateZoneForAllPlayers(i);
	            continue;
		     }
			 if((GTick() - Zones[i][timeEndCapture]) > TimeAfterCaptureForMoney*60000)
			 {
			    IncBandMoneys(Zones[i][numBand], floatround(floatmul(Zones[i][area], MoneysForAreaInTenMinute)));
				//IncBandExp(Zones[i][numBand], floatround(floatmul(float(GetNumWarBanditsForBandOnServ(Zones[i][numBand])), ZoneBandExpKoeff)));
			 }
		}
	}
	//    
	new numZ;
	for(new i=0; i<maxNumBands; i++)
	{
		if(bands[i][enabled] != 0)
		{
			numZ = numZonesForBandForAddExp(i);
			if(numZ > 0)
			  IncBandExp(i, floatround(floatmul(float(GetNumWarBanditsForBandOnServ(i)*numZ), ZoneBandExpKoeff)));
		}
	}
}

public UpdatePlayersZone()
{
    for(new id=0; id<=MaxPlayerID; id++)
		if(IsPlayerConnected(id))
		{
          PlayerParams[id][playerZone] = -1;
          for(new i = 0; i < numZones; i++)
	        if(isPlayerInZoneMy(id, i))
	        {
               PlayerParams[id][playerZone] = i;
               break;
            }
        }
}

isAnyBandZoneCapture(bandID)
{
   for(new i = 0; i < numZones; i++)
	   if((Zones[i][numBand] == bandID) && (Zones[i][isCapture] != -1)) return true;//
   return false;
}

//------------------------------------------------------------------------------

ClearZones()
{
    for(new i = 0; i < numZones; i++)
	{
		if(Zones[i][numBand] != -1)
		{
            Zones[i][numBand] = -1;
            updateZoneForAllPlayers(i);
            CaptureZoneBD(i, -1);
		}
	}
}
