#include <a_samp>

new version[] = "1.6 Beta";
new dateOfEndingWork[] = "17.05.2008";

forward Timer_UpdateCP();
forward Float:GetDistanceBetweenPlayerAndCP(playerid, numCP);
forward IsPlayerNearCP(playerid, numCP);

//Colling functions
forward CPEngine_CreateCPForAll(Float:X, Float:Y, Float:Z, Float:SIZ, Float:DIS, INTERIOR, ISMAIN, NAME[]);
forward CPEngine_CreateCPForPlayer(playerid, Float:X, Float:Y, Float:Z, Float:SIZ, Float:DIS, INTERIOR, ISMAIN, NAME[]);
forward CPEngine_DeleteCP(NAME[]);
forward Timer_SetPlayerCheckpointEx(playerid, Float:X, Float:Y, Float:Z, Float:size);


enum Pics
{
	Enabled, Float:x, Float:y, Float:z, Float:siz, Float:distanse, interior, players, isMain, name[50]
}

new MassPics[500][Pics];                                                        //,     
new isTimerEnabled;                                                             //,    
new ShowedCPForPlayer[MAX_PLAYERS];                                             //     
new isPlayerInCP[MAX_PLAYERS];                                                  //    (-1 - .   )

public OnFilterScriptInit()
{
    new tmp[256];
	print("\n--------------------------------------");
	format(tmp, sizeof(tmp), " Engine for work with checkpoints (ver. %s) Date of releasing: %s", version, dateOfEndingWork);
	print(tmp);
	print("--------------------------------------\n");
	isTimerEnabled = 0;
	CallRemoteFunction("CPEngine_Load", "");
	return 1;
}

public OnGameModeInit()
{
    for(new i = 0; i < sizeof(MassPics); i++)
	{
        MassPics[i][Enabled] = 0;
        MassPics[i][players] = -1;
	}
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
	    ShowedCPForPlayer[i] = -1;
	    isPlayerInCP[i] = -1;
	}
    CallRemoteFunction("CPEngine_Ready", "");
	return 1;
}

public OnPlayerConnect(playerid)
{
	if(isTimerEnabled == 0)
	{
		 isTimerEnabled = 1;
		 SetTimer("Timer_UpdateCP", 2000, 1);
	}
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
    for(new k = 0; k < sizeof(MassPics); k++)
	{
		 if(MassPics[k][players] == playerid)
		 {
		     MassPics[k][Enabled] = 0;
		     CallRemoteFunction("CPEngine_DelCP", "s", MassPics[k][name]);
		 }
	}
	return 1;
}

public Timer_UpdateCP()                                                         //,  
{
    new Float:dis;
    new PlayerInterior;
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		 if(IsPlayerConnected(i))
		 {
			   new numShowedCP = -1;
			   new Float:DisShowedCP = 999999.0;
			   new IsMainCP = 0;
			   
			   PlayerInterior = GetPlayerInterior(i);
			   
			   for(new k = 0; k < sizeof(MassPics); k++)
			   {
				   if((IsMainCP == 0)&&                                         //     
				      (MassPics[k][Enabled] != 0) &&                            //   
                      (MassPics[k][interior] == PlayerInterior) &&              //     ,   
				      ((MassPics[k][players] == -1) || (MassPics[k][players] == i)))  //    
				   {
						if(MassPics[k][isMain] != 0)
						{
                             numShowedCP = k;
                             IsMainCP = 1;
						}
						else
						{
						   if(IsPlayerNearCP(i, k))
						   {
						      dis = GetDistanceBetweenPlayerAndCP(i, k);
						      if(dis < DisShowedCP)
						      {
                                 numShowedCP = k;
                                 DisShowedCP = dis;
						      }
						   }
						}
				   }
			   }
			   if(numShowedCP != -1)                                            //   ,   
			   {
                   DisablePlayerCheckpoint(i);
                   if(ShowedCPForPlayer[i] != numShowedCP) //   
                   {
				     ShowedCPForPlayer[i] = numShowedCP;
				     SetTimerEx("Timer_SetPlayerCheckpointEx", 100, 0, "dffff", i, MassPics[numShowedCP][x], MassPics[numShowedCP][y], MassPics[numShowedCP][z], MassPics[numShowedCP][siz]);
				   }
				   else SetPlayerCheckpoint(i, MassPics[numShowedCP][x], MassPics[numShowedCP][y], MassPics[numShowedCP][z], MassPics[numShowedCP][siz]);
			   }
			   else                                                             //   
			   {
                   isPlayerInCP[i] = -1;  //  
                   if(ShowedCPForPlayer[i] != -1)                               //  ,   
                   {
						DisablePlayerCheckpoint(i);
						ShowedCPForPlayer[i] = -1;
                   }
			   }
		 }
	}
}

public IsPlayerNearCP(playerid, numCP)//    
{
	new Float:x1, Float:y1, Float:z1;
	GetPlayerPos(playerid, x1, y1, z1);
	//MassPics[numCP][distanse]
	//MassPics[numCP][x]
	//MassPics[numCP][y]
	//MassPics[numCP][z]
	if((x1 > (MassPics[numCP][x] - MassPics[numCP][distanse])) &&
	   (x1 < (MassPics[numCP][x] + MassPics[numCP][distanse])) &&
	   (y1 > (MassPics[numCP][y] - MassPics[numCP][distanse])) &&
	   (y1 < (MassPics[numCP][y] + MassPics[numCP][distanse])) &&
	   (z1 > (MassPics[numCP][z] - MassPics[numCP][distanse])) &&
	   (z1 < (MassPics[numCP][z] + MassPics[numCP][distanse]))
	  )
	   return true;
	return false;
}

public Float:GetDistanceBetweenPlayerAndCP(playerid, numCP)
{
    new Float:x1,Float:y1,Float:z1,Float:x2,Float:y2,Float:z2;
    new Float:tmpdis;
    GetPlayerPos(playerid,x1,y1,z1);
	x2 = MassPics[numCP][x]; y2 = MassPics[numCP][y]; z2 = MassPics[numCP][z];
    tmpdis = floatsqroot(floatpower(floatabs(floatsub(x2,x1)),2)+floatpower(floatabs(floatsub(y2,y1)),2)+floatpower(floatabs(floatsub(z2,z1)),2));
    return tmpdis;
}

public OnPlayerEnterCheckpoint(playerid)
{
	new numCP = ShowedCPForPlayer[playerid];
	if(numCP != -1)
	{
		 new Float:dis = GetDistanceBetweenPlayerAndCP(playerid, numCP);
		 if(dis <= MassPics[numCP][siz])
		 {
			  // :    
			  if(isPlayerInCP[playerid] != numCP)
			  {
                 isPlayerInCP[playerid] = numCP;
			     CallRemoteFunction("CPEngine_PlayerEnterCheckpoint", "ds", playerid, MassPics[numCP][name]);
			  }
		 }
	}
	return 1;
}

public OnPlayerLeaveCheckpoint(playerid)
{
    isPlayerInCP[playerid] = -1;
	return 1;
}

public CPEngine_CreateCPForAll(Float:X, Float:Y, Float:Z, Float:SIZ, Float:DIS, INTERIOR, ISMAIN, NAME[])
{
	new numCP = -1;
	for(new i = sizeof(MassPics) - 1; i >= 0; i--)
	    if(MassPics[i][Enabled] == 0) numCP = i;
	if(numCP != -1)
	{
        MassPics[numCP][players] = 256;
        MassPics[numCP][Enabled] = 1;
        MassPics[numCP][x] = X;
        MassPics[numCP][y] = Y;
        MassPics[numCP][z] = Z;
        MassPics[numCP][siz] = SIZ;
        MassPics[numCP][distanse] = DIS;
        MassPics[numCP][interior] = INTERIOR;
        MassPics[numCP][players] = -1;
        MassPics[numCP][isMain] = ISMAIN;
        format(MassPics[numCP][name], 50, "%s", NAME);
	}
	/*
	new tmp[500];
	format(tmp, sizeof(tmp), "Remout Calling Add public CP. Parameters:\n X=%f; Y=%f;  Z=%f\nsize=%f; distance=%f\ninterior=%d\nisMain mode=%d\nCPname=%s\n", X, Y, Z, SIZ, DIS, INTERIOR, ISMAIN, NAME);
	print(tmp);*/
}

public CPEngine_CreateCPForPlayer(playerid, Float:X, Float:Y, Float:Z, Float:SIZ, Float:DIS, INTERIOR, ISMAIN, NAME[])
{
	new numCP = -1;
	for(new i = sizeof(MassPics) - 1; i >= 0; i--)
	    if(MassPics[i][Enabled] == 0) numCP = i;
	if(numCP != -1)
	{
        MassPics[numCP][players] = -1;
        MassPics[numCP][Enabled] = 1;
        MassPics[numCP][x] = X;
        MassPics[numCP][y] = Y;
        MassPics[numCP][z] = Z;
        MassPics[numCP][siz] = SIZ;
        MassPics[numCP][distanse] = DIS;
        MassPics[numCP][interior] = INTERIOR;
        MassPics[numCP][players] = playerid;
        MassPics[numCP][isMain] = ISMAIN;
        format(MassPics[numCP][name], 50, "%s", NAME);
	}
	/*
	new tmp[500];
	format(tmp, sizeof(tmp), "Remout Calling Add Personal CP. Parameters:\n X=%f; Y=%f;  Z=%f\nsize=%f; distance=%f\ninterior=%d\nisMain mode=%d\nCPname=%s\n", X, Y, Z, SIZ, DIS, INTERIOR, ISMAIN, NAME);
	print(tmp);*/
}

public CPEngine_DeleteCP(NAME[])
{
	for(new i = 0; i < sizeof(MassPics); i++)
	{
		 if(MassPics[i][Enabled] == 1)
			 if(strcmp(NAME, MassPics[i][name], true) == 0)
			 {
			     MassPics[i][Enabled] = 0;
			     for(new k = 0; k < MAX_PLAYERS; k++)
					 if(isPlayerInCP[k] == i)
					 {
					     DisablePlayerCheckpoint(k);
					     isPlayerInCP[k] = -1;
					 }
			     /*
			     new tmp[256];
			     format(tmp, sizeof(tmp), "Remout Calling Delete CP. Parameters:\n CPname=%s\n", NAME);
	             print(tmp);*/
			 }
	}
}
public OnPlayerCommandText(playerid, cmdtext[])
{
    if(isTimerEnabled == 0)
	{
		 isTimerEnabled = 1;
		 SetTimer("Timer_UpdateCP", 2000, 1);
	}
	return 0;
}

public Timer_SetPlayerCheckpointEx(playerid, Float:X, Float:Y, Float:Z, Float:size)
{
    SetPlayerCheckpoint(playerid, X, Y, Z, size);
}
