/***************************************************************
 *  Copyright notice
 *
 *  (c) 2012 Alexey Atsyn <alexey.atsyn@i-tribe.de>
 *  All rights reserved
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
 
#include <a_samp>

#define PRESSED(%0) (((newkeys & (%0)) == (%0)) && ((oldkeys & (%0)) != (%0)))
#define RELEASED(%0) (((newkeys & (%0)) != (%0)) && ((oldkeys & (%0)) == (%0)))
#define INVALID_TANK_ID -1
#define DEFAULT_COLOR 0x00ff00ff
#define TEXT_DRAW_X 500.0
#define TEXT_DRAW_Y 100.0

forward OnPlayerUpdateEx();

enum eTanks
{
    modelid,
	Float:pos_x,
	Float:pos_y,
	Float:pos_z,
	Float:z_angle,
	tankId,
	driverId
};

new Tanks[][eTanks] = {
	{564,1529.3932,2854.3728,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.3932,2858.7728,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.3932,2849.3728,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.4678,2863.1904,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.0792,2867.6772,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.2622,2872.2107,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1522.6322,2879.1001,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1518.0280,2879.1797,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1513.7631,2879.0244,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1509.1581,2879.0920,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1504.8099,2878.9028,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1500.3846,2879.0242,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1495.8590,2879.1492,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1491.3911,2878.9771,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1486.9619,2879.0283,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1482.6857,2879.0007,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1478.0557,2879.1558,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1473.5273,2878.8899,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1469.1694,2878.8320,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1464.6866,2879.0518,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1460.2422,2878.9714,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1455.8513,2878.9995,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1451.4379,2879.1709,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1446.9805,2879.0723,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1442.4031,2879.0911,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1437.9766,2879.0886,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1433.4949,2879.0806,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1429.1157,2879.1416,11.1331,180.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1422.2821,2872.8909,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1421.9963,2868.7576,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1421.9508,2864.4150,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1422.0011,2860.2981,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1421.9917,2856.1045,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1422.3557,2851.8264,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1422.0736,2847.5159,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1421.8431,2843.0835,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1422.2369,2838.9246,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1421.8597,2834.7024,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1422.2986,2830.3572,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1422.1290,2826.1777,11.1331,270.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.9758,2845.1824,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.9102,2840.6592,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.1786,2836.2881,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.8413,2831.5664,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.2976,2827.2964,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.8719,2822.6968,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.1521,2818.1934,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.1056,2813.7107,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.4456,2809.2498,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.3163,2804.7048,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.9115,2800.2986,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.0135,2795.7471,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1530.0189,2791.3064,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID},
	{564,1529.5897,2786.9189,11.1331,90.0,INVALID_VEHICLE_ID,INVALID_PLAYER_ID}
};

enum ePlayers
{
	pObject,
	startTime,
	playerInTank,
	bool:playerInBattlefield,
	playerCount,
	Text:powerText,
	Float:shotPower,
	color,
	killer
};

new timer;
new defaulData[ePlayers] = {
	INVALID_OBJECT_ID,
	-1,
	INVALID_TANK_ID,
	false,
	0,
	Text:INVALID_TEXT_DRAW,
	0.0,
	DEFAULT_COLOR,
	INVALID_PLAYER_ID
};
new Players[MAX_PLAYERS][ePlayers];

public OnFilterScriptInit()
{
    print("______________________\n\
	Tanks battle loaded.\n\
	Developer: $tepashka (alexey.atsyn@i-tribe.de)\n\
	Version: 1.1\n\
    ______________________");
	for (new i; i < sizeof(Tanks); i++)
	{
		Tanks[i][tankId] = CreateVehicle(Tanks[i][modelid], Tanks[i][pos_x], Tanks[i][pos_y], Tanks[i][pos_z], Tanks[i][z_angle], -1, -1, 99999999999999999);
	}
	for (new playerid; playerid < MAX_PLAYERS; playerid++)
	{
		if (IsPlayerConnected(playerid)) SetDefaultValue(playerid);
	}
	timer = SetTimer("OnPlayerUpdateEx", 50, 1);
	return 1;
}

public OnFilterScriptExit()
{
	KillTimer(timer);
	for (new i; i < sizeof(Tanks); i++)
	{
	    if (Tanks[i][driverId] != INVALID_PLAYER_ID)
		{
			RemovePlayerFromVehicle(Tanks[i][driverId]);
		}
		DestroyVehicle(Tanks[i][tankId]);
	}
	return 1;
}

public OnPlayerConnect(playerid)
{
	SetDefaultValue(playerid);
	return 0;
}

public OnPlayerDisconnect(playerid, reason)
{
	SetDefaultValue(playerid);
	return 0;
}

public OnPlayerSpawn(playerid)
{
 	SetCameraBehindPlayer(playerid);
	SetDefaultValue(playerid);
	return 0;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	if (Players[playerid][playerInTank] != INVALID_TANK_ID)
	{
	
	    if (Players[playerid][killer] != INVALID_PLAYER_ID)
		{
	        if (Players[playerid][killer] == playerid) SetPlayerScore(playerid, GetPlayerScore(playerid)-1);
			else SetPlayerScore(Players[playerid][killer], GetPlayerScore(Players[playerid][killer])+1);
	    	Players[playerid][killer] = INVALID_PLAYER_ID;
	    }
	    
		SetDefaultValue(playerid);
		return 1;
	}
	return 0;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	if(newstate == PLAYER_STATE_DRIVER && Players[playerid][playerInTank] != INVALID_TANK_ID)
	{
	    GameTextForPlayer(playerid,"~y~EAE A OE O",2000,0);
	    Players[playerid][playerInBattlefield] = false;
	    new Float:x, Float:y, Float:z;
	    GetVehiclePos(GetPlayerVehicleID(playerid), x, y, z);
	    if (Players[playerid][pObject] == INVALID_OBJECT_ID)
		{
			Players[playerid][pObject] = CreatePlayerObject(playerid, 1318, x, y, floatadd(z, 0.1), 0.0, 90.0, 0.0, 100.0);
		}
	}
	return 0;
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{

	if (PRESSED(KEY_SECONDARY_ATTACK) && GetPlayerState(playerid) == PLAYER_STATE_ONFOOT)
	{
		new tank = GetTankNearPlayer(playerid);
		if (tank != INVALID_TANK_ID)
		{
			Players[playerid][playerInTank] = tank;
			Tanks[tank][driverId] = playerid;
			PutPlayerInVehicle(playerid, Tanks[tank][tankId], 0);
			return 1;
		}
	}
	
	if (Players[playerid][playerInTank] != INVALID_TANK_ID)
	{
	    if (PRESSED(KEY_SECONDARY_ATTACK))
		{
			SetDefaultValue(playerid);
			return 1;
	    }
	    
		if (Players[playerid][playerInBattlefield] == true)
		{
			if ((PRESSED(KEY_FIRE) || PRESSED(KEY_ACTION)) && floatcmp(Players[playerid][shotPower], 0.0) == 0)
			{
			    Players[playerid][shotPower] = 10.0;
			    Players[playerid][startTime] = tickcount();
				Players[playerid][color] = DEFAULT_COLOR;

                if (Players[playerid][powerText] == Text:INVALID_TEXT_DRAW)
				{
                	TextDrawHideForAll(Players[playerid][powerText]);
                    TextDrawDestroy(Players[playerid][powerText]);
                }
			    Players[playerid][powerText] = TextDrawCreate(TEXT_DRAW_X, TEXT_DRAW_Y, " ");
				TextDrawUseBox(Players[playerid][powerText], true);
				TextDrawBoxColor(Players[playerid][powerText], Players[playerid][color]);
				TextDrawSetShadow(Players[playerid][powerText],0);
				TextDrawTextSize(Players[playerid][powerText], floatadd(Players[playerid][shotPower], TEXT_DRAW_X),0.0);
				TextDrawShowForPlayer(playerid,Players[playerid][powerText]);

			}
			else if ((RELEASED(KEY_FIRE) || RELEASED(KEY_ACTION)) && floatcmp(Players[playerid][shotPower], 0.0) == 1)
			{
			    TextDrawHideForAll(Players[playerid][powerText]);
			    TextDrawDestroy(Players[playerid][powerText]);
			    Players[playerid][powerText] = Text:INVALID_TEXT_DRAW;
			    Players[playerid][startTime] = -1;
			    new Float:rot, Float:x, Float:y, Float:z, vehicleId = GetPlayerVehicleID(playerid);
			    GetVehiclePos(vehicleId, x, y, z);
			    GetVehicleZAngle(vehicleId, rot);

		        x = floatsub(x, floatmul(Players[playerid][shotPower], floatsin(rot, degrees)));
		        y = floatadd(y, floatmul(Players[playerid][shotPower], floatcos(rot, degrees)));
				z = floatadd(z, 0.1);
				Players[playerid][shotPower] = 0.0;
			    if ((1122.0 < x < 1418.0) && (2723.6 < y < 2860.0))
				{
				    for (new targetPlayer; targetPlayer < MAX_PLAYERS; targetPlayer++)
					{
						if(
							IsPlayerConnected(targetPlayer) &&
							Players[targetPlayer][playerInTank] != INVALID_TANK_ID &&
							Players[targetPlayer][playerInBattlefield] == true &&
							IsPlayerInRangeOfPoint(targetPlayer, 6.0, x, y, z)
						) Players[targetPlayer][killer] = playerid;
					}
				    CreateExplosion(x, y, z, 12, 6.0);
				}
			}
		}
	}
	return 0;
}

public OnPlayerUpdateEx()
{
    for (new playerid; playerid < MAX_PLAYERS; playerid++)
    {
	    if (Players[playerid][playerInTank] != INVALID_TANK_ID)
	    {
	    	new Float:x, Float:y, Float:z, curentTickcount = tickcount();
			GetVehiclePos(GetPlayerVehicleID(playerid), x, y, z);
			if (Players[playerid][playerInBattlefield] == true)
			{
			    new Float:hp;
				GetVehicleHealth(GetPlayerVehicleID(playerid), hp);
			    if ((1122.0 < x < 1418.0) && (2723.6 < y < 2860.0))
				{
			        Players[playerid][playerCount] = 0;
			        if (floatcmp(Players[playerid][shotPower], 0.0) == 1)
					{
			        	TextDrawHideForAll(Players[playerid][powerText]);
			            Players[playerid][shotPower] = floatadd(Players[playerid][shotPower], 2.0);
			            Players[playerid][startTime] = curentTickcount;
			            Players[playerid][color] += 0x04FB0000;//0x05000000 - 0x00050000 ;
			            TextDrawBoxColor(Players[playerid][powerText], Players[playerid][color]);
			            TextDrawTextSize(Players[playerid][powerText], floatadd(Players[playerid][shotPower], TEXT_DRAW_X),0.0);
						if (floatcmp(Players[playerid][shotPower], 100.0) == 1)
						{
							Players[playerid][shotPower] = 0.0;
							for (new targetPlayer; targetPlayer < MAX_PLAYERS; targetPlayer++)
							{
								if(
									IsPlayerConnected(targetPlayer) &&
									Players[targetPlayer][playerInTank] != INVALID_TANK_ID &&
									Players[targetPlayer][playerInBattlefield] == true &&
									IsPlayerInRangeOfPoint(targetPlayer, 6.0, x, y, z)
								) Players[targetPlayer][killer] = playerid;
							}
						    CreateExplosion(x, y, z, 12, 6.0);
						    SetPlayerPos(playerid, x, y, z);
							TextDrawDestroy(Players[playerid][powerText]);
							Players[playerid][powerText] = Text:INVALID_TEXT_DRAW;
					        Players[playerid][startTime] = -1;
					        Players[playerid][playerCount] = 0;
					        return 1;
						}
						else
						{
							TextDrawShowForPlayer(playerid,Players[playerid][powerText]);
						}
			        }
			    }
				else if(curentTickcount - Players[playerid][startTime] > 2000)//2 sec
				{
			        GameTextForPlayer(playerid, "~r~EP셏EC A OE O", 800, 4);
			        Players[playerid][startTime] = curentTickcount;
			        Players[playerid][playerCount] += 1;
			        if (Players[playerid][playerCount] > 0)
					{
			        	z = floatmul(floatdiv(hp, 10.0), float(Players[playerid][playerCount]));
						SetVehicleHealth(GetPlayerVehicleID(playerid), floatsub(hp, z));
			        }
			    }
			    SetPlayerHealth(playerid, floatdiv(hp, 10.0));
			}
			else
			{
			    if ((1122.0 < x < 1418.0) && (2723.6 < y < 2860.0))
				{
			    	DestroyPlayerObject(playerid,Players[playerid][pObject]);
			        Players[playerid][startTime] = -1;
			        Players[playerid][pObject] = INVALID_OBJECT_ID;
			        Players[playerid][playerCount] = 0;
			        Players[playerid][playerInBattlefield] = true;
			    }
				else
				{
			        new Float:rot = atan2(floatsub(x, 1415.1682), floatsub(y, 2808.2485));//center of battlefield
			       	if (floatcmp(rot, 0.0) != -1 &&  floatcmp(270.0, rot) == 1) rot = floatsub(360.0, rot);
					else if (floatcmp(0.0, rot) == 1) rot = floatmul(rot, -1.0);
					MovePlayerObject(
						playerid,
						Players[playerid][pObject],
						floatadd(x, floatmul(2.0, floatsin(rot, degrees))),
						floatsub(y, floatmul(2.0, floatcos(rot, degrees))),
						floatadd(z, 0.1),
						999999.0,
						0.0,
						90.0,
						floatadd(rot, 90.0)
					);
				}
			}
		}
	}
	return 1;
}

//MY FUNCTION
GetTankNearPlayer(playerid)
{
	for (new i, Float:position[3]; i < sizeof(Tanks); i++)
	{
	    if (Tanks[i][driverId] == INVALID_PLAYER_ID)
		{
	        GetVehiclePos(Tanks[i][tankId], position[0], position[1], position[2]);
	        if (IsPlayerInRangeOfPoint(playerid, 3.0, position[0], position[1], position[2])) return i;
        }
	}
	return INVALID_TANK_ID;
}

SetDefaultValue(playerid)
{
	new tank = Players[playerid][playerInTank];
	if (tank != INVALID_TANK_ID)
	{
		RemovePlayerFromVehicle(playerid);
		Tanks[tank][driverId] = INVALID_PLAYER_ID;
	    SetVehicleToRespawn(Tanks[tank][tankId]);
	}

	if (Players[playerid][powerText] != Text:INVALID_TEXT_DRAW)
	{
        TextDrawHideForAll(Players[playerid][powerText]);
		TextDrawDestroy(Players[playerid][powerText]);
	}
	if (Players[playerid][pObject] != INVALID_OBJECT_ID)
	{
		DestroyPlayerObject(playerid, Players[playerid][pObject]);
	}

	Players[playerid] = defaulData;
}
