/*

	: QuidemSys v2.3
	:
		     .       .
	
	: ZiGGi (ziggi.org, my@ziggi.org)
	: 2012-02-25
	
	: sa-mp server  0.3c  
	: Pawn 3.2.3664

*/

#define FILTERSCRIPT

#include <..\compiler\includes\a_samp>
#include "foreach"

#define TD_FONT		2 //  id   
#define FUEL_SPEED	2 //  ,   1 
#define FUEL_TARIF	1 //    ,  

#define MAX_STRING	128

#define COLOR_RED		0xAA3333AA
#define COLOR_GREEN		0x33AA33AA
#define COLOR_YELLOW	0xFFFF00AA

enum Fuel_Info {
	Float:Coord_X,
	Float:Coord_Y,
	Float:Coord_Z
}

new FuelStations[][Fuel_Info] = {
	{1595.5406, 2198.0520, 10.3863},
	{2202.0649, 2472.6697, 10.5677},
	{2115.1929, 919.9908, 10.5266},
	{2640.7209, 1105.9565, 10.5274},
	{608.5971, 1699.6238, 6.9922},
	{618.4878, 1684.5792, 6.9922},
	{2146.3467, 2748.2893, 10.5245},
	{-1679.4595, 412.5129, 6.9973},
	{-1327.5607, 2677.4316, 49.8093},
	{-1470.0050, 1863.2375, 32.3521},
	{-2409.2200, 976.2798, 45.2969},
	{-2244.1396, -2560.5833, 31.9219},
	{-1606.0544, -2714.3083, 48.5335},
	{1937.4293, -1773.1865, 13.3828},
	{-91.3854, -1169.9175, 2.4213},
	{1383.4221, 462.5385, 20.1506},
	{660.4590, -565.0394, 16.3359},
	{1381.7206, 459.1907, 20.3452},
	{-1605.7156, -2714.4573, 48.5335}
};

new FuelList[] = {
70,45,40,298,40,40,200,80,60,40,40,40,40,45,45,40,70,100,
45,40,40,40,45,45,20,200,40,70,70,40,45,60,90,100,35,0,
40,50,40,40,45,5,40,50,65,40,35,90,20,60,0,40,20,20,
20,60,50,20,40,45,90,30,20,35,5,5,40,40,20,90,90,20,
20,20,40,40,40,40,40,45,40,0,45,45,20,20,30,90,90,70,
70,40,40,20,40,45,40,90,50,50,40,5,40,40,40,50,40,40,
50,0,0,90,90,90,298,298,40,40,40,400,400,30,30,30,50,50,
40,40,50,40,20,20,60,40,40,40,40,50,50,20,40,40,40,50,
70,40,40,40,90,40,40,40,40,300,50,40,80,80,40,40,40,40,
40,90,90,40,45,45,20,0,50,10,20,50,20,40,40,300,50,50,
40,30,50,20,0,40,30,40,50,40,0,0,300,200,0,20,40,40,
40,50,40,60,40,40,40,45,0,0,0,50,0,0,
};

new Text:white[MAX_PLAYERS], Text:black[MAX_PLAYERS], Text:speedom[MAX_PLAYERS];
new Float:Fuel[MAX_VEHICLES], IsLocked[MAX_VEHICLES];
new fill_TimerID[MAX_PLAYERS] = {0,...}, SpeedTimer = 0;


public OnFilterScriptInit()
{
	ManualVehicleEngineAndLights();
	for (new i = 0; i < MAX_VEHICLES; i++)
	{
		Fuel[i] = 999;
	}
	foreach (Player, playerid)
	{
		create_TextDraws(playerid);
	}
	SpeedTimer = SetTimer("speed_Timer",500,1);
	print("QuidemSys v2.3 initialized.");
	return 1;
}

public OnFilterScriptExit()
{
	foreach (Player, playerid)
	{
		TextDrawHideForPlayer(playerid, black[playerid]);
		TextDrawHideForPlayer(playerid, white[playerid]);
		TextDrawHideForPlayer(playerid, speedom[playerid]);
		
		TextDrawDestroy(black[playerid]);
		TextDrawDestroy(white[playerid]);
		TextDrawDestroy(speedom[playerid]);
	}
	if (SpeedTimer != 0) KillTimer(SpeedTimer);
	return 1;
}

public OnVehicleSpawn(vehicleid)
{
	Fuel[vehicleid] = FuelList[vehicleid];
	return 1;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	new vehicleid = GetPlayerVehicleID(playerid);

	if (!strcmp(cmdtext, "/fill", true))
	{
		if (vehicleid == 0)
			return SendClientMessage(playerid,COLOR_RED,"    !");
		
		if (!IsPlayerAtFuelStation(playerid))
			return SendClientMessage(playerid,COLOR_RED,"   !");
		
		if (GetPVarInt(playerid,"Refueling"))
			return SendClientMessage(playerid,COLOR_RED,"   !");
		
		new vehiclemodel = GetVehicleModel(vehicleid);
		switch (vehiclemodel)
		{
			case 481,509,510:
			{
				return SendClientMessage(playerid,COLOR_YELLOW,":      .");
			}
		}
		
		if (Fuel[vehicleid] >= FuelList[vehiclemodel-400])
			return SendClientMessage(playerid,COLOR_YELLOW,".::    .");
		
		SetPVarFloat(playerid,"OldFuel",Fuel[vehicleid]);
		fill_TimerID[playerid] = SetTimerEx("fill_Timer", 1000, 1, "i", playerid);
		SetPVarInt(playerid,"Refueling",1);
		return 1;
	}
	
	if (!strcmp(cmdtext, "/lock", true))
	{
		if (vehicleid == 0)
			return SendClientMessage(playerid,COLOR_RED,"    !");
		
		switch (IsLocked[vehicleid])
		{
			case 0:
			{
				SendClientMessage(playerid,COLOR_RED," !");
				IsLocked[vehicleid] = 1;
			}
			case 1:
			{
				SendClientMessage(playerid,COLOR_GREEN," !");
				IsLocked[vehicleid] = 0;
			}
		}
		foreach (Player, i)
		{
			SetVehicleParamsForPlayer(vehicleid,i,0,IsLocked[vehicleid]);
		}
		SetVehicleParamsForPlayer(vehicleid,playerid,0,0);
		return PlayerPlaySound(playerid,1057,0.0,0.0,0.0);
	}
	
	if (!strcmp(cmdtext, "/engine", true))
	{
		if (vehicleid == 0)
			return SendClientMessage(playerid,COLOR_RED,"    !");
		
		if (Fuel[vehicleid] <= 0.1)
		{
			SendClientMessage(playerid, COLOR_YELLOW, "    .");
		}
		else
		{
			new engine, lights, alarm, doors, bonnet, boot, objective;
			GetVehicleParamsEx(vehicleid, engine, lights, alarm, doors, bonnet, boot, objective);
			SetVehicleParamsEx(vehicleid, VEHICLE_PARAMS_ON, lights, alarm, doors, bonnet, boot, objective);
		}
		return 1;
	}

	return 0;
}

forward fill_Timer(playerid);
public fill_Timer(playerid)
{
   	new vehicleid = GetPlayerVehicleID(playerid);
	
	Fuel[vehicleid] += FUEL_SPEED;
	if (vehicleid == 0 || !IsPlayerAtFuelStation(playerid) || Fuel[vehicleid] >= FuelList[ GetVehicleModel(vehicleid)-400 ])
	{
		new RefueledAmount = floatround( Fuel[vehicleid] - GetPVarFloat(playerid,"OldFuel") ) * FUEL_TARIF;
		GivePlayerMoney(playerid, -RefueledAmount);
		
		new string[MAX_STRING];
		format(string, sizeof(string), "     $%d.", RefueledAmount);
		SendClientMessage(playerid, COLOR_YELLOW, string);
		
		if (fill_TimerID[playerid] != 0) KillTimer(fill_TimerID[playerid]);
		SetPVarInt(playerid,"Refueling",0);
	}
	return 0;
}

forward speed_Timer();
public speed_Timer()
{
	new string[MAX_STRING], Float:health, vehicleid, vehiclemodel, locked[16], speed[16], speed_temp[5], speed_count=0;
	
	foreach (Player, playerid)
	{
		vehicleid = GetPlayerVehicleID(playerid);
		
		if (vehicleid == 0)
		{
			TextDrawHideForPlayer(playerid, black[playerid]);
			TextDrawHideForPlayer(playerid, white[playerid]);
			TextDrawHideForPlayer(playerid, speedom[playerid]);
			continue;
		}
		
		if (Fuel[vehicleid] <= 0.1)
		{
			new engine, lights, alarm, doors, bonnet, boot, objective;
			GetVehicleParamsEx(vehicleid, engine, lights, alarm, doors, bonnet, boot, objective);
			SetVehicleParamsEx(vehicleid, VEHICLE_PARAMS_OFF, lights, alarm, doors, bonnet, boot, objective);
			Fuel[vehicleid] = 0.0;
		}
		
		GetVehicleHealth(vehicleid, health);
		
		vehiclemodel = GetVehicleModel(vehicleid);
		if (Fuel[vehicleid] > FuelList[vehiclemodel-400])
		{
			Fuel[vehicleid] = FuelList[vehiclemodel-400];
		}
		
		locked[0] = '\0';
		switch (IsLocked[vehicleid])
		{
			case 0: strcat(locked,"~G~");
			case 1: strcat(locked,"~R~");
		}
		
		speed_count = GetVehicleSpeed(vehicleid);
		speed[0] = '\0';
		if (Fuel[vehicleid] == 0.0)
		{
			strcat(speed,"~W~");
		}
		else
		{
			switch (speed_count)
			{
				case 0:
				{
					strcat(speed,"~G~");
					Fuel[vehicleid] -= 0.0002;
				}
				case 1..60:
				{
					strcat(speed,"~G~");
					Fuel[vehicleid] -= 0.004;
				}
				case 61..90:
				{
					strcat(speed,"~Y~");
					Fuel[vehicleid] -= 0.008;
				}
				default:
				{
					strcat(speed,"~R~");
					Fuel[vehicleid] -= 0.012;
				}
			}
		}
		valstr(speed_temp, speed_count);
		strcat(speed, speed_temp);
		strcat(speed, "/");
		
		format(string,sizeof(string),
			"~B~: %s~N~~B~: ~W~%0.1f .~n~~B~: ~W~%0.0f%%~N~~B~: %s",
			speed, Fuel[vehicleid], health/10, locked
		);
		
		TextDrawSetString(speedom[playerid], rusText(string));
		TextDrawShowForPlayer(playerid, black[playerid]);
		TextDrawShowForPlayer(playerid, white[playerid]);
		TextDrawShowForPlayer(playerid, speedom[playerid]);
	}
	return 1;
}

public OnPlayerConnect(playerid)
{
	create_TextDraws(playerid);
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
	TextDrawDestroy(black[playerid]);
	TextDrawDestroy(white[playerid]);
	TextDrawDestroy(speedom[playerid]);
	return 1;
}

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	new vehicleid = GetPlayerVehicleID(playerid);
	
	switch ( GetVehicleModel(vehicleid) )
	{
		case 481,509,510: return 0;
	}
	
	if (newstate == PLAYER_STATE_DRIVER)
	{
		new engine, lights, alarm, doors, bonnet, boot, objective;
		GetVehicleParamsEx(vehicleid, engine, lights, alarm, doors, bonnet, boot, objective);
		if (Fuel[vehicleid] <= 0.1)
		{
			SetVehicleParamsEx(vehicleid, VEHICLE_PARAMS_OFF, lights, alarm, doors, bonnet, boot, objective);
			SendClientMessage(playerid, COLOR_YELLOW, "    .    (/engine).");
		}
		else
		{
			SetVehicleParamsEx(vehicleid, VEHICLE_PARAMS_ON, lights, alarm, doors, bonnet, boot, objective);
		}
		return 1;
	}
	if (oldstate == PLAYER_STATE_DRIVER)
	{
		TextDrawHideForPlayer(playerid, black[playerid]);
		TextDrawHideForPlayer(playerid, white[playerid]);
		TextDrawHideForPlayer(playerid, speedom[playerid]);
		return 1;
	}
	return 1;
}

stock IsPlayerAtFuelStation(playerid)
{
	for (new fuelid = 0; fuelid < sizeof(FuelStations); fuelid++)
	{
		if (IsPlayerInRangeOfPoint(playerid, 10, FuelStations[fuelid][Coord_X], FuelStations[fuelid][Coord_Y], FuelStations[fuelid][Coord_Z]))
		{
			return 1;
		}
	}
	return 0;
}

stock GetVehicleSpeed(vehicleid)
{
	new Float:pos[3];
	GetVehicleVelocity(vehicleid, pos[0], pos[1], pos[2]);
	return floatround( floatsqroot(pos[0]*pos[0] + pos[1]*pos[1] + pos[2]*pos[2]) * 100 );
}

stock create_TextDraws(playerid)
{
	black[playerid] = TextDrawCreate(494.000000, 379.000000, "_");
	TextDrawUseBox(black[playerid], 1);
	TextDrawBoxColor(black[playerid], 0x00000085);
	TextDrawTextSize(black[playerid], 626.000000, 0.000000);
	TextDrawAlignment(black[playerid], 0);
	TextDrawBackgroundColor(black[playerid], 0x000000FF);
	TextDrawFont(black[playerid], 2);
	TextDrawLetterSize(black[playerid], 1.700000, 3.940000);
	TextDrawColor(black[playerid], 0x000000FF);
	TextDrawSetOutline(black[playerid], 1);
	TextDrawSetProportional(black[playerid], 1);
	TextDrawSetShadow(black[playerid], 1);

	white[playerid] = TextDrawCreate(495.000000, 380.000000, "_");
	TextDrawUseBox(white[playerid], 1);
	TextDrawBoxColor(white[playerid], 0xAAAAAA77);
	TextDrawTextSize(white[playerid], 625.500000, 0.000000);
	TextDrawAlignment(white[playerid], 0);
	TextDrawBackgroundColor(white[playerid], 0x000000FF);
	TextDrawFont(white[playerid], 2);
	TextDrawLetterSize(white[playerid], 1.350000, 3.720000);
	TextDrawColor(white[playerid], 0xAAAAAA88);
	TextDrawSetOutline(white[playerid], 1);
	TextDrawSetProportional(white[playerid], 1);
	TextDrawSetShadow(white[playerid], 1);

	speedom[playerid] = TextDrawCreate(495.000000, 377.700000, "-");
	TextDrawAlignment(speedom[playerid], 0);
	TextDrawBackgroundColor(speedom[playerid], 0x000000FF);
	TextDrawFont(speedom[playerid], TD_FONT);
	TextDrawLetterSize(speedom[playerid], 0.299999, 1.000000);
	TextDrawColor(speedom[playerid], 0xFFFFFFFF);
	TextDrawSetOutline(speedom[playerid], 1);
	TextDrawSetProportional(speedom[playerid], 1);
	return 1;
}

stock rusText(string[]) // by Alex009
{
	new result[MAX_STRING];
	for (new i = 0; i < sizeof(result); i++)
	{
		switch (string[i])
		{
			case '': result[i] = 'a';
			case '': result[i] = 'A';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = 'e';
			case '': result[i] = 'E';
			case '': result[i] = 'e';
			case '': result[i] = 'E';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = 'k';
			case '': result[i] = 'K';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = 'M';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = 'o';
			case '': result[i] = 'O';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = 'p';
			case '': result[i] = 'P';
			case '': result[i] = 'c';
			case '': result[i] = 'C';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = 'y';
			case '': result[i] = 'Y';
			case '': result[i] = ' ';
			case '': result[i] = '';
			case '': result[i] = 'x';
			case '': result[i] = 'X';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			case '': result[i] = '';
			default: result[i] = string[i];
		}
	}
	return result;
}
