leadersTable = {}
playersInMission = 1

addEventHandler ( "onResourceStart", getResourceRootElement(),
	function ()
		local root = xmlLoadFile ("sat_records.xml")
		local recordsroot = xmlFindChild (root,"records",0)
		if (recordsroot) then
			for i,v in ipairs (xmlNodeGetChildren(recordsroot)) do
				local name = xmlNodeGetAttribute (v,"name")
				local killed = tonumber(xmlNodeGetAttribute (v,"killed"))
				local perc = tonumber(xmlNodeGetAttribute (v,"perc"))
				local tempTable = { name, killed, perc }
				table.insert(leadersTable, tempTable )
			end
			for i,v in ipairs(leadersTable) do
				outputDebugString ("Name " .. v[1])
			end
			local randMath = math.random ( 1, 10 )
			xmlUnloadFile ( root )
		end
		satMissionMarker = createMarker ( -329.852, 1536.53, 75.6317, "cylinder", 1.0, 255, 0, 0 )
		addEventHandler( "onMarkerHit", satMissionMarker, startSatMission )
		createBlip ( -329.852, 1536.53, 76.6117, 5, 2, 255, 0, 0, 255, 0, 200 )
		outputDebugString ( "Sattelite mission resource special for SAMP-RUS.com", 3 )
	end
)


function saveRecords ()
	local root = xmlLoadFile ("sat_records.xml")
	local recordsroot = xmlFindChild (root,"records",0)
	if (recordsroot) then
		for i,v in ipairs (xmlNodeGetChildren(recordsroot)) do
		  xmlNodeSetAttribute ( v, "name", leadersTable[i][1] )
		  xmlNodeSetAttribute ( v, "killed", tostring(leadersTable[i][2]) )
		  xmlNodeSetAttribute ( v, "perc", tostring(leadersTable[i][3]) )
		end
		xmlSaveFile(root)
		xmlUnloadFile ( root )
	end
end

function startSatMission ( hitElement, matchingDimension )
	if getElementType(hitElement) == "player" then
		if matchingDimension then
			triggerClientEvent ( hitElement, "showSatMenuStartS", hitElement, playersInMission )
			playersInMission = playersInMission + 1
			if playersInMission == 300 then
				playersInMission = 1
			end
		end
	end
end

function askLeadersTable ( askType, zKilled, zPerc )
	if askType == 0 then
		triggerClientEvent ( source, "showLeadersTableS", source, leadersTable )
	else
		local record = 0
		for i,v in ipairs(leadersTable) do
			if zKilled > v[2] then
				local tempTable = { getPlayerName ( source ), zKilled, zPerc }
				table.insert ( leadersTable, i, tempTable )
				table.remove ( leadersTable, 11 )
				record = 1
				saveRecords ()
				triggerClientEvent ( source, "sendLeadersTableS", source, i )
				break
			end
		end
		if record == 0 then
			triggerClientEvent ( source, "sendLeadersTableS", source, 0 )
		end
	end
end

addEvent( "askLeadersTableC", true )
addEventHandler( "askLeadersTableC", getRootElement(), askLeadersTable )
