//------------------------------------------------------------------------------
// xStreamer Core

#include <a_samp>
#include <xClient>
//------------------------------------------------------------------------------

#define STR 128

forward Timer();
forward Core_SetPlayerPos(playerid,Float:x,Float:y,Float:z);
forward Core_CreateObject(modelid2,Float:xf,Float:yf,Float:z,Float:rx,Float:ry,Float:rz,Float:viewdistobj);
forward Core_DestroyObject(objectid);
forward Core_SetTimerSpeed(speed);
forward Core_Online();
forward Core_CreateTeleport(name[],Float:x,Float:y,Float:z,Float:rot,inte,msg[]);
forward Core_DestroyTeleport(teleid);

//------------------------------------------------------------------------------

// these define the areas edges.

#if !defined AREA_X_START
#define AREA_X_START -2000.0
#endif

#if !defined AREA_Y_START
#define AREA_Y_START -2000.0
#endif

// defines the size of areas

#if !defined AREA_SIZE
#define AREA_SIZE 100
#endif

// these define how many areas there are

#if !defined AREAS_X
#define AREAS_X 40
#endif

#if !defined AREAS_Y
#define AREAS_Y 40
#endif

// defines how many objects can fit in 1 area

#if !defined MAX_AREA_OBJECTS
#define MAX_AREA_OBJECTS 100
#endif

// defines how many objects a player can see

#if !defined MAX_OBJECTS_VIEW
#define MAX_OBJECTS_VIEW 150
#endif

// how many objects can be streamed

#if !defined MAX_STREAMED_OBJECTS
#define MAX_STREAMED_OBJECTS 2000 // Plenty, imo
#endif

// defines how many teleport commands can be loaded

#if !defined MAX_TELEPORT_CMDS
#define MAX_TELEPORT_CMDS 100
#endif

// defines the teleports msg colour

#if !defined TELE_MSG_COLOUR
#define TELE_MSG_COLOUR 0x00CC66AA
#endif

//------------------------------------------------------------------------------

#define AREA_SIZE_MAX AREA_SIZE * 3
#define XMAX AREA_X_START + (AREAS_X * AREA_SIZE) - 1
#define YMAX AREA_Y_START + (AREAS_Y * AREA_SIZE) - 1

new Areas[AREAS_X][AREAS_Y][MAX_AREA_OBJECTS];
new AreaSize[AREAS_X][AREAS_Y];

//------------------------------------------------------------------------------

enum object_info
{
	modelid,
	Float:ox,
	Float:oy,
	Float:oz,
	Float:orx,
	Float:ory,
	Float:orz,
	Float:viewdist,
	bool:used
}

new Objects[MAX_STREAMED_OBJECTS][object_info],
	max_objs = 0;

enum player_info
{
	objlist[MAX_OBJECTS_VIEW],
	objliston,
	objids[MAX_OBJECTS_VIEW],
	Float:lastpos[3]
}
new Player[MAX_PLAYERS][player_info];

enum tele_info
{
	tname[STR],
	Float:tx,
	Float:ty,
	Float:tz,
	Float:trot,
	tint,
	tmsg[STR],
	bool:tused
}

new Teleports[MAX_TELEPORT_CMDS][tele_info],
	max_teles = 0;

//------------------------------------------------------------------------------

bool:IsInReach(Float:x,Float:y,Float:z,Float:x2,Float:y2,Float:z2,Float:dist)
{
	x = (x > x2) ? x - x2 : x2 - x;
	if(x > dist) return false;
	y = (y > y2) ? y - y2 : y2 - y;
	if(y > dist) return false;
	z = (z > z2) ? z - z2 : z2 - z;
	if(z > dist) return false;
	return true;
}

//------------------------------------------------------------------------------

new timer;

public OnFilterScriptInit()
{
	timer = SetTimer("Timer",500,1);
	
	print("************************************");
	print("* Loaded billiondollarisland by Hangover");
	print("* Using xCore by Boylett");
	print("************************************");

//cars
AddStaticVehicle(425,3730.7212,-2867.6428,19.8876,178.7788,43,0); //
AddStaticVehicle(445,3738.6975,-2857.3760,2.2358,4.9582,39,39); //
AddStaticVehicle(402,3722.5869,-2870.9729,2.1820,347.9372,13,13); //
AddStaticVehicle(411,3641.6038,-2868.2266,2.0775,359.2842,112,1); //
AddStaticVehicle(451,3645.0925,-2868.1956,2.0569,357.1864,125,125); //
AddStaticVehicle(506,3658.4646,-2867.3955,2.0547,268.5543,6,6); //
AddStaticVehicle(479,3698.5159,-2938.4983,2.1435,178.2247,59,36); //
AddStaticVehicle(458,3692.7549,-2938.4417,2.2287,178.3652,101,1); //
AddStaticVehicle(573,3689.3862,-2938.4736,3.0405,178.4318,115,43); //
AddStaticVehicle(431,3638.6836,-2957.7473,2.4560,91.6618,92,72); //
AddStaticVehicle(446,3661.5488,-2983.1018,-0.5744,76.4903,1,35); //
AddStaticVehicle(522,3641.7378,-2940.3630,1.9070,91.2846,3,8); //
AddStaticVehicle(586,3641.7190,-2937.7312,1.8703,90.3051,122,1); //
AddStaticVehicle(586,3641.5261,-2935.7966,1.8810,80.8709,122,1); //
AddStaticVehicle(468,3641.8892,-2933.4106,2.0187,96.5815,46,46); //
AddStaticVehicle(523,3641.7607,-2930.9053,1.9058,93.4336,0,0); //
AddStaticVehicle(521,3641.8057,-2928.7168,1.9124,156.5602,75,13); //
AddStaticVehicle(419,3679.6057,-2939.6626,2.1482,270.0804,47,76); //
AddStaticVehicle(457,3718.3330,-2921.2837,1.9509,154.8918,45,1); //
AddStaticVehicle(457,3716.4917,-2920.2053,1.9772,140.9300,13,1); //
AddStaticVehicle(463,3765.9998,-2960.1934,1.8903,237.0540,84,84); //
AddStaticVehicle(463,3768.3037,-2956.4695,1.8941,233.4185,84,84); //
//objs
CreateObject(3997, 3709.335693, -2914.645020, 1.350456, 0.0000, 0.0000, 0.0000);
CreateObject(4186, 3888.721680, -2909.798340, 8.354763, 0.0000, 0.8594, 261.2688);
CreateObject(744, 3719.806396, -2917.734375, 1.286328, 0.0000, 0.0000, 0.0000);
CreateObject(1234, 3722.013184, -2920.531738, 2.910136, 0.0000, 0.0000, 0.0000);
CreateObject(4888, 3712.222168, -2862.905518, 10.072842, 0.0000, 0.0000, 183.0600);
CreateObject(6283, 3681.569336, -2965.198730, 6.091390, 0.0000, 0.0000, 0.0000);
CreateObject(16106, 3766.088623, -2942.876465, 5.650649, 0.0000, 0.8594, 146.1044);
CreateObject(5743, 3821.187988, -2910.317383, -0.048515, 0.0000, 0.0000, 350.5462);
CreateObject(1675, 3796.246094, -2927.769043, 4.532824, 0.0000, 0.0000, 0.0000);
CreateObject(1675, 3802.577393, -2887.006348, 4.532824, 0.0000, 0.0000, 0.0000);
CreateObject(1675, 3850.630615, -2886.661865, 4.525356, 0.0000, 0.0000, 353.9839);
CreateObject(1675, 3847.868896, -2926.033936, 4.532824, 0.0000, 0.0000, 263.7431);
CreateObject(11111, 3616.191895, -2900.975586, 2.450462, 2.5783, 0.0000, 69.6143);
CreateObject(11111, 3560.195068, -2880.158936, 4.238499, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3485.606934, -2852.475098, 5.422601, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3512.977295, -2862.678467, 4.987540, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3458.773438, -2842.484619, 5.848997, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3434.283691, -2833.397949, 6.237716, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3414.212402, -2825.932617, 6.555832, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3338.847656, -2797.936523, 7.755287, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3366.131348, -2808.079590, 7.318961, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3312.797607, -2788.245850, 8.169100, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3285.263428, -2778.034180, 8.606506, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3259.202881, -2768.362305, 9.020370, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3232.496826, -2758.420166, 9.444723, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3206.105713, -2748.615967, 9.863924, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3183.740723, -2740.321045, 10.218627, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3156.172852, -2730.074951, 10.656687, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3129.949951, -2720.365967, 11.073027, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3103.229004, -2710.436279, 11.497521, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3077.531982, -2700.891357, 11.905611, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3050.769287, -2690.927490, 12.330874, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 3023.710449, -2680.934326, 12.760454, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2999.027100, -2671.777832, 13.152261, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2974.883301, -2662.827637, 13.535399, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2950.613770, -2653.787354, 13.920778, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2922.740234, -2643.452637, 14.363599, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2902.477295, -2635.921387, 14.686154, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2876.807617, -2626.362793, 15.093932, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2850.665039, -2616.648682, 15.509171, 0.8594, 0.0000, 69.6143);
CreateObject(11111, 2795.161865, -2595.970459, 15.515759, 359.1406, 0.0000, 69.6143);
CreateObject(11111, 2740.586670, -2577.887939, 14.626791, 359.1406, 0.0000, 73.9115);
CreateObject(11111, 2683.910400, -2561.524170, 12.880702, 357.4217, 0.0000, 73.9115);
CreateObject(1238, 2675.598877, -2564.539551, 12.955105, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2672.680908, -2561.856201, 12.949159, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2671.114014, -2559.452148, 12.924303, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2670.769043, -2555.624512, 12.919459, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2670.694336, -2550.905518, 12.913491, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2677.291992, -2565.901611, 13.064071, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2679.612061, -2567.714355, 13.187077, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2681.776367, -2569.093994, 13.297937, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2683.729492, -2570.104004, 13.395045, 0.0000, 0.0000, 0.0000);
CreateObject(1238, 2686.184570, -2572.037354, 13.506671, 0.0000, 0.0000, 0.0000);
CreateObject(1340, 3863.542236, -2941.900635, 2.417038, 0.0000, 0.0000, 79.0681);
CreateObject(1341, 3868.687744, -2942.389893, 2.296501, 0.0000, 0.0000, 0.0000);
CreateObject(1342, 3873.645996, -2942.049805, 2.343942, 0.0000, 0.0000, 96.2569);
CreateObject(1346, 3891.287354, -2940.564697, 2.723444, 0.0000, 0.0000, 242.2571);
CreateObject(1346, 3892.253174, -2938.946533, 2.749639, 0.0000, 28.3614, 243.1166);
CreateObject(6965, 3882.039063, -2907.566162, 5.759038, 0.0000, 0.0000, 0.0000);
CreateObject(7916, 3632.517334, -2931.605713, -1.949896, 0.0000, 5.1566, 260.3053);
CreateObject(1571, 3625.550781, -2911.380127, 3.301238, 0.0000, 358.2811, 161.5742);
CreateObject(1225, 3671.402832, -2862.814941, 2.075192, 0.0000, 0.0000, 0.0000);
CreateObject(1225, 3665.567139, -2862.107178, 2.075192, 0.0000, 0.0000, 0.0000);
CreateObject(1225, 3661.876953, -2861.875488, 2.075192, 0.0000, 0.0000, 0.0000);
CreateObject(3867, 3670.780273, -2882.326904, 16.156675, 0.0000, 0.0000, 0.0000);
CreateObject(2823, 3666.547363, -2950.107666, 1.353438, 0.0000, 0.0000, 0.0000);

return 1;
}

public OnFilterScriptExit()
{
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		for(new o = 0; o < Player[i][objliston]; o++)
		{
			DestroyPlayerObject(i,Player[i][objlist][o]);
		}
	}
}

//------------------------------------------------------------------------------

public OnPlayerConnect(playerid)
{
 	Player[playerid][objliston] = 0;
	Player[playerid][lastpos][0] = 0.0;
	Player[playerid][lastpos][1] = 0.0;
	Player[playerid][lastpos][2] = 0.0;
}

public OnPlayerDisconnect(playerid)
{
	for(new o = 0; o < Player[playerid][objliston]; o++)
	{
		DestroyPlayerObject(playerid,Player[playerid][objlist][o]);
	}
	Player[playerid][objliston] = 0;
}

//------------------------------------------------------------------------------

public Timer()
{
	for(new i = 0; i < MAX_PLAYERS; i++)
		if(IsPlayerConnected(i))
		{
		    new Float:pos[3];
			GetPlayerPos(i,pos[0],pos[1],pos[2]);
		    PlayerObjectUpdate(i,pos);
		}
	return 1;
}

PlayerObjectUpdate(playerid,Float:pos[3])
{
	new x, y,
		bool:viewing[sizeof(Objects)],
		viewids[sizeof(Objects)];
	
	if(!IsInReach(pos[0],pos[1],pos[2],Player[playerid][lastpos][0],Player[playerid][lastpos][1],Player[playerid][lastpos][2],AREA_SIZE_MAX))
	{
		for(new o = 0; o < Player[playerid][objliston]; o++)
		{
			DestroyPlayerObject(playerid,Player[playerid][objlist][o]);
		}
		Player[playerid][objliston] = 0;
	} else {
		for(new o = 0; o < Player[playerid][objliston]; o++)
		{
			viewids[Player[playerid][objlist][o]] = o;
			viewing[Player[playerid][objlist][o]] = true;
		}
	}
	
	Player[playerid][lastpos] = pos;

    for(new Float:a = AREA_X_START, d = 0; a <= XMAX; a += AREA_SIZE, d++)
    {
        if(pos[0] < a)
        {
            x = d - 1;
            break;
        }
	}

    for(new Float:a = AREA_Y_START, d = 0; a <= YMAX; a += AREA_SIZE, d++)
    {
        if(pos[1] < a)
        {
            y = d - 1;
            break;
        }
	}
	
	for(new maxx = x + 2, tmpx = x; tmpx <= maxx; tmpx++)
	{
	    for(new maxy = y + 2, tmpy = y; tmpy <= maxy; tmpy++)
	    {
			for(new i = 0; i < AreaSize[tmpx][tmpy]; i++)
			{
			    new objectid = Areas[tmpx][tmpy][i];
			    if(!viewing[objectid])
			    {
			        if(IsInReach(pos[0],pos[1],pos[2],Objects[objectid][ox],Objects[objectid][oy],Objects[objectid][oz],Objects[objectid][viewdist]))
			        {
			            if(Player[playerid][objliston] >= MAX_OBJECTS_VIEW)
			            {
			                printf("Player %d has exceeded the object limit. Put a smaller view distance on the objects surrounding this area: %f,%f,%f",playerid,pos[0],pos[1],pos[2]);
			            } else {
			            	viewids[objectid] = Player[playerid][objliston];
			            	viewing[objectid] = true;
			            	Player[playerid][objlist][Player[playerid][objliston]] = objectid;
			            	Player[playerid][objids][Player[playerid][objliston]] = CreatePlayerObject(playerid,Objects[objectid][modelid],Objects[objectid][ox],Objects[objectid][oy],Objects[objectid][oz],Objects[objectid][orx],Objects[objectid][ory],Objects[objectid][orz]);
			            	Player[playerid][objliston]++;
						}
			        }
			    } else if(!IsInReach(pos[0],pos[1],pos[2],Objects[objectid][ox],Objects[objectid][oy],Objects[objectid][oz],Objects[objectid][viewdist]))
			    {
			        Player[playerid][objliston]--;
		            DestroyPlayerObject(playerid,Player[playerid][objids][viewids[objectid]]);
		            Player[playerid][objlist][viewids[objectid]] = Player[playerid][objlist][Player[playerid][objliston]];
		            Player[playerid][objids][viewids[objectid]] = Player[playerid][objids][Player[playerid][objliston]];
		            viewids[Player[playerid][objlist][viewids[objectid]]] = viewids[objectid];
			        viewing[objectid] = false;
			    }
			}
	    }
	}
}

public Core_SetPlayerPos(playerid,Float:x,Float:y,Float:z)
{
	new Float:pos[3];
	pos[0] = x;
	pos[1] = y;
	pos[2] = z;
	PlayerObjectUpdate(playerid,pos);
	return SetPlayerPos(playerid,Float:x,Float:y,Float:z);
}

public OnPlayerSpawn(playerid)
{
    new Float:pos[3];
	GetPlayerPos(playerid,pos[0],pos[1],pos[2]);
    PlayerObjectUpdate(playerid,pos);
    return 1;
}

public Core_CreateObject(modelid2,Float:xf,Float:yf,Float:z,Float:rx,Float:ry,Float:rz,Float:viewdistobj)
{
	if(max_objs >= sizeof(Objects))
	{
	    print("xObjects Error: An object couldn't be created. Increase the MAX_STREAMED_OBJECTS define in the core and recompile");
	    return -1;
	}
	
	new thisobj;
	for(thisobj = 0; thisobj < sizeof(Objects); thisobj++)
	{
	    if(!Objects[thisobj][used])
	    {
			Objects[thisobj][modelid] = modelid2;
			Objects[thisobj][ox] = xf;
			Objects[thisobj][oy] = yf;
			Objects[thisobj][oz] = z;
			Objects[thisobj][orx] = rx;
			Objects[thisobj][ory] = ry;
			Objects[thisobj][orz] = rz;
			Objects[thisobj][viewdist] = viewdistobj;
			Objects[thisobj][used] = true;
			break;
	    }
	}
	
	max_objs++;

    new x, y;
    for(new Float:a = AREA_X_START, d = 0; a <= XMAX; a += AREA_SIZE, d++)
    {
        if(Objects[thisobj][ox] < a)
        {
            x = d;
            break;
        }
	}

    for(new Float:a = AREA_Y_START, d = 0; a <= YMAX; a += AREA_SIZE, d++)
    {
        if(Objects[thisobj][oy] < a)
        {
            y = d;
            break;
        }
	}
	if(AreaSize[x][y] >= MAX_AREA_OBJECTS)
	{
	    printf("xObjects Error: Object %d had to be missed because there wasnt enough room in its area. Increase the area limit",thisobj);
		return -1;
	} else {
		Areas[x][y][AreaSize[x][y]] = max_objs;
		AreaSize[x][y]++;
	}
	return thisobj;
}

public Core_DestroyObject(objectid)
{
	if(objectid >= sizeof(Objects))
	{
	    printf("xObjects error: Core_DestroyObject(%d) invalid objectid",objectid);
		return -1;
	}
	else if(!Objects[objectid][used])
	{
	    printf("xObjects error: Core_DestroyObject(%d) invalid objectid",objectid);
		return -1;
	}
	
    new x, y;
    for(new Float:a = AREA_X_START, d = 0; a <= XMAX; a += AREA_SIZE, d++)
    {
        if(Objects[objectid][ox] < a)
        {
            x = d;
            break;
        }
	}

    for(new Float:a = AREA_Y_START, d = 0; a <= YMAX; a += AREA_SIZE, d++)
    {
        if(Objects[objectid][oy] < a)
        {
            y = d;
            break;
        }
	}
	
	new last = AreaSize[x][y] - 1;
	for(new i = 0; i < AreaSize[x][y]; i++)
	{
	    if(Areas[x][y][i] == objectid)
	    {
	        if(i != last) Areas[x][y][i] = Areas[x][y][last];
	        AreaSize[x][y]--;
	        break;
	    }
	}
	
	Objects[objectid][used] = false;
	max_objs--;
	
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
	    if(IsPlayerConnected(i))
	    {
			for(new o = 0; o < Player[i][objliston]; o++)
			{
			    if(Player[i][objlist][o] == objectid)
			    {
			        Player[i][objliston]--;
		            DestroyPlayerObject(i,Player[i][objids][o]);
		            Player[i][objlist][o] = Player[i][objlist][Player[i][objliston]];
		            Player[i][objids][o] = Player[i][objids][Player[i][objliston]];
				}
			}
		}
	}
	return 1;
}

public Core_SetTimerSpeed(speed)
{
	KillTimer(timer);
	timer = SetTimer("Timer",speed,1);
	return 1;
}

public Core_Online() return 1;

public Core_CreateTeleport(name[],Float:x,Float:y,Float:z,Float:rot,inte,msg[])
{
	if(max_teles >= sizeof(Teleports))
	{
	    print("xTeleports Error: A teleport command couldn't be created. Increase the MAX_TELEPORT_CMDS define in the core and recompile");
	    return -1;
	}

	new thistele;
	for(thistele = 0; thistele < sizeof(Teleports); thistele++)
	{
	    if(!Teleports[thistele][tused])
	    {
	        for(new i = 0, l = strlen(name); i < l; i++) Teleports[thistele][tname][i] = name[i];
	        Teleports[thistele][tx] = x;
	        Teleports[thistele][ty] = y;
	        Teleports[thistele][tz] = z;
	        Teleports[thistele][trot] = rot;
	        Teleports[thistele][tint] = inte;
	        for(new i = 0, l = strlen(msg); i < l; i++) Teleports[thistele][tmsg][i] = msg[i];
	        Teleports[thistele][tused] = true;
			break;
	    }
	}

	max_teles++;

	return thistele;
}

public Core_DestroyTeleport(teleid)
{
	if(teleid >= sizeof(Teleports))
	{
	    printf("xTeleports error: Core_DestroyTeleport(%d) invalid teleportid",teleid);
		return -1;
	}
	else if(!Teleports[teleid][tused])
	{
	    printf("xTeleports error: Core_DestroyTeleport(%d) invalid teleportid",teleid);
		return -1;
	}
	Teleports[teleid][tused] = false;
	return 1;
}

public OnPlayerCommandText(playerid,cmdtext[])
{
	for(new i = 0; i < sizeof(Teleports); i++)
	{
	    if(Teleports[i][tused])
	    {
	        if(strcmp(Teleports[i][tname],cmdtext[1],true) == 0)
	        {
	            SetPlayerInterior(playerid,Teleports[i][tint]);
	            SetPlayerFacingAngle(playerid,Teleports[i][trot]);
	            Core_SetPlayerPos(playerid,Teleports[i][tx],Teleports[i][ty],Teleports[i][tz]);
		        SendClientMessage(playerid,TELE_MSG_COLOUR,Teleports[i][tmsg]);
		        return 1;
	        }
	    }

if (strcmp("/bdisland", cmdtext, true, 10) == 0)
{
    SetPlayerPos(playerid, 3728.460449, -2905.244629, 2.729117);
    return 1;
    }
	}
	return 0;
}
