local screenWidth,screenHeight = guiGetScreenSize()
local hudShowed = false

local weaponNames = {
	{"Кастет", 110},
	{"Клюшка", 110},
	{"Полцейская дубинка", 130},
	{"Нож", 110},
	{"Бита", 110},
	{"Лопата", 110},
	{"Кий", 110},
	{"Катана", 110},
	{"Бензопила", 130}, -- бок
	{"Дилдо", 110},
	{"Дилдо", 110},
	{"Вибратор", 130}, -- бок
	{"Вибратор", 130}, -- бок
	{"Цветы", 110},
	{"cane", 110},
	{"Граната", 110},
	{"tear gas", 110},
	{"Молотов", 110},
	{"", 110},
	{"", 110},
	{"", 110},
	{"Пистолет", 110},
	{"Бесшумный", 130}, -- бок
	{"Пустынный орел", 140}, -- бок
	{"Шотган", 110},
	{"дробовик", 110},
	{"Боевой шотган", 130}, -- бок
	{"UZI", 110},
	{"MP5", 110},
	{"AK-47", 110},
	{"M4", 110},
	{"TEC-9", 110},
	{"Винтовка", 110},
	{"Снайперка", 110},
	{"Рокет ланчер", 130}, -- бок
	{"RPG", 110},
	{"Огнемет", 110},
	{"minigun", 110},
	{"satchel", 110},
	{"", 110},
	{"Спрей", 110},
	{"Огнетушитель", 130}, -- бок
	{"Камера", 110},
}

local texture = dxCreateTexture ( "inter.dds", "dxt3" )

function findRotation(x1,y1,x2,y2)
 
  local t = -math.deg(math.atan2(x2-x1,y2-y1))
  if t < 0 then t = t + 360 end;
  return t;
 
end

function updateCamera ()
	local x, y, z, lx, ly, lz = getCameraMatrix()
	local rz = findRotation ( x, y, lx, ly )
	dxDrawImageSection ( 12, screenHeight-26, 168, 32, rz*(-2.84)-84, 20, 168, 32, texture )
	local health = getElementHealth ( localPlayer )
	local num = math.floor(health/7)
	local x = 12
	for i = 1, num do 
		dxDrawImageSection ( x, screenHeight-55, 16, 64, 355, 836, 16, 64, texture )
		x = x+10
	end
	dxDrawImageSection ( 0, screenHeight-64, 256, 64, 0, 126, 256, 64, texture )
	dxDrawImageSection ( screenWidth-256, screenHeight-64, 256, 64, 190, 130, 256, 64, texture )
	local ammo = getPedTotalAmmo ( localPlayer )
	local clip = getPedAmmoInClip ( localPlayer )
	local weapon = getPedWeapon ( localPlayer )
	local minutes, hours = getTime ()
	if minutes < 10 then minutes = "0"..tostring(minutes) end
	if hours < 10 then hours = "0"..tostring(hours) end
	if weapon == 0 then
		dxDrawText ( "Пусто", screenWidth-110, screenHeight - 55, screenWidth, screenHeight, tocolor ( 255, 255, 255, 255 ), 1.2, "default" )
	else
		dxDrawText ( weaponNames[weapon][1], screenWidth-weaponNames[weapon][2], screenHeight - 55, screenWidth, screenHeight, tocolor ( 255, 255, 255, 255 ), 1.2, "default" )
	end
	 dxDrawText ( clip.."/"..ammo-clip, screenWidth-70, screenHeight - 25, screenWidth, screenHeight, tocolor ( 255, 255, 255, 255 ), 1.2, "default" )
	 dxDrawText ( minutes..":"..hours, screenWidth-150, screenHeight - 25, screenWidth, screenHeight, tocolor ( 255, 255, 255, 255 ), 1.2, "default" )
end


function testHud ()
	if hudShowed then
		hudShowed = false
		removeEventHandler ( "onClientRender", root, updateCamera )
		showPlayerHudComponent ( "ammo", true )
		showPlayerHudComponent ( "health", true )
		showPlayerHudComponent ( "money", true )
		showPlayerHudComponent ( "weapon", true )
		showPlayerHudComponent ( "radar", true )
		showPlayerHudComponent ( "clock", true )
	else
		hudShowed = true
		addEventHandler ( "onClientRender", root, updateCamera )
		showPlayerHudComponent ( "clock", false )
		showPlayerHudComponent ( "ammo", false )
		showPlayerHudComponent ( "health", false )
		showPlayerHudComponent ( "money", false )
		showPlayerHudComponent ( "weapon", false )
		showPlayerHudComponent ( "radar", false )
	end
end

addCommandHandler ( "newhud", testHud )