/*//--------------------------------------------------------------------------//

                        "Test Your Server" Filterscript
                        Creators: LuxurY, Evgeniy
                        Version: 1.3
                        
                        
              										    (c) 2007 LDT
                                                        http://luxury.mybb.ru

//----------------------------------------------------------------------------*/
#pragma tabsize 0
#include <a_samp>

new version[] = "1.3 beta";

//max values
new MVC=700, MVM=70, MOC=250, MPC=400, MOP=200, MP=200, MTDC=1024, MGZC=1024, MMC=128;
//recommended values
new RVC=700, RVM=60, ROC=150, RPC=250, ROP=200, RP=200, RTDC=100, RGZC=100, RMC=50;

public OnFilterScriptInit() {
new warnings, errors;
new VehCount = VehicleCount();
new VehModel = VehicleModel();
new ObjCount = ObjectCount();
new PickCount = PickupCount();
new OnlPl = OnlinePlayers();
new MaxPl = GetMaxPlayers();
new TextDrCount = TextDrawCount();
new GZCount = GangZoneCount();
new MenCount = MenuCount();
print(" Test Your Server Filterscript loaded!");
printf(" Version: %s",version);
print(" Testing started...");
print(" ______________________________________________________");
print("| Title                  Count      Max    Recomended  |");
print("|______________________________________________________|");
printf(" Vehicles:              [%4d]    [%4d]    [%3d]",VehCount,MVC,RVC);
printf(" Types of vehicles:     [%4d]    [%4d]    [%3d]",VehModel,MVM,RVM);
printf(" Objects:               [%4d]    [%4d]    [%3d]",ObjCount,MOC,ROC);
printf(" Pickups:               [%4d]    [%4d]    [%3d]",PickCount,MPC,RPC);
printf(" Online players:        [%4d]    [%4d]    [%3d]",OnlPl,MOP,ROP);
printf(" Max players:           [%4d]    [%4d]    [%3d]",MaxPl,MP,RP);
printf(" TextDraw:              [%4d]    [%4d]    [%3d]",TextDrCount,MTDC,RTDC);
printf(" GangZone:              [%4d]    [%4d]    [%3d]",GZCount,MGZC,RGZC);
printf(" Menu:                  [%4d]    [%4d]    [%3d]",MenCount,MMC,RMC);
print(" ______________________________________________________\n");
print("              Errors and Warnings:");
print(" ______________________________________________________");
if (VehCount > MVC) {
errors++;
printf(" Error: Count of vehicles must be not more than %d",MVC); }
if (VehicleModel() > MVM) {
errors++;
printf(" Error: Count of types of vehicles must be not more than %d",MVM); }
else if (VehicleModel() > RVM) {
warnings++;
printf(" Warning: Recomended count of types of vehicles is %d",RVM); }
if (ObjectCount() > MOC) {
errors++;
printf(" Error: Count of objects must be not more than %d",MOC); }
else if (ObjectCount() > ROC) {
warnings++;
printf(" Warning: Recomended count of objects is %d",ROC); }
if (PickupCount() > MPC) {
errors++;
printf(" Error: Count of pickups must be not more than %d",MPC); }
else if (PickupCount() > RPC) {
warnings++;
printf(" Warning: Recomended count of pickups is %d",RPC); }
if (TextDrawCount() > MTDC) {
errors++;
printf(" Error: Count of TextDraw must be not more than %d",MTDC); }
else if (TextDrawCount() > RTDC) {
warnings++;
printf(" Warning: Recomended count of TextDraw is %d",RTDC); }
if (GangZoneCount() > MGZC) {
errors++;
printf(" Error: Count of GangZone must be not more than %d",MGZC); }
else if (GangZoneCount() > RGZC) {
warnings++;
printf(" Warning: Recomended count of GangZone is %d",RGZC); }
if (MenuCount() > MMC) {
errors++;
printf(" Error: Count of Menu must be not more than %d",MMC); }
else if (MenuCount() > RMC) {
warnings++;
printf(" Warning: Recomended count of Menu is %d",RMC); }
print(" ______________________________________________________");
printf("                          Errors: %d Warnings: %d \n",errors,warnings);
print(" The end of testing");
print(" ______________________________________________________");
return 1;
}

stock VehicleModel() {
new model[250], nummodel;
for (new i=1;i<VehicleCount()+1;i++) {
model[GetVehicleModel(i)-400]++;
}
for (new i=0;i<250;i++) {
if (model[i]!=0) {
nummodel++;
}}
return nummodel;
}

stock VehicleCount() {
new numcar=CreateVehicle(490,0,0,0,0,0,0,3000);
DestroyVehicle(numcar);
return numcar-1;
}

stock ObjectCount() {
new numo = CreateObject(1245,0,0,1000,0,0,0);
DestroyObject(numo);
return numo-1;
}

stock PickupCount() {
new nump = CreatePickup(371,2,0,0,1000);
DestroyPickup(nump);
return nump;
}

stock TextDrawCount() {
new Text:TT = TextDrawCreate(1,1,"Test");
TextDrawDestroy(TT);
return TT;
}

stock GangZoneCount() {
new cz = GangZoneCreate(3,3,5,5);
GangZoneDestroy(cz);
return cz;
}

stock MenuCount() {
new cm;
for (new menx=1;menx<128;menx++) {
if (IsValidMenu(menx)) {
cm++;
}}
return cm;
}

stock OnlinePlayers() {
new ol;
for(new i=0; i < MAX_PLAYERS; i++) {
if (IsPlayerConnected(i)) {
ol++;
}}
return ol;
}

