channelTable =
{
	["Bandit Rock"] = "http://mfile.akamai.com/90687/live/reflector:42231.asx?bkup=42233&prop=e",
	[1] = "Bandit Rock",
	
	["101.9FM Chicago - The Mix"] = "http://playerservices.streamtheworld.com/pls/WTMXFM.pls",
	[2] = "101.9FM Chicago - The Mix",
	
	["100.3FM Chicago - Rewind"] = "http://playerservices.streamtheworld.com/pls/WILVFM.pls",
	[3] = "100.3FM Chicago - Rewind",
	
	["97.1FM Chicago - The Drive"] = "http://playerservices.streamtheworld.com/pls/WDRVFM.pls",
	[4] = "97.1FM Chicago - The Drive",
	
	["97.1FM Chicago - Deep Tracks"] = "http://playerservices.streamtheworld.com/pls/WDRVFM2.pls",
	[5] = "97.1FM Chicago - Deep Tracks",
	
	["Classic Rock"] = "http://listen.rockradio.com/public3/classicrock.pls",
	[6] = "Classic Rock",
	
	["Classic Hard-Rock"] = "http://listen.rockradio.com/public3/classichardrock.pls",
	[7] = "Classic Hard-Rock",
	
	["80's Rock"] = "http://listen.rockradio.com/public3/80srock.pls",
	[8] = "80's Rock",
	
	["90's Rock"] = "http://listen.rockradio.com/public3/90srock.pls",
	[9] = "90's Rock",
	
	["Modern Rock"] = "http://listen.rockradio.com/public3/modernrock.pls",
	[10] = "Modern Rock",
	
	["Hard Rock"] = "http://listen.rockradio.com/public3/hardrock.pls",
	[11] = "Hard Rock", 
	
	["Rock Ballads"] = "http://listen.rockradio.com/public3/rockballads.pls",
	[12] = "Rock Ballads", 
	
	["Classic Metal"] = "http://listen.rockradio.com/public3/classicmetal.pls",
	[13] = "Classic Metal",

	["Metal"] = "http://listen.rockradio.com/public3/metal.pls",
	[14] = "Metal", 
	
	["Heavy Metal"] = "http://listen.rockradio.com/public3/heavymetal.pls",
	[15] = "Heavy Metal", 

	["Power Metal"] = "http://listen.rockradio.com/public3/powermetal.pls",
	[16] = "Power Metal", 
	
	["Symphonic Metal"] = "http://listen.rockradio.com/public3/symphonicmetal.pls",
	[17] = "Symphonic Metal", 
	
	["Thrash Metal"] = "http://listen.rockradio.com/public3/thrashmetal.pls",
	[18] = "Thrash Metal", 
	
	["VKNET Radio(Trance)"] = "http://radio2.vknet.se:7000/",
	[19] = "VKNET Radio(Trance)", 
	
	["Classic Eurodance"] = "http://listen.di.fm/public3/classiceurodance.pls?358b8a011c1e0cf5b9f695a7",
	[20] = "Classic Eurodance", 
	
	["Eurodance"] = "http://listen.di.fm/public3/eurodance.pls?358b8a011c1e0cf5b9f695a7",
	[21] = "Eurodance", 
	
	["Classic Trance"] = "http://listen.di.fm/public3/classictrance.pls?358b8a011c1e0cf5b9f695a7",
	[22] = "Classic Trance", 

	["Epic Trance"] = "http://listen.di.fm/public3/epictrance.pls?358b8a011c1e0cf5b9f695a7",
	[23] = "Epic Trance", 
	
	["Trance"] = "http://listen.di.fm/public3/trance.pls?358b8a011c1e0cf5b9f695a7",
	[24] = "Trance", 
	
	["Vocal Trance"] = "http://listen.di.fm/public3/vocaltrance.pls?358b8a011c1e0cf5b9f695a7",
	[25] = "Vocal Trance", 
	
	["Techno"] = "http://listen.di.fm/public3/techno.pls?358b8a011c1e0cf5b9f695a7",
	[26] = "Techno", 
	
	["House"] = "http://listen.di.fm/public3/house.pls?358b8a011c1e0cf5b9f695a7",
	[27] = "House", 
	
	["Disco House"] = "http://listen.di.fm/public3/discohouse.pls?358b8a011c1e0cf5b9f695a7",
	[28] = "Disco House", 

	["Dubstep"] = "http://listen.di.fm/public3/dubstep.pls?358b8a011c1e0cf5b9f695a7",
	[29] = "Dubstep", 
	
	["Club Sounds"] = "http://listen.di.fm/public3/club.pls?358b8a011c1e0cf5b9f695a7",
	[30] = "Club Sounds", 
	
	["UK Garage"] = "http://listen.di.fm/public3/ukgarage.pls?358b8a011c1e0cf5b9f695a7",
	[31] = "UK Garage", 
	
	["Space Dreams"] = "http://listen.di.fm/public3/spacemusic.pls?358b8a011c1e0cf5b9f695a7",
	[32] = "Space Dreams", 
	
	["Chiptunes"] = "http://listen.di.fm/public3/chiptunes.pls?358b8a011c1e0cf5b9f695a7",
	[33] = "Chiptunes",
	
	["Big Radio - Grunge FM"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=151082",
	[34] = "Big Radio - Grunge FM",
	
	["90's Alternative"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=1034265",
	[35] = "90's Alternative",
	
	["Classic Rock/Metal Mix"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=558051",
	[36] = "Classic Rock/Metal Mix",
	
	["80's Hairband"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=277192",
	[37] = "80's Hairband",
	
	["Hair Metal 101"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=104511",
	[38] = "Hair Metal 101",
	
	["Full Metal Circus"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=212303",
	[39] = "Full Metal Circus",
	
	["Radio Paralax"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=19665",
	[40] = "Radio Paralax",
	
	["Radio Nintendo"] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=1217932",
	[41] = "Radio Nintendo"
}

function math.round(number, decimals, method)
    decimals = decimals or 0
    local factor = 10 ^ decimals
    if (method == "ceil" or method == "floor") then return math[method](number * factor) / factor
    else return tonumber(("%."..decimals.."f"):format(number)) end
end

radioMainWindow = guiCreateWindow(535, 241, 508, 269, "[F*A*G] Radio", false)
	guiWindowSetSizable(radioMainWindow, false)
	guiSetVisible(radioMainWindow, false)

radioTabPanel = guiCreateTabPanel(9, 26, 490, 234, false, radioMainWindow)

radioMainTab = guiCreateTab("Main", radioTabPanel)

radioVisualizerPlaceholder = guiCreateGridList(5, 5, 480, 150, false, radioMainTab)

radioMetaArtistLabel = guiCreateLabel(9, 7, 466, 15, "Artist: ", false, radioVisualizerPlaceholder)
	guiSetFont(radioMetaArtistLabel, "default-bold-small")
	guiSetVisible(radioMetaArtistLabel, false)
radioMetaTitleLabel = guiCreateLabel(9, 27, 466, 15, "Title: ", false, radioVisualizerPlaceholder)
	guiSetFont(radioMetaTitleLabel, "default-bold-small")
	guiSetVisible(radioMetaTitleLabel, false)

radioPlayerPlayButton = guiCreateStaticImage(79, 160, 42, 42, "Img/PlayButton.png", false, radioMainTab)
radioPlayerStopButton = guiCreateStaticImage(79, 160, 42, 42, "Img/StopButton.png", false, radioMainTab)
	guiSetVisible(radioPlayerStopButton, false)
radioPlayerPrevButton = guiCreateStaticImage(42, 162, 32, 32, "Img/PreviousButton.png", false, radioMainTab)
radioPlayerNextButton = guiCreateStaticImage(126, 162, 32, 32, "Img/NextButton.png", false, radioMainTab)
radioHelpIcon = guiCreateStaticImage(5, 162, 32, 32, "Img/Info.png", false, radioMainTab)
radioPlayerVolume = guiCreateScrollBar(202, 184, 268, 15, true, false, radioMainTab)
	guiScrollBarSetScrollPosition(radioPlayerVolume, 30.0)  


radioLibraryTab = guiCreateTab("Library", radioTabPanel)
radioLibraryGridlist = guiCreateGridList(5, 6, 208, 199, false, radioLibraryTab)
	guiGridListSetSortingEnabled(radioLibraryGridlist, false)
guiGridListAddColumn(radioLibraryGridlist, "List of Radio Channels", 0.9)
	for key, value in ipairs(channelTable) do
		if (value) then
			guiGridListAddRow(radioLibraryGridlist)
		end
	end
		guiGridListSetItemText(radioLibraryGridlist, 0, 1, "Rock Channels", true, false)
		guiGridListSetItemColor(radioLibraryGridlist, 0, 1, 132, 31, 255)
			guiGridListSetItemText(radioLibraryGridlist, 1, 1, "Bandit Rock", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 2, 1, "97.1FM Chicago - Deep Tracks", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 3, 1, "Classic Rock", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 4, 1, "Classic Hard-Rock", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 5, 1, "80's Rock", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 6, 1, "90's Rock", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 7, 1, "Modern Rock", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 7, 1, "Hard Rock", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 7, 1, "Rock Ballads", false, false)
		guiGridListSetItemText(radioLibraryGridlist, 8, 1, "Metal Channels", true, false)
		guiGridListSetItemColor(radioLibraryGridlist, 8, 1, 132, 31, 255)
			guiGridListSetItemText(radioLibraryGridlist, 9, 1, "Classic Metal", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 10, 1, "Metal", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 11, 1, "Heavy Metal", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 12, 1, "Power Metal", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 13, 1, "Symphonic Metal", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 14, 1, "Thrash Metal", false, false)
		guiGridListSetItemText(radioLibraryGridlist, 15, 1, "Electronic Channels", true, false)
		guiGridListSetItemColor(radioLibraryGridlist, 15, 1, 132, 31, 255)
			guiGridListSetItemText(radioLibraryGridlist, 16, 1, "VKNet Radio(Trance)", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 17, 1, "Classic Eurodance", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 18, 1, "Eurodance", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 19, 1, "Classic Trance", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 20, 1, "Epic Trance", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 21, 1, "Trance", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 22, 1, "Vocal Trance", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 23, 1, "Techno", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 24, 1, "House", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 25, 1, "Dubstep", false, false)
		guiGridListSetItemText(radioLibraryGridlist, 26, 1, "Miscellaneous", true, false)
		guiGridListSetItemColor(radioLibraryGridlist, 26, 1, 132, 31, 255)
			guiGridListSetItemText(radioLibraryGridlist, 27, 1, "Club Sounds", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 28, 1, "UK Garage", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 29, 1, "Space Dreams", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 30, 1, "Chiptunes", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 31, 1, "Big Radio - Grunge FM", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 32, 1, "90's Alternative", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 33, 1, "Classic Rock/Metal Mix", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 34, 1, "80's Hairband", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 35, 1, "Hair Metal 101", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 36, 1, "Full Metal Circus", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 37, 1, "Radio Paralax", false, false)
			guiGridListSetItemText(radioLibraryGridlist, 38, 1, "Radio Nintendo", false, false)
	
radioLibrarySearchField = guiCreateEdit(221, 21, 259, 28, "Search for a Channel...", false, radioLibraryTab)
radioLibraryPlayButton = guiCreateButton(221, 54, 109, 27, "Play", false, radioLibraryTab)

radioSettingsTab = guiCreateTab("Settings", radioTabPanel)
radioSettingsLabel1 = guiCreateLabel(11, 6, 262, 18, "Visualize Type", false, radioSettingsTab)
	guiSetFont(radioSettingsLabel1, "default-bold-small")
	guiLabelSetColor(radioSettingsLabel1, 132, 31, 255)
radioVisOption1 = guiCreateRadioButton(16, 29, 173, 15, "Transparent Boxes", false, radioSettingsTab)
radioVisOption2 = guiCreateRadioButton(16, 49, 173, 15, "Chamfered Rectangle", false, radioSettingsTab)
radioVisOption3 = guiCreateRadioButton(16, 69, 173, 15, "Rounded Rectangle", false, radioSettingsTab)
radioVisOption4 = guiCreateRadioButton(16, 89, 173, 15, "Rectangles", false, radioSettingsTab)
radioVisOption5 = guiCreateRadioButton(16, 109, 173, 15, "Default Rectangles", false, radioSettingsTab)
	guiRadioButtonSetSelected(radioVisOption5, true)
radioStreamSettingsLabel = guiCreateLabel(212, 6, 97, 15, "Stream Settings", false, radioSettingsTab)
	guiSetFont(radioStreamSettingsLabel, "default-bold-small")
	guiLabelSetColor(radioStreamSettingsLabel, 132, 31, 255)
radioMuteOtherStreams = guiCreateCheckBox(218, 32, 132, 15, "Mute Other Streams", false, false, radioSettingsTab)
radioOutputMessage = guiCreateCheckBox(233, 54, 232, 15, "Output Message if a Sound is Stopped", false, false, radioSettingsTab)
radioRenderMetaInfo = guiCreateCheckBox(218, 74, 132, 15, "Render Meta Info", false, false, radioSettingsTab)
radioVisMetaInfo = guiCreateCheckBox(218, 94, 175, 15, "Show Meta Info in Visualizer", false, false, radioSettingsTab)
radioSetVolume = guiCreateCheckBox(218, 114, 232, 15, "Set Other Sounds to Same Volume", false, false, radioSettingsTab)
	
radioHelpWindow = guiCreateWindow(486, 224, 390, 381, "[F*A*G] Radio Information", false)
	guiWindowSetSizable(radioHelpWindow, false)
	guiSetVisible(radioHelpWindow, false)
radioHelpMemo = guiCreateMemo(9, 24, 372, 294, "Current Version: 2.3\n\n                                   Information:\n\nThis Radio was programmed by [F*A*G]Dealman, member of the \"Freaking Awesome Guys\" community with a lot of help by [F*A*G]Hex547. Its intention is to simply the broadcasting of internet radios inside Multi Theft Auto.\n\n                                   Disclaimer:\n\nThis resource is not to be re-distributed by anyone without written approval of either authors(Dealman, Hex547). You are free to modify the resource to your liking, and use it on your server without our consent.\n\n                                   Usage:\n\nKeybinds:\n  Left Shift + R = Toggles the Radio GUI on and off.\n  Left Shift + LeftArrow = Change to previous channel.\n  Left Shift + RightArrow = Change to next channel.\n  Left Shift + UpArrow = Play/Stop the radio.\n\nCommands:\n  /Radio = Toggles the Radio RGUI on and off.\n  /RadioHelp = Shows this help window.\n\n© FreakingAwesomeGuys 2013. All Rights Reserved.\nNo part of this code or any of its contents may be reproduced, copied, modified or adapted, without the prior written consent of the authors, unless otherwise indicated for stand-alone materials.", false, radioHelpWindow)
	guiMemoSetReadOnly(radioHelpMemo, true)
radioHelpCloseButton = guiCreateButton(125, 331, 127, 37, "Close", false, radioHelpWindow)

local PDZFont = dxCreateFont("Font/PDZ.ttf", 9)

local screenX, screenY = guiGetScreenSize()

local radioStream = nil
local isStreaming = false
local wasStopped = false
local muteOtherStreams = false

-- Radio Logic
local currentChannel = 1
local channelName = channelTable[1]
local radioVolume = (guiScrollBarGetScrollPosition(radioPlayerVolume)/100)
local roundedVolume = (math.round(radioVolume, 4)*100)
local themColours = {50,50,50}
local metaTable = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
local streamArtist = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
local streamTitle = "Not Applicable (Might still be downloading, or radio doesn't support this!)"

-- For Flashing Text
local flashRed, flashGreen, flashBlue = 172, 105, 255
local flashingPurple = tocolor(flashRed, flashGreen, flashBlue, 255)
local incrementQ = true

-- Settings, quite yes indeed
local imageOne = false
local imageTwo = false
local imageThree = false
local imageRect = true

-- For DX Positioning
local winX, winY = guiGetPosition(radioMainWindow, false)

function updateGUIPosition()
	if(source == radioMainWindow) then
		winX, winY = guiGetPosition(radioMainWindow, false)
	end
end
addEventHandler("onClientGUIMove", getRootElement(), updateGUIPosition)

function updateOnTabChange()
	if(source == radioLibraryTab) then
		removeEventHandler("onClientRender", getRootElement(), textToDraw)
	elseif(source == radioMainTab) then
		addEventHandler("onClientRender", getRootElement(), textToDraw)
	elseif(source == radioSettingsTab) then
		removeEventHandler("onClientRender", getRootElement(), textToDraw)
	end
end
addEventHandler("onClientGUITabSwitched", getRootElement(), updateOnTabChange)

function flashingPurpleColour()
	amount = (incrementQ and 1) or -1
	if(flashRed >= 200) and (flashGreen >= 133) then
		incrementQ = false
	elseif(flashRed <= 172) and (flashGreen <= 105) then
		incrementQ = true
	end
	flashRed = flashRed+amount
	flashGreen = flashGreen+amount
	flashingPurple = tocolor(flashRed, flashGreen, flashBlue, 255)
end
addEventHandler("onClientRender", getRootElement(), flashingPurpleColour)

function textToDraw()
	dxDrawText("Volume: "..tostring(roundedVolume).."/100", winX+290, winY+215, 948, 469, tocolor(132, 31, 255, 255), 1.00, PDZFont, "left", "top", false, false, true, true, false)
	dxDrawText("Current Channel:", winX+25, winY+180, 694, 438, tocolor(132, 31, 255, 255), 1.00, PDZFont, "left", "top", false, false, true, true, false)
	dxDrawText(channelTable[currentChannel], winX+200, winY+180, 973, 438, flashingPurple, 1.00, PDZFont, "left", "top", false, true, true, true, false)
	if(radioStream ~= nil) then
		--BPM = getSoundBPM(radioStream) or 200
		changeVariable = 2
		newRed = themColours[1]+(math.random(0,changeVariable)*((math.random(0,3)>1 and -1) or 1))
		newGreen = themColours[2]+(math.random(0,changeVariable)*((math.random(0,3)>1 and -1) or 1))
		newBlue = themColours[3]+(math.random(0,changeVariable)*((math.random(0,3)>1 and -1) or 1))
		themColours[1] = (newRed>100 and 100) or (newRed<0 and 0) or newRed
		themColours[2] = (newGreen>100 and 100) or (newGreen<0 and 0) or newGreen
		themColours[3] = (newBlue>100 and 100) or (newBlue<0 and 0) or newBlue
		colour = tocolor(themColours[1], themColours[2], themColours[3], 255)
		soundTable = getSoundFFTData(radioStream, 8192, 32)
		txWidth = 14
		if(not soundTable) then return false end
		for i,v in pairs(soundTable) do
			theHeight = math.round((v*320),0)>140 and 140 or math.round((v*320),0)
			if(guiRadioButtonGetSelected(radioVisOption1)) then
				dxDrawImage(winX+25+(i*txWidth), winY+170, txWidth-1, theHeight*-1, "Img/Test.png", 0, 0, 0, colour, true)
			elseif(guiRadioButtonGetSelected(radioVisOption2)) then
				dxDrawImage(winX+25+(i*txWidth), winY+170, txWidth-1, theHeight*-1, "Img/Test2.png", 0, 0, 0, colour, true)
			elseif(guiRadioButtonGetSelected(radioVisOption3)) then
				dxDrawImageSection(winX+25+(i*txWidth), winY+170, txWidth-1, theHeight*-1, 0, 0, 64, (320/100)*theHeight, "Img/Test3.png", 0, 0, 0, colour, true)
			elseif(guiRadioButtonGetSelected(radioVisOption4)) then
				dxDrawImageSection(winX+25+(i*txWidth), winY+170, txWidth-1, theHeight*-1, 0, 0, 64, (320/100)*theHeight, "Img/Test4.png", 0, 0, 0, colour, true)
			elseif(guiRadioButtonGetSelected(radioVisOption5)) then
				dxDrawRectangle(winX+25+(i*txWidth), winY+170, txWidth-1, theHeight*-1, colour, true)
			end
		end
	end
end

function checkAndUpdateStreamMeta()
	if(source == radioStream) and (radioStream ~= nil) then
		metaTable = getSoundMetaTags(radioStream)
		if(metaTable.artist ~= nil) and (metaTable.title ~= nil) then
			streamArtist = tostring(metaTable.stream_name)
			streamTitle = tostring(metaTable.stream_title)
			guiSetText(radioMetaArtistLabel, "Artist: "..streamArtist)
			guiSetText(radioMetaTitleLabel, "Title: "..streamTitle)
		elseif(metaTable.artist == nil) and (metaTable.title == nil) then
			streamArtist = tostring(metaTable.stream_name)
			streamTitle = tostring(metaTable.stream_title)
			guiSetText(radioMetaArtistLabel, "Artist: "..streamArtist)
			guiSetText(radioMetaTitleLabel, "Title: "..streamTitle)
		end
	end
end
addEventHandler("onClientSoundChangedMeta", getRootElement(), checkAndUpdateStreamMeta)

function directXStreamInformation()
	if(metaTable.artist ~= nil) and (metaTable.title ~= nil) then
		dxDrawText("Artist: "..streamArtist, screenX*0.6727941176470588, screenY*0.7799479166666667, screenX*0.9970588235294118, screenY*0.8515625, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6727941176470588, screenY*0.77734375, screenX*0.9970588235294118, screenY*0.8489583333333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6713235294117647, screenY*0.7799479166666667, screenX*0.9955882352941176, screenY*0.8515625, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6713235294117647, screenY*0.77734375, screenX*0.9955882352941176, screenY*0.8489583333333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6720588235294118, screenY*0.7786458333333333, screenX*0.9963235294117647, screenY*0.8502604166666667, flashingPurple, 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6727941176470588, screenY*0.8671875, screenX*0.9970588235294118, screenY*0.9388020833333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6727941176470588, screenY*0.8645833333333333, screenX*0.9970588235294118, screenY*0.9361979166666667, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6713235294117647, screenY*0.8671875, screenX*0.9955882352941176, screenY*0.9388020833333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6713235294117647, screenY*0.8645833333333333, screenX*0.9955882352941176, screenY*0.9361979166666667, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6720588235294118, screenY*0.8658854166666667, screenX*0.9963235294117647, screenY*0.9375, flashingPurple, 1.00, PDZFont, "left", "top", false, true, true, false, false)
	elseif(metaTable.artist == nil) and (metaTable.title == nil) then
		dxDrawText("Artist: "..streamArtist, screenX*0.6727941176470588, screenY*0.7799479166666667, screenX*0.9970588235294118, screenY*0.8515625, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6727941176470588, screenY*0.77734375, screenX*0.9970588235294118, screenY*0.8489583333333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6713235294117647, screenY*0.7799479166666667, screenX*0.9955882352941176, screenY*0.8515625, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6713235294117647, screenY*0.77734375, screenX*0.9955882352941176, screenY*0.8489583333333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: "..streamArtist, screenX*0.6720588235294118, screenY*0.7786458333333333, screenX*0.9963235294117647, screenY*0.8502604166666667, flashingPurple, 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6727941176470588, screenY*0.8671875, screenX*0.9970588235294118, screenY*0.9388020833333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6727941176470588, screenY*0.8645833333333333, screenX*0.9970588235294118, screenY*0.9361979166666667, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6713235294117647, screenY*0.8671875, screenX*0.9955882352941176, screenY*0.9388020833333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6713235294117647, screenY*0.8645833333333333, screenX*0.9955882352941176, screenY*0.9361979166666667, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: "..streamTitle, screenX*0.6720588235294118, screenY*0.8658854166666667, screenX*0.9963235294117647, screenY*0.9375, flashingPurple, 1.00, PDZFont, "left", "top", false, true, true, false, false)
	elseif(metaTable.stream_name == nil) and (metaTable.stream_title == nil) then
		dxDrawText("Artist: N/A"..streamArtist, screenX*0.6727941176470588, screenY*0.7799479166666667, screenX*0.9970588235294118, screenY*0.8515625, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: N/A"..streamArtist, screenX*0.6727941176470588, screenY*0.77734375, screenX*0.9970588235294118, screenY*0.8489583333333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: N/A"..streamArtist, screenX*0.6713235294117647, screenY*0.7799479166666667, screenX*0.9955882352941176, screenY*0.8515625, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: N/A"..streamArtist, screenX*0.6713235294117647, screenY*0.77734375, screenX*0.9955882352941176, screenY*0.8489583333333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Artist: N/A"..streamArtist, screenX*0.6720588235294118, screenY*0.7786458333333333, screenX*0.9963235294117647, screenY*0.8502604166666667, flashingPurple, 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: N/A"..streamTitle, screenX*0.6727941176470588, screenY*0.8671875, screenX*0.9970588235294118, screenY*0.9388020833333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: N/A"..streamTitle, screenX*0.6727941176470588, screenY*0.8645833333333333, screenX*0.9970588235294118, screenY*0.9361979166666667, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: N/A"..streamTitle, screenX*0.6713235294117647, screenY*0.8671875, screenX*0.9955882352941176, screenY*0.9388020833333333, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: N/A"..streamTitle, screenX*0.6713235294117647, screenY*0.8645833333333333, screenX*0.9955882352941176, screenY*0.9361979166666667, tocolor(0, 0, 0, 255), 1.00, PDZFont, "left", "top", false, true, true, false, false)
		dxDrawText("Title: N/A"..streamTitle, screenX*0.6720588235294118, screenY*0.8658854166666667, screenX*0.9963235294117647, screenY*0.9375, flashingPurple, 1.00, PDZFont, "left", "top", false, true, true, false, false)
	end
end

function handleDirectXStreamInfoRendering()
	if(source == radioRenderMetaInfo) then
		if(guiCheckBoxGetSelected(radioRenderMetaInfo) == true) then
			if(radioStream ~= nil) then
				addEventHandler("onClientRender", getRootElement(), directXStreamInformation)
			end
		elseif(guiCheckBoxGetSelected(radioRenderMetaInfo) == false) then
			removeEventHandler("onClientRender", getRootElement(), directXStreamInformation)
		end
	end
	
	if(source == radioVisMetaInfo) then
		if(guiCheckBoxGetSelected(radioVisMetaInfo) == true) then
			guiSetVisible(radioMetaArtistLabel, true)
			guiSetVisible(radioMetaTitleLabel, true)
		elseif(guiCheckBoxGetSelected(radioVisMetaInfo) == false) then
			guiSetVisible(radioMetaArtistLabel, false)
			guiSetVisible(radioMetaTitleLabel, false)
		end
	end
end
addEventHandler("onClientGUIClick", getRootElement(), handleDirectXStreamInfoRendering)

function toggleCursor()
	if(isCursorShowing()) then
		showCursor(false)
	else
		showCursor(true)
	end
end
bindKey("F3", "down", toggleCursor)

function onClientChangeStreamState_Handler()
	if(source == radioPlayerPlayButton) then
		if(radioStream == nil) then
			radioStream = playSound(channelTable[channelTable[currentChannel]])
			setSoundVolume(radioStream, radioVolume)
			guiSetVisible(radioPlayerPlayButton, false)
			guiSetVisible(radioPlayerStopButton, true)
			isMouseOverStop = true
		end
	end
	if(source == radioPlayerStopButton) then
		if(radioStream ~= nil) then
			stopSound(radioStream)
			radioStream = nil
			guiSetVisible(radioPlayerStopButton, false)
			guiSetVisible(radioPlayerPlayButton, true)
			guiSetText(radioMetaArtistLabel, "Artist: "..streamArtist)
			guiSetText(radioMetaTitleLabel, "Title: "..streamTitle)
		end
	end
end
addEventHandler("onClientGUIClick", getRootElement(), onClientChangeStreamState_Handler)

function onClientUseLibrary_Handler()
	if(source == radioLibraryPlayButton) then
	local selectedItem = guiGridListGetSelectedItem(radioLibraryGridlist)
		if(selectedItem ~= -1) then
		local itemText = guiGridListGetItemText(radioLibraryGridlist, selectedItem, 1)
			if(radioStream == nil) then
				for k,v in pairs(channelTable) do
					if(v == itemText) then
						currentChannel = k
						radioStream = playSound(channelTable[channelTable[currentChannel]])
						setSoundVolume(radioStream, radioVolume)
						guiSetVisible(radioPlayerPlayButton, false)
						guiSetVisible(radioPlayerStopButton, true)
					end
				end	
			elseif(radioStream ~= nil) then
				for k,v in pairs(channelTable) do
					if(v == itemText) then
						stopSound(radioStream)
						currentChannel = k
						radioStream = playSound(channelTable[channelTable[currentChannel]])
						setSoundVolume(radioStream, radioVolume)
						guiSetVisible(radioPlayerPlayButton, false)
						guiSetVisible(radioPlayerStopButton, true)
					end
				end
			end
		end
	end
end
addEventHandler("onClientGUIClick", getRootElement(), onClientUseLibrary_Handler)

function onClientUseSearch_Handler()
	guiGridListClear(radioLibraryGridlist)
	searchText = string.lower(guiGetText(radioLibrarySearchField))
	if(searchText == "") then
		for name, data in pairs(channelTable) do
		local newRow = guiGridListAddRow(radioLibraryGridlist)
			guiGridListSetItemText(radioLibraryGridlist, newRow, 1, name:gsub("123456789",""), false, false)
		end
	else
		for name, data in pairs(channelTable) do
			if(string.find(string.lower(name), searchText, 1, true)) then
			local newRow = guiGridListAddRow(radioLibraryGridlist)
				guiGridListSetItemText(radioLibraryGridlist, newRow, 1, name:gsub("123456789",""), false, false)
			end
		end
	end
end
addEventHandler("onClientGUIChanged", getRootElement(), onClientUseSearch_Handler)

function onClientChangeChannelNext_Handler()
	if((source == radioPlayerNextButton) and (radioStream == nil)) then
		currentChannel = ((currentChannel+1 <= #channelTable) == true and currentChannel+1) or 1
	elseif((source == radioPlayerNextButton) and (radioStream ~= nil)) then
		currentChannel = ((currentChannel+1 <= #channelTable) == true and currentChannel+1) or 1
		setTimer(function()
			stopSound(radioStream)
			radioStream = playSound(channelTable[channelTable[currentChannel]])
			streamArtist = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
			streamTitle = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
			guiSetText(radioMetaArtistLabel, "Artist: "..streamArtist)
			guiSetText(radioMetaTitleLabel, "Title: "..streamTitle)
			setSoundVolume(radioStream, radioVolume)
		end, 250, 1)
	end
end
addEventHandler("onClientGUIClick", getRootElement(), onClientChangeChannelNext_Handler)

function onClientChangeChannelPrev_Handler()
	if((source == radioPlayerPrevButton) and (radioStream == nil)) then
		currentChannel = ((currentChannel-1 >= 1) == true and currentChannel-1) or #channelTable
	elseif((source == radioPlayerPrevButton) and (radioStream ~= nil)) then
		currentChannel = ((currentChannel-1 >= 1) == true and currentChannel-1) or #channelTable
		setTimer(function()
			stopSound(radioStream)
			radioStream = playSound(channelTable[channelTable[currentChannel]])
			streamArtist = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
			streamTitle = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
			guiSetText(radioMetaArtistLabel, "Artist: "..streamArtist)
			guiSetText(radioMetaTitleLabel, "Title: "..streamTitle)
			setSoundVolume(radioStream, radioVolume)
		end, 250, 1)
	end
end
addEventHandler("onClientGUIClick", getRootElement(), onClientChangeChannelPrev_Handler)

function onClientChangeVolume_Handler()
	radioVolume = (guiScrollBarGetScrollPosition(radioPlayerVolume)/100)
	roundedVolume = (math.round(radioVolume, 4)*100)
	if(source == radioPlayerVolume) then
		if(radioStream ~= nil) then
			setSoundVolume(radioStream, radioVolume)
		end
	end
end
addEventHandler("onClientGUIScroll", getRootElement(), onClientChangeVolume_Handler)

function checkForKeybind(button)
	-- Show or Hide the Radio Player
	if((getKeyState("lshift") == true) and (getKeyState("r") == true)) and (isChatBoxInputActive() == false) and (isConsoleActive() == false) then
		setTimer(function()
			setRadioChannel(0)
		end, 50, 1)
		showGUI()	
	-- Next Channel
	elseif((getKeyState("lshift") == true) and (getKeyState("arrow_r") == true) and (isChatBoxInputActive() == false) and (isConsoleActive() == false)) then
		if(radioStream == nil) then
			currentChannel = ((currentChannel+1 <= #channelTable) == true and currentChannel+1) or 1
		elseif(radioStream ~= nil) then
			currentChannel = ((currentChannel+1 <= #channelTable) == true and currentChannel+1) or 1
			setTimer(function()
				stopSound(radioStream)
				radioStream = playSound(channelTable[channelTable[currentChannel]])
				streamArtist = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
				streamTitle = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
				guiSetText(radioMetaArtistLabel, "Artist: "..streamArtist)
				guiSetText(radioMetaTitleLabel, "Title: "..streamTitle)
				setSoundVolume(radioStream, radioVolume)
			end, 250, 1)
		end
	-- Previous Channel
	elseif((getKeyState("lshift") == true) and (getKeyState("arrow_l") == true) and (isChatBoxInputActive() == false) and (isConsoleActive() == false)) then
		if(radioStream == nil) then
			currentChannel = ((currentChannel-1 >= 1) == true and currentChannel-1) or #channelTable
		elseif(radioStream ~= nil) then
			currentChannel = ((currentChannel-1 >= 1) == true and currentChannel-1) or #channelTable
			setTimer(function()
				stopSound(radioStream)
				radioStream = playSound(channelTable[channelTable[currentChannel]])
				streamArtist = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
				streamTitle = "Not Applicable (Might still be downloading, or radio doesn't support this!)"
				guiSetText(radioMetaArtistLabel, "Artist: "..streamArtist)
				guiSetText(radioMetaTitleLabel, "Title: "..streamTitle)
				setSoundVolume(radioStream, radioVolume)
			end, 250, 1)
		end	
	-- Play or Stop the stream
	elseif((getKeyState("lshift") == true) and (getKeyState("arrow_u") == true) and (isChatBoxInputActive() == false) and (isConsoleActive() == false)) then
		if(radioStream == nil) then
			radioStream = playSound(channelTable[channelTable[currentChannel]])
			setSoundVolume(radioStream, radioVolume)
			guiSetVisible(radioPlayerPlayButton, false)
			guiSetVisible(radioPlayerStopButton, true)
		elseif(radioStream ~= nil) and (wasStopped == false) then
			stopSound(radioStream)
			radioStream = nil
			guiSetVisible(radioPlayerPlayButton, true)
			guiSetVisible(radioPlayerStopButton, false)
		end
	-- Increase the volume
	elseif((getKeyState("lshift") == true) and (button == "mouse_wheel_up") and (isChatBoxInputActive() == false) and (isConsoleActive() == false)) then
		if(radioStream == nil) then
			return
		elseif(radioStream ~= nil) then
			setTimer(function()
				setRadioChannel(0)
			end, 50, 1)
			radioVolume = radioVolume+0.1
			radioVolume = (tonumber(radioVolume) <= 0 and 0) or (tonumber(radioVolume) >= 1 and 1) or tonumber(radioVolume)
			setSoundVolume(radioStream, radioVolume)
			guiScrollBarSetScrollPosition(radioPlayerVolume, radioVolume*100)
			if(radioVolume >= 1) then
				radioVolume = 1
				outputChatBox("#696969[FAG-Radio]: #841FFFYou've reached maximum volume!", 255, 255, 255, true)
			end
		end
		-- Decrease the volume
	elseif((getKeyState("lshift") == true) and (button == "mouse_wheel_down") and (isChatBoxInputActive() == false) and (isConsoleActive() == false)) then
		if(radioStream == nil) then
			return
		elseif(radioStream ~= nil) then
			setTimer(function()
				setRadioChannel(0)
			end, 50, 1)
			radioVolume = radioVolume-0.1
			radioVolume = (tonumber(radioVolume) <= 0 and 0) or (tonumber(radioVolume) >= 1 and 1) or tonumber(radioVolume)
			setSoundVolume(radioStream, radioVolume)
			guiScrollBarSetScrollPosition(radioPlayerVolume, radioVolume*100)
			if(radioVolume <= 0) then
				radioVolume = 0
				outputChatBox("#696969[FAG-Radio]: #841FFFYou've muted the Radio!", 255, 255, 255, true)
			end
		end
	end
end
addEventHandler("onClientKey", getRootElement(), checkForKeybind)

function muteOtherStreams(success, length, streamName)
	if(guiCheckBoxGetSelected(radioMuteOtherStreams) == true) then
		if(source ~= nil) and (source ~= radioStream) then
			stopSound(source)
			if(guiCheckBoxGetSelected(radioOutputMessage) == true) then
				outputChatBox("#696969[FAG-Radio]: #841FFFAnother Stream was stopped!", 255, 255, 255, true)
			end
		end
	else
		if(source ~= nil) and (source ~= radioStream) then
			if(guiCheckBoxGetSelected(radioSetVolume) == true) then
				setSoundVolume(source, radioVolume)
			end
		end
	end
end
addEventHandler("onClientSoundStream", getRootElement(), muteOtherStreams)

function muteOtherStreamsOnSelected()
local soundList = getElementsByType("sound")
	if(source == radioMuteOtherStreams) then
		if(guiCheckBoxGetSelected(radioMuteOtherStreams) == true) then
			for key, value in pairs(soundList) do
				if(value ~= nil) and (value ~= radioStream) then
					outputChatBox("#696969[FAG-Radio]: #841FFFAnother Stream was stopped!", 255, 255, 255, true)
					stopSound(value)
				end
			end
		end
	end
end
addEventHandler("onClientGUIClick", getRootElement(), muteOtherStreamsOnSelected)

function showGUI()
	if(guiGetVisible(radioMainWindow) == false) then
		guiSetVisible(radioMainWindow, true)
		showCursor(true)
			if(guiGetSelectedTab(radioTabPanel) == radioMainTab) then
				addEventHandler("onClientRender", getRootElement(), textToDraw)
			end
	else
		guiSetVisible(radioMainWindow, false)
		removeEventHandler("onClientRender", getRootElement(), textToDraw)
		showCursor(false)
	end
end
addCommandHandler("radio", showGUI, false)

function helpGUILogic()
	if(source == radioHelpCloseButton) then
		guiSetVisible(radioHelpWindow, false)
	end
	if(source == radioHelpIcon) then
		guiSetVisible(radioHelpWindow, true)
		guiBringToFront(radioHelpWindow)
	end
end
addEventHandler("onClientGUIClick", getRootElement(), helpGUILogic)

function showHelpGUI()
	if(guiGetVisible(radioHelpWindow) == false) then
		guiSetVisible(radioHelpWindow, true)
		showCursor(true)
	else
		guiSetVisible(radioHelpWindow, false)
	end
end
addCommandHandler("radiohelp", showHelpGUI, false)

function resourceStartedNotification()
	outputChatBox("#696969[FAG Radio]:#841FFF Resource started! Press Left Shift+R to toggle the GUI!", 255, 255, 255, true)
	outputChatBox("#696969[FAG Radio]:#841FFF Type /RadioHelp for information on how to use the Radio!", 255, 255, 255, true)
end
addEventHandler("onClientResourceStart", getResourceRootElement(getThisResource()), resourceStartedNotification)

addEventHandler("onClientResourceStart",getResourceRootElement(getThisResource()),function()
	guiSetInputMode("no_binds_when_editing")
end)