// MTA pickups

#include <a_samp>

#define MAX_MTA_PICKUPS 50
enum 
{
	PICKTYPE_REPAIR,
	PICKTYPE_CHANGECOLOR,
	PICKTYPE_CHANGEMODEL,
	PICKTYPE_BOOM
}


forward t_CreateMTApickup( pickmodel, Float:x, Float: y, Float: z, virtualworld, tcolor, newcar, pcolor1, pcolor2 );
forward t_isMTApickupValid( pickupid );
forward t_destroyAllMTAPickup();
forward t_destroyMTAPickup( pickupid );
forward t_updateMTApickup( pickupid, tcolor, newcar, vcolor1, vcolor2 );
forward updatePickup( pickupid );

new VehicleNameS[][] = {
	"Landstalker","Bravura","Buffalo","Linerunner","Pereniel","Sentinel","Dumper",
	"Firetruck","Trashmaster","Stretch","Manana","Infernus","Voodoo","Pony","Mule",
	"Cheetah","Ambulance","Leviathan","Moonbeam","Esperanto","Taxi","Washington",
	"Bobcat","Mr Whoopee","BF Injection","Hunter","Premier","Enforcer","Securicar",
	"Banshee","Predator","Bus","Rhino","Barracks","Hotknife","Trailer","Previon",
	"Coach","Cabbie","Stallion","Rumpo","RC Bandit","Romero","Packer","Monster Truck",
	"Admiral","Squalo","Seasparrow","Pizzaboy","Tram","Trailer","Turismo","Speeder",
	"Reefer","Tropic","Flatbed","Yankee","Caddy","Solair","Berkley's RC Van","Skimmer",
	"PCJ-600","Faggio","Freeway","RC Baron","RC Raider","Glendale","Oceanic","Sanchez",
	"Sparrow","Patriot","Quad","Coastguard","Dinghy","Hermes","Sabre","Rustler",
	"ZR-350","Walton","Regina","Comet","BMX","Burrito","Camper","Marquis","Baggage",
	"Dozer","Maverick","News Chopper","Rancher","FBI Rancher","Virgo","Greenwood",
	"Jetmax","Hotring","Sandking","Blista Compact","Police Maverick","Boxville",
	"Benson","Mesa","RC Goblin","Hotring Racer","Hotring Racer","Bloodring Banger",
	"Rancher","Super GT","Elegant","Journey","Bike","Mountain Bike","Beagle","Cropdust",
	"Stunt","Tanker","RoadTrain","Nebula","Majestic","Buccaneer","Shamal","Hydra",
	"FCR-900","NRG-500","HPV1000","Cement Truck","Tow Truck","Fortune","Cadrona",
	"FBI Truck","Willard","Forklift","Tractor","Combine","Feltzer","Remington",
	"Slamvan","Blade","Freight","Streak","Vortex","Vincent","Bullet","Clover",
	"Sadler","Firetruck","Hustler","Intruder","Primo","Cargobob","Tampa","Sunrise",
	"Merit","Utility","Nevada","Yosemite","Windsor","Monster Truck","Monster Truck",
	"Uranus","Jester","Sultan","Stratum","Elegy","Raindance","RC Tiger","Flash",
	"Tahoma","Savanna","Bandito","Freight","Trailer","Kart","Mower","Duneride",
	"Sweeper","Broadway","Tornado","AT-400","DFT-30","Huntley","Stafford","BF-400",
	"Newsvan","Tug","Trailer","Emperor","Wayfarer","Euros","Hotdog","Club","Trailer",
	"Trailer","Andromada","Dodo","RC Cam","Launch","Police (LSPD)","Police (SFPD)",
	"Police (LVPD)","Police Ranger","Picador","S.W.A.T. Van","Alpha","Phoenix",
	"Glendale","Sadler","Luggage Trailer","Luggage Trailer","Stair Trailer",
	"Boxville", "Farm Plow","Utility Trailer"
};

enum pinfo
{
	pid,
	pctype,
	pmodel,
	Text3D:tid,
	Float:posx,
	Float:posy,
	Float:posz,
	valid,
	pvrtual,
	pnewcar,
	color1,
	color2
};

new pickupInfo[ MAX_MTA_PICKUPS ][ pinfo ];
new pickup;

public OnFilterScriptInit()
{
	print( "\n------------------------------------------------------------------" );
	print( "    a.k.a MTA v 0.2.1 by Dima-kun(Morino_Reigan)" );
	print( "            CopyRight  SAMP-RUS TEAM 2013 " );
	print( "-------------------------------------------------------------------\n" );
}

public OnFilterScriptExit()
{
	for( new i = 0; i < MAX_MTA_PICKUPS; i++ )
	{
	    if( pickupInfo[ i ][ valid ] == 1 )
	    {
	    	DestroyPickup( pickupInfo[ i ][ pid ] );
	    	pickupInfo[ i ][ valid ] = 0;
		}
	}
	return 1;
}

public OnPlayerConnect(playerid)
{
	SendClientMessage( playerid, 0xffffffff, "  www.samp-rus.com   GTA-MP  GTA IV" );
	return 1;
}

public t_CreateMTApickup( pickmodel, Float: x, Float: y, Float: z, virtualworld, tcolor, newcar, pcolor1, pcolor2 )
{
	if( pickup > MAX_MTA_PICKUPS ) return print( "MTA_Pickups Error: Too many pickups!" );
	switch( newcar )
	{
		case 0:
		{
			pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
			CallRemoteFunction( "onMTApickupCreate", "ii", pickup, PICKTYPE_REPAIR );
			pickupInfo[ pickup ][ tid ] = Create3DTextLabel( "Repair Car", tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_REPAIR;
			pickupInfo[ pickup ][ valid ] = 1;
		}
		case 1:
		{
			pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
			CallRemoteFunction( "onMTApickupCreate", "ii", pickup, PICKTYPE_CHANGECOLOR );
			pickupInfo[ pickup ][ tid ] = Create3DTextLabel( "Change color", tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_CHANGECOLOR;
			pickupInfo[ pickup ][ valid ] = 1;
			pickupInfo[ pickup ][ color1 ] = pcolor1;
			pickupInfo[ pickup ][ color2 ] = pcolor2;
		}
		case 2:
		{
			pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
			CallRemoteFunction( "onMTApickupCreate", "ii", pickup, PICKTYPE_BOOM );
			pickupInfo[ pickup ][ tid ] = Create3DTextLabel( "Boom", tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_BOOM;
			pickupInfo[ pickup ][ valid ] = 1;
		}
		default:
		{
		    pickupInfo[ pickup ][ pid ] = CreatePickup( pickmodel, 14, x, y, z, virtualworld );
		    pickupInfo[ pickup ][ tid ] = Create3DTextLabel( VehicleNameS[ newcar  - 400 ], tcolor, x, y, z + 0.7, 50.0, virtualworld, 1 );
			pickupInfo[ pickup ][ pctype ] = PICKTYPE_CHANGEMODEL;
			CallRemoteFunction( "onMTApickupCreate", "ii", pickup, PICKTYPE_CHANGEMODEL );
			pickupInfo[ pickup ][ valid ] = 1;
			pickupInfo[ pickup ][ pnewcar ] = newcar;
			pickupInfo[ pickup ][ color1 ] = pcolor1;
			pickupInfo[ pickup ][ color2 ] = pcolor2;
		}
	}
	pickupInfo[ pickup ][ posx ] = x;
	pickupInfo[ pickup ][ posy ] = y;
	pickupInfo[ pickup ][ posz ] = z;
	pickupInfo[ pickup ][ pmodel ] = pickmodel;
	pickupInfo[ pickup ][ pvrtual ] = virtualworld;
	pickup++;
	return pickup - 1;
}

public t_destroyMTAPickup( pickupid )
{
		if( pickupInfo[ pickupid ][ valid ] == 1 )
	    {
	    	DestroyPickup( pickupInfo[ pickupid ][ pid ] );
	    	pickupInfo[ pickupid ][ valid ] = 0;
	    	return 1;
		}
		return 0;
}

public t_destroyAllMTAPickup()
{
    for(new i = 0; i <= pickup; i++ )
	{
	    if( pickupInfo[ i ][ valid ] == 1 )
	    {
	    	DestroyPickup( pickupInfo[ i ][ pid ] );
	    	pickupInfo[ i ][ valid ] = 0;
		}
	}
	return 1;
}
public OnPlayerPickUpPickup( playerid, pickupid )
{
    for( new j = 0; j <= pickup; j++ )
	{
		if( pickupid == pickupInfo[ j ][ pid ] && pickupInfo[ j ][ valid ] == 1 )
		{
  			if( IsPlayerInAnyVehicle( playerid ) )
			{
     			new vehicleid = GetPlayerVehicleID( playerid );
       			switch( pickupInfo[ j ][ pctype ] )
    	    	{
					case PICKTYPE_REPAIR:
					{
						RepairVehicle( vehicleid );
						SetTimerEx( "updatePickup", 3000, false, "i", j );
						CallRemoteFunction( "onVehicleRepair", "iii", playerid, vehicleid, pickupInfo[ j ][ pid ] );
						return 1;
					}
					case PICKTYPE_CHANGECOLOR:
					{
					 	SetTimerEx( "updatePickup", 3000, false, "i", j );
						ChangeVehicleColor( vehicleid, pickupInfo[ j ][ color1 ], pickupInfo[ j ][ color2 ] );
						CallRemoteFunction( "onVehicleChangecolour", "iiiii", playerid, vehicleid, pickupInfo[ j ][ pid ], pickupInfo[ j ][ color1 ], pickupInfo[ j ][ color2 ] );
						return 1;
					}
					case PICKTYPE_BOOM:
					{
						SetTimerEx( "updatePickup", 3000, false, "i", j );
						new Float: pos [ 3 ];
						GetVehiclePos( vehicleid, pos[ 0 ], pos[ 1 ], pos[ 2 ] );
						CreateExplosion( pos[ 0 ], pos[ 1 ], pos[ 2 ], 5, 20.0 );
						CallRemoteFunction( "onVehicleBoom", "iii", playerid, vehicleid, pickupid );
						return 1;
					}
					default:
					{
						new oldmodel = GetVehicleModel( vehicleid );
						SetTimerEx( "updatePickup", 3000, false, "i", j );
						new Float:x,
							Float:y,
							Float:z,
							Float: fa,
							vehid;
       					GetVehicleZAngle( vehicleid, fa );
       					GetVehiclePos( vehicleid, x, y, z );
       					new string[ 128 ];
       					format( string, sizeof( string ), "ID: %i Rotation: %.3f", vehicleid, fa );
       					SendClientMessage( playerid, 0xffffffff, string );
       					DestroyVehicle( vehicleid );
					  	vehid = CreateVehicle( pickupInfo[ j ][ pnewcar ], x, y, z, fa, pickupInfo[ j ][ color1 ], pickupInfo[ j ][ color2 ], 100000 );
						PutPlayerInVehicle( playerid, vehid, 0 );
						CallRemoteFunction( "onVehicleChangeModel", "iiii", playerid, vehid, pickupInfo[ j ][ pnewcar ], oldmodel );
						return 1;
			    	}
		    	}
   			}
     	}
	}
	return 1;
}

public updatePickup( pickupid )
{
	DestroyPickup( pickupInfo[ pickupid ][ pid ] );
	pickupInfo[ pickupid ][ valid ] = 1;
	pickupInfo[ pickupid ][ pid ] = CreatePickup( pickupInfo[ pickupid ][ pmodel ], 14, pickupInfo[ pickupid ][ posx ], pickupInfo[ pickupid ][ posy ], pickupInfo[ pickupid ][ posz ], pickupInfo[ pickupid ][ pvrtual ] );
	return 1;
}

public t_isMTApickupValid( pickupid )
	return pickupInfo[ pickupid ][ valid ];


public t_updateMTApickup( pickupid, tcolor, newcar, vcolor1, vcolor2 )
{
    if( pickupInfo[ pickupid ][ valid ] == 1 )
	{
		if( newcar == 0 )
		{
			pickupInfo[ pickupid ][ pctype ] = PICKTYPE_REPAIR;
			pickupInfo[ pickupid ][ valid ] = 1;
		}
		else if( newcar == 1 )
		{
			pickupInfo[ pickupid ][ pctype ] = PICKTYPE_CHANGECOLOR;
			pickupInfo[ pickupid ][ valid ] = 1;
			pickupInfo[ pickupid ][ color1 ] = vcolor1;
			pickupInfo[ pickupid ][ color2 ] = vcolor2;
		}
		else
		{
			pickupInfo[ pickupid ][ pctype ] = PICKTYPE_CHANGEMODEL;
			pickupInfo[ pickupid ][ valid ] = 1;
			pickupInfo[ pickupid ][ pnewcar ] = newcar;
		}
	}
	printf( "MTA-pickup: ID:%i update", pickupid );
	return 1;
}
