#include <a_samp>
#include <foreach>
#define MAX_CHECKPOINTS 500
#define INVALID_CHECKPOINT_ID 999

forward playercheckpointUpdate( playerid );
forward d_setPlayerCheckpoint( playerid, Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style );
forward d_deletePlayerCheckpoint( playerid, type );
forward d_setCheckpoint( Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style );
forward d_deleteCheckpoint( type );
forward d_setMinimumMapIconID( id );
forward d_getCheckPointType( playerid );
forward updateplayercheckpoints( );
forward d_deleteCheckpoint( type );

new
	gPlayerCheckpointStatus[ MAX_PLAYERS ],
	MIN_MAPCONID,
	timer,
	Iterator:CheckStreamer<100>;

enum pStr
{
	Float: pcX,
	Float: pcY,
	Float: pcZ,
	Float: pcRC,
	Float: pcR,
	pcFP,
	pcType,
	pcStyle
};
new PlayerCheckStreamer[ MAX_CHECKPOINTS ][ pStr ];

public OnFilterScriptInit()
{
	print( "*******************************************************" );
	print( "** [FS+Include] Multi Checkpoints v0.1.2 by Dima-kun **" );
	print( "**            		                         **" );
	print( "**         CopyRight  2014 SAMP-RUS-TEAM            **" );
	print( "********************************************************" );
	timer = SetTimer( "updateplayercheckpoints", 3600000, true );
	return 1;
}

public OnFilterScriptExit()
{
	print( "*******************************************************" );
	print( "** [FS+Include] Multi Checkpoints v0.1.2 by Dima-kun **" );
	print( "**            		                         **" );
	print( "**         CopyRight  2014 SAMP-RUS-TEAM            **" );
	print( "*******************************************************" );
	KillTimer( timer );
	return 1;
}

public OnPlayerSpawn( playerid )
{
    SetTimerEx( "playercheckpointUpdate", 1000, false, "i", playerid );
    return 1;
}

public playercheckpointUpdate( playerid )
{
	if( IsPlayerConnected( playerid ) )
	{
		foreach (new j : CheckStreamer)
		{
		    if( PlayerCheckStreamer[ j ][ pcType ] == -1 ) continue;
		   	if( IsPlayerInRangeOfPoint( playerid, PlayerCheckStreamer[ j ][ pcR ], PlayerCheckStreamer[ j ][ pcX ], PlayerCheckStreamer[ j ][ pcY ], PlayerCheckStreamer[ j ][ pcZ ] ) )
			{
			    if( gPlayerCheckpointStatus[ playerid ] != PlayerCheckStreamer[ j ][ pcType ] )
				{
			    	if( PlayerCheckStreamer[ j ][ pcFP ] == playerid )
			    	{
						gPlayerCheckpointStatus[ playerid ] = PlayerCheckStreamer[ j ][ pcType ];
						DisablePlayerCheckpoint( playerid );
						SetPlayerCheckpoint( playerid, PlayerCheckStreamer[ j ][ pcX ], PlayerCheckStreamer[ j ][ pcY ], PlayerCheckStreamer[ j ][ pcZ ], PlayerCheckStreamer[ j ][ pcRC ] );
						break;
					}
   				}
	       	}
	    	else
			{
			   	DisablePlayerCheckpoint( playerid );
		    	gPlayerCheckpointStatus[ playerid ] = 999;
		    }
		}
		SetTimerEx( "playercheckpointUpdate", 1000, false, "i", playerid );
	}
	return 1;
}

public d_setPlayerCheckpoint( playerid, Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style )
{
	for( new i = 0; i < MAX_CHECKPOINTS; i++ )
	{
	    if( PlayerCheckStreamer[ i ][ pcType ] == -1 )
	    {
			PlayerCheckStreamer[ i ][ pcR ] = viewradius;
			PlayerCheckStreamer[ i ][ pcX ] = x;
			PlayerCheckStreamer[ i ][ pcY ] = y;
			PlayerCheckStreamer[ i ][ pcZ ] = z;
			PlayerCheckStreamer[ i ][ pcFP ] = playerid;
			PlayerCheckStreamer[ i ][ pcRC ] = radius;
			PlayerCheckStreamer[ i ][ pcType ] = type;
			PlayerCheckStreamer[ i ][ pcStyle ] = style;
			if( style == MAPICON_GLOBAL ) SetPlayerMapIcon( playerid, MIN_MAPCONID + i, x, y, z, 0, 0xff0000ff, style );
	    	Iter_Add( CheckStreamer, i );
	    	break;
    	}
    }
	return 1;
}

public d_deletePlayerCheckpoint( playerid, type )
{
	foreach (new i : CheckStreamer)
	{
	    if( PlayerCheckStreamer[ i ][ pcType ] == type && PlayerCheckStreamer[ i ][ pcFP ] == playerid )
	    {
	        new
        		next;

	        PlayerCheckStreamer[ i ][ pcR ] = 0.0;
			PlayerCheckStreamer[ i ][ pcX ] = 0.0;
			PlayerCheckStreamer[ i ][ pcY ] = 0.0;
			PlayerCheckStreamer[ i ][ pcZ ] = 0.0;
			PlayerCheckStreamer[ i ][ pcRC ] = 0.0;
			PlayerCheckStreamer[ i ][ pcFP ] = INVALID_PLAYER_ID;
			PlayerCheckStreamer[ i ][ pcType ] = -1;
			PlayerCheckStreamer[ i ][ pcStyle ] = -1;
			RemovePlayerMapIcon( playerid, MIN_MAPCONID + i );
			DisablePlayerCheckpoint( playerid );
			Iter_SafeRemove(CheckStreamer, i, next);
			i = next;
	    }
	}
	return 1;
}

public d_setCheckpoint( Float: x, Float: y, Float: z, Float: radius, Float: viewradius, type, style )
{
	foreach(new i:Player)
	 	d_setPlayerCheckpoint( i, x, y, z, radius, viewradius, type, style );
	return 1;
}

public d_deleteCheckpoint( type )
{
	foreach(new i:Player)
	        d_deletePlayerCheckpoint( i, type );
	return 1;
}


public d_setMinimumMapIconID( id )
{
	MIN_MAPCONID = id;
	return 1;
}

public d_getCheckPointType( playerid )
	return gPlayerCheckpointStatus[ playerid ];
