#include <a_samp>

#define yellow 0xFFFF00AA
#define red 0xFF0000AA

new AirBreakVar[MAX_PLAYERS];
new SetDistance[MAX_PLAYERS];

forward AfterPlayerConnect(playerid);
forward OnGetPlayerKeys();

public OnFilterScriptInit()
{
	SetTimer("OnGetPlayerKeys", 250, 1);

	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		SetDistance[i] = 5;
	}
	return 1;
}

public OnFilterScriptExit()
{
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		TogglePlayerControllable(i, 1);
	}
	return 1;
}

public OnPlayerConnect(playerid)
{
	SetTimerEx("AfterPlayerConnect", 1000, 0, "i", playerid);
	return 1;
}

public AfterPlayerConnect(playerid)
{
	AirBreakVar[playerid] = 0;
	SetDistance[playerid] = 5;
	return 1;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	if(strcmp("/abon", cmdtext, true, 12) == 0)
	{
		if(AirBreakVar[playerid] == 0)
		{
			if(IsPlayerInAnyVehicle(playerid) == 0)
			{
				AirBreakVar[playerid] = 1;
				SetCameraBehindPlayer(playerid);

				TogglePlayerControllable(playerid, 0);
				SendClientMessage(playerid, yellow, "Air Break on, /abset to change the move distance, /aboff to turn off");
			}
			else
			{
				SendClientMessage(playerid, red, "You can not activate Air Break when in a vehicle");
			}
		}
		else
		{
			SendClientMessage(playerid, red, "Your Air Break is already on");
		}
		return 1;
	}
	
	if(strcmp("/aboff", cmdtext, true, 12) == 0)
	{
		if(AirBreakVar[playerid] == 1)
		{
			AirBreakVar[playerid] = 0;
			TogglePlayerControllable(playerid, 1);
			SendClientMessage(playerid, yellow, "Air Break off, /abon to turn on");
		}
		else
		{
			SendClientMessage(playerid, red, "Your Air Break is already off");
		}
		return 1;
	}

	if(strcmp("/abset", cmdtext, true, 6) == 0)
	{
		if(AirBreakVar[playerid] == 1)
		{
			new string[128], pos = strfind(cmdtext, " ", true);
			strdel(cmdtext, 0, pos + 1);

			SetDistance[playerid] = strval(cmdtext);

			format(string, sizeof(string), "You have set your Air Break distance to %d", strval(cmdtext));
			SendClientMessage(playerid, yellow, string);
		}
		else
		{
			SendClientMessage(playerid, red, "Your Air Break is currently off");
		}
		return 1;
	}
	
	if(strcmp("/abhelp", cmdtext, true, 6) == 0)
	{
		SendClientMessage(playerid, yellow, "** Air Break Help **");
		SendClientMessage(playerid, yellow, "/abon to turn Air Break on - /aboff to turn Air Break off");
		SendClientMessage(playerid, yellow, "Forwards button to go forward - Backwards button to go backwards");
		SendClientMessage(playerid, yellow, "Left button to go left - Right button to go right");
		SendClientMessage(playerid, yellow, "Jump button to go up - Sprint button to go down");
		SendClientMessage(playerid, yellow, "Special Ctrl Left to turn left - Special Ctrl Right to turn right");
		SendClientMessage(playerid, yellow, "** **");
		return 1;
	}
	return 0;
}

public OnGetPlayerKeys()
{
	for(new i = 0; i < MAX_PLAYERS; i++)
	{
		new Keys, UpDown, LeftRight;
		GetPlayerKeys(i, Keys, UpDown, LeftRight);
	
		if(IsPlayerInAnyVehicle(i) == 1)
		{
			if(AirBreakVar[i] == 1)
			{
				AirBreakVar[i] = 0;
				TogglePlayerControllable(i, 1);
			}
		}
		
		if(AirBreakVar[i] == 1)
		{
			new Float:X, Float:Y, Float:Z, Float:A;
			GetPlayerPos(i, X, Y, Z);
			GetPlayerFacingAngle(i, A);

			if(UpDown == KEY_UP)
			{
				X += (SetDistance[i] * floatsin(-A, degrees)); //Made by Y_Less
				Y += (SetDistance[i] * floatcos(-A, degrees)); //Made by Y_Less
				
				SetPlayerPos(i, X, Y, Z);
				SetCameraBehindPlayer(i);
				return 1;
			}

			if(UpDown == KEY_DOWN)
			{
				X -= (SetDistance[i] * floatsin(-A, degrees)); //Made by Y_Less
				Y -= (SetDistance[i] * floatcos(-A, degrees)); //Made by Y_Less
				
				SetPlayerPos(i, X, Y, Z);
				SetCameraBehindPlayer(i);
				return 1;
			}

			if(LeftRight == KEY_RIGHT)
			{	
				A += -90;
				X += floatmul(floatsin(-A, degrees), SetDistance[i]); // Made by Nero_3D
				Y += floatmul(floatcos(-A, degrees), SetDistance[i]); // Made by Nero_3D
				
				SetPlayerPos(i, X, Y, Z);
				SetCameraBehindPlayer(i);
				return 1;
			}

			if(LeftRight == KEY_LEFT)
			{
				A += 90;
				X += floatmul(floatsin(-A, degrees), SetDistance[i]); // Made by Nero_3D
				Y += floatmul(floatcos(-A, degrees), SetDistance[i]); // Made by Nero_3D
				
				SetPlayerPos(i, X, Y, Z);
				SetCameraBehindPlayer(i);
				return 1;
			}
			
			if(Keys == KEY_JUMP)
			{
				SetPlayerPos(i, X, Y, Z + SetDistance[i]);
				SetCameraBehindPlayer(i);
				return 1;
			}

			if(Keys == KEY_SPRINT)
			{
				SetPlayerPos(i, X, Y, Z - SetDistance[i]);
				SetCameraBehindPlayer(i);
				return 1;
			}
			
			if(Keys == KEY_ANALOG_RIGHT)
			{
				SetPlayerFacingAngle(i, A - (SetDistance[i] * 4));
				SetCameraBehindPlayer(i);
				return 1;
			}
			
			if(Keys == KEY_ANALOG_LEFT)
			{
				SetPlayerFacingAngle(i, A + (SetDistance[i] * 4));
				SetCameraBehindPlayer(i);
				return 1;
			}
		}
	}
	return 1;
}
