//===============================================================
//
// 					  MTA 1.
//						Version 0.1
// 						by Dima-kun
//				CopyRight  SAMP-RUS TEAM 2012 
// 		    
//			      
//
//===============================================================

/*
	native LoadMap( filename[], typestrim = 1, Float: viewdis = 350.0 ); //  
	native Unloadmap( mapid ); //  
	native UnloadAllMaps(); //   
	native strcharsplit( const string[], &index, seperator=' ' ); //  .    strtok
*/
#if defined d_maps_included
	#endinput
#endif
#define d_maps_included

//===============================================================
//
// 		 ,     
//
//===============================================================
#define MAX_OBJECT ( 5000 )
#define MAX_MAPS ( 20 )

//===============================================================
//
// 			,     
//
//===============================================================

#define MAP_NOTFOUND ( -1 )
#define MAP_TOOBIG_LEN ( -2 )
#define MAX_MAX_LOADED ( -3 ) 

static loadedMaps = -1;
static loadedObj;
static loadedVehs;

enum mInfo
{
	_mobjects[ MAX_OBJECTS ],
	_mvehicles[ MAX_VEHICLES ],
	_mobjCount,
	_mvehCount,
	_mStreamer,
	bool: _mapValid
};
new MapInfo[ MAX_MAPS ][ mInfo ];

//===============================================================
//
// 	: LoadMap( filename[], typestrim = 1, Float: viewdis = 350.0 ) -    
// 		:
//			filename[] -   
//			typestrim -   : 
//							1 -    .(CreateObject)
//							2 - MidoStream,     xObjects.
//							3 - rObjects.
//  		Float: viewdis - ,        
//		 ID  .
//		
//		,   :
//
//		MAP_NOTFOUND( -1 ) -    ,    .
//		MAP_TOOBIG_LEN( -2 ) -    .
//		MAX_MAX_LOADED( -3 ) -    .
//
//===============================================================

stock LoadMap( filename[], typestrim = 1, Float: viewdis = 350.0 )
{
	if( loadedMaps == MAX_MAPS ) return MAX_MAX_LOADED;
	if( strlen( filename ) > 40 ) return MAP_TOOBIG_LEN;
	new File: file,
		string[ 256 ],
		tmp[ 50 ],
		_intVal[ 5 ],
		Float: _floatVal[ 6 ];
	loadedMaps++;
		
//===============================================================
//
// 	     scriptfiles/maps. 
// 	  		      :
// 	format( string, sizeof( string ), "maps/%s", filename );
//
//===============================================================

	format( string, 50, "maps/%s", filename );
	if( ( file = fopen( string, io_read ) ) )
	{
		while( fread( file, string ) )
		{
		
//===============================================================
//
// 			   . 
//
//===============================================================

			new start = strfind( string, "<", true ) - 1,
				end = strfind( string, ">", true ),
				tags = strfind( string, "</object>", true );
				
//===============================================================
//
// 			   . 
//
//===============================================================

			if( tags >= 0 ) strdel( string, tags, tags + 10 );
			tags = strfind( string, "</vehicle>", true );
			if( tags >= 0 ) strdel( string, tags, tags + 10 );
			tags = strfind( string, "</map>", true );
			if( tags >= 0 ) strdel( string, tags, tags + 6 );
			strdel( string, start, start + 1 );
			strdel( string, end - 1, end + 1 );

			tmp = strcharsplit( string, start, ' ' );
			
//===============================================================
//
// 			  .
//
//===============================================================

			if( !strcmp( tmp, "object", true ) )
			{
			
//===============================================================
//
// 			 ID  
//
//===============================================================

				start = strfind( string, "model", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_intVal[ 0 ] = strval( tmp );
				
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 0 ] = floatstr( tmp );
				
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 1 ] = floatstr( tmp );
				
//===============================================================
//
// 			  Z 
//
//===============================================================

				start = strfind( string, "posZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 2 ] = floatstr( tmp );
				
//===============================================================
//
// 		      
//
//===============================================================

				start = strfind( string, "rotX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 3 ] = floatstr( tmp );
				
//===============================================================
//
// 		      
//
//===============================================================

				start = strfind( string, "rotY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 4 ] = floatstr( tmp );
				
//===============================================================
//
// 		      Z
//
//===============================================================

				start = strfind( string, "rotZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 5 ] = floatstr( tmp );
//===============================================================
//
// 	     
// 				   .
//
//===============================================================
				switch( typestrim )
				{
					case 2:MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateStreamedObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], viewdis );
					case 3:MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateStreamObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], viewdis );
					case 4:MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateDynamicObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], -1, -1, viewdis, 0.0 );
					default: MapInfo[ loadedMaps ][ _mobjects ][ loadedObj ] = CreateObject( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], _floatVal[ 4 ], _floatVal[ 5 ], viewdis );
				}
				loadedObj++;
			}
			if( !strcmp( tmp, "vehicle", true ) )
			{
			
//===============================================================
//
// 			 ID  
//
//===============================================================

				start = strfind( string, "model", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_intVal[ 0 ] = strval( tmp );
			
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 0 ] = floatstr( tmp );

//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 1 ] = floatstr( tmp );

//===============================================================
//
// 			  Z 
//
//===============================================================

				start = strfind( string, "posZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 2 ] = floatstr( tmp );

//===============================================================
//
// 			    
//
//===============================================================

				start = strfind( string, "rotZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 3 ] = floatstr( tmp );

//===============================================================
//
// 					   
//
//===============================================================

				MapInfo[ loadedMaps ][ _mvehicles ][ loadedVehs ] = AddStaticVehicle( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], -1, -1 );
				loadedVehs++;
			}
//===============================================================
//
// 		 ,      MTA:Race
//
//===============================================================

			if( !strcmp( tmp, "spawnpoint", true ) )
			{
			
//===============================================================
//
// 			 ID  
//
//===============================================================

				start = strfind( string, "vehicle", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_intVal[ 0 ] = strval( tmp );
			
//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posX", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 0 ] = floatstr( tmp );

//===============================================================
//
// 			   
//
//===============================================================

				start = strfind( string, "posY", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 1 ] = floatstr( tmp );

//===============================================================
//
// 			  Z 
//
//===============================================================

				start = strfind( string, "posZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 2 ] = floatstr( tmp );

//===============================================================
//
// 			    
//
//===============================================================

				start = strfind( string, "rotZ", true ) - 1;
				tmp = strcharsplit( string, start, '=' );
				tmp = strcharsplit( string, start, ' ' );
				start = strfind( tmp, "\"", true );
				strdel( tmp, start, start + 1  );
				end = strfind( tmp, "\"", true );
				strdel( tmp, end, end + 1 );
				_floatVal[ 3 ] = floatstr( tmp );

//===============================================================
//
// 					   
//
//===============================================================

				MapInfo[ loadedMaps ][ _mvehicles ] = AddStaticVehicle( _intVal[ 0 ], _floatVal[ 0 ], _floatVal[ 1 ], _floatVal[ 2 ], _floatVal[ 3 ], -1, -1 );
				loadedVehs++;
			}
		}
		
//===============================================================
//
// 			  
//
//===============================================================

		fclose( file );
		MapInfo[ loadedMaps ][ _mapValid ] = true;
		MapInfo[ loadedMaps ][ _mobjCount ] = loadedObj;
		MapInfo[ loadedMaps ][ _mvehCount ] = loadedVehs;
		MapInfo[ loadedMaps ][ _mStreamer ] = typestrim;
		printf( " %s .\n:%i\n:%i", filename, loadedObj, loadedVehs );
		return loadedMaps;
	}
	return MAP_NOTFOUND;
}

//===============================================================
//
// 	: bool: Unloadmap( mapid ) -    
// 		:
//			mapid - ID   
// 	 true,   .  false,      .
//
//===============================================================

stock bool: Unloadmap( _mapid )
{
	if( MapInfo[ _mapid ][ _mapValid ] == true )
	{
		for( new i = 0; i < MapInfo[ _mapid ][ _mobjCount ]; i++ )
		{
			if( MapInfo[ loadedMaps ][ _mStreamer ] == 1)DestroyObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
			else if( MapInfo[ loadedMaps ][ _mStreamer ] == 2) DestroyStreamedObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
			else DestroyStreamObject( MapInfo[ _mapid ][ _mobjects ][ i ] );
		}
		for( new v = 0; v < MapInfo[ _mapid ][ _mvehCount ]; v++ )
			DestroyVehicle( MapInfo[ _mapid ][ _mvehicles ][ v ] );
		MapInfo[ _mapid ][ _mapValid ] = false;
		return true;
	}
	return false;
}
//===============================================================
//
// 	: bool: UnloadAllMaps() -     
// 	   -  .
//
//===============================================================
stock bool: UnloadAllMaps()
{
	for( new mapid = 0; mapid < MAX_MAPS; mapid++ )
	{
		if( MapInfo[ mapid ][ _mapValid ] == true )
		{
			for( new i = 0; i < MapInfo[ mapid ][ _mobjCount ]; i++ )
			{
				if( MapInfo[ loadedMaps ][ _mStreamer ] == 1)DestroyObject( MapInfo[ mapid ][ _mobjects ][ i ] );
				else if( MapInfo[ loadedMaps ][ _mStreamer ] == 2) DestroyStreamedObject( MapInfo[ mapid ][ _mobjects ][ i ] );
				else DestroyStreamObject( MapInfo[ mapid ][ _mobjects ][ i ] );
			}
			for( new v = 0; v < MapInfo[ loadedMaps ][ _mvehCount ]; v++ )
				DestroyVehicle( MapInfo[ mapid ][ _mvehicles ][ v ] );
			MapInfo[ mapid ][ _mapValid ] = false;
		}
	}
	return true;
}


stock DestroyStreamedObject( dID )
	return CallRemoteFunction( "DestroyStreamedObject", "i", dID );
stock DestroyStreamObject( id )
    return CallRemoteFunction( "Core_DestroyStreamObject", "i", id );
stock CreateStreamedObject( oID, Float:X, Float: Y, Float: Z,Float: rX, Float: rY, Float: rZ, Float: ViewD )
	return CallRemoteFunction( "CreateStreamedObject", "ifffffff", oID, X, Y, Z, rX, rY, rZ,  ViewD );
stock CreateDynamicObject( modelid, Float: xpos, Float: ypos, Float: zpos, Float: xrot, Float: yrot, Float: zrot, Float: viewdist = 150.0 )
	return CallRemoteFunction( "Core_CreateStreamObject", "ifffffff", modelid, xpos,ypos, zpos, xrot, yrot, zrot, viewdist );
native CreateDynamicObject(modelid, Float:x, Float:y, Float:z, Float:rx, Float:ry, Float:rz, worldid = -1, interiorid = -1, playerid = -1, Float:streamdistance = 200.0, Float:drawdistance = 0.0);
native DestroyDynamicObject(objectid);
stock strcharsplit( const string[], &index, seperator = ' ' )
{
	new result[ 20 ], 
		i = 0;
	if( index != 0 ) index++;
	while ( string[ index ] && string[ index ] != seperator )
	{
		result[ i++ ] = string[ index++ ];
	}
	return result;
}