#if defined _mtapickups_included
  #endinput
#endif
#define _mtapickups_included

/*

	Функции:
		1. createMTAPickUp - создаёт пикап.
			Параметры:
				pickmodel - модель пикапа
				Float:x, Float:y, Float:z - позиции x,y,z пикапа
				virtualworld - виртуальный мир, в котором располагается пикап
				tcolor - цвет надписи над пикапом(hex)
				newcar - ID модели на которую заменяется машина(если 0, то машина будет восстановлена, а если 1, то покрашена в цвета color1 и color2, а если 2 - то машина будет взорвана)
				color1 - цвет машины №1
				color2 - цвет машины №2
			Функция вовращает ID созданного пикапа.
		2. destroyMTAPickup - удаляет пикап.
			Параметры:
				pickupid - ID пикапа
			Функция не возвращает ничего.
		3. destroyAllMTAPickup - удаляет все пикапы.
			Параметров нету.
			Функция не возвращает ничего принципиального.
		4. isMTApickupValid - проверяет состояние пикапа 
			Параметры:
				pickupid - ID пикапа
			Функция возвращает 1 если пикап существует, и 0 - если не существует.
		5. updateMTAPickUp - с помощью этой функции можно настроить функционал пикапа не удаляя пикап
			Параметры:
				pickupid - ID пикапа
				tcolor - цвет текста над пикапом(hex)
				newcar - ID модели на которую заменяется машина(если 0, то машина будет восстановлена, а если 1, то покрашена в цвета color1 и color2)
				color1 - цвет машины №1
				color2 - цвет машины №2
			Функция не вовзращает ничего принципиального.
			
*/

stock createMTAPickUp( pickmodel, Float:x, Float:y, Float:z, virtualworld, tcolor = 0xffffffff, newcar = 0, color1 = 1, color2 = 1 ) return CallRemoteFunction( "t_CreateMTApickup","ifffixiii", pickmodel, Float:x, Float: y, Float: z, virtualworld, tcolor, newcar, color1, color2 );
stock destroyMTAPickup( pickupid )return CallRemoteFunction( "t_destroyMTAPickup", "i", pickupid );
stock destroyAllMTAPickup() return CallRemoteFunction( "t_destroyAllMTAPickup", "i", 1 );
stock isMTApickupValid( pickupid ) return CallRemoteFunction( "t_isMTApickupValid", "i", pickupid );
stock updateMTAPickUp( pickupid, tcolor = 0xffffffff, newcar = 0, color = 1, color2 = 1 )return CallRemoteFunction( "t_updateMTApickup", "ixiii", pickupid, tcolor, newcar, color1, color2 );

/*

	Колбэки:
		1. onVehicleRepair  - вызывается при восстановлении машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID восстановленной машиной
				pickupid - ID восстановившего пикапа
				
		2. onVehicleChangeModel - вызывается при смене модели машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID машины, которой меняют модель
				newmodel - Модель, присвоенная машине
				oldmodel - Модель, которая была до смены.
				
		3. onMTApickupCreate - вызывается при создании пикапа.
			Параметры:
				pickupid - ID созданного пикапа
				pictype - Тип пикапа
				
		4.onVehicleColoured - вызывается при смене цвета машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID машины, которой меняют цвет
				pickupid - ID пикапа, сменившего цвет мащины
				newcolor1 - новый цвет машины №1
				newcolor2 - новый цвет машины №2
				
		5.onVehicleBoom - вызывается при взрыве машины
			Параметры:
				playerid - ID водителя
				vehicleid - ID машины, которая взорвалась
				pickupid - ID восстановившего пикапа
*/

forward onVehicleRepair( playerid, vehicleid, pickupid );
forward onVehicleColoured( playerid, vehicleid, pickupid, newcolor1, newcolor2 );
forward onVehicleChangeModel( playerid, vehicleid, newmodel, oldmodel );
forward onMTApickupCreate( pickupid, pictype );
forward onVehicleBoom( playerid, vehicleid, pickupid );

//# Типы пикапов
#define PICKUP_CHANGECOLOR	( 1 )
#define PICKUP_BOOM			( 2 )