/*

	[Include] Для базового игрового скрипта Game Move v0.2
	Автор: Dima-kun
	SAMP-RUS.COM, 2014
	
	Сборник всех доступных функций для пользования. Без каких-либо дырок для утечки информации сервера.



	
	Функция:
		setPlayerPosEx( playerid, Float:x, Float:y, Float:z, Float: FacingAngle, interior=0, virtual = 0 ) - Устанавливает игрока на позицию с дополнительными данными.
	Параметры:
		playerid - ID игрока, которого нужно установить на указанное место
		Float:x - Координата Х
		Float:y - Координата Y
		Float:z - Координата Z
		Float:FacingAngle - Угол поворота игрока
		interior - ID интерьера(не обязателеный параметр)
		virtual - ID вирутального мира(не обязателеный параметр)
	Функция не возвращает специальных значений

*/

stock setPlayerPosEx( playerid,  Float:sppx,  Float:sppy,  Float:sppz,  Float:sppFA, interior = 0, virtual = 0 )
	return CallRemoteFunction( "setPlayerPosEx", "iffffii", playerid,  sppx,  sppy,  sppz,  sppFA, interior, virtual );

/*
	
	Функция:
		getPlayerState( playerid ) - возвращает состояние игрока на сервере внутри игрового скрипта
	Параметры:
		playerid - ID игрока
	Список возможных результатов данной функции находятся внизу инклюда

*/

stock getPlayerState( playerid )
	return CallRemoteFunction( "getPlayerState", "i", playerid );

/*
	
	Функция:
		givePlayerMoney( playerid,  amount ) - Дает деньги игроку в обход античита. Но в скрипте можно использовать GivePlayerMoney !
	Параметры:
		playerid - ID игрока
		amount - количество денег

*/

stock givePlayerMoney( playerid,  amount )
	return CallRemoteFunction( "giveplayerMoney", "ii", playerid,  amount );

#define GivePlayerMoney givePlayerMoney

/*
	
	Функция:
		setPlayerState( playerid, stat ) - задает состояние игрока на сервере внутри игрового скрипта
	Параметры:
		playerid - ID игрока
		stat - состояние игрока ( int )
	Список возможных результатов данной функции находятся внизу инклюда

*/

stock setPlayerState( playerid, stat )
	return CallRemoteFunction( "setPlayerState", "ii", playerid,  stat );

/*
	
	Функция:
		giveplayerHealth( playerid,  Float: amount ) - дает здоровье игроку
	Параметры:
		playerid - ID игрока
		Float: amount - количество здоровья

*/

stock giveplayerHealth( playerid,  Float: amount )
	return CallRemoteFunction( "giveplayerHealth", "if", playerid,  amount );

/*
	
	Функция:
		setPlayerHealth( playerid,  Float:amount) - устанавливает здоровье игроку
	Параметры:
		playerid - ID игрока
		Float: amount - количество здоровья
	Функция для исключения античита, возможно употребление SetPlayerHealth

*/

stock setPlayerHealth( playerid,  Float: amount )
	return CallRemoteFunction( "setPlayerHealth", "if", playerid,  amount );

#define SetPlayerHealth setPlayerHealth

/*
	
	Функция:
		loadPlayerInfoInt( file[], line[] ) - Извлекает данные из файла регистрации игрока 
	Параметры:
		file[] - Файл
		line[] - название строки
	Возвращает целое число

*/

stock loadPlayerInfoInt( file[], line[] )
	return CallRemoteFunction( "loadPlayerInfoInt", "ss", file, line );

/*
	
	Функция:
		Float:loadPlayerInfoFloat( file[], line[] ) - Извлекает данные из файла регистрации игрока 
	Параметры:
		file[] - Файл
		line[] - название строки
	Возвращает число с плавающей запятой

*/

stock Float:loadPlayerInfoFloat( file[], line[] )
	return CallRemoteFunction( "loadPlayerInfoInt", "ss", file, line );

/*
	
	Функция:
		savePlayerInfoInt( file[], line[], valus ) - Сохраняет строку с целым значением.
	Параметры:
		file[] - Файл
		line[] - название строки
		valus - значение строки

*/

stock savePlayerInfoInt( file[], line[], valus )
	return CallRemoteFunction( "savePlayerInfoInt", "ssi", file, line, valus );

/*
	
	Функция:
		showPlayerDialog( playerid, dialogid, style, title[], text[], button1[], button2[] ) - Для расширения функционала.
	В скрипте можно использовать ShowPlayerDialog. 
	
*/

stock showPlayerDialog( playerid, dialogid, style, title[], text[], button1[], button2[] )
	return CallRemoteFunction( "showPlayerDialog", "iiissss", playerid, dialogid, style, title, text, button1, button2 );

#define ShowPlayerDialog showPlayerDialog

/*
	
	Функция:
		isDialogShowingToPlayer( playerid ) - проверяет открыт ли у игрока какой либо диалог
	Параметры:
		playerid - ID игрока.
	1 - если открыт какой-либо диалог и 0 - если нет.
*/

stock isDialogShowingToPlayer( playerid )
	return CallRemoteFunction( "isDialogShowingToPlayer", "i", playerid );

/*

	Функция:
		HideDialog( playerid ) - Нужно добавить в начало колбэка OnDialogResponse. Для корректной работы функции выше.
	Параметры:
		playerid - ID игрока.

*/

stock HideDialog( playerid )
	return CallRemoteFunction( "HideDialog", "i", playerid );

/*

	Функция:
		isPlayerNameOnline( nickname[] ) - Проверяет есть ли игрок на сервере с таким именем
	Параметры:
		nickname[] - ник 
	Возвращает true если есть такой игрок, и false - если нету.

*/

stock bool: isPlayerNameOnline( const nickname[ MAX_PLAYER_NAME ] )
	return CallRemoteFunction( "isPlayerNameOnline", "s", nickname );

/*

	Функция:
		givePlayerVehicle( playerid, modelid ) - Выдать игроку машину
	Параметры:
		playerid - ID игрока, которому нужно дать машину
		modelid - ID модели машины
	Возвращает true если дали машину, false - если нет

*/

stock bool: givePlayerVehicle( const playerid, const modelid )
	return CallRemoteFunction( "givePlayerVehicle", "ii", playerid, modelid );

/*

	Функция:
		RandomPlayer() - Возвращает ID случано выбранного игрока.
	Функция возвратит INVALID_PLAYER_ID если на сервере нету игроков

*/

stock RandomPlayer()
	return CallRemoteFunction( "RandomPlayer", "i", 1 );

/*

	Функция:
		ArePlayersConnected() - проверяет есть ли на сервере хоть 1 игрок или нет
	Функция вернет true если есть хоть 1 игрок или false если нету игроков

*/

stock bool: ArePlayersConnected()
	return CallRemoteFunction( "ArePlayersConnected", "i", 1 );

/*

	Функция:
		isPlayerLogged( playerid ) - Проверяет зашел ли игрок под своим аккуантом.
	Параметры:
		playerid - ID игрока.
	1 - если зашел и 0 если не зашел

*/

stock isPlayerLogged( playerid )
	return CallRemoteFunction( "isPlayerLogged", "i", playerid );

/*

	Функция:
		isPlayerHaveAcсount( playerid ) - Проверяет есть ли у игрока аккаунт
	Параметры:
		playerid - ID игрока.
	1 - если есть и 0 если нету

*/

stock isPlayerHaveAccount( playerid )
	return CallRemoteFunction( "isPlayerHaveAccount", "i", playerid );

/*
	
	Функция:
		setPlayerArmour( playerid,  Float:amount ) - устанавливает броню игроку
	Параметры:
		playerid - ID игрока
		Float: amount - количество брони
	Функция для исключения античита, возможно употребление SetPlayerArmour

*/

stock setPlayerArmour( playerid,  Float: amount )
	return CallRemoteFunction( "setPlayerArmour", "if", playerid,  amount );

#define SetPlayerArmour setPlayerArmour

/*
	
	Функция:
		givePlayerArmour( playerid,  Float:amount ) - даёт броню игроку
	Параметры:
		playerid - ID игрока
		Float: amount - количество брони

*/

stock givePlayerArmour( playerid,  Float:amount )
	return CallRemoteFunction( "givePlayerArmour", "if", playerid,  amount );

/*

	Функция:
		GetRandomFromInput( arg1, arg2, ... argN ) - Случайно выбирает и возвращает введенный аргумент
	Возвращает любое значение argN.

*/

stock GetRandomFromInput(...)
{
    new 
		input[ 100 ], 
		generate;
    if( numargs() == 0 ) return -1;
    for( new i = 0; i < numargs(); i++ )
        input[ i ] = getarg( i );
    generate = random( numargs() );
    return input[ generate ];
}

/*
	
	Функция:
		giveSuperArmour( playerid ) - Даёт пуленепробиваемую броню игроку
	Параметры:
		playerid - ID игрока

*/

stock giveSuperArmour( playerid )
	return CallRemoteFunction( "giveSuperArmour", "i", playerid );

/*
	
	Функция:
		takeSuperArmour( playerid ) - Забирает пуленепробиваемую броню у игрока
	Параметры:
		playerid - ID игрока

*/

stock takeSuperArmour( playerid )
	return CallRemoteFunction( "takeSuperArmour", "i", playerid );

/*
	
	Функция:
		createAvtomat( type, string[], color, Float:x, Float:y, Float:z, Float:rotx, Float:roty, Float:rotz, virtual, price ) - создает автомат с напитками или сигаретами
	Параметры:
		type - тип автомата. Внизу инклюда есть список доступных автоматов.
		string[] - Текст над автоматом
		color - цвет текста
		Float:x - позиция Х автомата
		Float:y - позиция Y автомата
		Float:z - Позиция Z автомата
		Float:rotx - Угол поворота относительно оси Х
		Float:roty - Угол поворота относительно оси Y
		Float:rotz  - Угол поворота относительно оси Z
		virtual - виртуальный мир, в котором находится автомат
		price - цена единицы, купленной в автомате
	Функция возвращает ID созданного автомата.

*/

stock createAvtomat( type, string[], color, Float: x, Float: y, Float: z, Float: rotx, Float: roty, Float: rotz, virtual = 0, price = 20 )	
	return CallRemoteFunction( "a_createAvtomat", "issffffffii", type, string, color, Float:x, Float:y, Float:z, Float:rotx, Float:roty, Float:rotz, virtual, price );

/*
	
	Функция:
		destroyAvtomat( avtomatid ) - Удаляет автомат с сервера.
	Параметры:
		avtomatid - ID автомата

*/

stock destroyAvtomat( avtomatid )
	return CallRemoteFunction( "a_destroyAvtomat", "i", avtomatid );

/*
	
	Функция:
		getPlayerID( name[] ) - Узнает ID игрока по его нику.
	Параметры:
		name[] - ник игрока
	Вернет INVALID_PLAYER_ID если нет такого игрока
	
*/

stock getPlayerID( name[] )
	return CallRemoteFunction( "getPlayerID", "s", name );

/*
	
	Функция:
		clearChatToPlayer( playerid ) - Очищает чат игроку
	Параметры:
		playerid - ID игрока
	
*/

stock clearChatToPlayer( playerid )
	return CallRemoteFunction( "clearChatToPlayer", "i", playerid );

/*

	Функция:
		createPlayer3DtextLableEx(playerid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0) - Создать, и прикрепить 
	Параметры:
		playerid - ID игрока, к которому нужно прикрепить текст
		text[] - Текст(Text 3D)
		color - цвет текста
		Float:x - Координата Х
		Float:y - Координата Y
		Float:z - Координата Z 
		Float:DrawDistance - дистанция видимости
		virtual - виртуальный мир
		testLOS - проверка на видимость сквозь стены.
	Функция не возвращает специальных значений. Прикрепить можно только одну надпись к одному игроку.
	
*/

stock createPlayer3DtextLableEx( playerid, text[], color, Float:x, Float:y, Float:z, Float:DrawDistance, virtual, testLOS )
	return CallRemoteFunction( "createPlayer3DtextLableEx", "isxffffii", playerid, text, color, x, y, z, DrawDistance, virtual, testLOS );

/*

	Функция:
		deletePlayer3DtextLableEx(playerid) - удалить Надпись прикрепленную к игроку.
	Параметры:
		playerid - ID игрока
	Функция не возвращает специальных значений.

*/

stock deletePlayer3DtextLableEx( playerid )
	return CallRemoteFunction( "deletePlayer3DtextLableEx", "i", playerid );

/*

	Функция:
		updatePlayer3DtextLableEx(playerid,color,text[]) - Обновляет текст прикрепленный к игроку
	Параметры:
		playerid - ID игрока
		color - Цвет текста
		text[] - Текст
	Функция не возвращает специальных значений.

*/

stock updatePlayer3DtextLableEx( playerid, color, text[] )
	return CallRemoteFunction( "updatePlayer3DtextLableEx", "ixs", playerid, color, text );

/*
	
	Функция:
		clearChatToAll() - Очищает чат всем игрокам
	Нет параметров
	
*/

stock clearChatToAll()
	return CallRemoteFunction( "clearChatToAll", "i", 1 );

/*

	Функция:
		givePlayerMoneyToPlayer( playerid, targetid, amount ) - Передать деньги игрок игроку.
	Параметры:
		playerid - ID игрока, который передает деньги
		targetid - ID игрока, который получает деньги
		amount - количество денег
	Функция не возвращает специальных значений.

*/

stock givePlayerMoneyToPlayer( playerid, targetid, amount )
	return CallRemoteFunction( "givePlayerMoneyToPlayer", "iii", playerid, targetid, amount );

/*

	Функция:
		givePlayerMoneyToPlayerEx( playerid, targetid, amount, Float: range ) - Передает деньги игроку, если игрок находится в зоне досигаемости
	Параметры:
		playerid - ID игрока, который передает деньги
		targetid - ID игрока, который получает деньги
		amount - количество денег
		Float: range - дальность досигаемости игрока.
	Функция не возвращает специальных значений.

*/

stock givePlayerMoneyToPlayerEx( const playerid, const targetid, const amount, Float: range )
	return CallRemoteFunction( "givePlayerMoneyToPlayerEx", "iiif", playerid, targetid, amount, range );

/*

	Функция:
		givePlayerHealthToPlayer( playerid, targetid, Float: amount ) - Передает здоровье игрока игроку
	Параметры:
		playerid - ID игрока, который передает здоровье
		targetid - ID игрока, который получает здоровье
		amount - количество здоровья
	Функция не возвращает специальных значений.

*/

stock givePlayerHealthToPlayer( const playerid, const targetid, Float: amount )
	return CallRemoteFunction( "givePlayerHealthToPlayer", "iif", playerid, targetid, range );

/*

	Функция:
		givePlayerHealthToPlayerEx( playerid, targetid, Float: amount, Float: range ) - Передает здоровье игроку, если игрок находится в зоне досигаемости
	Параметры:
		playerid - ID игрока, который передает здоровье
		targetid - ID игрока, который получает здоровье
		amount - количество здоровья
		Float: range - дальность досигаемости игрока.
	Функция не возвращает специальных значений.

*/

stock givePlayerHealthToPlayerEx( const playerid, const targetid, Float: amount, Float: range )
	return CallRemoteFunction( "givePlayerHealthToPlayerEx", "iiff", playerid, targetid, amount, range );
	
/*

	Функция:
		givePlayerArmourToPlayer( const playerid, const targetid, Float: amount ) - Передает броню игрока игроку
	Параметры:
		playerid - ID игрока, который передает броню
		targetid - ID игрока, который получает броню
		amount - количество брони
	Функция не возвращает специальных значений.

*/

stock givePlayerArmourToPlayer( const playerid, const targetid, Float: amount )
	return CallRemoteFunction( "givePlayerArmourToPlayer", "iif", playerid, targetid, amount );
	
/*

	Функция:
		givePlayerArmourToPlayerEx( playerid, targetid, Float: amount, Float: range ) - Передает броню игроку, если игрок находится в зоне досигаемости
	Параметры:
		playerid - ID игрока, который передает броню
		targetid - ID игрока, который получает броню
		amount - количество брони
		Float: range - дальность досигаемости игрока.
	Функция не возвращает специальных значений.

*/

stock givePlayerArmourToPlayerEx( const playerid, const targetid, Float: amount, Float: range )
	return CallRemoteFunction( "givePlayerArmourToPlayerEx", "iiff", playerid, targetid, amount, range );

/*

	Функция:
		isPickupWeaponModel(modelid) - Проверка на то, что является данная модель пикапа оружием.
	Параметры:
		modelid - модель пикапа
	Функция возратит 1(true) если истина, и 0(false) если ложь.

*/

stock bool:isPickupWeaponModel( const modelid )
	return ( modelid > 320 && modelid < 372 ) ? ( true ) : ( false );

/*

	Функция:
		setVehiclePosEx(vehicleid,Float:x,Float:y,Float:z,Float:RotateAngle,interior=0,virtual=0) - Устанавливает позицию машины, с дополнительными параметрами
	Параметры:
		vehicleid - ID машины
		Float:x - Координата Х
		Float:y - Координата Y
		Float:z - Координата Z
		Float:RotateAngle - Угол поворота машины
		interior - ID интерьера
		virtual - ID вирутального мира
	Функция не возвращает специальных значений.

*/

stock bool:setVehiclePosEx( vehicleid, Float:x, Float:y, Float:z, Float:RotateAngle, interior = 0, virtual = 0 )
	return CallRemoteFunction( "setVehiclePosEx", "iffffii", playerid, x, y, z, RotateAngle, interior, virtual );

/*

	Функция:
		getVehicleInfo(vehicleid,&Float:x,&Float:y,&Float:z,&Float:RotateAngle,&Float:health,&interior,&virtual,&model) - Узнает комплекс информации машины
	Параметры:
		vehicleid - ID машины
		Float:x - Координата Х
		Float:y - Координата Y
		Float:z - Координата Z
		Float:RotateAngle - Угол поворота
		Float:health - здоровье
		interior - ID интерьера
		virtual - ID виртуального мира
		model- модель машины
	Функция возвращает комплекс информации о машине.

*/

stock bool:getVehicleInfo( vehicleid, &Float:x, &Float:y, &Float:z, &Float:RotateAngle, &Float:health, &interior, &virtual, &model )
{
	if( vehicleid == INVALID_VEHICLE_ID ) return false;
	GetVehiclePos( vehicleid, x ,y, z );
	GetVehicleZAngle( vehicleid, RotateAngle );
	GetVehicleHealth( vehicleid, health );
	interior = getVehicleInterior( vehicleid );
	virtual = GetVehicleVirtualWorld( vehicleid );
	model = GetVehicleModel( vehicleid );
	return true;
}

/*

	Функция:
		turnCarEngine(vehicleid, status) - Завести\Заглушить двиготель машины
	Параметры:
		vehicleid - ID машины
		status - Завести\Заглушить машину (1\0)
	Функция не возвращает специальных значений.

*/

stock turnCarEngine( vehicleid, status )
	return CallRemoteFunction( "turnCarEngine", "ii", vehicleid, status );

/*

	Функция:
		isCarEngineRunned(vehicleid) - Проверяет заведена ли машина.
	Параметры:
		vehicleid - ID машины
	Возвращает статус машины: 1 - заведена 0 заглушена

*/

stock isCarEngineRunned( vehicleid )
	return CallRemoteFunction( "isCarEngineRunned", "i", vehicleid );

/*

	Функция:
		turnCarLights(vehicleid, status) - Включить\Выключить фары
	Параметры:
		vehicleid - ID машины
		status - Включить\Выключить фары (1\0)
	Функция не возвращает специальных значений.

*/

stock turnCarLights( vehicleid, status )
	return CallRemoteFunction( "turnCarLights", "ii", vehicleid, status );

/*

	Функция:
		isCarLightsOn(vehicleid) - Проверяет статус  фар 
	Параметры:
		vehicleid - ID машины
	Функция возвращает статус фар: Включены(1), или выключены(0)

*/

stock isCarLightsOn( vehicleid )
	return CallRemoteFunction( "isCarLightsOn", "i", vehicleid );

/*

	Функция:
		turnCarAlarm(vehicleid, status) - Включает\Выключает сигнализацию в машине
	Параметры:
		vehicleid - ID машины
		status - Включить\Выключить сигнализацию (1\0)
	Функция не возвращает специальных значений.

*/

stock turnCarAlarm( vehicleid, status )
	return CallRemoteFunction( "turnCarAlarm", "ii", vehicleid, status );

/*

	Функция:
		isCarAlarmActive(vehicleid) - Проверка статус сигнализации
	Параметры:
		vehicleid - ID машины
	Функция возвращает статус сигнализации: Включена(1), или выключена(0)

*/

stock isCarAlarmActive( vehicleid )
	return CallRemoteFunction( "isCarAlarmActive", "i", vehicleid );

/*

	Функция:
		turnCarDoors(vehicleid, status) - Открывает\Закрывает двери в машине
	Параметры:
		vehicleid - ID машины
		status - Открыть\Закрыть двери (1\0)
	Функция не возвращает специальных значений.

*/

stock turnCarDoors( vehicleid, status )
	return CallRemoteFunction( "turnCarDoors", "ii", vehicleid, status );

/*

	Функция:
		isCarDoorsOpen(vehicleid) - проверяет статус дверей
	Параметры:
		vehicleid - ID машины
	Функция возвращает статус дверей: Открыты(1), или Закрыты(0)

*/

stock isCarDoorsOpen( vehicleid )
	return CallRemoteFunction( "isCarDoorsOpen", "i", vehicleid );

/*

	Функция:
		turnCarBonnet(vehicleid, status) - Открыть\Закрыть капот машины
	Параметры:
		vehicleid - ID машины
		status - Открыть\Закрыть капот (1\0)
	Функция не возвращает специальных значений.

*/

stock turnCarBonnet( vehicleid, status )
	return CallRemoteFunction( "turnCarBonnet", "ii", vehicleid, status );

/*

	Функция:
		isCarBonnetOpen(vehicleid) - Узнает статус капота
	Параметры:
		vehicleid - ID машины
	Функция возвращает статус капота: Открыт(1), или Закрыт(0)

*/

stock isCarBonnetOpen( vehicleid )
	return CallRemoteFunction( "isCarBonnetOpen", "i", vehicleid );

/*

	Функция:
		turnCarBoot(vehicleid, status) - Открыть\Закрыть багажник машины
	Параметры:
		vehicleid - ID машины
		status - Открыть\Закрыть Багажник (1\0)
	Функция не возвращает специальных значений.

*/

stock turnCarBoot( vehicleid, status )
	return CallRemoteFunction( "turnCarBoot", "ii", vehicleid, status );

/*

	Функция:
		isCarBootOpen(vehicleid) - Узнает статус багажника
	Параметры:
		vehicleid - ID машины
	Функция возвращает статус багажника: Открыт(1), или Закрыт(0)

*/

stock isCarBootOpen( vehicleid )
	return CallRemoteFunction( "isCarBootOpen", "i", vehicleid );

/*

	Функция:
		turnCarObjective(vehicleid, status) - Установить машину как цель
	Параметры:
		vehicleid - ID машины
		status - Установить\Снять цель на\с машину\ы (1\0)
	Функция не возвращает специальных значений.

*/

stock turnCarObjective( vehicleid, status )
	return CallRemoteFunction( "turnCarObjective", "ii", vehicleid, status );

/*

	Функция:
		isCarObjective(vehicleid) - Проверяет статус цели машины
	Параметры:
		vehicleid - ID машины
	Функция возвращает статус машины: Является целью(1), или Не является(0)

*/

stock isCarObjective( vehicleid )
	return CallRemoteFunction( "isCarObjective", "i", vehicleid );

/*
	
	Функция:
		getWeaponSlot( weaponid ) - узнает слот, в котором находится данное оружие
	Параметры:
		weaponid - ID оружия
	
*/

stock getWeaponSlot( weaponid )
	return CallRemoteFunction( "getWeaponSlot", "i", weaponid );

/*

	Функция:
		createTeleportPoint(teleportid,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false) - Создает точку телепорта.
	Параметры:
		teleportid - ID точки телепорта(Нужно указывать самим! Внимание! нельзя указыать одинаковые иды на двух точках!)
		Float:x - Координата Х изначального места
		Float:y - Координата Y изначального места
		Float:z - Координата Z изначального места
		Float:newx - Координата Х конечного места
		Float:newy - Координата Y конечного места
		Float:newz - Координата Z конечного места
		Float:newFacingAngle - Угол поворота
		interior - ID интерьера(Необязательный параметр. По умолчания:0)
		virtual - ID вируального мира(Необязательный параметр. По умолчания:0)
		bool:isvehicle - Является ли это точка телепорта только для пешеходов(false) или можно еще и с машинами(true)
	Функция не возвращает специальных значений.

*/

stock createTeleportPoint( e_ptp, Float:x, Float:y, Float:z, Float:newx, Float:newy, Float:newz, Float:newFacingAngle, interior=0, virtual=0, bool:isvehicle = false )
	return CallRemoteFunction( "createTeleportPoint", "ifffffffiib", e_ptp, x, y, z, newx, newy, newz, newFacingAngle, interior, virtual, isvehicle );

/*

	Функция:
		destroyTeleportPoint(tppointid) - Уничтожает точку телепорта
	Параметры:
		teleportid - ID точки телепорта
	Функция не возвращает специальных значений.

*/

stock destroyTeleportPoint( tppointid )
	return CallRemoteFunction( "destroyTeleportPoint", "i", tppointid );

/*

	Функция:
		isValidTeleportPoint(tppointid) - Проверяет существует ли точка телепорта.
	Параметры:
		teleportid - ID точки телепорта
	Функция возвращает true если существует и false если не существует.

*/

stock bool:isValidTeleportPoint( tppointid )
	return CallRemoteFunction( "isValidTeleportPoint", "i", tppointid );

/*

	Функция:
		updateTeleportPoint(e_ptp,Float:x,Float:y,Float:z,Float:newx,Float:newy,Float:newz,Float:newFacingAngle,interior=0,virtual=0,bool:isvehicle=false) - Функция обновляет точку телепорта
	Параметры:
		teleportid - ID точки телепорта(Нужно указывать уже существующий ID, иначе вернет (-1))
		Float:x - Координата Х изначального места
		Float:y - Координата Y изначального места
		Float:z - Координата Z изначального места
		Float:newx - Координата Х конечного места
		Float:newy - Координата Y конечного места
		Float:newz - Координата Z конечного места
		Float:newFacingAngle - Угол поворота
		interior - ID интерьера(Необязательный параметр. По умолчания:0)
		virtual - ID вируального мира(Необязательный параметр. По умолчания:0)
		bool:isvehicle - Является ли это точка телепорта только для пешеходов(false) или можно еще и с машинами(true)
	Функция не возвращает специальных значений.

*/

stock updateTeleportPoint( e_ptp, Float:x, Float:y, Float:z, Float:newx, Float:newy, Float:newz, Float:newFacingAngle, interior=0, virtual=0, bool:isvehicle = false )
	return CallRemoteFunction( "destroyTeleportPoint", "ifffffffiib", e_ptp, x, y, z, newx, newy, newz, newFacingAngle, interior, virtual, isvehicle );

/*

	Функция:
		createVehicle3DtextLableEx(vehicleid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0) - прикрепить текст к машине
	Параметры:
		vehicleid - ID машины, к которой нужно прикрепить текст
		text[] - Текст(Text 3D)
		color - цвет текста
		Float:x - Координата Х
		Float:y - Координата Y
		Float:z - Координата Z 
		Float:DrawDistance - дистанция видимости
		virtual - виртуальный мир
		testLOS - проверка на видимость сквозь стены.
	Функция не возвращает специальных значений. Прикрепить можно только одну надпись к одной машине.

*/

stock createVehicle3DtextLableEx( vehicleid, text[], color, Float:x=0.0, Float:y=0.0, Float:z=0.7, Float:DrawDistance=100.0, virtual=0, testLOS=0 )
	return CallRemoteFunction( "createVehicle3DtextLableE", "isxffffii", vehicleid, text, color, x, y, z, DrawDistance, virtual, testLOS );

/*

	Функция:
		deleteVehicle3DtextLableEx(vehicleid)  - Удалить надпись прикрепленную к машине
	Параметры:
		playerid - ID игрока
	Функция не возвращает специальных значений.

*/

stock deleteVehicle3DtextLableEx( vehicleid )
	return CallRemoteFunction( "deleteVehicle3DtextLableEx", "i", vehicleid );

/*

	Функция:
		updateVehicle3DtextLableEx(vehicleid,color,text[]) -Обновляет текст прикрепленный к машине
	Параметры:
		vehicleid - ID Машины
		color - Цвет текста
		text[] - Текст
	Функция не возвращает специальных значений.

*/

stock updateVehicle3DtextLableEx( vehicleid, color, text[] )
	return CallRemoteFunction( "updateVehicle3DtextLableEx", "ixs", vehicleid, color, text );

/*

	Функция:
		GetVehicleSpeed(vehicleid) - Возвращает скорость машины.
	Параметры:
		vehicleid - ID машины которую нужно остановить.
	Функция не возвращает специальных значений.

*/

stock GetVehicleSpeed( vehicleid )
	return CallRemoteFunction( "GetVehicleSpeed", "i", vehicleid );

/*

	Функция:
		givePlayerWeaponEx(playerid,{id}) - выдает оружие игроку.
	Параметры:
		playerid - ID игрока, которому нужно выдать оружие
		{id} - иды оружий, выдаваемых игроку, через запятую.
	Функцию оптимизировал Stepashka, разработал sk47
	Функция не возвращает специальных значений.

*/

stock givePlayerWeaponEx( ... )
{ 
	if ( numargs() % 2 == 0 ) return 0; 
	for ( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i + 1 ) && getarg( i ) ) 
		{ 
			GivePlayerWeapon( getarg( 0 ), getarg( i ), getarg(i + 1) ); 
			i++; 
		} 
	} 
	return 1; 
}

/*

	Функция:
		addVehicleComponentEx(vehicleid, {id}) - Устанавливает машине указанные компоненты
	Параметры:
		vehicleid - ID машины, которой нужно установить компонент
		{id} - иды компонентов, устанавливаемых на машину через запятую
	Функция не возвращает специальных значений.

*/

stock addVehicleComponentEx( ... )
{ 
	if ( numargs() % 2 == 0 ) return 0; 
	for ( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i ) ) 
			AddVehicleComponent( getarg( 0 ), getarg( i ) ); 
	} 
	return 1; 
}

/*
	
	Функция:
		removeVehicleComponentEx(vehicleid, {id}) - Удаляет у машины указанные компоненты
	Параметры:
		vehicleid - ID машины, которой нужно удалить компонент
		{id} - иды компонентов, удаляемых с машины через запятую
	Функция не возвращает специальных значений.

*/

stock removeVehicleComponentEx( ... )
{ 
	if ( numargs() % 2 == 0 ) return 0; 
	for ( new i = 1; i < numargs(); i++ ) 
	{ 
		if ( getarg( i ) ) 
			RemoveVehicleComponent( getarg( 0 ), getarg( i ) ); 
	} 
	return 1; 
}

/*
	
	Функция:
		isAvtomatValid( avtomatid ) - Проверяет существует ли такой автомат на сервере
	Параметры:
		avtomatid - ID автомата
	1 - если существует, 0 - если нет

*/

stock isAvtomatValid( avtomatid )
	return CallRemoteFunction( "a_isAvtomatValid", "i", avtomatid );

/*
	
	Функция:
		updateAvtomat( avtomatid, newtype, newstring[], newcolor, Float:newx, Float:newy, Float:newz, Float:newrotx, Float:newroty, Float:newrotz, newvirtual, newprice ) - обновляет автомат с напитками или сигаретами
	Параметры:
		avtomatid - ID автомата
		newtype - тип автомата. Внизу инклюда есть список доступных автоматов.
		newstring[] - Текст над автоматом
		newcolor - цвет текста
		Float:newx - позиция Х автомата
		Float:newy - позиция Y автомата
		Float:newz - Позиция Z автомата
		Float:newrotx - Угол поворота относительно оси Х
		Float:newroty - Угол поворота относительно оси Y
		Float:newrotz  - Угол поворота относительно оси Z
		newvirtual - виртуальный мир, в котором находится автомат
		newprice - цена единицы, купленной в автомате

*/

stock updateAvtomat( avtomatid, newtype, newstring[], newcolor, Float:newx, Float: newy, Float: newz, Float: newrotx, Float: newroty, Float: newrotz, newvirtual = 0, newprice = 20 )	
	return CallRemoteFunction( "a_updateAvtomat", "iisxffffffii", avtomatid, newtype, newstring, newcolor, newx, newy, newz, newrotx, newroty, newrotz, newvirtual, newprice );

/*
	
	Функция:
		destroyAllAvtomats() - Удаляет все автоматы

*/

stock destroyAllAvtomats()
	return CallRemoteFunction( "a_destroyAllAvtomats" );

/*
	
	Функция:
		setConfigValue( slot, value ) - Изменяет конфигурацию запущенного сервера
	Параметры:
		slot - Пункт конфигурации. Внизу есть список.
		value - значение

*/

stock setConfigValue( slot, value )
	return CallRemoteFunction( "setConfigValue", "ii", slot, value );

/*
	
	Функция:
		getConfigValue( slot ) - узнает конфигурацию запущенного сервера
	Параметры:
		slot - Пункт конфигурации. Внизу есть список.

*/

stock getConfigValue( slot )
	return CallRemoteFunction( "getConfigValue", "i", slot );

/*
	
	Функция:
		setPlayerColorForAll( color ) - Устанавливает цвет для всех игроков
	Параметры:
		playerid - ID игрока

*/

stock setPlayerColorForAll( color )
	return CallRemoteFunction( "setPlayerColorForAll", "x", color );

/*
	
	Функция:
		killPlayer( playerid ) - убивает игрока
	Параметры:
		playerid - ID игрока

*/

stock killPlayer( playerid )
	return CallRemoteFunction( "killPlayer", "i", playerid );

/*
	
	Функция:
		showPM( playerid, targetid ) - Открывает диалоговое окно для личного сообщения
	Параметры:
		playerid - ID игрока, который отправляет
		targetid - ID игрока, который получает

*/

stock showPM( playerid, targetid )
	return CallRemoteFunction( "showPM", "ii", playerid, targetid );

/*
	
	Функция:
		showMessage( playerid, message[], time ) - показывает короткое сообщение в нижнем правом углу
	Параметры:
		playerid - ID игрока
		message[] - текст сообщения
		time - время, которое будет отображаться сообщение в секундах.

*/

stock showMessage( playerid, message[], time )
	return CallRemoteFunction( "showMessage", "isi", playerid, message[], time );

/*
	
	Функция:
		blockAccount( playerid, reason ) - блокирует аккаунт игрока
	Параметры:
		playerid - ID игрока
		reason - причина

*/

stock blockAccount( playerid, reason )
	return CallRemoteFunction( "BlockAccount", "is", playerid, reason );

/*
	
	Функция:
		CreateFire( Float:X,  Float:Y,  Float:Z,  Float:R ) - создает огонь
	Параметры:
		Float:X - позиция Х огня
		Float:Y - позиция Y огня
		Float:Z - позиция Z огня
		Float:R - Радиус действия огня(в котором игроки могут поулчить ожоги)
	Функция возвращает ID огня.

*/

stock CreateFire( Float: X, Float: Y, Float: Z, Float: R )
	return CallRemoteFunction( "CreateFire", "ffff", X,  Y,  Z,  R );

/*
	
	Функция:
		deleteFire( fireid ) - удаляет огонь
	Параметры:
		fireid - ID огня

*/

stock deleteFire( fireid )
	return CallRemoteFunction( "KillFire", "i", fireid );

/*
	
	Функция:
		getServerTime( &hour, &minute ) - узнает время на сервере
	Параметры:
		&hour - часы
		&minute - минуты
	Функция возрвщает значения в параметры данной функции.

*/

stock getServerTime( &hour, &minute )
{
	hour = CallRemoteFunction(  "getHour", "i", 1  );
	minute = CallRemoteFunction(  "getMinute", "i", 1  );
	return 1;
}

/*
	
	Функция:
		getPlayerName( playerid ) - узнает имя игрока
	Параметры:
		playerid - ID игрока
	Функция имя игрока

*/

stock getPlayerName( playerid )
{
	new pname[ MAX_PLAYER_NAME ];
	GetPlayerName( playerid, pname, MAX_PLAYER_NAME );
	return pname;
}

/*

	Функция:
		getWeaponName( weaponid ) - Узнает название оружия на русском
	Параметры:
		weaponid - ID оружия(0-50)
	Функция возвращает название оружия на русском языке

*/

stock getWeaponName( weaponid )
{
	new 
		weanr[ 50 ];
	switch ( weaponid ) 
	{
		case 0: weanr = "Кулаки";
		case 1: weanr = "Кастет";
		case 2: weanr = "Гольф клюшка";
		case 3: weanr = "Ментовская дубинка";
		case 4: weanr = "Нож";
		case 5: weanr = "Бейсбольная бита";
		case 6: weanr = "Лопата";
		case 7: weanr = "Бильярдный кий";
		case 8: weanr = "Катана";
		case 9: weanr = "Бензопила";
		case 10: weanr = "Фаллоимитатор";
		case 11: weanr = "Фаллоимитатор";
		case 12: weanr = "Вибратор";
		case 13: weanr = "Вибратор";
		case 14: weanr = "Букет цветов";
		case 15: weanr = "Трость";
		case 16: weanr = "Граната";
		case 17: weanr = "Слезоточивый газ";
		case 18: weanr = "Коктейль молотова";
		case 19: weanr = "Задавило";
		case 20: weanr = "Задавило";
		case 21: weanr = "ДжетПак";
		case 22: weanr = "Пистолет";
		case 23: weanr = "Пистолет с глушителем";
		case 24: weanr = "Пустынный орел";
		case 25: weanr = "Ружье";
		case 26: weanr = "Обрез";
		case 27: weanr = "Боевой дробовик";
		case 28: weanr = "МАК 10";
		case 29: weanr = "МП5";
		case 30: weanr = "Калашников";
		case 31: weanr = "М4";
		case 32: weanr = "ТЕК9";
		case 33: weanr = "Сельская Винтовка";
		case 34: weanr = "Снайперская винтовка";
		case 35: weanr = "РПГ";
		case 36: weanr = "Рокетная установка";
		case 37: weanr = "Огнемет";
		case 38: weanr = "Миниган";
		case 39: weanr = "Ранец";
		case 40: weanr = "Детонатор";
		case 41: weanr = "Балончик";
		case 42: weanr = "Огнетушитель";
		case 43: weanr = "Камера";
		case 44: weanr = "НайтГуглс";
		case 45: weanr = "ПНВ";
		case 46: weanr = "Парашут";
		case 47: weanr = "Машина";
		case 48: weanr = "НЕТ";
		case 49: weanr = "Задавил";
		case 50: weanr = "Винтом вертолета";
		default:weanr = "Unknown";
	}
	return weanr;
}

/*
	
	Функция:
		Cmd( cmd[] ) - сравнивает вводимую команду
	Параметры:
		cmd[] - введённная команда

*/

#define Cmd(%0) \ 
	if( strcmp( cmdtext, %0, true ) == 0 )

// Для осведомления! Не изменять!
#define STATE_NONE     ( 0 )
#define STATE_CONNECT  ( 1 )
#define STATE_REQCLASS ( 2 )
#define STATE_SPAWNED  ( 3 )
#define STATE_DEAD     ( 4 )
#define MAX_PASSWORD   ( 16 ) //Максимальная длина пароля. Увеличение значения может привести к CRASH сервера

//Для колбэка OnPlayerCheatDetected
#define CHEAT_SOBEIT   ( 1 ) // Подозрение на собейт у игрока
#define CHEAT_MONEY    ( 2 ) // Взлом денег
#define CHEAT_HEALTH   ( 3 ) // Взлом здоровья
#define CHEAT_ARMOUR   ( 4 ) // Взлом брони
#define CHEAT_TELEPORT ( 5 ) // Не законный телепорт
#define CHEAT_PING     ( 6 ) // Превышение Пинга
#define CHEAT_CUSE     ( 7 ) // Использование бага +С
#define CHEAT_BUNNYHOP ( 8 ) // Использование Банни-хоп

// reason'ы колбэка OnPlayerLogin
#define REASON_SUCCESSFUL   ( 1 ) // Игрок зашел в аккуант успешно
#define REASON_WRONGEPASS   ( 2 ) // Не верный пароль 
#define REASON_ACCBLOCKED   ( 3 ) // Аккуант заблокирован
#define REASON_NOTFOUNDED   ( -1 ) // Не найден аккуант

// action'ы колбэка OnPlayerAction
#define ACTION_BLOCK   ( 1 ) // При блокировки аккуанта
#define ACTION_AFK     ( 2 ) // При наказании за АФК

// Система автоматов.
#define AVTOMAT_TYPE_BEER   ( 0 ) // Автомат,  продающий пиво
#define AVTOMAT_TYPE_WINE   ( 1 ) // Автомат,  продающий вино
#define AVTOMAT_TYPE_SPRUNK ( 2 ) // Автомат,  продающий газировку
#define AVTOMAT_TYPE_CIGGY  ( 3 ) // Автомат,  продающий сигары

// Слоты Конфига
#define CONFIG_ANTICHEAT  	( 0 )
#define CONFIG_CARDEMAGE  	( 1 )
#define CONFIG_CHATID     	( 2 )
#define CONFIG_LOGACT     	( 3 )
#define CONFIG_DROPWEAPON 	( 4 )
#define CONFIG_ANTIADV    	( 5 )
#define CONFIG_MAXPING    	( 6 )
#define CONFIG_ANTICAPS   	( 7 )
#define CONFIG_ANTIFLOOD  	( 8 )
#define CONFIG_ANTIAFK    	( 9 )
#define CONFIG_GAMECLOCK  	( 10 )
#define CONFIG_SUPERARMOUR  ( 11 )
#define CONFIG_VEHICLEDAMAGE( 12 )
#define CONFIG_DAMAGEAKACOD	( 13 )
#define CONFIG_REGISTRATION	( 14 )
#define CONFIG_HEADSHOT		( 15 )
//#end define

// Существующие колбэки:

/*

	Колбэк:
		OnLoadModule( moduleid ) - вызывается при подключении модуля.
	Параметры:
		moduleid - ID подключенного модуля

*/

forward OnLoadModule( moduleid );

/*

	Колбэк:
		CheckModule( tmp ) - проверяет является подключаемый скрипт модулем.
	Параметры:
		tmp - ничего не значащий параметр. Возвращает всегда 1.

*/

forward CheckModule( tmp );

/*

	Колбэк:
		OnPlayerSave( playerid ) - вызывается когда сохраняется аккаунт игрока
	Параметры:
		playerid - ID игрока

*/

forward OnPlayerSave( playerid );

/*

	Колбэк:
		OnPlayerLogin( playerid, reason ) - вызывается когда игрок пытается войти на сервер под своим аккаунтом, при регистрации вызывается тоже..
	Параметры:
		playerid - ID игрока
		reason - ответ сервера да действие (см. выше)

*/

forward OnPlayerLogin( playerid, reason );

/*

	Колбэк:
		OnPlayerCheatDetected( playerid, cheatid ) - вызывается когда античит замечает использование чита
	Параметры:
		playerid - ID игрока
		cheatid - ID чита (см. выше)

*/

forward OnPlayerCheatDetected( playerid, cheatid );

/*

	Колбэк:
		RespawnVehicle( vehicleid ) - вызывается когда машина респавнится на свое место
	Параметры:
		vehicleid - ID машины

*/

forward RespawnVehicle( vehicleid );

/*

	Колбэк:
		OnPlayerDrink( playerid ) - вызывается когда игрок пъет напитки(автоматы)
	Параметры:
		playerid - ID игрока

*/

forward OnPlayerDrink( playerid );

/*

	Колбэк:
		OnPlayerSmoke( playerid ) - вызывается когда игрок курит сигареты(автоматы)
	Параметры:
		playerid - ID игрока

*/

forward OnPlayerSmoke( playerid );

/*

	Колбэк:
		OnPlayerBuyCigarettes( playerid, avtomatid, price ) - вызывается когда игрок покупает сигареты
	Параметры:
		playerid - ID игрока
		avtomatid - ID автомата
		price - цена сигарет

*/

forward OnPlayerBuyCigarettes( playerid, avtomatid, price );

/*

	Колбэк:
		OnPlayerBuyDrink( playerid, avtomatid, price ) - вызывается когда игрок покупает напитки
	Параметры:
		playerid - ID игрока
		avtomatid - ID автомата
		price - цена напитка

*/

forward OnPlayerBuyDrink( playerid, avtomatid, price );

/*

	Колбэк:
		OnPlayerPM( playerid, targetid, msg[] ) - вызывается когда игрок отправляет/получает личное сообщение
	Параметры:
		playerid - ID игрока, который отправляет Личное Сообщение
		targetid - ID игрока, который получает Личное Сообщение
		msg[] - текст сообщения

*/

forward OnPlayerPM( playerid, targetid, msg[] );

/*

	Колбэк:
		OnPlayerAction( targetid, action, reason[] ) - вызывается когда у игрока изменяется его состояние
	Параметры:
		targetid - ID игрока, у которого изменилось состояние
		action - новое состояние(см. выше)
		reason[] - причина смерти

*/

forward OnPlayerAction( targetid, action, reason[] );

/*

	Колбэк:
		onPlayerSuicide( playerid, reason ) - вызывается при самоубийстве игрока
	Параметры:
		playerid - ID игрока, который самоубился
		reason - причина смерти

*/

forward onPlayerSuicide( playerid, reason );

/*

	Колбэк:
		onPlayerKill( playerid, victimid, reason ) - вызывается при убийстве
	Параметры:
		playerid - ID игрока, который убил
		victimid - жертва
		reason - причина смерти

*/

forward onPlayerKill( playerid, victimid, reason );

/*

	Колбэк:
		onPlayerShoot( playerid, weaponid ) - вызывается при стрельбе
	Параметры:
		playerid - ID игрока который стреляет
		weaponid - ID оружия из которого стреляют

*/

forward onPlayerShoot( playerid, weaponid );
//Last Modificate - 1:00 10.02.2014