
	                                                                in 2012
*/

// Includes --------------------------------------------------------------------
#include <a_samp>
#include <YSI\y_timers>
#include <s3Zone.pwn>

//------------------------------------------------------------------------------



// WARNING: Define your function to get player team ---------.------------------
stock GetTeam(playerid)
	return gTeam[ playerid ];           // change playerid to variable with your team ID (example 'return pInfo[playerid][Team];')




// Defines ---------------------------------------------------------------------
#define FOREACH(%0,%1)  	for(new %0=0;%0<%1;%0++) if(IsPlayerConnected(%0))

#define MAX_ATTACKERS   2           // Max attackers need to start the gang war (this attackers must be on the same turf).

//------------------------------------------------------------------------------
enum s3_ENUM_DATA
	{
        P_Attacker,
		P_Protector
	};

new
	S_AttackTeam = -1,
	S_ProtectTeam = -1,
	S_Protectors = 0,
	S_Attackers = 0,
	G_GangZoneInWar = -1,
	G_WarStarted = false,
	T_GangZone
	;

new
	s3_DATA[ MAX_PLAYERS ][ s3_ENUM_DATA ],
	NEW_ZONE[ MAX_PLAYERS ],
	OLD_ZONE[ MAX_PLAYERS ]
	;

forward s_OnPlayerDisconnect(playerid);
public s_OnPlayerDisconnect(playerid)
{
	if (G_WarStarted)
	{
	 	if (IsPlayerAsProtector(playerid))
		{
		   	S_Protectors--;
		    s3_DATA[ playerid ][ P_Protector ] = 0;
		}
		if (IsPlayerAsAttacker(playerid))
		{
		    S_Attackers--;
		    s3_DATA[ playerid ][ P_Attacker ] = 0;
		}
	}
	return 1;
}
forward s_OnPlayerDeath(playerid);
public s_OnPlayerDeath(playerid)
{
    if (G_WarStarted)
	{
	 	if (IsPlayerAsProtector(playerid))
		{
		   	S_Protectors--;
		    s3_DATA[ playerid ][ P_Protector ] = 0;
		}
		if (IsPlayerAsAttacker(playerid))
		{
		    S_Attackers--;
		    s3_DATA[ playerid ][ P_Attacker ] = 0;
		}
	}
	return 1;
}

forward OnPlayerStartGangWar(playerid, zoneid);
public OnPlayerStartGangWar(playerid, zoneid)
{
	// Start flash gang zone
	SetGangZoneFlash(zoneid);

	G_WarStarted = true;

	S_ProtectTeam = GetGangZoneOwner(zoneid);
	S_AttackTeam = GetTeam(playerid);
	G_GangZoneInWar = zoneid;
	
	/*
		---------------------------------------------------------

		HERE YOU CAN PASTE WHATEVER YOU WANT. WHAT HAVE TO HAPPEN
		WHEN GANG WAR BEGIN.
		
		Example - Send all attacker message about War or protectors.
		
		---------------------------------------------------------
	*/

	T_GangZone = SetTimer("OnGangZoneWarFinish", 1000*30, false);
}

stock SetPlayerAsProtector(playerid)
{
	s3_DATA[ playerid ][ P_Protector ] = 1;
	S_Protectors++;
	return 1;
}

stock IsPlayerAsProtector(playerid)
{
	if (s3_DATA[ playerid ][ P_Protector ]) return 1;
	else return 0;
}

stock SetPlayerAsAttacker(playerid)
{
	s3_DATA[ playerid ][ P_Attacker ] = 1;
	S_Attackers++;
	return 1;
}

stock IsPlayerAsAttacker(playerid)
{
	if (s3_DATA[ playerid ][ P_Attacker ]) return 1;
	else return 0;
}

forward OnGangZoneWarFinish();
public OnGangZoneWarFinish()
{
    if (S_Attackers > 0)
    {
		if (S_Protectors == 0)
		{
		    // enemies take out the zone
		    SetGangZoneOwnerTeam(G_GangZoneInWar, S_AttackTeam);

		    FOREACH(playerid, MAX_PLAYERS)
			{
				if (GetTeam(playerid) == S_AttackTeam)
    			{
		    		GameTextForPlayer(playerid, "~g~THIS HOOD IS YOURS!", 1000*3, 5);
				}
				if (GetTeam(playerid) == S_ProtectTeam)
				{
                    GameTextForPlayer(playerid, "~r~YOU'VE LOST THIS HOOD", 1000*3, 5);
				}
			}
		}
	}
	else
	{
		FOREACH(playerid, MAX_PLAYERS)
		{
			if (GetTeam(playerid) == S_ProtectTeam)
			{
	    		GameTextForPlayer(playerid, "~g~YOU PROTECTED YOUR GANG ZONE", 1000*3, 5);
			}
		}
	}
	EndGangWar();
}

Timer:GZCallback[1000]()
{
	FOREACH(i, MAX_PLAYERS)
	{
	    new zoneid = GetPlayerGangZone(i);
	    if (IsPlayerInAnyGangZone(i))
	    {
			if (NEW_ZONE[ i ] != zoneid)    // if zone has changed
			{
				OLD_ZONE[ i ] = NEW_ZONE[ i ];
			 	NEW_ZONE[ i ] = zoneid;
			}

		    // if new zone isn't same as old
		    if (NEW_ZONE[ i ] != OLD_ZONE[ i ])
			{
   				OnPlayerChangeGangZone(i);
			}
		}
		else
		{
			if(NEW_ZONE[ i ] == -1)
			{
				if (s3_DATA[ i ][ P_Attacker ])
				{
					s3_DATA[ i ][ P_Attacker ] = 0;
					S_Attackers--;

					GameTextForPlayer(i, "~r~YOU LEFT FROM GANG WAR", 1000*3, 5);

					if (S_Attackers <= 0)
					{
						OnGangZoneWarFinish();

						SendClientMessage(i, -1, "Gangwar has ended!");
					}
				}
				if (s3_DATA[ i ][ P_Protector ])
				{
					s3_DATA[ i ][ P_Protector ] = 0;
					S_Protectors--;

					GameTextForPlayer(i, "~r~YOU LEFT FROM GANG WAR", 1000*3, 5);

					if (S_Protectors <= 0)
					{
						OnGangZoneWarFinish();

						SendClientMessage(i, -1, "Gangwar has ended!");
					}
				}
			}
		}
  	}
}

forward OnPlayerChangeGangZone(playerid);
public OnPlayerChangeGangZone(playerid)
{
	// If in this zone run war
	if (G_WarStarted)
	{
	    if (s3_DATA[ playerid ][ P_Protector ] || s3_DATA[ playerid ][ P_Attacker ])
	    {
			if (NEW_ZONE[ playerid ] != G_GangZoneInWar)
			{
		    	if (s3_DATA[ playerid ][ P_Attacker ])
				{
					s3_DATA[ playerid ][ P_Attacker ] = 0;
					S_Attackers--;
					
					GameTextForPlayer(playerid, "~r~YOU LEFT FROM GANG WAR", 1000*3, 5);
					
					if (S_Attackers <= 0)
					{
						OnGangZoneWarFinish();
						
						SendClientMessage(playerid, -1, "Gangwar has ended!");
					}
				}
				if (s3_DATA[ playerid ][ P_Protector ])
				{
					s3_DATA[ playerid ][ P_Protector ] = 0;
					S_Protectors--;
					
					GameTextForPlayer(playerid, "~r~YOU LEFT FROM GANG WAR", 1000*3, 5);
					
					if (S_Protectors <= 0)
					{
						OnGangZoneWarFinish();
						
						SendClientMessage(playerid, -1, "Gangwar has ended!");
					}
				}
			}
		}
		else
		{
			if (GetTeam(playerid) == S_AttackTeam)	SetPlayerAsAttacker(playerid);
			if (GetTeam(playerid) == S_ProtectTeam) 	SetPlayerAsProtector(playerid);
		}
	}
	else
	{
	    if (GetTeam(playerid) != GetGangZoneOwner(NEW_ZONE[ playerid ]))
	    {
			if (!s3_DATA[ playerid ][ P_Attacker ])
			{
		        SetPlayerAsAttacker(playerid);

		        // if attackers is more than MAX_ATTACKERS
				if (S_Attackers >= MAX_ATTACKERS)
				{
				    OnPlayerStartGangWar(playerid, NEW_ZONE[ playerid ]);
                	GameTextForPlayer(playerid, "~r~YOU START GANG WAR", 1000*3, 5);
                }
			}
		}
	}
}

stock EndGangWar()
{
	FOREACH(playerid, MAX_PLAYERS)
	{
		s3_DATA[ playerid ][ P_Attacker ] = 0;
		s3_DATA[ playerid ][ P_Protector ] = 0;
		GangZoneStopFlashForPlayer(playerid, G_GangZoneInWar);
	}

	S_AttackTeam = -1;
	S_ProtectTeam = -1;

	S_Protectors = 0;
	S_Attackers = 0;

	G_GangZoneInWar = -1;

	G_WarStarted = false;
	KillTimer(T_GangZone);
}