/*
        @author:        s3rious
        @name:      s3Zone - Gang Zone Functions
        @ver:       1.2
 
                                                                        in 2012
*/
// Includes --------------------------------------------------------------------
#include < A_SAMP >
 
// Defines ---------------------------------------------------------------------
#define MAX_GANGZONES  500              // You can change it
#define MAX_GZ_TEAMS    20
 
enum GZ_ENUM_DATA
{
        Zone_id = 0,
        Owner_team,
        Float:MinX,
        Float:MinY,
        Float:MaxX,
        Float:MaxY
}
 
new
        s3Zone_g_Zone[ MAX_GANGZONES ][ GZ_ENUM_DATA ],
        s3Zone_g_Color[ MAX_GZ_TEAMS ],
        s3Zone_g_GangZones
        ;
 
//------------------------------------------------------------------------------
stock CreateGangZone(Float:minx, Float:miny, Float:maxx, Float:maxy, s_Owner, colorzone)
{
        if (s3Zone_g_GangZones < MAX_GANGZONES)
        {
                s3Zone_g_Zone[ s3Zone_g_GangZones ][ Zone_id ] = GangZoneCreate(minx, miny, maxx, maxy);
                s3Zone_g_Zone[ s3Zone_g_GangZones ][ Owner_team ] = s_Owner;
                s3Zone_g_Zone[ s3Zone_g_GangZones ][ MinX ] = minx;
                s3Zone_g_Zone[ s3Zone_g_GangZones ][ MinY ] = miny;
                s3Zone_g_Zone[ s3Zone_g_GangZones ][ MaxX ] = maxx;
                s3Zone_g_Zone[ s3Zone_g_GangZones ][ MaxY ] = maxy;
 
                s3Zone_g_Color[ s_Owner ] = colorzone;
 
                s3Zone_g_GangZones++;
                return s3Zone_g_GangZones;
        }
        else
        {
            printf("s3Zone Error: You exceed maximum gangzones \ %d | %d ", s3Zone_g_GangZones, MAX_GANGZONES);
            return 0;
        }
}
 
//------------------------------------------------------------------------------
stock bool:IsPlayerInGangZone(playerid, zoneid)
{
    if(!s3Zone_g_GangZones) return false;
 
    new
                Float:PosX,
                Float:PosY,
                Float:PosZ
        ;
 
    GetPlayerPos(playerid, PosX, PosY, PosZ);
    if((s3Zone_g_Zone[ zoneid ][ MinX ] < PosX) && (s3Zone_g_Zone[ zoneid ][ MaxX ] > PosX) && (s3Zone_g_Zone[ zoneid ][ MinY ] < PosY) && (s3Zone_g_Zone[ zoneid ][ MaxY ] > PosY)) return true;
    else return false;
}
 
//------------------------------------------------------------------------------
stock bool:IsPlayerInAnyGangZone(playerid)
{
        if(GetPlayerGangZone(playerid) != 0) return true;
        return false;
}
 
//------------------------------------------------------------------------------
stock SetGangZoneFlash(zoneid)
{
        GangZoneFlashForAll(zoneid, 0xFF000096);
        return 1;
}
 
//------------------------------------------------------------------------------
stock SetGangZoneOwnerTeam(zoneid, n_Owner)
{
        GangZoneHideForAll(zoneid);
        GangZoneShowForAll(zoneid, s3Zone_g_Color[ n_Owner ]);
 
        s3Zone_g_Zone[ zoneid ][ Owner_team ] = n_Owner;
        return 1;
}
 
//------------------------------------------------------------------------------
stock GetPlayerGangZone(playerid)
{
        if(!s3Zone_g_GangZones) return 0;
 
        new
                s3Zone_l_Zone   =       0
        ;
 
        while(s3Zone_l_Zone < s3Zone_g_GangZones)
        {
            s3Zone_l_Zone++;
            if(IsPlayerInGangZone(playerid, s3Zone_l_Zone))
                {
                        return s3Zone_l_Zone;
                }
        }
        return 0;
}
 
//------------------------------------------------------------------------------
stock GetGangZoneOwner(zoneid)
{
        return s3Zone_g_Zone[ zoneid ][ Owner_team ];
}