// Simple script functions.   ,      pawn-
// : 31.12.2010 11:45
#if defined _easyfuncs_included
	#endinput
#endif
#define _easyfuncs_included

#define vehEngine_on (1)
#define vehEngine_off (0)
#define vehEngine_not_use (-1)
#define vehLights_on (1)
#define vehLights_off (0)
#define vehLights_not_use (-1)
#define vehAlarm_on (1)
#define vehAlarm_off (0)
#define vehAlarm_not_use (-1)
#define vehDoors_on (1)
#define vehDoors_off (0)
#define vehDoors_not_use (-1)
#define vehBonnet_on (1)
#define vehBonnet_off (0)
#define vehBonnet_not_use (-1)
#define vehBoot_on (1)
#define vehBoot_off (0)
#define vehBoot_not_use (-1)
#define vehObjective_on (1)
#define vehObjective_off (0)
#define vehObjective_not_use (-1)

static checkpointid;

static VehNames[][] = {
	 "Landstalker",
	   "Bravura",
	 "Buffalo",
	 "Linerunner",
	"Pereniel",
	 "Sentinel",
	 "Dumper",
	"Firetruck",
	"Trashmaster",
	 "Stretch",
	 "Manana",
	 "Infernus",
	 "Voodoo",
	  "Pony",
	 "Mule",
	 "Cheetah",
	"Ambulance",
	"Leviathan",
	 "Moonbeam",
	"Esperanto",
	 "Taxi",
	"Washington",
	"Bobcat",
	 "Mr Whoopee",
	"BF Injection",
	 "Hunter",
	 "Premier",
	"Enforcer",
	 "Securicar",
	 "Banshee",
	"Predator",
	"Bus",
	 "Rhino",
	"Barracks",
	"Hotknife",
	 "Trailer",
	 "Previon",
	"Coach",
	 "Cabbie",
	  "Stallion",
	 "Rumpo",
	 "RC Bandit",
	 "Romero",
	 "Packer",
	"Monster Truck",
	 "Admiral",
	"Squalo",
	"Seasparrow",
	 "Pizzaboy",
	"Tram",
	"Trailer",
	 "Turismo",
	"Speeder",
	 "Reefer",
	 "Tropic",
	"Flatbed",
	 "Yankee",
	 "Caddy",
	"Solair",
	"Berkley's RC Van",
	 "Skimmer",
	"PCJ-600",
	 "Faggio",
	 "Freeway",
	 "RC Baron",
	"RC Raider",
	 "Glendale",
	"Oceanic",
	"Sanchez",
	 "Sparrow",
	"Patriot",
	 "Quad",
	"Coastguard",
	"Dinghy",
	"Hermes",
	"Sabre",
	 "Rustler",
	 "ZR-350",
	"Walton",
	"Regina",
	"Comet",
	 "BMX",
	"Burrito",
	 "Camper",
	 "Marquis",
	"Baggage",
	"Dozer",
	"Maverick",
	"News Chopper",
	"Rancher",
	"FBI Rancher",
	"Virgo",
	 "Greenwood",
	"Jetmax",
	 "Hotring",
	"Sandking",
	"Blista Compact",
	 "Police Maverick",
	"Boxville",
	"Benson",
	"Mesa",
	"RC Goblin",
	"Hotring Racer",
	 "Hotring Racer",
	"Bloodring Banger",
	 "Rancher",
	"Super GT",
	"Elegant",
	 "Journey",
	"Bike",
	"Mountain Bike",
	 "Beagle",
	"Cropdust",
	 "Stunt",
	 "Tanker",
	"RoadTrain",
	"Nebula",
	"Majestic",
	"Buccaneer",
	"Shamal",
	"Hydra",
	"FCR-900",
	 "NRG-500",
	"HPV1000",
	 "Cement Truck",
	"Tow Truck",
	 "Fortune",
	 "Cadrona",
	 "FBI Truck",
	 "Willard",
	 "Forklift",
	  "Tractor",
	 "Combine",
	 "Feltzer",
	 "Remington",
	"Slamvan",
	"Blade",
	"Freight",
	"Streak",
	"Vortex",
	 "Vincent",
	"Bullet",
	"Clover",
	"Sadler",
	 "Firetruck",
	 "Hustler",
	 "Intruder",
	 "Primo",
	"Cargobob",
	 "Tampa",
	 "Sunrise",
	"Merit",
	 "Utility",
	 "Nevada",
	 "Yosemite",
	 "Windsor",
	"Monster Truck",
	"Monster Truck",
	"Uranus",
	"Jester",
	"Sultan",
	"Stratum",
	"Elegy",
	"Raindance",
	"RC Tiger",
	"Flash",
	"Tahoma",
	"Savanna",
	"Bandito",
	"Freight",
	 "Trailer",
	"Kart",
	"Mower",
	"Duneride",
	 "Sweeper",
	"Broadway",
	"Tornado",
	"AT-400",
	"DFT-30",
	"Huntley",
	"Stafford",
	"BF-400",
	"Newsvan",
	 "Tug",
	"Trailer",
	"Emperor",
	"Wayfarer",
	 "Euros",
	"Hotdog",
	"Club",
	 "Trailer",
	"Trailer",
	"Andromada",
	"Dodo",
	"RC Cam",
	"Launch",
	 "Police (LSPD)",
	"Police (SFPD)",
	"Police (LVPD)",
	"Police Ranger",
	"Picador",
	"S.W.A.T. Van",
	"Alpha",
	"Phoenix",
	"Glendale",
	"Sadler",
	"Luggage Trailer",
	 "Luggage Trailer",
	 "Stair Trailer",
	 "Boxville",
	 "Farm Plow",
	"Utility Trailer"
};

enum
{
	NOT_USE,
	USE
}

enum skill
{
PISTOL,			
PISTOL_SILENCED,		
DESERT_EAGLE,		
SHOTGUN,				
SAWNOFF_SHOTGUN,		
SPAS12_SHOTGUN,		
MICRO_UZI,			
MP5,					
AK47,				
M4,					
SNIPERRIFLE			
};
static PlayerSkill[MAX_PLAYERS][skill];
static Text3D:label[MAX_PLAYERS];
static textLable[MAX_PLAYERS];
static Text3D:vlabel[MAX_PLAYERS];
static vtextLable[MAX_PLAYERS];
static e_vint[MAX_VEHICLES];

stock setPlayerSkillLevel(playerid,types,skil)
{
	SetPlayerSkillLevel(playerid, types, skil);
	switch(types)
	{
		case 0:PlayerSkill[playerid][PISTOL]=skil;
		case 1:PlayerSkill[playerid][PISTOL_SILENCED]=skil;
		case 2:PlayerSkill[playerid][DESERT_EAGLE]=skil;
		case 3:PlayerSkill[playerid][SHOTGUN]=skil;
		case 4:PlayerSkill[playerid][SAWNOFF_SHOTGUN]=skil;
		case 5:PlayerSkill[playerid][SPAS12_SHOTGUN]=skil;
		case 6:PlayerSkill[playerid][MICRO_UZI]=skil;
		case 7:PlayerSkill[playerid][MP5]=skil;
		case 8:PlayerSkill[playerid][AK47]=skil;
		case 9:PlayerSkill[playerid][M4]=skil;
		case 10:PlayerSkill[playerid][SNIPERRIFLE]=skil;
	}
	return -1;
}

stock setPlayerSkillLevelToAll(types,skil)
{

	for(new i=GetMaxPlayers();i>=0;--i)
	{
		if(IsPlayerConnected(i))
		{
			setPlayerSkillLevel(i,types,skil);
		}
	}
	return -1;
}

stock getPlayerSkillLevel(playerid,types)
{
	switch(types)
	{
	case 0:return PlayerSkill[playerid][PISTOL];
	case 1:return PlayerSkill[playerid][PISTOL_SILENCED];
	case 2:return PlayerSkill[playerid][DESERT_EAGLE];
	case 3:return PlayerSkill[playerid][SHOTGUN];
	case 4:return PlayerSkill[playerid][SAWNOFF_SHOTGUN];
	case 5:return PlayerSkill[playerid][SPAS12_SHOTGUN];
	case 6:return PlayerSkill[playerid][MICRO_UZI];
	case 7:return PlayerSkill[playerid][MP5];
	case 8:return PlayerSkill[playerid][AK47];
	case 9:return PlayerSkill[playerid][M4];
	case 10:return PlayerSkill[playerid][SNIPERRIFLE];
	}
	return -1;
}


stock getGameModeText()
{
	new str[64]; 
	GetServerVarAsString("gamemodetext", str, sizeof(str)); 
	return str;
}

stock getNumPlayersOnline()
{
	new kolvo;
	for(new i=GetMaxPlayers();i>=0;--i)
	{
		if(IsPlayerConnected(i)&&!IsPlayerNPC(i))kolvo++;
	}
	return kolvo;
}

stock getGravity()
{
      new str[64]; 
      GetServerVarAsString("gravity", str, sizeof(str)); 
      return str; 
}

stock getServerWeather()
{
      new str; 
      GetServerVarAsInt("weather");
      return str; 
}

stock getPlayerName(playerid)
{
	new pname[MAX_PLAYER_NAME];
	GetPlayerName(playerid,pname,sizeof(pname));
	return pname;
}

stock Float:getPlayerHealth(playerid)
{
	new Float:phealth;
	GetPlayerHealth(playerid,phealth);
	return phealth;
}

stock givePlayerHealth(playerid,Float:health)
{
	if(getPlayerHealth(playerid)+health>=100)return SetPlayerHealth(playerid,100);
	new Float:phealth;
	GetPlayerHealth(playerid,phealth);
	SetPlayerHealth(playerid,phealth+health);
	return 1;
}

stock Float:getPlayerArmour(playerid)
{
	new Float:armour;
	GetPlayerArmour(playerid,armour);
	return armour;
}

stock givePlayerArmour(playerid,Float:armour)
{
	if(getPlayerArmour(playerid)+armour>=100)return SetPlayerArmour(playerid,100.0);
	new Float:parmour;
	GetPlayerArmour(playerid,parmour);
	SetPlayerArmour(playerid,parmour+armour);
	return 1;
}

stock getPlayerIP(playerid)
{
	new pIP[16];
	GetPlayerIp(playerid,pIP,sizeof(pIP));
	return pIP;
}

stock getPlayerID(name[])
{
	for(new i=GetMaxPlayers();i>=0;--i)
	{
		if(IsPlayerConnected(i))
		{
			new pname[MAX_PLAYER_NAME];
			GetPlayerName(i,pname,sizeof(pname));
			if(!strcmp(name,pname,true))
			{
				return i;
			}
		}
	}
	return INVALID_PLAYER_ID;
}

stock sendMessageToAdmins(color,msg[])
{
	for(new i=GetMaxPlayers();i>=0;--i)
	{
		if(IsPlayerConnected(i)&&IsPlayerAdmin(i))
		{
			SendClientMessage(i,color,msg);
		}
	}
	return 1;
}
stock clearChatToPlayer(playerid)
{
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	SendClientMessage(playerid,0xffffff," ");
	return 1;
}
stock clearChatToAll()
{
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	SendClientMessageToAll(0xfffffff," ");
	return 1;
}

stock sendPersonalMessage(playerid,targetid,color,string[])
{
	if(IsPlayerConnected(playerid)&&IsPlayerConnected(targetid))
	{
		new str[128];
		format(str,sizeof(str),"*PM-sent to:%s(ID:%i): %s",getPlayerName(targetid),targetid,string);
		SendClientMessage(playerid,color,str);
		format(str,sizeof(str),"*PM-received from:%s(ID:%i): %s",getPlayerName(playerid),playerid,string);
		SendClientMessage(targetid,color,str);
		return 1;
	}
	return 0;
}

stock getPlayerInfo(playerid,&Float:x,&Float:y,&Float:z,&Float:FacingAngle,&Float:health,&Float:armour,&pstate,&interior,&virtual,&skin,&team,&ping,&color)
{
	if(IsPlayerConnected(playerid))
	{
		GetPlayerPos(playerid,x,y,z);
		GetPlayerFacingAngle(playerid,FacingAngle);
		GetPlayerHealth(playerid,health);
		GetPlayerArmour(playerid,armour);
		pstate=GetPlayerState(playerid);
		interior=GetPlayerInterior(playerid);
		virtual=GetPlayerVirtualWorld(playerid);
		skin=GetPlayerSkin(playerid);
		team=GetPlayerTeam(playerid);
		ping=GetPlayerPing(playerid);
		color=GetPlayerColor(playerid);
		return 1;
	}
	return INVALID_PLAYER_ID;
}


stock setPlayerColorForAll(color)
{
	for(new i=GetMaxPlayers();i>=0;--i)
	{
		if(IsPlayerConnected(i))
		{
			SetPlayerColor(i,color);
		}
	}
	return 1;
}


stock createPlayer3DtextLableEx(playerid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0)
{
	if(!IsPlayerConnected(playerid)&&textLable[playerid]==USE)return 0;
	label[playerid]=Create3DTextLabel(text,color,0.0,0.0,0.0,DrawDistance,virtual,testLOS);
	Attach3DTextLabelToPlayer(label[playerid], playerid, x, y, z);
	textLable[playerid]=USE;
	return 1;
}

stock deletePlayer3DtextLableEx(playerid)
{
	if(!IsPlayerConnected(playerid)&&textLable[playerid]==NOT_USE)return 0;
	Delete3DTextLabel(label[playerid]);
	textLable[playerid]=NOT_USE;
	return 1;
}

stock updatePlayer3DtextLableEx(playerid,color,text[])
{
	if(!IsPlayerConnected(playerid)&&textLable[playerid]==NOT_USE)return 0;
	Update3DTextLabelText(label[playerid], color, text);
	return 1;
}

stock getWeaponSlot(weaponid)
{
	switch(weaponid)
	{
		case 0,1:return 0;
		case 2..9: return 1;
		case 22,23,24:return 2;
		case 25,26,27:return 3;
		case 28,29,32:return 4;
		case 30,31:return 5;
		case 33,34:return 6;
		case 35,36,37,38:return 7;
		case 16,17,18,39:return 8;
		case 41,42,43:return 9;
		case 10..15:return 10;
		case 44,45,46:return 11;
		default:return -1;
	}
	return -1;
}

stock setPlayerPosEx(playerid,Float:x,Float:y,Float:z,Float:FacingAngle,interior=0,virtual=0)
{
	SetPlayerPos(playerid,x,y,z);
	SetPlayerFacingAngle(playerid,FacingAngle);
	SetPlayerInterior(playerid,interior);
	SetPlayerVirtualWorld(playerid,virtual);
	return 1;
}
stock getPlayerPosEx(playerid,&Float:x,&Float:y,&Float:z,&Float:FacingAngle,&interior,&virtual)
{
	GetPlayerPos(playerid,x,y,z);
	GetPlayerFacingAngle(playerid,FacingAngle);
	interior=GetPlayerInterior(playerid);
	virtual=GetPlayerVirtualWorld(playerid);
	return 1;
}

stock isPickupWeaponModel(modelid)
{
	return (modelid>320&&modelid<372)?(1):(0);
}
stock getWeaponName(weaponid)
{
	new weanr[50];
	switch (weaponid) {
	case 0: weanr = "";
	case 1: weanr = "";
	case 2: weanr = " ";
	case 3: weanr = " ";
	case 4: weanr = "";
	case 5: weanr = " ";
	case 6: weanr = "";
	case 7: weanr = " ";
	case 8: weanr = "";
	case 9: weanr = "";
	case 10: weanr = "";
	case 11: weanr = "";
	case 12: weanr = "";
	case 13: weanr = "";
	case 14: weanr = " ";
	case 15: weanr = "";
	case 16: weanr = "";
	case 17: weanr = " ";
	case 18: weanr = " ";
	case 19: weanr = "";
	case 20: weanr = "";
	case 21: weanr = "";
	case 22: weanr = "";
	case 23: weanr = "  ";
	case 24: weanr = " ";
	case 25: weanr = "";
	case 26: weanr = "";
	case 27: weanr = " ";
	case 28: weanr = " 10";
	case 29: weanr = "5";
	case 30: weanr = "";
	case 31: weanr = "4";
	case 32: weanr = "9";
	case 33: weanr = " ";
	case 34: weanr = " ";
	case 35: weanr = "";
	case 36: weanr = " ";
	case 37: weanr = "";
	case 38: weanr = "";
	case 39: weanr = "";
	case 40: weanr = "";
	case 41: weanr = "";
	case 42: weanr = "";
	case 43: weanr = "";
	case 44: weanr = "";
	case 45: weanr = "";
	case 46: weanr = "";
	case 47: weanr = "";
	case 48: weanr = "";
	case 49: weanr = "";
	case 50: weanr = " ";
	default:weanr = "Unknown";
	}
	return weanr;
}

stock loadFromFileAsInt(file[],stroka[])
{
	new load;
	new File:sfile,parametr[256],value[255],cmpValue[255];
	sfile=fopen(file,io_read);
	while(fread(sfile,cmpValue))
	{
		for(new i = 0, j = strlen(cmpValue); i < j; i++) if(cmpValue[i] == '\n' || cmpValue[i] == '\r') cmpValue[i] = '\0';
		parametr = strtoks(cmpValue,0);
		value = strtoks(cmpValue,(strlen(parametr)+1));
		if(strcmp(parametr,stroka,true)==0)load=strval(value);
	}
	fclose(sfile);
	return load;
}

stock saveInFileAsInt(file[],stroka[],value)
{
	new File:sfile,cmpValue[255];
	sfile=fopen(file,io_append);
	format(cmpValue,sizeof(cmpValue),"%s %i\r\n",stroka,value);
	fwrite(sfile,cmpValue);
	fclose(sfile);
	return 1;
}

stock saveInFileAsFloat(file[],stroka[],Float:value)
{
	new File:sfile,cmpValue[255];
	sfile=fopen(file,io_append);
	format(cmpValue,sizeof(cmpValue),"%s %f\r\n",stroka,value);
	fwrite(sfile,cmpValue);
	fclose(sfile);
	return 1;
}

stock saveInFileAsString(file[],stroka[],value[])
{
	new File:sfile,cmpValue[255];
	sfile=fopen(file,io_append);
	format(cmpValue,sizeof(cmpValue),"%s %s\r\n",stroka,value);
	fwrite(sfile,cmpValue);
	fclose(sfile);
	return 1;
}

stock getFileInfo(filename[],&lines,&bytes)
{
	new count,File:file,idx[100];
	if((file=fopen(filename,io_read)))
	{
		while((fread(file,idx)))
		{
			count++;
		}
		fclose(file);
		lines=count;
		bytes=flength(file);
		return 1;
	}
	return 0;
}

stock Float:loadFromFileAsFloat(file[],stroka[])
{
	new Float:load;
	new File:sfile,parametr[256],value[255],cmpValue[255];
	sfile=fopen(file,io_read);
	while(fread(sfile,cmpValue))
	{
		for(new i = 0, j = strlen(cmpValue); i < j; i++) if(cmpValue[i] == '\n' || cmpValue[i] == '\r') cmpValue[i] = '\0';
		parametr = strtoks(cmpValue,0);
		value = strtoks(cmpValue,(strlen(parametr)+1));
		if(strcmp(parametr,stroka,true)==0)load=floatstr(value);
	}
	fclose(sfile);
	return load;
}

stock loadFromFileAsString(file[],stroka[])
{
	new File:sfile,parametr[256],value[255],cmpValue[255],result[20];
	sfile=fopen(file,io_read);
	while(fread(sfile,cmpValue))
	{
		for(new i = 0, j = strlen(cmpValue); i < j; i++) if(cmpValue[i] == '\n' || cmpValue[i] == '\r') cmpValue[i] = '\0';
		parametr = strtoks(cmpValue,0);
		value = strtoks(cmpValue,(strlen(parametr)+1));
		if(strcmp(parametr,stroka,true)==0)strmid(result,value,0,strlen(value),255);
	}
	fclose(sfile);
	return result;
}

stock setVehicleInterior(vehicleid,interior)
{
	e_vint[vehicleid]=interior;
	LinkVehicleToInterior(vehicleid,e_vint[vehicleid]);
	return 1;
}

stock getVehicleInterior(vehicleid)
{
	return e_vint[vehicleid];
}

stock setVehiclePosEx(vehicleid,Float:x,Float:y,Float:z,Float:RotateAngle,interior=0,virtual=0)
{
	SetVehiclePos(vehicleid,x,y,z);
	SetVehicleZAngle(vehicleid,RotateAngle);
	SetVehicleInterior(vehicleid,interior);
	SetVehicleVirtualWorld(vehicleid,virtual);
	return 1;
}

stock getVehicleInfo(vehicleid,&Float:x,&Float:y,&Float:z,&Float:RotateAngle,&Float:health,&interior,&virtual,&model)
{
	
	GetVehiclePos(vehicleid,x,y,z);
	GetVehicleZAngle(vehicleid,RotateAngle);
	GetVehicleHealth(vehicleid,health);
	interior=getVehicleInterior(vehicleid);
	virtual=GetVehicleVirtualWorld(vehicleid);
	model=GetVehicleModel(vehicleid);
	return 1;
}

stock turnCarEngine(vehicleid, status)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
   	GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
    SetVehicleParamsEx(vehicleid, status, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return 1;
}

stock isCarEngineRunned(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return (eengine==VEHICLE_PARAMS_ON)?true:false;
}

stock turnCarLights(vehicleid, status)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
    SetVehicleParamsEx(vehicleid, eengine, status, ealarm, edoors, ebonnet, eboot, eobjective);
	return 1;
}

stock isCarLightsOn(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return (elights==VEHICLE_PARAMS_ON)?true:false;
}

stock turnCarAlarm(vehicleid, status)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	SetVehicleParamsEx(vehicleid, eengine, elights, status, edoors, ebonnet, eboot, eobjective);
	return 1;
}

stock isCarAlarmActive(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return (ealarm==VEHICLE_PARAMS_ON)?true:false;
}

stock turnCarDoors(vehicleid, status)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
    SetVehicleParamsEx(vehicleid, eengine, elights, ealarm, status, ebonnet, eboot, eobjective);
	return 1;
}

stock isCarDoorsOpen(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return (edoors==VEHICLE_PARAMS_ON)?true:false;
}

stock turnCarBonnet(vehicleid, status)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
    SetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, status, eboot, eobjective);
	return 1;
}

stock isCarBonnetOpen(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return (ebonnet==VEHICLE_PARAMS_ON)?true:false;
}

stock turnCarBoot(vehicleid, status)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
   	SetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, status, eobjective);
	return 1;
}

stock isCarBootOpen(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return (eboot==VEHICLE_PARAMS_ON)?true:false;
}

stock turnCarObjective(vehicleid, status)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
    SetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, status);
	return 1;
}

stock isCarObjective(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID)return 0;
	new eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective;
    GetVehicleParamsEx(vehicleid, eengine, elights, ealarm, edoors, ebonnet, eboot, eobjective);
	return (eboot==VEHICLE_PARAMS_ON)?true:false;
}

stock createVehicle3DtextLableEx(vehicleid,text[],color,Float:x=0.0,Float:y=0.0,Float:z=0.7,Float:DrawDistance=100.0,virtual=0,testLOS=0)
{
	if(vehicleid==INVALID_VEHICLE_ID&&vtextLable[vehicleid]==USE)return 0;
	vlabel[vehicleid]=Create3DTextLabel(text,color,0.0,0.0,0.0,DrawDistance,virtual,testLOS);
	Attach3DTextLabelToVehicle(vlabel[vehicleid], vehicleid, x, y, z);
	vtextLable[vehicleid]=USE;
	return 1;
}

stock deleteVehicle3DtextLableEx(vehicleid)
{
	if(vehicleid==INVALID_VEHICLE_ID&&vtextLable[vehicleid]==NOT_USE)return 0;
	Delete3DTextLabel(vlabel[vehicleid]);
	vtextLable[vehicleid]=NOT_USE;
	return 1;
}

stock updateVehicle3DtextLableEx(vehicleid,color,text[])
{
	if(vtextLable[vehicleid]==NOT_USE)return 0;
	Update3DTextLabelText(vlabel[vehicleid], color, text);
	return 1;
}

stock getVehicleName(vehicleid)
{
	new result[50],modelid;
	modelid=GetVehicleModel(vehicleid);
	strmid(result,VehNames[modelid-400],0,strlen(VehNames[modelid-400]),255);
	return result;
}

stock randomEx(min,max)
{
	new rand;
	do
	{
		rand=random(max+1);
	}while(rand<min);
	return rand;
}
static pCheckpoint[MAX_PLAYERS];
stock createPlayerCheckpoint(playerid,Float:x,Float:y,Float:z,Float:round)
{
	SetPlayerCheckpoint(playerid,x,y,z,round);
	CallRemoteFunction("onCheckPointCreate","i",checkpointid);
	pCheckpoint[playerid]=checkpointid;
	checkpointid++;
	return checkpointid;
}



stock strtoks(const string[],valve)
{
	new index=valve;
	new length = strlen(string);
	while ((index < length) && (string[index] <= ' '))
	{
		index++;
	}

	new offset = index;
	new result[20];
	while ((index < length) && (string[index] > ' ') && ((index - offset) < (sizeof(result) - 1)))
	{
		result[index - offset] = string[index];
		index++;
	}
	result[index - offset] = EOS;
	return result;
}

forward onCheckPointCreate(checkpointid);